library("MASS")

a <- mvrnorm(500, c(0, 0), diag(2))
b <- mvrnorm(500, c(2, 0), 4 * diag(2))

data <- data.frame(
	rbind(
		cbind(a, 0),
		cbind(b, 1)
	)
)
names(data) <- c("x1", "x2", "d")
data <- transform(data, d=as.factor(d))

plot(
	data[1:2],
	col=c("red", "green")[data$d],
	pch=(1:2)[data$d]
)

title(main="Samples from \"overlapping\" two-dimensional normal distributions")
legend(
	x="bottomright",
	legend=expression(
		paste(m[1]==(list(0,0)), ", ", sigma[1]^2==1),
		paste(m[2]==(list(2,0)), ", ", sigma[2]^2==4)
	),
	col=c("red", "green"),
	pch=1:2
)

library(nnet)

net <- nnet(d ~ x1 + x2, data=data, size=2, maxit=200)

t <- table(
	y=predict(net, type="class"),
	d=data$d
)
print(t)
cat("accuracy: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="")
