library("MASS")

a <- mvrnorm(500, c(0, 0), diag(2))
b <- mvrnorm(500, c(2, 0), 4 * diag(2))
c <- mvrnorm(500, c(1, 4), 2 * diag(2))

data <- data.frame(
	rbind(
		cbind(a, 1),
		cbind(b, 2),
		cbind(c, 3)
	)
)
names(data) <- c("x1", "x2", "d")
data <- transform(data, d=as.factor(d))

plot(data[1:2],
	col=c("red", "green", "blue")[data$d],
	pch=(1:3)[data$d]
)
title(main="Samples from \"overlapping\" three-dimensional normal distributions")
legend(
	x="bottomright",
	legend=expression(
		paste(m[1]==(list(0,0)), ", ", sigma[1]^2==1),
		paste(m[2]==(list(2,0)), ", ", sigma[2]^2==4),
		paste(m[3]==(list(1,4)), ", ", sigma[3]^2==2)
	),
	col=c("red", "green", "blue"),
	pch=1:3
)

library(nnet)

net <- nnet(d ~ x1 + x2, data=data, size=2, maxit=200)

t <- table(
	y=predict(net, type="class"),
	d=data$d
)
print(t)
cat("accuracy: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="")
