require(pixmap)

file <- if (.Platform$OS.type == "unix") {
	require(gWidgets)
	gfile(filter=list("PGM files"=list(patterns=c("*.pgm"))))
} else
	file.choose()

if (! is.na(file)) {
	image <- read.pnm(file)
	x <- as.vector(t(attr(image, "grey")))
	names(x) <- paste("X", 1:length(x), sep="")
	y <- predict(net, rbind(x), type="class")
	print(y)
}
