library(nnet)
library(pixmap)

x <- scan("all_train.list", what=character())
x <- substring(x, 35)

Y <- sapply(
	x,
	function(z) strsplit(z, "_", fixed=TRUE)[[1]]
)
Y <- t(Y)
Y <- Y[, 2:4]
colnames(Y) <- paste("Y", 1:3, sep="")
Y <- data.frame(Y)

images <- sapply(
	x,
	function(file) {
		image <- read.pnm(file)
		as.vector(t(attr(image, "grey")))
	}
)
images <- t(images)

data <- cbind(data.frame(images), Y[1])
net <- nnet(Y1 ~ ., data=data, size=3, MaxNWts=4000, maxit=500, decay=1e-3)

t <- table(predict(net, type="class"), Y[[1]])
print(t)
cat("Accuracy on training set: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="")
