library(fractal)

n <- 11

x1 <- sample(nrow(lorenz) - n + 1, size=500, replace=FALSE)

x2 <- sample(nrow(lorenz) - n + 1, size=500, replace=FALSE)

m1 <- sapply(x1, function(z) lorenz[z:(z + n - 1), 1])

m2 <- sapply(x2, function(z) lorenz[z:(z + n - 1), 1])

m1 <- t(m1)
m1 <- as.data.frame(m1)

m2 <- t(m2)
m2 <- as.data.frame(m2)

net <- nnet(V11 ~ ., data=m1, size=10, linout=TRUE, skip=TRUE, maxit=1000, decay=1e-3)

err <- sum((predict(net, m2[, 1:10]) - m2[, 11])^2)
cat("Error on test set: ", err, "\n")

input <- lorenz[1:10,1]

tmp <- input

for (i in 1:(1000 - length(input))) {

	p <- predict(net, matrix(input, nrow=1))

	input <- c(input[-1], p)
	tmp <- c(tmp, p)
}

plot(lorenz[1:1000, 1], type="l", col="blue")
points(tmp, col="red", type="l")
