library(fractal)
library(nnet)

n <- 11

m <- sapply(1:1000, function(z) lorenz[z:(z + n - 1), 1])

m <- t(m)
m <- as.data.frame(m)

net <- nnet(V11 ~ ., data=m, size=10, linout=TRUE, maxit=1000, skip=TRUE, abstol=1e-6, decay=1e-6)

input <- lorenz[1:(n-1),1]

y <- input

for (i in 1:1000) {

	p <- predict(net, matrix(input, nrow=1))

	input <- c(input[-1], p)
	y <- c(y, p)
}

plot(lorenz[1:length(y), 1], type="l", col="blue")
points(y, col="red", type="l")
