moon <- function(r = 10, w = 6, n = 500) {

	alpha <- runif(n, 0, pi)
	delta <- runif(n, -w / 2, w / 2)

	x <- cos(alpha) * (r + delta)
	y <- sin(alpha) * (r + delta)

	data.frame(x = x, y = y)
}

m1 <- moon()

m2 <- moon()
m2 <- transform(m2, x = x + 10, y = -y + 4)

plot(rbind(m1, m2))

plot(rbind(m1, m2), type="n")
points(m1, pch=20, col="red")
points(m2, pch=20, col="blue")
