moon <- function(r = 10, w = 6, n = 500) {

	alpha <- runif(n, 0, pi)
	delta <- runif(n, -w / 2, w / 2)

	x <- cos(alpha) * (r + delta)
	y <- sin(alpha) * (r + delta)

	data.frame(x = x, y = y)
}

two.moons <- function(r = 10, w = 6, n = 500, d = -4) {

	m1 <- moon(r, w, n);

        m2 <- moon(r, w, n);
        m2 <- transform(m2, x = x + r, y = -y - d)

        m <- rbind(
                transform(m1, d = 0),
                transform(m2, d = 1)
        )
        m <- transform(m, d = as.factor(d))
}

moons <- two.moons()
summary(moons)

plot(moons[1:2])
plot(moons[1:2], pch=20, col=c("red", "blue")[moons$d])

library(nnet)
net <- nnet(d ~ x + y, data=moons, size=3)
y <- predict(net, type="class")
t <- table(y=y, d=moons$d)
print(t)
