parity <- function(x) {
	x <- as.integer(as.logical(x))
	sum(x) %% 2
}

library(e1071)

n <- 3

x <- bincombinations(n)
d <- apply(x, 1, parity)
data <- data.frame(
	x,
	d=factor(d)
)

library(nnet)
net <- nnet(d ~ ., data=data, size=ceiling((n + 1) / 2), maxit=300)

y <- predict(net, type="class")
t <- table(data$d, y)
print(t)
cat("accuracy: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="")
