f <- function(x, y) dnorm(sqrt(x^2 + y^2))

x <- seq(-5, 5, length=100)
y <- x

fxy <- outer(x, y, f)

persp(x, y, fxy, ticktype="detailed", col="yellow", theta=30, phi=30)

xy <- expand.grid(x=x, y=y)

sxy <- xy[sample(1:nrow(xy), 1000),]

library(nnet)
n <- nnet(sxy, f(sxy$x, sxy$y), linout=TRUE, size=15)

oldpar <- par(no.readonly=TRUE)
par(mfcol=c(1, 2))

persp(x, y, fxy, ticktype="detailed", zlab="f(x,y)", col="YELLOW", theta=30, phi=30)
title(
	main=expression(
		f(x, y) == frac(1, sqrt(2 * pi)) * e^{-~~frac(x^2 + y^2, 2)}
	)
)

persp(x, y, matrix(predict(n, xy), nrow=length(x)), zlab="f'(x,y)", ticktype="detailed", col="yellow", theta=30, phi=30)
title(main="Közelítés neurális hálózattal")

par(oldpar)
