data <- read.csv("http://archive.ics.uci.edu/ml/machine-learning-databases/wine/wine.data", header=FALSE)
data <- transform(data, V1=factor(V1))
pairs(
	data[2:6],
	bg=c("red", "green", "blue")[data[[1]]],
	pch=21,
	cex=1.5
)

selected.rows <- sample(1:nrow(data), nrow(data) * 0.5)

library(nnet)
net <- nnet(
	V1 ~ .,
	data=data,
	subset=selected.rows,
	size=50,
	maxit=300
)

t1 <- table(
	y=factor(predict(net, data[selected.rows, 2:14], type="class")),
	d=data[selected.rows, 1]
)
print(t1)
cat("accuracy on training set: ", 100 * sum(diag(t1)) / sum(t1), "%\n", sep="")

t2 <- table(
	y=predict(net, data[-selected.rows, 2:14], type="class"),
	d=data[-selected.rows, 1]
)
print(t2)
cat("accuracy on test set: ", 100 * sum(diag(t2)) / sum(t2), "%\n", sep="")
