data <- read.csv("http://archive.ics.uci.edu/ml/machine-learning-databases/wine/wine.data", header=FALSE)
data <- transform(data, V1=factor(V1))
pairs(
	data[2:6],
	bg=c("red", "green", "blue")[data[[1]]],
	pch=21,
	cex=1.5
)

selected.rows <- sample(1:nrow(data), nrow(data) * 0.5)

library(nnet)
net <- nnet(
	V1 ~ .,
	data=data,
	size=50,
	maxit=300
)

t <- table(
	y=predict(net, type="class"),
	d=data[[1]]
)
print(t)

accuracy <- 100 * sum(diag(t)) / sum(t)
cat("accuracy: ", accuracy, "%\n", sep="")
