par(ask=TRUE)

library("MASS")

a <- mvrnorm(500, c(0, 0), diag(2))
b <- mvrnorm(500, c(2, 0), 4 * diag(2))

data <- data.frame(
	rbind(
		cbind(a, 0),
		cbind(b, 1)
	)
)
names(data) <- c("x1", "x2", "d")
data <- transform(data, d=as.factor(d))

plot(
	data[1:2],
	col=c("red", "green")[data$d],
	pch=(1:2)[data$d]
)

title(main="Samples from \"overlapping\" two-dimensional normal distributions")
legend(
	x="bottomright",
	legend=expression(
		paste(m[1]==(list(0,0)), ", ", sigma[1]^2==1),
		paste(m[2]==(list(2,0)), ", ", sigma[2]^2==4)
	),
	col=c("red", "green"),
	pch=1:2
)

library(e1071)

m <- svm(d ~ x1 + x2, data=data)
print(m)

t <- table(y=predict(m), d=data$d)

print(t)

accuracy <- 100 * sum(diag(t)) / sum(t)

cat("Accuracy: ", accuracy, "%\n", sep="")

plot(m, data)
