library(e1071)
library(pixmap)

x <- scan("straightrnd_train.list", what=character())
x <- substring(x, 35)

Y <- sapply(
	x,
	function(z) strsplit(z, "_", fixed=TRUE)[[1]]
)
Y <- t(Y)
Y <- Y[, 2:4]
colnames(Y) <- paste("Y", 1:3, sep="")
Y <- data.frame(Y)

images <- sapply(
	x,
	function(file) {
		image <- read.pnm(file)
		as.vector(t(attr(image, "grey")))
	}
)
images <- t(images)

data <- cbind(data.frame(images), Y[3])

#	m <- svm(Y3 ~ ., data=data, cost=10)

m <- svm(images, Y[[3]], kernel="linear")
print(m)

t <- table(predict(m), Y[[3]])
print(t)
cat("Accuracy on training set: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="")
