par(ask=TRUE)

n <- 100

x1 <- runif(n, -5, 5)
y1 <- x1 + rnorm(n, 0, 2)

x2 <- runif(n, -5, 5)
y2 <- x2 + 4 + rnorm(n, 0, 2)

library(e1071)

data <- data.frame(
	rbind(
		cbind(x1, y1, 1),
		cbind(x2, y2, 2)
	)
)

names(data) <- c("x", "y", "d")
data <- transform(data, d=as.factor(d))

plot(
	data[1:2],
	col=c("green", "red")[data$d],
	pch=20
)

m <- svm(d ~ ., data=data, kernel="linear", scale=FALSE)
print(m)

points(m$SV, cex=2)

t <- table(y=predict(m), d=data$d)

print(t)

cat("Accuracy: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="")

plot(m, data)
