f <- function(x) cos(3 * x)^2 * sin(x)
plot(f, -1, 1, main=substitute(f(x) == z, list(z=body(f))))

x <- runif(100, -1, 1)
d <- f(x)
e <- rnorm(n=length(x), sd=0.1)

d <- d + e

points(x, d, col="red", pch=4)

xx <- seq(-1, 1, length=100)

################################################################################
#
# 1 rejtett réteget tartalmazó előrecsatolt neurális hálózat
#
################################################################################

library(nnet)

m1 <- nnet(x, d, size=10, linout=TRUE, maxit=200)
print(m1)

y1 <- predict(m1, cbind(xx))

points(xx, y1, col="blue", pch=20)

################################################################################
#
# SVM
#
################################################################################

library(e1071)

m2 <- svm(x, d, kernel="radial", gamma=5, scale=FALSE)
print(m2)
y2 <- predict(m2, xx)

points(xx, y2, col="green", pch=20)

legend(
	"bottomright",
	c("Original function", "Training data", "nnet", "svm"),
	pch=c(-1, 4, 20, 20),
	lty=c("solid", "blank", "blank", "blank"),
	col=c("black", "red", "blue", "green")	
)
