data <- read.csv("http://archive.ics.uci.edu/ml/machine-learning-databases/spambase/spambase.data", header = FALSE)

data <- transform(data, V58 = factor(V58))

summary(data)

library(e1071)

select <- sample(1:nrow(data), nrow(data) / 2)

m <- svm(V58 ~ ., data = data, kernel = "linear", subset = select)
print(m)

t_train <- table(y = predict(m), d = data$V58[select])
print(t_train)
cat("Accuracy on training set: ", 100 * sum(diag(t_train)) / sum(t_train), "%\n", sep="")

t_test <- table(y = predict(m, data[-select, -58]), d = data$V58[-select])
print(t_test)
cat("Accuracy on test set: ", 100 * sum(diag(t_test)) / sum(t_test), "%\n", sep="")
