data <- read.csv("http://archive.ics.uci.edu/ml/machine-learning-databases/spambase/spambase.data", header = FALSE)

data <- transform(data, V58 = factor(V58))

spam <- subset(data, V58 == 1)
non.spam <- subset(data, V58 == 0)

select.spam <- sample(1:nrow(spam), 100)

select.non.spam <- sample(1:nrow(non.spam), 100)

train <- rbind(
	spam[select.spam,],
	non.spam[select.non.spam,]
)

test <- rbind(
	spam[-select.spam,],
	non.spam[-select.non.spam,]
)

library(e1071)

m <- svm(V58 ~ ., data = train, kernel = "linear")
print(m)

t_train <- table(y = predict(m), d = train$V58)
print(t_train)
cat("Accuracy on training set: ", 100 * sum(diag(t_train)) / sum(t_train), "%\n", sep="")

t_test <- table(y = predict(m, test[-58]), d = test$V58)
print(t_test)
cat("Accuracy on test set: ", 100 * sum(diag(t_test)) / sum(t_test), "%\n", sep="")
