data <- read.csv("http://archive.ics.uci.edu/ml/machine-learning-databases/spambase/spambase.data", header = FALSE)

data <- transform(data, V58 = factor(V58))

summary(data)

library(e1071)

m <- svm(V58 ~ ., data = data, kernel = "linear")
print(m)

y <- predict(m)

t <- table(y, d = data$V58)
print(t)

cat("Accuracy: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="")
