two.spirals <- function() {
	i <- 0:96
	angle <- i * pi / 16
	radius <- 6.5 * (104 - i) / 104
	x <- radius * cos(angle);
	y <- radius * sin(angle);
	data <- data.frame(
		rbind(
			cbind(x, y, 0),
			cbind(-x, -y, 1)
		)
	)
	names(data) <- c("x", "y", "d")
	data <- transform(data, d=factor(d))
}

data <- two.spirals()

par(ask=TRUE)

plot(data[1:2], col=c("green", "blue")[data[[3]]], pch=20, main="Two-spirals")

library(e1071)

m <- svm(d ~ ., data=data, kernel="radial", gamma=10)
print(m)

t <- table(predict(m), data$d)

print(t)

cat("Accuracy: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="")

plot(m, data)
