data <- read.csv("http://archive.ics.uci.edu/ml/machine-learning-databases/wine/wine.data", header=FALSE)

data <- transform(data, V1=as.factor(V1))

pairs(data[2:6],
	bg=c("red", "green", "blue")[data[[1]]],
	pch=21,
	cex=1.5
)

select <- sample(1:nrow(data), nrow(data) / 2)

################################################################################
#
# 1 rejtett réteget tartalmazó előrecsatolt neurális hálózat
#
################################################################################

library(nnet)
m_nnet <- nnet(
	V1 ~ .,
	data=data,
	subset=select,
	size=50
)
print(m_nnet)

t_nnet_training <- table(
	y=predict(m_nnet, type="class"),
	d=data[select, 1]
)
print(t_nnet_training)
cat("Accuracy on training set (nnet): ", 100 * sum(diag(t_nnet_training)) / sum(t_nnet_training), "%\n", sep="")

t_nnet_test <- table(
	y=predict(m_nnet, data[-select, -1], type="class"),
	d=data[-select, 1]
)
print(t_nnet_test)
cat("Accuracy on test set (nnet): ", 100 * sum(diag(t_nnet_test)) / sum(t_nnet_test), "%\n", sep="")

################################################################################
#
# SVM
#
################################################################################

library(e1071)
m_svm <- svm(
	V1 ~ .,
	data=data,
	subset=select
)
print(m_svm)

t_svm_training <- table(
	y=predict(m_svm),
	d=data[select, 1]
)
print(t_svm_training)
cat("Accuracy on training test (svm): ", 100 * sum(diag(t_svm_training)) / sum(t_svm_training), "%\n", sep="")

t_svm_test <- table(
	y=predict(m_svm, data[-select, -1]),
	d=data[-select, 1]
)
print(t_svm_test)
cat("Accuracy on test test (svm): ", 100 * sum(diag(t_svm_test)) / sum(t_svm_test), "%\n", sep="")
