data <- read.csv("http://archive.ics.uci.edu/ml/machine-learning-databases/wine/wine.data", header=FALSE)

data <- transform(data, V1=as.factor(V1))

pairs(data[2:6],
	bg=c("red", "green", "blue")[data[[1]]],
	pch=21,
	cex=1.5
)

select <- sample(1:nrow(data), nrow(data) * 0.5)

################################################################################
#
# 1 rejtett réteget tartalmazó előrecsatolt neurális hálózat
#
################################################################################

library(nnet)
m_nnet <- nnet(
	V1 ~ .,
	data=data,
	size=50,
	maxit=1000
)
print(m_nnet)

t_nnet <- table(
	y=predict(m_nnet, type="class"),
	d=data[[1]]
)
print(t_nnet)
cat("Accuracy (nnet): ", 100 * sum(diag(t_nnet)) / sum(t_nnet), "%\n", sep="")

################################################################################
#
# SVM
#
################################################################################

library(e1071)
m_svm <- svm(V1 ~ ., data=data)
print(m_svm)

t_svm <- table(y=predict(m_svm), d=data[[1]])
print(t_svm)
cat("Accuracy (svm): ", 100 * sum(diag(t_svm)) / sum(t_svm), "%\n", sep="")
