; lineage2.eu launcher (c) dmx
; DDoS @ Core
; creds: infratec

#UserAgent$ = "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)"

; Microsoft constants

#INTERNET_DEFAULT_HTTP_PORT = 80
#INTERNET_DEFAULT_HTTPS_PORT = 443
#INTERNET_OPEN_TYPE_DIRECT = 1
#INTERNET_OPEN_TYPE_PROXY = 3
#INTERNET_SERVICE_HTTP = 3

#INTERNET_FLAG_PRAGMA_NOCACHE =           $00000100
#INTERNET_FLAG_IGNORE_CERT_CN_INVALID =   $00001000
#INTERNET_FLAG_IGNORE_CERT_DATE_INVALID = $00002000
#INTERNET_FLAG_NO_COOKIES =               $00080000
#INTERNET_FLAG_KEEP_CONNECTION =          $00400000
#INTERNET_FLAG_SECURE =                   $00800000
#INTERNET_FLAG_DONT_CACHE =               $04000000

#HTTP_ADDREQ_FLAG_ADD = $20000000
#HTTP_ADDREQ_FLAG_REPLACE = $80000000
#HTTP_QUERY_STATUS_CODE = 19

#INTERNET_OPTION_SECURITY_FLAGS = 31
#INTERNET_OPTION_END_BROWSER_SESSION = 42
#SECURITY_FLAG_IGNORE_UNKNOWN_CA = $00000100

Structure ServerStructure
	UserAgent$
	Secure.i
	OpenHandle.i
	ConnectionHandle.i
	RequestHandle.i
	KeepAlive.i
	Server$
	Path$
	Parameters$
	User$
	Password$
	Base64Auth$
EndStructure

Structure HTTPAnswerSructure
	Status.i
	Content$
EndStructure


Procedure.i OpenConnection(*Info.ServerStructure)
	Protected.l timeout
	Protected.i Result, port
	
	*Info\OpenHandle = InternetOpen_(*Info\UserAgent$, #INTERNET_OPEN_TYPE_DIRECT, "", "", 0)
	
	If *Info\OpenHandle
		timeout = 1000
		InternetSetOption_(*Info\OpenHandle, 2, timeout, 4)
		InternetSetOption_(0, #INTERNET_OPTION_END_BROWSER_SESSION, #Null, 0)
		
		If *Info\Secure
			*Info\KeepAlive = #True
			port = #INTERNET_DEFAULT_HTTPS_PORT
		Else
			port = #INTERNET_DEFAULT_HTTP_PORT
		EndIf
		
		*Info\ConnectionHandle = InternetConnect_(*Info\OpenHandle, *Info\Server$, port, "", "", #INTERNET_SERVICE_HTTP, 0, 0)
		If *Info\ConnectionHandle
			Result = #True
		EndIf
	EndIf
	
	ProcedureReturn Result
EndProcedure

Procedure.i SendHeader(*Info.ServerStructure, Header$)
	Protected.l Flag
	Protected.i Result, Pos
	Protected FirstLine$
	
	Pos = FindString(Header$, #CRLF$)
	FirstLine$ = Left(Header$, Pos)
	Header$ = Mid(Header$, Pos + 2)
	
	Flag = #INTERNET_FLAG_PRAGMA_NOCACHE
	; Flag | #INTERNET_FLAG_NO_COOKIES
	Flag | #INTERNET_FLAG_DONT_CACHE
	
	If *Info\Secure
		Flag | #INTERNET_FLAG_SECURE
		Flag | #INTERNET_FLAG_IGNORE_CERT_CN_INVALID
		Flag | #INTERNET_FLAG_IGNORE_CERT_DATE_INVALID
	EndIf
	
	If *Info\KeepAlive
		Flag | #INTERNET_FLAG_KEEP_CONNECTION
	EndIf
	
	*Info\RequestHandle = HttpOpenRequest_(*Info\ConnectionHandle, StringField(FirstLine$, 1, " "), StringField(FirstLine$, 2, " "), "", "", #Null, Flag, 0)
	If *Info\RequestHandle
		HttpAddRequestHeaders_(*Info\RequestHandle, Header$, Len(Header$), #HTTP_ADDREQ_FLAG_ADD|#HTTP_ADDREQ_FLAG_REPLACE)
		Result = #True
	EndIf
	
	ProcedureReturn Result
EndProcedure

Procedure.i SendBody(*Info.ServerStructure, Body$)
	Protected.l dwFlags, dwBuffLen
	Protected.i Result, Ok, SendHandle
	
	Repeat
		SendHandle = HttpSendRequest_(*Info\RequestHandle, #Null, 0, @Body$, Len(Body$))
		
		If SendHandle = 0
			If GetLastError_() = 12045
				dwBuffLen = SizeOf(dwFlags)
				InternetQueryOption_(*Info\RequestHandle, #INTERNET_OPTION_SECURITY_FLAGS, @dwFlags, @dwBuffLen)
				
				dwFlags | #SECURITY_FLAG_IGNORE_UNKNOWN_CA
				InternetSetOption_(*Info\RequestHandle, #INTERNET_OPTION_SECURITY_FLAGS, @dwFlags, SizeOf(dwFlags))
				Ok + 1
			Else
				Ok = 3
			EndIf
		Else
			Ok = 2
		EndIf
	Until Ok >= 2
	
	If Ok = 2
		Result = #True
	Else
		Result = #False
	EndIf
	
	If SendHandle
		InternetCloseHandle_(SendHandle)
	EndIf
	
	ProcedureReturn Result
EndProcedure

Procedure.i ReceiveAnswer(*Info.ServerStructure, *Answer.HTTPAnswerSructure)
	Protected.l Count
	Protected.i Result, Help
	Protected *Buffer
	
	*Answer\Status = 0
	*Answer\Content$ = ""
	
	*Buffer = AllocateMemory(1024)
	If *Buffer
		Repeat
			Help = InternetReadFile_(*Info\RequestHandle, *Buffer, 1024, @Count)
			If Help = #True And Count = 0
				;download complete
				Count = 10
				If HttpQueryInfo_(*Info\RequestHandle, #HTTP_QUERY_STATUS_CODE, *Buffer, @Count, #Null)
					*Answer\Status = Val(PeekS(*Buffer, Count))
				EndIf
				
				Result = #True
			Else
				If GetLastError_() = 0
					*Answer\Content$ + PeekS(*Buffer, Count, #PB_UTF8)
				Else
					*Answer\Content$ = ""
					Break
				EndIf
			EndIf
		Until Result
		FreeMemory(*Buffer)
	EndIf
	
	ProcedureReturn Result
EndProcedure

Procedure.s HttpReceive(URL$, METHOD$, Data$)
	Protected.i request_handle
	Protected Header$, Post$
	Protected Info.ServerStructure, Answer.HTTPAnswerSructure
	
	If LCase(GetURLPart(URL$, #PB_URL_Protocol)) = "https"
		Info\Secure = #True
	EndIf
	
	Info\Server$ = GetURLPart(URL$, #PB_URL_Site)
	Info\Path$ = GetURLPart(URL$, #PB_URL_Path)
	
	Info\Parameters$ = GetURLPart(URL$, #PB_URL_Parameters)
	If Len(Info\Parameters$)
		Info\Parameters$ = "?" + Info\Parameters$
	EndIf
	
	OpenConnection(@Info)
	
	If Info\ConnectionHandle
		Post$ = Data$
		
		Header$ = METHOD$ + " /" + Info\Path$ + Info\Parameters$ + #CRLF$
		Header$ + "Host: " + Info\Server$ + #CRLF$
		Header$ + "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8" + #CRLF$
		If METHOD$ = "POST"
			Header$ + "Content-Type: application/x-www-form-urlencoded" + #CRLF$
		EndIf
		Header$ + #CRLF$
		
		If SendHeader(@Info, Header$)
			If SendBody(@Info, Post$)
				If ReceiveAnswer(@Info, @Answer)
					;Debug Answer\Status
					;Debug Answer\Content$
				Else
					;Debug Answer\Status
					;Debug Answer\Content$
				EndIf
			EndIf
			
			InternetCloseHandle_(Info\RequestHandle)
		EndIf
		
		InternetCloseHandle_(Info\ConnectionHandle)
		InternetCloseHandle_(Info\OpenHandle)
	EndIf
	
	ProcedureReturn Answer\Content$
EndProcedure
 
; jaPBe Version=3.13.4.880
; Build=1
; FirstLine=0
; CursorPosition=1
; ExecutableFormat=Windows
; Executable=lel.exe
; DontSaveDeclare
; EOF