::==============================================
::  PE Configuration Scripts, (c) reatogo 2005
::----------------------------------------------
:: BootProfileInit.cmd
:: DESCR:     Run a registry bootprofile
:: Version:   1.0
::
:: Uses REG.EXE (XP version)
::
:: Script By: AEC-REATOGO
::==============================================

@echo off
SETLOCAL ENABLEEXTENSIONS

::echo - %TIME%: BootProfileInit.cmd %1 %2 >> c:\mslogon.log

if "%1"=="/?" GOTO _HELP
if /I "%1"=="/help" GOTO _HELP
GOTO _MAIN

:_HELP
echo ===============================================================================
echo BootProfileInit.cmd
echo PE Configuration Scripts, (c) reatogo 2005
echo.
echo DESCRIPTION: Run a registry boot profile
echo.
echo BootProfileInit [/?] {NumBootProfile} [/descr]
echo.
echo   /help or /?           : Show this message
echo   {NumBootProfile}      : 1-9 : Read profile's REG data and run it
echo   /descr                : Print profile's short description 
echo ===============================================================================
:_END_HELP
GOTO _END


:_MAIN
set PM=start /wait xpeinit.exe -f -m
set _LOGFILE=%temp%\init.log

:: If exists use the XP version of Reg.exe (named reg_xp.exe)
:: (W2k3 version is incompatible)
set REGAPP=reg.exe
if exist "%systemRoot%\system32\reg_xp.exe" set REGAPP=reg_xp.exe

SET PROF_NUM=%1

if "%2"=="/descr" GOTO _DESCR
if "%2"=="--descr" GOTO _DESCR

::===================================================================
::  PageFile
::===================================================================

:_PAGEFILE

 CALL :GetProfileParams %PROF_NUM% "SetPageFile" _SETPAGEFILE 2>nul
 if NOT "%_SETPAGEFILE%"=="1" GOTO _END_PAGEFILE

 %PM% "Setting up PageFile..." 

 CALL :GetProfileParams %PROF_NUM% "CustomPageFileInit" _PF_CUSTOM 2>nul
 if NOT "%_PF_CUSTOM%"=="1" GOTO _NO_CUSTOMPF

 CALL :GetProfileParams %PROF_NUM% "CustomPageFileInitCmd" _PF_CUSTOM_CMD 2>nul
 if "%_PF_CUSTOM_CMD%"=="" GOTO _NO_CUSTOMPF
 
 :: Expand EnvVars in CMDLine and run it with xpeinit
 for /f "tokens=*" %%k in ('echo %_PF_CUSTOM_CMD%') do set _exp_CMD=%%k
 start /wait xpeinit "%_exp_CMD%"

 set _exp_CMD=
 set _PF_CUSTOM=
 set _PF_CUSTOM_CMD=

 GOTO :_END_PAGEFILE

 
:_NO_CUSTOMPF

 CALL :GetProfileParams %PROF_NUM% "ShowPageFileGUI" _SHOW_PF_GUI 2>nul
 CALL :GetProfileParams %PROF_NUM% "PageFileSize" _PF_SIZE 2>nul
 CALL :GetProfileParams %PROF_NUM% "PageFileDrive" _PF_Drive 2>nul


:_MAIN_PAGEFILE
 echo.
 echo [PageFile Creation]
 echo Show SetPageFile GUI: %_SHOW_PF_GUI%
 echo PageFile Size      : %_PF_SIZE%
 echo PageFile Drive     : %_PF_DRIVE%
 
 SET _PARAM=
 IF "%_SHOW_PF_GUI%"=="1" SET _PARAM=%_PARAM% /ShowGUI
 IF NOT "%_PF_SIZE%"=="" SET _PARAM=%_PARAM% /size:%_PF_SIZE%
 IF NOT "%_PF_Drive%"=="" SET _PARAM=%_PARAM% /drive:%_PF_Drive%

 ECHO Executing: CALL init-pagefile.cmd %_PARAM%
 CALL init-pagefile.cmd %_PARAM%
 SET _PARAM=

:_END_PAGEFILE


::===================================================================
::  RAMDRV VOLUME CONFIGURATION
::===================================================================

:_INIT_RAMDRV
 CALL :GetProfileParams %PROF_NUM% "CustomRamDrvInitCmd" _RAMDRV_CUSTOM_CMD 2>nul
 if "%_RAMDRV_CUSTOM_CMD%"=="" GOTO _NO_CUSTOMRAMDRV
 
 :: Expand EnvVars in CMDLine and run it with xpeinit
 for /f "tokens=*" %%k in ('echo %_RAMDRV_CUSTOM_CMD%') do set _exp_CMD=%%k
 start /wait xpeinit "%_exp_CMD%"

 set _exp_CMD=
 set _RAMDRV_CUSTOM=
 set _RAMDRV_CUSTOM_CMD=

 GOTO :_END_INITRAMDRV

 :_NO_CUSTOMRAMDRV

 CALL :GetProfileParams %PROF_NUM% "InitRamDrv" _INITRAMDRV 2>nul
 if NOT "%_INITRAMDRV%"=="1" GOTO _END_INITRAMDRV

 %PM% "Setting up RAMDRV..." 

 CALL :GetProfileParams %PROF_NUM% "CustomRamDrvInit" _RAMDRV_CUSTOM 2>nul
 if NOT "%_RAMDRV_CUSTOM%"=="1" GOTO _NO_CUSTOMRAMDRV

 CALL :GetProfileParams %PROF_NUM% "RamDrvType" _RAMDRV_TYPE 2>nul
 CALL :GetProfileParams %PROF_NUM% "RamDriveSize" _RAMDRIVE_SIZE 2>nul
 CALL :GetProfileParams %PROF_NUM% "VDiskHostDrive" _VD_HOSTDRIVE 2>nul
 CALL :GetProfileParams %PROF_NUM% "VDiskDriveLetter" _VD_DRIVELETTER 2>nul
 CALL :GetProfileParams %PROF_NUM% "VDiskSize" _VD_SIZE 2>nul

 echo.
 echo [RAMDRV]
 echo InitRamDrv: %_INITRAMDRV%
 echo RAMDRV TYPE: %_RAMDRV_TYPE%
 
if /I "%_RAMDRV_TYPE%"=="ram" (
 echo RAMDRV SIZE: %_RAMDRIVE_SIZE%
 call init-ramdrv.cmd /type:ram /size:%_RAMDRIVE_SIZE%
)
 
if /I "%_RAMDRV_TYPE%"=="vdisk" (
 echo VDHOST Drive: %_VD_HOSTDRIVE%
 echo VDisk Drive Letter : %_VD_DRIVELETTER%
 echo VDisk Drive Size   : %_VD_SIZE%
 if /I "%_RAMDRV_TYPE%"=="vdisk" call init-ramdrv.cmd /type:vdisk /size:%_VD_SIZE% /vdhost:%_VD_HOSTDRIVE%
)

:_END_INITRAMDRV

::===================================================================
:: RAMDRV data initialization
::===================================================================

:_INIT_RAMDRVFS

 CALL :GetProfileParams %PROF_NUM% "InitRamDrvFS" _INITRAMDRVFS 2>nul
 if NOT "%_INITRAMDRVFS%"=="1" GOTO _END_INIT_RAMDRVFS
 

 %PM% "Setting up RAMDRV Data..." 

 CALL :GetProfileParams %PROF_NUM% "CustomRamDrvFSInit" _RAMDRVFS_CUSTOM 2>nul
 if NOT "%_RAMDRVFS_CUSTOM%"=="1" GOTO _NO_CUSTOMRAMDRVFS

 CALL :GetProfileParams %PROF_NUM% "CustomRamDrvFSInitCmd" _RAMDRVFS_CUSTOM_CMD 2>nul
 if "%_RAMDRVFS_CUSTOM_CMD%"=="" GOTO _NO_CUSTOMRAMDRVFS
 
 :: Expand EnvVars in CMDLine and run it with xpeinit
 for /f "tokens=*" %%k in ('echo %_RAMDRVFS_CUSTOM_CMD%') do set _exp_CMD=%%k
 start /wait xpeinit "%_exp_CMD%"
 
 set _exp_CMD=
 set _RAMDRVFS_CUSTOM=
 set _RAMDRVFS_CUSTOM_CMD=
 
 GOTO :_END_INIT_RAMDRVFS

 
:_NO_CUSTOMRAMDRVFS

 CALL :GetProfileParams %PROF_NUM% "RAMDRVFormat" _RAMDRV_FORMAT 2>nul
 CALL :GetProfileParams %PROF_NUM% "RAMDRVCreateData" _RAMDRV_DATA 2>nul
 
 echo.
 echo [RAMDRVDATA]
 echo InitRamDrv Filesystem : "%_INITRAMDRVFS%"
 echo Format RAMDRV         : "%_RAMDRV_FORMAT%"
 echo Create RAMDRV Data    : "%_RAMDRV_DATA%"
  
 :Validate _RAMDRV_FORMAT
 SET _CHK=
 for %%a IN (NTFS NTFS-C FAT FAT32) do (if /I "%%a"=="%_RAMDRV_FORMAT%" SET _CHK=%%a)
 if "%_CHK%"=="" SET _RAMDRV_FORMAT=
 SET _CHK=
 
 SET INITCMD=
 if "%_RAMDRV_DATA%"=="1" SET INITCMD=/INIT
 if NOT "%_RAMDRV_FORMAT%"=="" SET INITCMD=%INITCMD% /F:%_RAMDRV_FORMAT%
 
 call init-ramdrv-data.cmd %INITCMD%
 SET INITCMD=

:_END_INIT_RAMDRVFS


::===================================================================
::  PnP Hardware Detection
::===================================================================

CALL :GetProfileParams %PROF_NUM% "InitPnp" _INITPNP 2>nul
IF NOT "%_INITPNP%"=="1" GOTO _END_INIT_PNP

%PM% "Hardware Detection..." 

CALL :GetProfileParams %PROF_NUM% "CustomPnpInit" _PNP_CUSTOM 2>nul
if NOT "%_PNP_CUSTOM%"=="1" GOTO _NO_CUSTOMPNP

CALL :GetProfileParams %PROF_NUM% "CustomPnpInitCmd" _PNP_CUSTOM_CMD 2>nul
if "%_PNP_CUSTOM_CMD%"=="" GOTO _NO_CUSTOMPNP

:: Expand EnvVars in CMDLine and run it with xpeinit
for /f "tokens=*" %%k in ('echo %_PNP_CUSTOM_CMD%') do set _exp_CMD=%%k
start /wait xpeinit "%_exp_CMD%"

set _exp_CMD=
set _PNP_CUSTOM=
set _PNP_CUSTOM_CMD=

GOTO :_END_INIT_PNP

:_NO_CUSTOMPNP

CALL :GetProfileParams %PROF_NUM% "PnpDetection" _PNPDETECTION 2>nul

CALL :GetProfileParams %PROF_NUM% "DetectNetDevices" _PNPNET 2>nul
CALL :GetProfileParams %PROF_NUM% "DetectUSBDevices" _PNPUSB 2>nul
CALL :GetProfileParams %PROF_NUM% "DetectDisplayDevices" _PNPVGA 2>nul
CALL :GetProfileParams %PROF_NUM% "DetectComPorts" _PNPCOM 2>nul

SET PNPMETHOD=
if "%_PNPNET%"=="1" SET PNPMETHOD=%PNPMETHOD% /NET
if "%_PNPUSB%"=="1" SET PNPMETHOD=%PNPMETHOD% /USB
if "%_PNPVGA%"=="1" SET PNPMETHOD=%PNPMETHOD% /DISPLAY
if "%_PNPCOM%"=="1" SET PNPMETHOD=%PNPMETHOD% /COMPorts

if "%_PNPDETECTION%"=="hwpnp" GOTO _custom_pnp
if "%_PNPDETECTION%"=="full" SET PNPMETHOD=%PNPMETHOD% /detection:full
if "%_PNPDETECTION%"=="basic" SET PNPMETHOD=%PNPMETHOD% /detection:basic
GOTO _MAIN_PNP

:_CUSTOM_PNP
 CALL :GetProfileParams %PROF_NUM% "HwPNPParams" _PNPPARAMS 2>nul
 SET PNPMETHOD=%PNPMETHOD% /detection:hwpnp %_PNPPARAMS%

:_MAIN_PNP

 echo.
 echo [PnP Detection]
 echo PnpDetection : %_PNPDETECTION%
 echo PnpParams    : %PNPMETHOD%

 call init-pnp.cmd %PNPMETHOD%

:_END_INIT_PNP

::===================================================================
:: DISPLAY
::===================================================================
:_INIT_DISPLAY

 CALL :GetProfileParams %PROF_NUM% "InitDisplay" _INITDISPLAY 2>nul
 if NOT "%_INITDISPLAY%"=="1" GOTO _END_INIT_DISPLAY

 %PM% "Setting up Display..." 

 CALL :GetProfileParams %PROF_NUM% "CustomDisplayInit" _DISPLAY_CUSTOM 2>nul
 if NOT "%_DISPLAY_CUSTOM%"=="1" GOTO _NO_CUSTOMDISPLAY

 CALL :GetProfileParams %PROF_NUM% "CustomDisplayInitCmd" _DISPLAY_CUSTOM_CMD 2>nul
 if "%_DISPLAY_CUSTOM_CMD%"=="" GOTO _NO_CUSTOMDISPLAY

 :: Expand EnvVars in CMDLine and run it with xpeinit
 for /f "tokens=*" %%k in ('echo %_DISPLAY_CUSTOM_CMD%') do set _exp_CMD=%%k
 start /wait xpeinit "%_exp_CMD%"

 set _exp_CMD=
 set _DISPLAY_CUSTOM=
 set _DISPLAY_CUSTOM_CMD=

 GOTO :_END_INIT_DISPLAY

:_NO_CUSTOMDISPLAY

 CALL :GetProfileParams %PROF_NUM% "ResolutionX" _RESX 2>nul
 CALL :GetProfileParams %PROF_NUM% "ResolutionY" _RESY 2>nul
 CALL :GetProfileParams %PROF_NUM% "MaxBitsPerPixel" _BPPMAX 2>nul
 CALL :GetProfileParams %PROF_NUM% "MaxRefreshRate" _REFRESHMAX 2>nul
 
 call chres.cmd %_RESX% %_RESY% %_BPPMAX% %_REFRESHMAX%

:_END_INIT_DISPLAY



::===================================================================
:: NETWORKING
::===================================================================

:_INIT_NET

 CALL :GetProfileParams %PROF_NUM% "InitNetworking" _INITNETWORKING 2>nul
 if NOT "%_INITNETWORKING%"=="1" GOTO _END_INIT_NET

 %PM% "Setting up Networking..." 

 CALL :GetProfileParams %PROF_NUM% "CustomNetInit" _NET_CUSTOM 2>nul
 if NOT "%_NET_CUSTOM%"=="1" GOTO _NO_CUSTOMNET

 CALL :GetProfileParams %PROF_NUM% "CustomNetInitCmd" _NET_CUSTOM_CMD 2>nul
 if "%_NET_CUSTOM_CMD%"=="" GOTO _NO_CUSTOMNET

 :: Expand EnvVars in CMDLine and run it with xpeinit
 for /f "tokens=*" %%k in ('echo %_NET_CUSTOM_CMD%') do set _exp_CMD=%%k
 start /wait xpeinit "%_exp_CMD%"

 set _exp_CMD=
 set _NET_CUSTOM=
 set _NET_CUSTOM_CMD=

 GOTO :_END_INIT_NET

:_NO_CUSTOMNET



 CALL :GetProfileParams %PROF_NUM% "NetworkingGUI" _USE_NET_GUI 2>nul
 echo.
 echo [NETWORKING]
 echo InitNetworking      : %_INITNETWORKING%
 echo Use Network Cfg GUI : %_USE_NET_GUI%
 
 CALL :GetProfileParams %PROF_NUM% "DHCP" _DHCP 2>nul
 CALL :GetProfileParams %PROF_NUM% "RAS" _RAS 2>nul
 CALL :GetProfileParams %PROF_NUM% "WIRELESS" _WIRELESS 2>nul

 CALL :GetProfileParams %PROF_NUM% "Sharing" _Share 2>nul
 CALL :GetProfileParams %PROF_NUM% "ComputerName" _CName 2>nul
 CALL :GetProfileParams %PROF_NUM% "WorkgroupName" _WGName 2>nul
 CALL :GetProfileParams %PROF_NUM% "AdministratorPass" _AdmPass 2>nul
 
 if NOT "%_CName%"=="" SET NETCFGPARAMS=%NETCFGPARAMS% /CN:%_CName%
 if NOT "%_WGName%"=="" SET NETCFGPARAMS=%NETCFGPARAMS% /WG:%_WGName%
 if NOT "%_AdmPass%"=="" SET NETCFGPARAMS=%NETCFGPARAMS% /PW:%_AdmPass%

 if "%_RAS%"=="1" SET NETCFGPARAMS=%NETCFGPARAMS% /RAS
 if "%_WIRELESS%"=="1" SET NETCFGPARAMS=%NETCFGPARAMS% /WIRELESS

 if /I "%_USE_NET_GUI%"=="PenetCFG" GOTO _START_NET_GUI
 if /I "%_USE_NET_GUI%"=="NetConfig" GOTO _START_NET_GUI
 
 if "%_DHCP%"=="1" SET NETCFGPARAMS=%NETCFGPARAMS% /DHCP
 if "%_SHARE%"=="1" SET NETCFGPARAMS=%NETCFGPARAMS% /SHARE
 
 call init-net.cmd %NETCFGPARAMS%
 GOTO _END_INIT_NET
 
 :_START_NET_GUI
 CALL :GetProfileParams %PROF_NUM% "NetGUIParams" _NET_GUI_PARAMS 2>nul
 call init-net.cmd %NETCFGPARAMS% /GUI:%_USE_NET_GUI% %_NET_GUI_PARAMS%
 
:_END_INIT_NET


::===================================================================
:: MULTIMEDIA
::===================================================================

:_INIT_MULTIMEDIA

 CALL :GetProfileParams %PROF_NUM% "InitMultimedia" _INITMULTIMEDIA 2>nul
 if NOT "%_INITMULTIMEDIA%"=="1" GOTO _END_INIT_MULTIMEDIA
 
 call init-multimedia.cmd

:_END_INIT_MULTIMEDIA


::===================================================================
:: APPLICATIONS
::===================================================================

:_INIT_APPS

 CALL :GetProfileParams %PROF_NUM% "InitApplications" _INITAPPS 2>nul
 if NOT "%_INITAPPS%"=="1" GOTO _END_INIT_APPS
 
 CALL :GetProfileParams %PROF_NUM% "CustomAppsInit" _APPS_CUSTOM 2>nul
 if NOT "%_APPS_CUSTOM%"=="1" GOTO _NO_CUSTOMAPPS

 CALL :GetProfileParams %PROF_NUM% "CustomAppsInitCmd" _APPS_CUSTOM_CMD 2>nul
 :: this causes errors if we use commands like -f "<message>" net start <service>
 if "%_APPS_CUSTOM_CMD%"=="" GOTO _NO_CUSTOMAPPS

 :: Expand EnvVars in CMDLine and run it with xpeinit
 for /f "tokens=*" %%k in ('echo %_APPS_CUSTOM_CMD%') do set _exp_CMD=%%k
 
 start /wait xpeinit %_exp_CMD%

 set _exp_CMD=
 set _APPS_CUSTOM=
 set _APPS_CUSTOM_CMD=

 GOTO _END_INIT_APPS

:_NO_CUSTOMAPPS

 call init-apps.cmd

:_END_INIT_APPS

:_END
endlocal
GOTO :EOF


::=============================================================================
:_DESCR
:: Get short boot profile description from registry

CALL :GetProfileParams %PROF_NUM% "Description" _DESCRIPTION 2>nul
if "%_DESCRIPTION%"=="" GOTO _END_DESCR

echo.   %PROF_NUM%  %_DESCRIPTION%
:_END_DESCR
endlocal
GOTO :EOF


::=============================================================================

:GetProfileParams
:: GetProfileParams {Profile number} "{Parameter}" ENV_VAR
:: Example:  GetProfileParams 1 "StartNetworking" STARTNET
set SP=HKLM\Software\MSLogon\Logon\BootProfiles
SET ProfNum=%1
SET ProfParam=%2
set ProfParamVal=
for /f "tokens=1-3* skip=4 delims=	" %%a in ('%REGAPP% query "%SP%\%ProfNum%" /v %2') DO set ProfParamVal=%%c
ENDLOCAL &set %3=%ProfParamVal%
GOTO :EOF
