::  Change Display Resolution
::  PE Configuration Scripts, (c) reatogo 2005
::  Script By AEC-REATOGO

@ECHO off
COLOR F0
:: -------------------------------------------------------------------------
:: Interactive Script for Setting Video Resolution
:: The user can view a list of currently supported video modes
:: and change the resolution to one of them
::
:: USES: Qres.exe by Anders Kjersen
:: -------------------------------------------------------------------------

SETLOCAL ENABLEEXTENSIONS 
Title=[ IMENU: View and Change Display Modes ]
set PM=start /wait xpeinit.exe -f -m
%PM% "IMENU: View and Change Display Modes"

SET RESTORE_RES=

:_RES_INIT
CLS
ECHO.
ECHO. --------------------------------------------------------------
ECHO.              View and Change Display Modes
ECHO. --------------------------------------------------------------
ECHO.
ECHO.    What would you like to do?
ECHO.
ECHO.     (1) View Current Display Settings
ECHO.      2  List All Supported Video Modes 
ECHO.      3  Change Resolution
ECHO.      r  Restore Previous Display Settings
ECHO.      x  Exit
ECHO.
ECHO. --------------------------------------------------------------
ECHO.

set CHOICE=
set /p CHOICE= Type your choice : 
ECHO.


:: Default to 1
if "%CHOICE%"=="" set CHOICE=1
if /I "%CHOICE%"=="x" GOTO _END_RES_INIT

set RESCMD=
if "%CHOICE%"=="1"  set RESCMD=qres /V /S
if "%CHOICE%"=="2"  set RESCMD=qres /V /L
if "%CHOICE%"=="3"  GOTO _NEWRES
if /I "%CHOICE%"=="r"  GOTO _RESTORERES

if "%RESCMD%"=="" ECHO Invalid selection [%CHOICE%]. Please try again.&pause&GOTO _RES_INIT
GOTO _RES_CMD

:_RESTORERES
if "%RESTORE_RES%"=="" GOTO _RES_INIT
qres %RESTORE_RES%
SET RESTORE_RES=
GOTO _RES_INIT
:_END_RESTORERES

:_NEWRES
:: Save current settings to enable restoring
for /f "tokens=1-7 delims=x, " %%a in ('qres /V /S') do (
 set XResolution=%%a
 set YResolution=%%b
 set bpp=%%c
 set VRef=%%f
)
SET RESTORE_RES=/X:%XResolution% /Y:%YResolution% /C:%bpp% /R:%VRef%
cls
ECHO. =======================================================================
ECHO.   Enter the new resolution in the form: 
ECHO.    /X:xres /Y:yres /C:color_depth_in_bits /R:refresh_rate_in_HZ
ECHO.   Example: /X:1024 /Y:768 /C:24 /R:75
ECHO.
ECHO.   IMPORTANT: If after changing mode your monitor goes blank you may
ECHO.    TYPE r AND THEN PRESS ENTER to restore the current display settings
ECHO. =======================================================================
ECHO.
set NEWMODE=
set /p NEWMODE= Enter new display mode : 
qres %NEWMODE%
GOTO _RES_INIT
:_END_NEWRES


:_RES_CMD
%RESCMD%
pause
GOTO _RES_INIT

:_END_RES_INIT

ENDLOCAL
goto :EOF
