::  RAMDRV PREPARATION CFG script
::  PE Configuration Scripts, (c) reatogo 2005
::  Script By AEC-REATOGO

@echo off
COLOR F0
:: -------------------------------------------------------------------------
:: Interactive Script for RAMDRV Volume initialization
:: The user selects the disk type between RAMDRIVE and VDISK
:: and chooses the drive size
:: -------------------------------------------------------------------------

SETLOCAL ENABLEEXTENSIONS 
Title=[ IMENU: Prepare RAMDRV Volume ]
set PM=start /wait xpeinit.exe -f -m
%PM% "IMENU: Prepare RAMDRV Volume"

:_RW_DSK_INIT
cls
echo.
ECHO. --------------------------------------------------------------
echo.                    PREPARE RAMDRV VOLUME
echo.           for Writing Profiles ^& Application Data
ECHO. --------------------------------------------------------------
echo.
echo.    What resource would you like to use for RAMDRV volume?
echo.
echo.     (1) Ram 
echo.      2  Virtual Disk (using local hard disk space)
echo.      x  Exit
echo.
ECHO. --------------------------------------------------------------
echo.

set CHOICE=
set /p CHOICE= Type your choice : 
cls

:: Default to RAM
if "%CHOICE%"=="" set CHOICE=1
if /I "%choice%"=="x" GOTO _END_RW_DSK_INIT

set RW_DSK=
if %CHOICE%==1 set RW_DSK=RAM
if %CHOICE%==2 set RW_DSK=VDISK

if "%RW_DSK%"=="" echo Invalide Selection [%CHOICE%]. Please try again.&pause&GOTO _RW_DSK_INIT

if %RW_DSK%==VDISK GOTO _VDISK

:_RAMDISK
cls
echo.
ECHO. --------------------------------------------------------------
echo.                     RAMDRIVE Resizing
echo.              Based on CWorks script solution
echo.               and AutoRamResizer by Sherpya
ECHO. --------------------------------------------------------------
echo.
echo.    Select the size of RAMDrive
echo.
echo.      1  8M
echo.      2  16M
echo.      3  32M
echo.      4  64M
echo.      5  128M
echo.      6  256M
echo.      7  512M
echo.      8  1024M
echo.      9  Auto Resize
echo.     (x) No change
echo.
ECHO. --------------------------------------------------------------
echo.

set CHOICE=
set /p CHOICE= Type your choice : 
cls

if "%CHOICE%"=="" set CHOICE=x

set RAMSIZE=
IF "%Choice%"=="1" set RAMSIZE=8M
IF "%Choice%"=="2" set RAMSIZE=16M
IF "%Choice%"=="3" set RAMSIZE=32M
IF "%Choice%"=="4" set RAMSIZE=64M
IF "%Choice%"=="5" set RAMSIZE=128M
IF "%Choice%"=="6" set RAMSIZE=256M
IF "%Choice%"=="7" set RAMSIZE=512M
IF "%Choice%"=="8" set RAMSIZE=1024M
if "%Choice%"=="9" set RAMSIZE=auto

if /I "%Choice%"=="x" GOTO _END_RAMSIZE

if "%RAMSIZE%"=="" echo Invalid Selection [%CHOICE%]. Please try again.&pause&GOTO :_RAMDISK

call init-ramdrv.cmd /type:ram /size:%RAMSIZE%
pause
:_END_RAMSIZE

GOTO _RW_DSK_INIT
:_END_RAMDISK


:_VDISK
cls
echo.
ECHO. --------------------------------------------------------------
echo                   VIRTUAL DISK USED AS RAMDRV
echo.  A file will be used as RW virtual disk and mounted as RAMDRV.
echo.     ** Concept and prepared vdisk images by sanbarrow **
echo.               using Ken Katos Virtual Disk Driver 
ECHO. --------------------------------------------------------------
echo.
echo.  Select the drive where the virtual disk file will be created
echo.
echo.  IMPORTANT: Make sure you select a *safe* drive for writing.
echo.
for %%i in (C D E F G H I J K L M N O P Q R S T U V W X Y Z) do (if exist %%i:\nul echo.         %%i)
echo.
ECHO. --------------------------------------------------------------

set DEF_DSK=
for %%i in (C D E F G H I J K L M N O P Q R S T U V W X Y Z) do (
 if exist %%i:\nul set DEF_DSK=%%i&GOTO _END_DEF_DSK 
)
:_END_DEF_DSK

if "%DEF_DSK%"=="" echo. No available disks to host the virtual disk!&pause&GOTO _RW_DSK_INIT

set CHOICE=
set /p CHOICE= Type your choice (Default %DEF_DSK%): 
if "%CHOICE%"=="" set CHOICE=%DEF_DSK%
echo.

:: Test if selected drive exists and is writable
if not exist %CHOICE%:\nul echo. Not a valid drive. Try Again&GOTO _VDISK



::echo - Attempt to prepare VDISK host folder
::md %CHOICE%:\SFX>nul
::if not exist %CHOICE%:\_ramfile_\nul echo. Not a R/W drive. Try Again&GOTO _VDISK
::ECHO SFX Drive %CHOICE%:

:: Correction Febr.7,2006
echo - Attempt to prepare VDISK host folder
md %CHOICE%:\_ramfile_>nul
if not exist %CHOICE%:\_ramfile_\nul echo. Not a R/W drive. Try Again&GOTO _VDISK
ECHO VDISK host folder: %CHOICE%:\_ramfile_


rem if "%RAMDRV%" == "" goto _end
if "%RAMDRV%" == "" set RAMDRV=B:

set RFDRV=%RAMDRV%
:: Handle VDK bug (lower case B:)
if "%RAMDRV%"=="B:" set RFDRV=b:

:: Drive letter for storing our virtual disks
set VFDRV=%CHOICE%

:_SEL_VDISK
cls
set VDSFXDIR=%SYSTEMDRIVE%\SFX
echo.
ECHO. --------------------------------------------------------------
echo.                 Virtual Disk Configuration
ECHO. --------------------------------------------------------------
echo.
echo.    Select the size of Virtual Disk
echo.
if exist "%VDSFXDIR%\ramfile100.rar" echo            100M
if exist "%VDSFXDIR%\ramfile200.rar" echo           (200M)
if exist "%VDSFXDIR%\ramfile300.rar" echo            300M
if exist "%VDSFXDIR%\ramfile500.rar" echo            500M
if exist "%VDSFXDIR%\ramfile1G.rar"  echo            1G
if exist "%VDSFXDIR%\ramfile2G.rar"  echo            2G
if exist "%VDSFXDIR%\ramfile4G.rar"  echo            4G
if exist "%VDSFXDIR%\ramfile8G.rar"  echo            8G
if exist "%VDSFXDIR%\ramfile16G.rar" echo            16G
echo.
ECHO. --------------------------------------------------------------

set CHOICE=
set /p CHOICE= Type your choice (Default 200M): 
echo.

if "%CHOICE%"=="" set CHOICE=200M
set VSIZE=%CHOICE%

set VFILE=
IF /I "%Choice%"=="100M" set VFILE=ramfile100.rar
IF /I "%Choice%"=="200M" set VFILE=ramfile200.rar
IF /I "%Choice%"=="300M" set VFILE=ramfile300.rar
IF /I "%Choice%"=="500M" set VFILE=ramfile500.rar
IF /I "%Choice%"=="1G"   set VFILE=ramfile1g.rar
IF /I "%Choice%"=="2G"   set VFILE=ramfile2g.rar
IF /I "%Choice%"=="4G"   set VFILE=ramfile4g.rar
IF /I "%Choice%"=="8G"   set VFILE=ramfile8g.rar
IF /I "%Choice%"=="16G"  set VFILE=ramfile16g.rar

if "%VFILE%"=="" echo. Invalid Selection [%CHOICE%]. Please try again.&pause&GOTO _SEL_VDISK

ECHO.
CALL init-ramdrv.cmd /type:vdisk /size:%CHOICE% /vdhost:%VFDRV%
pause
GOTO _RW_DSK_INIT
:_END_VDISK

:_END_RW_DSK_INIT

set RW_DSK=
set RAMSIZE=
set VFILE=
set VSIZE=
set RFDRV=

goto :EOF
