::==============================================
::  PE Configuration Scripts, (c) reatogo 2005
::----------------------------------------------
:: chres.cmd
:: DESCR:     CHANGE DISPLAY RESOLUTION
:: Version:   1.0
::
:: USES :     QRes.exe
::
:: Script By: AEC-REATOGO
::==============================================

@echo off
SETLOCAL ENABLEEXTENSIONS 

::echo - %TIME%: chres.cmd  %1 %2 %3 %4 >> c:\mslogon.log

if "%1"=="/?" GOTO _HELP
if /I "%1"=="/help" GOTO _HELP
GOTO _MAIN

:_HELP
echo ===============================================================================
echo chres.cmd
echo PE Configuration Scripts, (c) reatogo 2005
echo.
echo DESCRIPTION: Changes resolution using the best supported
echo   color depth and refresh ratio not exceeding specified limits.
echo.
echo chres.cmd [/?] {xres} {yres} {bppmax} {vrefreshmax}
echo.  
echo   /help or /?    Show this message
echo   {xres}         XResolution in pixels
echo   {yres}         YResolution in pixels
echo   {bppmax}       Max colors in bits per pixel
echo   {vrefreshmax}  Max vertical refresh rate in Hz
echo.
echo EXAMPLE: chres.cmd 1024 768 32 72
echo ===============================================================================
:_END_HELP
GOTO _END

:_MAIN

set _LOGFILE=%temp%\init.log

echo.>>%_LOGFILE%
echo [Display Settings]>>%_LOGFILE%
echo Display Settings

:: Get current settings
for /f "tokens=1-7 delims=x, " %%a in ('qres /V /S') do (
 set XResolution=%%a
 set YResolution=%%b
 set bppMax=%%c
 set VRefMax=%%f
)
echo - Current Settings :  [%XResolution%x%YResolution%, %bppMax% bits @ %VRefMax% Hz]>>%_LOGFILE%
echo - Current Settings :  [%XResolution%x%YResolution%, %bppMax% bits @ %VRefMax% Hz]


:: Command Line overwrites current settings
if not "%1"=="" if not "%2"=="" (
  set XResolution=%1
  set YResolution=%2
)
if not "%3"=="" if NOT %3 LEQ 0 (set bppMax=%3)
if not "%4"=="" if NOT %4 LEQ 0 (set VRefMax=%4)

echo - Settings requested : [%XResolution%x%YResolution%, %bppMax% bits @ %VRefMax% Hz]>>%_LOGFILE%
echo - Settings requested : [%XResolution%x%YResolution%, %bppMax% bits @ %VRefMax% Hz]
:: Get supported display modes for given resolution
:: Select the highest mode with refreshrate <= VRefMax and bpp<=bppMax
:: The following works because qres lists modes with better bbp & rr later

for /f "tokens=2-5" %%a in ('qres /L ^| findstr "%XResolution%x%Yresolution%"') do (
 if %%d LEQ %VRefMax% if %%a LEQ %bppMax% (
  set bpp=%%a
  set VRefresh=%%d
 )
)

if "%bpp%"=="" goto NOCHRES
set BitsPerPel=%bpp%

:: Set display settings
echo - Supported Settings:  [%XResolution%x%YResolution%, %BitsPerPel% bits @ %VRefMax% Hz]>>%_LOGFILE%
echo - Executing: qres.exe /x:%XResolution% /y:%YResolution% /c:%BitsPerPel% /r:%VRefresh% >>%_LOGFILE%
qres.exe /x:%XResolution% /y:%YResolution% /c:%BitsPerPel% /r:%VRefresh%

goto _END

:NOCHRES
echo - No matching display mode found.>>%_LOGFILE%
echo - Trying: qres.exe /x:%XResolution% /y:%YResolution%>>%_LOGFILE%
qres.exe /x:%XResolution% /y:%YResolution%

:_END

endlocal
goto :eof
