::===================================================================
::  PE Configuration Scripts, (c) reatogo 2005
::-------------------------------------------------------------------
:: init-net.cmd
:: DESCR:     NETWORK initialization (dhcp,sharing,ras,wireless,...)
:: Version:   1.0
::
:: Uses:      bartpe, netcfg, penetcfg, netconfig
::
:: Script By: AEC-REATOGO
::===================================================================

:: TodoList: 
::  (1) Add cmdline cfg of fixed ip 
::  (2) proxy settings

@echo off
SETLOCAL ENABLEEXTENSIONS

::echo - %TIME%: init-net.cmd %1 %2 %3 %4 %5 %6 %7 %8 %9 >> c:\mslogon.log

if "%1"=="/?" GOTO _HELP
if /I "%1"=="/help" GOTO _HELP
GOTO _MAIN

:_HELP
echo ===============================================================================
echo init-net.cmd
echo PE Configuration Scripts, (c) reatogo 2005
echo.
echo DESCRIPTION: NETWORK initialization (dhcp,sharing,ras,wireless,...)
echo.
echo init-net.cmd [/?] [/dhcp] [/share] [/ras] [/wireless]
echo              /WG:{WORKGROUP} /CN:{ComputerName} /PW:{SharingPassword}
echo              [/GUI:{NETGUI_program}] {GUI_PARAMS}
echo.
echo   /help or /? : Show this message
echo   /dhcp       : Enable DHCP client for auto network configuration
echo   /share      : Enable MS printer and files sharing server
echo   /ras        : Enable and start RAS sevices (dialup, pppoe)
echo   /wireless   : Enable and start wireless services
echo   /WG:{WORKGROUP}       : Set Workgroup name
echo   /CN:{ComputerName}    : Set computer name  
echo   /PW:{SharingPassword} : Set password for Administartor
echo   /GUI:{NETGUI_program} {GUI_PARAMS} : Configure NET with a GUI program
echo        {NETGUI_program}              : penetcfg or netconfig
echo        {GUI_PARAMS}                  : parameters of GUI program
echo ===============================================================================
:_END_HELP
GOTO _END


:_MAIN
set PM=start /wait xpeinit.exe -f -m
set _LOGFILE=%temp%\init.log


:: Default vars
set WG=
set CN=
set PW=

set USEPENETCFG=false
set USENETCONFIG=false
set SHARING=false
set RAS=false
set WIRELESS=false
set DHCP=false
set USE_NETCFG=false

set _NETGUI=
set _NETGUI_PARAMS=

:_GET_PARAMS
if "%1"=="" goto _END_GET_PARAMS
if /I "%1"=="/dhcp" set DHCP=true
if /I "%1"=="/share" set SHARING=true
if /I "%1"=="/ras" set RAS=true
if /I "%1"=="/wireless" set WIRELESS=true
if /I "%1"=="/netcfg" set USE_NETCFG=true
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/WG" if not "%%b"=="" set WG=%%b)
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/CN" if not "%%b"=="" set CN=%%b)
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/PW" if not "%%b"=="" set PW=%%b)
if NOT "%_NETGUI%"=="" set _NETGUI_PARAMS=%_NETGUI_PARAMS% %1&GOTO _next_param
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/GUI" if not "%%b"=="" set _NETGUI=%%b)
:_next_param
shift
GOTO _GET_PARAMS
:_END_GET_PARAMS

if /I "%_NETGUI%"=="penetcfg" set USEPENETCFG=true
if /I "%_NETGUI%"=="netconfig" set USENETCONFIG=true

:: Check if Penetcfg/NetConfig exists in System32
if not exist "%systemroot%\system32\penetcfg.exe" set USEPENETCFG=false
if not exist "%systemroot%\system32\netconfig.exe" set USENETCONFIG=false

:: Check if netcfg exists
if not exist "%SystemRoot%\System32\netcfg.exe" SET USE_NETCFG=false

:: Set DHCP to true if either %SHARING% or %RAS% or %WIRELESS% is true
if "%SHARING%"=="true" SET DHCP=true
if "%RAS%"=="true" SET DHCP=true
if "%WIRELESS%"=="true" SET DHCP=true

::-------------------
:: Networking
::-------------------
echo. >> %_LOGFILE%
echo [Networking]>> %_LOGFILE%
echo - %TIME%: Start>> %_LOGFILE%

echo.>> %_LOGFILE%
echo.  Use PENetCFG      : %USEPENETCFG%>> %_LOGFILE%
echo.  Use NetConfig     : %USENETCONFIG%>> %_LOGFILE%
echo.  Sharing           : %SHARING%>> %_LOGFILE%
echo.  RAS Services      : %RAS%>> %_LOGFILE%
echo.  Wireless Services : %WIRELESS%>> %_LOGFILE%
echo.>> %_LOGFILE%

:-------------------------------------------------------------------
:_PENETCFG
if "%USEPENETCFG%"=="true" (
 %PM% "Network configuration with PenetCFG..."
 ECHO - %TIME%:  Starting PenetCFG>> %_LOGFILE%
 ECHO Starting PenetCFG
 start /wait penetcfg.exe %_NETGUI_PARAMS%
 goto :RASSERVICES
)
:_END_PENETCFG

:-------------------------------------------------------------------
:_NETCONFIG
if "%USENETCONFIG%"=="true" (
 %PM% "Network configuration with NetConfig..."
 ECHO - %TIME%:  Starting NetConfig>> %_LOGFILE%
 ECHO Starting NetConfig
 start /wait NetConfig.exe %_NETGUI_PARAMS%
 goto :RASSERVICES
)
:_END_NETCONFIG


:-------------------------------------------------------------------
 SET _params=
 
 IF "%CN%"=="" GOTO _end_cn
 SET _params=%_params% -cn %CN%
:_end_cn

 IF "%WG%"=="" GOTO _end_wg
 SET _params=%_params% -wg %WG%
:_end_wg

 if "%_params%"=="" GOTO _end_names

:_names
 Echo - %TIME%: Setting Computer Name (%CN%, %WG%)>> %_LOGFILE%
 Echo Setting Computer Name (%CN%, %WG%)
 bartpe %_params%
:_end_names

:_adm_pass
if "%PW%"=="" GOTO _end_adm_pass
 echo - %TIME%: Setting Administrator Pass>> %_LOGFILE%
 echo Setting Administrator Pass 
 net user Administrator %PW%>> %_LOGFILE%
:_end_adm_pass

if not "%DHCP%"=="true" GOTO _END_BASIC_NET

:-------------------------------------------------------------------
:: First check if basic net services are already installed

bartpe.exe -c c -q ms_msclient>nul
if "%errorlevel%"=="0" (
 echo Skipping Basic Net Initialization. Services already installed!
 echo Skipping Basic Net Initialization. Services already installed!>> %_LOGFILE%
 goto _END_BASIC_NET
)


:-------------------------------------------------------------------
:_BASIC_NET


%PM% "Network - Tcp/IP protocol"
echo - %TIME%: Installing Tcp/Ip protocol>> %_LOGFILE%
echo Installing Tcp/Ip protocol

if "%USE_NETCFG%"=="true" (
 netcfg -l %SystemRoot%\inf\netmscli.inf -c p -i ms_tcpip>> %_LOGFILE%
) else (
 bartpe.exe -c p -i ms_tcpip>> %_LOGFILE%
)

if errorlevel 1 goto _END_MAIN
echo.  OK>> %_LOGFILE%


%PM% "Network  - MsClient protocol"
echo - %TIME%: Installing MSClient protocol>> %_LOGFILE%
echo Installing MSClient protocol

if "%USE_NETCFG%"=="true" (
 netcfg -l %SystemRoot%\inf\netmscli.inf -c c -i ms_msclient>> %_LOGFILE%
) else (
 bartpe.exe -c c -i ms_msclient>> %_LOGFILE%
)
if errorlevel 1 goto _END_MAIN
echo.  OK>> %_LOGFILE%

%PM% "Network - Tcp/IP Service"
echo - %TIME%: Starting Tcp/IP service>> %_LOGFILE%
echo Starting Tcp/IP service

net start tcpip >> %_LOGFILE%
:: if errorlevel 1 goto _END_BASIC_NET
echo.  OK>> %_LOGFILE%

%PM% "Network - Dhcp Service"
echo - %TIME%: Starting DHCP service>> %_LOGFILE%
echo Starting DHCP service

net start dhcp >> %_LOGFILE%
:: if errorlevel 1 goto _END_BASIC_NET
echo.  OK>> %_LOGFILE%

%PM% "Network - NLA Service"
echo - %TIME%: Starting NLA service>> %_LOGFILE%
echo Starting NLA service

net start nla >> %_LOGFILE%
:: if errorlevel 1 goto _END_BASIC_NET
echo.  OK>> %_LOGFILE%

%PM% "Network - LMHOSTS Service"
echo - %TIME%: Starting LMHOSTS service>> %_LOGFILE%
echo Starting LMHOSTS service

net start lmhosts >> %_LOGFILE%
:: if errorlevel 1 goto _END_BASIC_NET
echo.  OK>> %_LOGFILE%

:_END_BASIC_NET

::---------------------------------------
:SHARING
if not "%SHARING%"=="true" goto _end_sharing


:: CHECK if ms_server service is installed

bartpe.exe -c s -q ms_server>nul
if "%errorlevel%"=="0" (
 echo MS Server service is already installed!
 echo MS Server service is already installed!>> %_LOGFILE%
 goto _END_SHARING
)

%PM% "Network - Installing MS Server"
echo - %TIME%: Installing MS Server>> %_LOGFILE%
echo Installing Microsoft Server...

if "%USE_NETCFG%"=="true" (
 netcfg -l %SystemRoot%\inf\netserv.inf -c s -i ms_server>> %_LOGFILE%
) else (
 bartpe.exe -c s -i ms_server>> %_LOGFILE%
)
if errorlevel 1 goto _END_MAIN
echo.  OK>> %_LOGFILE%


%PM% "Network - Starting MS Server"
echo - %TIME%: Starting MS Server>> %_LOGFILE%
echo Starting MS Server...

net start server>> %_LOGFILE%
if errorlevel 1 goto _END_SHARING
echo.  OK>> %_LOGFILE%

%PM% "Network - Sharing Drives..."
echo - %TIME%: Sharing Drives>> %_LOGFILE%
echo Sharing Drives...
for %%i in (b c d e f g h i j k l m n o p q r s t u v w x y z) do (
	if exist %%i:\nul net share drive-%%i=%%i:\
)
echo.  OK>> %_LOGFILE%
:_END_SHARING
::---------------------------------------



::---------------------------------------
:RASSERVICES
if not "%RAS%"=="true" goto _END_RASSERVICES

:: Enabling Serial COM ports
%PM% "Enabling COM ports..."
echo - %TIME%: Enabling COM ports>> %_LOGFILE%
echo Enabling COM ports...
if exist "%SystemRoot%\System32\HWPnP.exe" HWPnP.exe -all +ACPI\PNP0400 +ACPI\PNP0401 +ACPI\PNP0501\1 +ACPI\PNP0501\2 /u /log
echo - %TIME%: OK>> %_LOGFILE%

%PM% "Network - Starting RAS Services..."
echo - %TIME%: Installing RAS Protocols and Services>> %_LOGFILE%
echo Installing RAS protocols and Services...

if "%USE_NETCFG%"=="true" (
 netcfg -l %SystemRoot%\inf\netrast.inf -c p -i MS_L2TP
 netcfg -l %SystemRoot%\inf\netrast.inf -c p -i MS_PPTP
 netcfg -l %SystemRoot%\inf\netrast.inf -c p -i MS_PPPOE
 netcfg -l %SystemRoot%\inf\netrast.inf -c p -i MS_Wanarp
 netcfg -l %SystemRoot%\inf\netrast.inf -c p -i MS_NDISWAN
 netcfg -l %SystemRoot%\inf\netrass.inf -c s -i MS_RASCLI
 netcfg -l %SystemRoot%\inf\netrass.inf -c s -i MS_RASSRV
 netcfg -l %SystemRoot%\inf\netrass.inf -c s -i MS_RASMAN
) else (
 bartpe -c p -i ms_l2tp
 bartpe -c p -i ms_pptp
 bartpe -c p -i ms_pppoe
 bartpe -c p -i ms_wanarp
 bartpe -c p -i ms_ndisuio
 bartpe -c p -i ms_ndiswan
 bartpe -c s -i ms_rascli
 bartpe -c s -i ms_rassrv
 bartpe -c s -i ms_rasman
)


echo - %TIME%: Starting RAS Services>> %_LOGFILE%
echo Starting RAS Services...

::net start tapisrv
net start rasman

:_END_RASSERVICES
::---------------------------------------


::---------------------------------------
:WIRELESS
if not "%WIRELESS%"=="true" goto _END_WIRELESS

%PM% "Network - Wireless Services..."
echo - %TIME%: Installing Wireless Services>> %_LOGFILE%
echo Installing Wireless Service...

:: Install Wireless Service
bartpe -c s -i ms_wzcsvc

echo - %TIME%: Starting Wireless Services>> %_LOGFILE%
echo Starting Wireless Service...
net start wzcsvc

:_END_WIRELESS


:_END_MAIN
echo - %TIME% Network Configuration Completed>>%_LOGFILE%

:_END
ENDLOCAL

goto :EOF