::===========================================================
::  PE Configuration Scripts, (c) reatogo 2005
::-----------------------------------------------------------
:: init-pnp.cmd
:: DESCR:     Plug and Play device detection / installation
:: Version:   1.0
::
:: Uses:      bartpe, HwPnP by Paraglider
::
:: Script By: AEC-REATOGO
::===========================================================

@echo off
SETLOCAL ENABLEEXTENSIONS 

::echo - %TIME%: init-pnp.cmd %1 %2 %3 %4 %5 %6 >> c:\mslogon.log

if "%1"=="/?" GOTO _HELP
if /I "%1"=="/help" GOTO _HELP
GOTO _MAIN

:_HELP
echo ===============================================================================
echo init-pnp.cmd
echo PE Configuration Scripts, (c) reatogo 2005
echo.
echo DESCRIPTION: Plug and Play device detection / installation
echo.
echo init-pnp.cmd [/?][/display] [/NET] [/ComPorts] [/USB] 
echo              /detection:[basic ^| full ^| hwpnp] [{HWPNP_PARAMS}]
echo ===============================================================================
:_END_HELP
GOTO _END

:_MAIN
set _LOGFILE=%temp%\init.log
set PM=start /wait xpeinit.exe -f -m

set $DETECTION=
set $HWPNP_PARAMS=


:_GET_PARAMS
if "%1"=="" goto _END_GET_PARAMS
if /I "%1"=="/ComPorts" set $COMPORTS=true
if /I "%1"=="/USB" set $USB=true
if /I "%1"=="/DISPLAY" set $DISPLAY=true
if /I "%1"=="/NET" set $NET=true
if /I "%$DETECTION%"=="hwpnp" set $HWPNP_PARAMS=%$HWPNP_PARAMS% %1&GOTO _next_param
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/detection" if not "%%b"=="" set $DETECTION=%%b)
:_next_param
shift
GOTO _GET_PARAMS
:_END_GET_PARAMS

set USEHWPNP=false

:: FULL Detection is handled with HWPNP
if /I "%$DETECTION%"=="full" set USEHWPNP=true
if /I "%$DETECTION%"=="hwpnp" set USEHWPNP=true
if /I "%$DETECTION%"=="custom" set USEHWPNP=true

if %USEHWPNP%==true if not exist "%systemroot%\system32\HwPnP.exe" set USEHWPNP=false

:: Revert to basic detection if HwPnP is not found 
if not %USEHWPNP%==true set $DETECTION=basic

if /I "%$DETECTION%"=="basic" set $DETECTION_CMD=bartpe -pnp 
if /I "%$DETECTION%"=="full"  set $DETECTION_CMD=start /wait HWPnP.exe +all /log /p /r
if /I "%$DETECTION%"=="hwpnp" set $DETECTION_CMD=start /wait HWPnP.exe %$HWPNP_PARAMS%

echo DETECTION
echo  Type : %$DETECTION%
echo  Cmd  : %$DETECTION_CMD%
echo EXTRA DETECTION
echo  Init NET      : %$NET%
echo  Init VIDEO    : %$DISPLAY%
echo  Init ComPorts : %$COMPORTS%
echo  Init USB      : %$USB%
echo.

:DETECTION
::-------------------------
:: PnP Hardware Detection
::-------------------------
%PM% "PnP Device Detection..."
echo. >> %_LOGFILE%
echo [PnP Hardware Detection]>> %_LOGFILE%
echo - %TIME% Start>> %_LOGFILE%
echo Detection     : %$DETECTION%>> %_LOGFILE%
echo Detection Cmd : %$DETECTION_CMD%>> %_LOGFILE%

:: Make sure netcfgx is registered otherwise nic installation may fail
regsvr32 /s netcfgx.dll

ECHO - %TIME% Running "%$DETECTION_CMD%" >> %_LOGFILE%
%$DETECTION_CMD% >> %_LOGFILE%

:: Extra initialization handled with HwPnP
:_EXTRA
if not exist "%systemroot%\system32\HwPnP.exe" ECHO init-pnp.cmd: WARNING: HWPnP not found&GOTO _END_EXTRA

if "%$COMPORTS%"=="true" (
  ECHO - Detect and enable ComPorts
  ECHO - %TIME% Detect and enable ComPorts >> %_LOGFILE%
  start /wait HWPnP.exe -all +ACPI\PNP0400 +ACPI\PNP0401 +ACPI\PNP0501\1 +ACPI\PNP0501\2 /u /log
)

if "%$USB%"=="true" (
 %PM% "PnP USB device detection..."
 ECHO - Detect USB devices
 ECHO - %TIME% Detect USB devices >> %_LOGFILE%
 start /wait HWPnP.exe -all +STORAGE\VOLUME +USB\ +USBSTOR\ /d /log
)

if "%$DISPLAY%"=="true" (
 %PM% "PnP Video device detection..."
 ECHO - Detect DISPLAY devices
 ECHO - %TIME% Detect DISPLAY devices >> %_LOGFILE%
 start /wait HWPnP.exe -all +@DISPLAY /log
)

if "%$NET%"=="true" (
 %PM% "PnP NET device detection..."
 ECHO - Detect NET devices
 ECHO - %TIME% Detect NET devices >> %_LOGFILE%
 start /wait HWPnP.exe -all +@NET /log
)
:_END_EXTRA

echo - %TIME% Completed>> %_LOGFILE%


:_END
ENDLOCAL
