::================================================================
::  PE Configuration Scripts, (c) reatogo 2005
::----------------------------------------------------------------
:: init-ramdrv-data.cmd
:: DESCR:     Format and tranfer profiles & data to RAMDRV
:: Version:   1.0
::
:: Uses:      REG.EXE from XP-SP2
::
:: Script By: AEC-REATOGO
::================================================================

@echo off
SETLOCAL ENABLEEXTENSIONS 

::echo - %TIME%: init-ramdrv-data.cmd %1 %2 %3 >> c:\mslogon.log


if "%1"=="/?" GOTO _HELP
if /I "%1"=="/help" GOTO _HELP
GOTO _MAIN

:_HELP
echo ========================================================================
echo init-ramdrv-data.cmd
echo PE Configuration Scripts, (c) reatogo 2005
echo.
echo DESCRIPTION: Format and tranfer profiles & data to RAMDRV
echo              RAMDRV can be a RamDrive, a Virtual Disk, ...
echo.
echo init-ramdrv-data.cmd [/?] [/F:{Filesystem}] [/init]
echo   /help or /?       Show this message
echo   /F:{FileSystem}   {FileSystem} is NTFS or NTFS-C or FAT32 or FAT
echo   /C                Compress volume (only when specified with /F:NTFS)
echo   /INIT             Initialize RAMDRV with profile structure 
echo =======================================================================
:_END_HELP
GOTO _END


:_MAIN
set _LOGFILE=%temp%\init.log
set PM=start /wait xpeinit.exe -f -m

:: If exists use the XP version of Reg.exe (named reg_xp.exe)
:: (W2k3 version is incompatible)
set REGAPP=reg.exe
if exist "%systemRoot%\system32\reg_xp.exe" set REGAPP=reg_xp.exe


set FS=
set format_ram=false
set compress_ramdrv=false
set init_ramdrv=false
set format_params=

:_GET_PARAMS
if "%1"=="" goto _END_GET_PARAMS
if /I "%1"=="/F:FAT" set FS=FAT
if /I "%1"=="/F:FAT32" set FS=FAT32
if /I "%1"=="/F:NTFS" set FS=NTFS
if /I "%1"=="/F:NTFS-C" set FS=NTFS&set compress_ramdrv=true
if /I "%1"=="/C" set compress_ramdrv=true
if /I "%1"=="/INIT" set init_ramdrv=true
shift
GOTO _GET_PARAMS
:_END_GET_PARAMS

if not "%FS%"=="" set format_ram=true

:: -----------------------------------------------------------------------
::  Format ramdrive with NTFS (optionally compressed) | FAT32 | FAT
:: -----------------------------------------------------------------------
:_format
set format_params=%RAMDRV% /FS:%FS% /V:RAMDisk /Q /x /FORCE
if "%compress_ramdrv%"=="true" if "%FS%"=="NTFS" set format_params=%format_params% /C
if "%format_ram%"=="true" format %format_params%



:: AT THIS POINT %RAMDRV% IS AVAILABLE FOR WRITING

if not "%init_ramdrv%"=="true" goto _end


:: Make sure some basic directories exist
if not exist %TEMP% md %TEMP%
if not exist %RAMDRV%\bin md %RAMDRV%\bin

echo INITLOG > %_LOGFILE%
echo.>> %_LOGFILE%
echo Date: %DATE%>> %_LOGFILE%
echo Time: %TIME%>> %_LOGFILE%
echo.>> %_LOGFILE%
echo [RAM initialization]>> %_LOGFILE%
echo - %TIME%: Start>> %_LOGFILE%
echo - ReFormated=%format_ram%>> %_LOGFILE%
echo - Compressed=%compress_ramdrv%>> %_LOGFILE%

:: -----------------------------------------------------------------------
::  Transfer Data (profiles,files,...) to RAMDRV
::   
::   - If found expand profiles-7z.exe   to %PROFILESDIR%
::   - If found expand Shortcuts-7z.exe  to %PROFILESDIR%
::   - If found expand ramfiles-7z.exe   to %RAMDRV%
:: -----------------------------------------------------------------------

echo - %TIME%: Starting RAMDRV Data Transfer>> %_LOGFILE%

::-----------------------------
:: GET Local Ansi/OEM code page
::-----------------------------
set CodePage=HKLM\SYSTEM\CurrentControlSet\Control\Nls\CodePage
FOR /F "tokens=1-2*" %%a IN ('%REGAPP% query "%CodePage%" /v "OEMCP"') DO (
 set OEMCP=%%c)
FOR /F "tokens=1-2*" %%a IN ('%REGAPP% query "%CodePage%" /v "ACP"') DO (
 set ACP=%%c)


:: ARCHIVES_ROOT: Specifies the folder to look for archived data

set ARCHIVES_ROOT=%SystemDrive%\SFX

:: Expand compressed default structure (look for 7z-sfx archives) 

if not exist "%PROFILESDIR%" md "%PROFILESDIR%">nul

:: We first look for compressed archives of Profiles. 

:_PROF_EXTRACT
:: 7zip SFX
if exist "%ARCHIVES_ROOT%\profiles-7z.exe" (
  echo -   Decompressing 7z SFX: %ARCHIVES_ROOT%\profiles-7z.exe >> %_LOGFILE%
  %ARCHIVES_ROOT%\profiles-7z.exe -o"%PROFILESDIR%\" -y
)
:_END_PROF_EXTRACT

:_PROFCHECK
:: Make a check if %USERPROFILE% has been created. 
:: If not, call init-profiles.cmd to prepare the default RamDrv.
:: If still %USERPROFILE% has not been created quit.

if exist "%USERPROFILE%" goto _profcheck
echo - SOMETHING IS WRONG. Profile structure not found.>> %_LOGFILE%
echo - Will now create default profile structure.>> %_LOGFILE%

:: Use the create-profiles.cmd generated with preprocessing
if exist "%systemroot%\system32\create-profiles.cmd"  call create-profiles.cmd
::
::if exist "%systemroot%\system32\init-profiles.cmd"  call init-profiles.cmd
if not exist "%USERPROFILE%" goto _end

:_profcheck

:_SHORTCUTS_EXTRACT
:: Shortcuts archive should be prepared so that it uses dir paths relative to 
:: ProfilesDir and properly localized. 
::   E.g we may have "Default User\Start Menu\Programs" and not
::       "Documents and Settings\Default User\Start Menu\Programs"

:: 7zip SFX
if exist %ARCHIVES_ROOT%\shortcuts-7z.exe (
  echo -   Decompressing 7z SFX: %ARCHIVES_ROOT%\shortcuts-7z.exe to "%PROFILESDIR%" >> %_LOGFILE%
  %ARCHIVES_ROOT%\shortcuts-7z.exe -o"%PROFILESDIR%\" -y
)
:_END_SHORTCUTS_EXTRACT

chcp %ACP%>NUL

CALL :GetUserFolder "AppData" SF_APPDATA
if exist "%ARCHIVES_ROOT%\appdata-7z.exe" (
  echo -   Decompressing 7z SFX: "%ARCHIVES_ROOT%\appdata-7z.exe" to "%SF_APPDATA%">> %_LOGFILE%
  %ARCHIVES_ROOT%\appdata-7z.exe -o"%SF_APPDATA%\" -y
)

CALL :GetCommonFolder "Common AppData" SF_COM_APPDATA
if exist "%ARCHIVES_ROOT%\commonappdata-7z.exe" (
  echo -   Decompressing 7z SFX: "%ARCHIVES_ROOT%\commonappdata-7z.exe" to "%SF_COM_APPDATA%" >> %_LOGFILE%
  %ARCHIVES_ROOT%\commonappdata-7z.exe -o"%SF_COM_APPDATA%\" -y
)

:_RAMFILES_EXTRACT
:: Expand compressed ramfiles

if exist "%ARCHIVES_ROOT%\ramfiles-7z.exe" (
  echo -   Decompressing 7z SFX: %ARCHIVES_ROOT%\ramfiles-7z.exe to "%RAMDRV%">> %_LOGFILE%
  %ARCHIVES_ROOT%\ramfiles-7z.exe -o"%RAMDRV%\" -y
)
:_END_RAMFILES_EXTRACT

chcp %OEMCP%>NUL

echo - %TIME%: RamDrv Data transfer completed>> %_LOGFILE%


:_end
set format_ram=
set compress_ramdrv=
set format_params=

endlocal
GOTO :EOF



:GetCommonFolder
:: GetCommonFolder "Standard_Folder_Name" ENVVar
set SP=HKLM\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders
set DestFolder=
for /f "tokens=1-3* skip=4 delims=	" %%a in ('%REGAPP% query "%SP%" /v %1') DO set DestFolder=%%c
ENDLOCAL &set %2=%DestFolder%
GOTO :EOF

:GetUserFolder
:: GetShellFolder "Standard_Folder_Name" ENVVar
set SP=HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders
set DestFolder=
for /f "tokens=1-3* skip=4 delims=	" %%a in ('%REGAPP% query "%SP%" /v %1') DO set DestFolder=%%c
ENDLOCAL &set %2=%DestFolder%
GOTO :EOF

