::================================================================
::  PE Configuration Scripts, (c) reatogo 2005
::----------------------------------------------------------------
:: init-ramdrv.cmd
:: DESCR:     Enable RAMDRV as normal RAM drive or Virtual Disk
:: Version:   1.0
::
:: Uses:      AutoRamResizer (Sherpya), vdk, devcon (MS) 
::
:: Script By: AEC-REATOGO
::================================================================

@echo off
SETLOCAL ENABLEEXTENSIONS 

::echo - %TIME%: init-ramdrv.cmd %1 %2 %4 %5 >> c:\mslogon.log

if "%1"=="/?" GOTO _HELP
if /I "%1"=="/help" GOTO _HELP
GOTO _MAIN


:_HELP
echo ================================================================================
echo DESCRIPTION: Enable RAMDRV as normal RAM drive or Virtual Disk
echo.
echo init-ramdrv.cmd /type:[ram^|vdisk] /size:^<drive_size^> 
echo                 /letter:^<ramdrv_letter^> /vdhost:[^<drive_letter^>^|$1^|$2^|...]
echo.
echo   /type:^<drive_type^> Set the drive type to ram or vdisk
echo   /size:^<drive_size^> Specify drive_size: 
echo      For ram drive:   8M^|16M^|32M^|64M^|96M^|128M^|256M^|384M^|512M^|1024M^|auto
echo                       DEFAULT: auto
echo      For vdisk drive: 200M ^| 300M ^| 500M ^| 1G ^| 2G ^| 4G ^| 8G ^| 16G
echo   /letter:^<drive_letter^>: Specify a drive letter to mount RAMDRV disk 
echo                             DEFAULT: %%RAMDRV%%
echo   /vdhost:^<drive_letter^>: Specify a drive letter with RW access to host vdisks
echo                             $D1-$D5 specifies the 1st,2nd,... available drive
echo                             DEFAULT: $D1
echo ================================================================================
:_END_HELP
GOTO _END

:_MAIN
set _LOGFILE=%temp%\init.log
set PM=start /wait xpeinit.exe -f -m

set DRV_TYPE=ram
set DRV_SIZE=auto
set DRV_VDHOST=$D1
set DRV_LETTER=%ramdrv%


:_GET_PARAMS
if "%1"=="" goto _END_GET_PARAMS
if "%1"=="/test_switch" set TEST_VAR=true
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/type" if not "%%b"=="" set DRV_TYPE=%%b)
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/size" if not "%%b"=="" set DRV_SIZE=%%b)
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/letter" if not "%%b"=="" set DRV_LETTER=%%b)
for /f "tokens=1* delims=:" %%a in ("%1") do (if /I "%%a"=="/vdhost" if not "%%b"=="" set DRV_VDHOST=%%b)
shift
GOTO _GET_PARAMS
:_END_GET_PARAMS


::----------------------------------------
SET RAMDRVLETTER=%ramdrv:~0,1%
for %%i in (b c d e f g h i j k l m n o p q r s u v w x y z) do (
 if /I "%%i"=="%DRV_LETTER%" SET RAMDRVLETTER=%%i
)

if "%RAMDRVLETTER%"=="" echo Missing or Invalid drive letter specification.&GOTO _END
if /I "%RAMDRVLETTER%"=="B" set RAMDRVLETTER=b



::----------------------------------------
set RW_DISK=
if /I "%DRV_TYPE%"=="ram" GOTO _RAMDISK
if /I "%DRV_TYPE%"=="vdisk" GOTO _VDISK

echo Invalid drive type specification ["%DRV_TYPE%"].&GOTO _END


::----------------------------------------
:_RAMDISK
if /I not "%DRV_TYPE%"=="ram" GOTO _END_RAMDISK

set RAMSIZE=
IF /I "%DRV_SIZE%"=="8M" set RAMSIZE=0x800000
IF /I "%DRV_SIZE%"=="16M" set RAMSIZE=0x1000000
IF /I "%DRV_SIZE%"=="32M" set RAMSIZE=0x2000000
IF /I "%DRV_SIZE%"=="64M" set RAMSIZE=0x4000000
IF /I "%DRV_SIZE%"=="96M" set RAMSIZE=0x6000000
IF /I "%DRV_SIZE%"=="128M" set RAMSIZE=0x8000000
IF /I "%DRV_SIZE%"=="256M" set RAMSIZE=0x10000000
IF /I "%DRV_SIZE%"=="384M" set RAMSIZE=0x18000000
IF /I "%DRV_SIZE%"=="512M" set RAMSIZE=0x20000000
IF /I "%DRV_SIZE%"=="1024M" set RAMSIZE=0x40000000

if /I "%DRV_SIZE%"=="auto" set RAMSIZE=auto

if "%RAMSIZE%"=="" echo Invalid size specification [%DRV_SIZE%].&GOTO _END

:: Check if we need to resize: Get current disk size setting from registry
SET _RAMDRV_KEY=HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Ramdriv\Parameters
SET _CUR_RSIZE=
FOR /F "skip=4 tokens=3 delims=	" %%a IN ('reg query %_RAMDRV_KEY% /v DiskSize') DO (
 SET _CUR_RSIZE=%%a
)
IF /I "%_CUR_RSIZE%"=="%RAMSIZE%" GOTO _END_RAMDISK


::----------------------------------------
echo Disabling a possibly open VDisk Drive
vdk close 0

::----------------------------------------
if "%RAMSIZE%"=="auto" GOTO _AUTO_RESIZE

echo Setting ram disk parameters: (DriveLetter: %RAMDRVLETTER%, DiskSize: %RAMSIZE%)
REG ADD HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Ramdriv\Parameters /f /v DiskSize /t REG_DWORD /d %RAMSIZE%>nul
REG ADD HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Ramdriv\Parameters /f /v DriveLetter /t REG_SZ /d %RAMDRVLETTER%:>nul

echo Restarting ramdrv service...
DEVCON.exe disable ramdriv
DEVCON.exe enable  ramdriv
GOTO _END_RAMDISK

::----------------------------------------
:_AUTO_RESIZE
if exist "%SystemRoot%\System32\AutoRamResizer.exe" (
  echo "Autoresizing RAM..."
  start /wait AutoRamResizer.exe
) else (
  echo ERROR: AutoRamResizer executable not found.
)
:_END_AUTO_RESIZE

:_END_RAMDISK



:_VDISK
if /I not "%DRV_TYPE%"=="vdisk" GOTO _END_VDISK

:: ================================================
::  Get the 5 first existing drives and store in 
::  $D1, $D2, $D3, $D4, $D5
:: ---------------------------------------------
set DRVSTR=CDEFGHIJKLMNOPQRSTUVWXYZ
set /a num=0

:_LOOP
if "%num%"=="5" GOTO _END_LOOP
set /a num=num+1

:_LOOP1
if "%DRVSTR%"=="" GOTO _END_LOOP1
set CURDRV=%DRVSTR:~0,1%
set DRVSTR=%DRVSTR:~1%
if exist %CURDRV%:\nul set $D%num%=%CURDRV%&GOTO _END_LOOP1
set curdrv=
GOTO _LOOP1
:_END_LOOP1

GOTO _LOOP
:_END_LOOP

set num=
set curdrv=
:: ================================================


if "%$D1%"=="" echo. No available disks to host the virtual disk!&GOTO _END

:: default to 1st available disk
if "%DRV_VDHOST%"=="" set DEF_DSK=%$D1%

if "%DRV_VDHOST%"=="$D1" set DEF_DSK=%$D1%
if "%DRV_VDHOST%"=="$D2" set DEF_DSK=%$D2%
if "%DRV_VDHOST%"=="$D3" set DEF_DSK=%$D3%
if "%DRV_VDHOST%"=="$D4" set DEF_DSK=%$D4%
if "%DRV_VDHOST%"=="$D5" set DEF_DSK=%$D5%

if "%DEF_DSK%"=="" SET DEF_DSK=%DRV_VDHOST:~0,1%


::----------------------------------------------------------------------------
:: Test if specified drive exists
if not exist %DEF_DSK%:\nul echo. Not a valid drive ["%DEF_DSK%"]. &GOTO _END

:: Test if %DEF_DSK% is writable
set tmpfn=tst-%random%.$$$
echo test> %DEF_DSK%:\%tmpfn%
if not exist "%DEF_DSK%:\%tmpfn%" echo Not a R/W drive.&GOTO _END
del %DEF_DSK%:\%tmpfn% >nul


::----------------------------------------------------------------------------

set VDSFXDIR=%SYSTEMDRIVE%\SFX

if "%DRV_SIZE%"=="" SET DRV_SIZE=200M
if "%DRV_SIZE%"=="auto" SET DRV_SIZE=200M

set VFILE=
IF /I "%DRV_SIZE%"=="100M" set VFILE=ramfile100
IF /I "%DRV_SIZE%"=="200M" set VFILE=ramfile200
IF /I "%DRV_SIZE%"=="300M" set VFILE=ramfile300
IF /I "%DRV_SIZE%"=="500M" set VFILE=ramfile500
IF /I "%DRV_SIZE%"=="1G"   set VFILE=ramfile1g
IF /I "%DRV_SIZE%"=="2G"   set VFILE=ramfile2g
IF /I "%DRV_SIZE%"=="4G"   set VFILE=ramfile4g
IF /I "%DRV_SIZE%"=="8G"   set VFILE=ramfile8g
IF /I "%DRV_SIZE%"=="16G"  set VFILE=ramfile16g

if "%VFILE%"=="" echo Invalid disk size [%DRV_SIZE%].&GOTO _END

:: if not exist "%VDSFXDIR%\%VFILE%.exe" echo 7z-Archived VDisk image "%VDSFXDIR%\%VFILE%.exe" not foumd.& GOTO _END
if not exist "%VDSFXDIR%\%VFILE%.rar" echo rar-Archived VDisk image "%VDSFXDIR%\%VFILE%.rar" not foumd.& GOTO _END

:_NEXT_VDISK
cls
echo Current Virtual Disk choices: 
echo.
echo.  * VDISK Size           : %DRV_SIZE%
echo.  * VDISK Archived File  : %SystemDrive%\SFX\%VFILE%
echo.  * VDISK Host Directory : %DEF_DSK%:\_ramfile_
echo.  * VDISK Mount Drive    : %RAMDRVLETTER%:
echo.

ECHO.
ECHO. - Disabling RamDriv...
DEVCON.exe disable ramdriv > nul

ECHO.
ECHO. - Starting Virtual Disk Driver ...
vdk start

ECHO.
ECHO. - Closing a possibly open vdisk 0 image...
vdk close 0

ECHO.
ECHO. - Extracting Disk Image...
:: %VDSFXDIR%\%VFILE% -e -o%DEF_DSK%:\_ramfile_\ -y
unrar.exe  x -o+ -y %VDSFXDIR%\%VFILE% %DEF_DSK%:\_ramfile_\

ECHO.
ECHO. - Mounting a RW Virtual Disk 0 as %RFDRV% ...
vdk open 0 %DEF_DSK%:\_ramfile_\mount-as-ramdrive.descriptor /rw /p:1 /l:%RAMDRVLETTER%:

:_END_VDISK

:_END
set RW_DSK=
set RAMSIZE=
set VFILE=
set VSIZE=
set RFDRV=

goto :EOF


