//RAJZ OSZTLY
//
#ifndef _RAJZ_	//ujabb definci s fordtsi hiba elkerlsre
#define _RAJZ_

//
extern HWND hwnd;
#include <ddraw.h>
#include <stdio.h>
//
//#pragma comment(lib, "Ole32.lib")
//
typedef struct
{
	LPDIRECTDRAWSURFACE7 kep;	//a memrira mutat pointer
	int sor;					//betlttt kp magassga (pixelekben)
	int oszlop;					//szlessg pixelekben
}KEP,*LPKEP;

//dekralcik:
 class RAJZ		//osztly neve
 {
 public:		//public sz alatti fggvnyek- vltozk kvlrl lthatak
	 RAJZ();	//konstruktor dekrallsa
	 ~RAJZ();	//destruktor
	 bool init();
	 void flip();
	 void hatter(DWORD szin=0);
	 void kiirbetu(LPCTSTR betu,int x,int y);
   	 void kiirszam(int szam,int x, int y);
	 void rajzol(int forrasfelulet,int forrasx,int forrasy,int forrassz,int forrasm,
				int celfelulet,int celx,int cely);
//
//


 protected:		//protected alattiakat csak az osztly lthatja s mg az utd osztlyok
	LPDIRECTDRAW7 obj;								//objektum mutat
	LPDIRECTDRAWSURFACE7	front;					//elskpernyre mutat pointer
	LPDIRECTDRAWSURFACE7	back;					//htskpernyre mutat pointer
	LPDIRECTDRAWCLIPPER		cl;						//klipper objektum		
	KEP					kepek[10];					//vrhatan ennyi kpfellet elg lesz
	void torles();
	void	load_init(int melyiket=-1,int hova= 0);	//resen meghivva =inicializlja az sszeset                   
	bool 	loadbmp(LPCTSTR nev,int hova);			//ez tlti be a kpet
	DWORD	szinkulcs;								//az tltsz szn trolsra

 };

//Megvalstsok:
 RAJZ::RAJZ()	//A konstruktor neve maga az osztlynv nem adhat vissza rtket,
 {				//teht tipusa sem lehet itt csak egy res konstruktor van egyenlre
	 szinkulcs=0x00ff00ff;

 }
 //
 RAJZ::~RAJZ()	//destruktor egyenlre ez is res.
 {
	 torles();
 }
 //
 bool RAJZ::init()
 {
	HRESULT hr;	//egy visszajelzs,hogy sikerlt-e a fggvnyt vgrehajtani
    hr = DirectDrawCreateEx( NULL, (VOID**)&obj,IID_IDirectDraw7, NULL );//tadjuk a mutatt
	//a directdraw objektum ltrehozshoz
    if(hr!=DD_OK) return false;
	hr = obj->SetCooperativeLevel( hwnd, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN );//rgyttmkdsi szin
	//teljes kperny kell
    if(hr!=DD_OK) return false;
	hr=obj->SetDisplayMode( 800, 600, 32,75,0);//kperny felbonts,sznmlysg,frekvencia.
    if(hr!=DD_OK) return false;
    DDSURFACEDESC2 ddsd;//struktra helyfoglalasa
    ZeroMemory( &ddsd, sizeof( ddsd ) );//adatok kitltse
    ddsd.dwSize            = sizeof( ddsd );
    ddsd.dwFlags           = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP |DDSCAPS_COMPLEX ;
    ddsd.dwBackBufferCount = 1;//1 db httrfellet kell
	hr = obj->CreateSurface( &ddsd, &front,NULL );//ltrehozzuk a felletet
    if(hr!=DD_OK) return false;
	DDSCAPS2 ddscaps;
    ZeroMemory( &ddscaps, sizeof( ddscaps ) );
    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
	hr = front->GetAttachedSurface( &ddscaps,&back );//lekrdezzk a htskperny cmt
    if(hr!=DD_OK) return false;
	hr = obj->CreateClipper( 0, &cl, NULL );//klipper objektum ltrehozsa
    cl->SetHWnd( 0, hwnd );
    hr = back->SetClipper(cl);//s hozzrendelse a httrhez.
    UpdateWindow(hwnd);			//ablakfrissts
	hatter(0x00000080);
	load_init();// mivel nincs bemen adat mindet betlti.
	return true;//ha eddig elr a progi,akkor van dx felletnk.
	
 }
 //
void RAJZ::torles()
 {
	 for(int i=0;i<10;i++)	//elsnek a kpfelleteket trljk
	 {
		 if(kepek[i].kep){ kepek[i].kep->Release();kepek[i].kep=NULL;}
	 }
	 obj->Release();obj=NULL;// s magt at ddraw objektumot
 }
//KPERNYVLTS
void RAJZ::flip()
{
	rajzol(0,0,0,800,600,-1,0,0);
	rajzol(1,0,0,18,18,-1,400,300);
	kiirbetu("els szvegem",100,100);
	kiirszam(0x00ff00ff,100,120);
	BOOL inf=front->Flip(NULL,0);
//	if(inf!=DD_OK /*&& aktiv*/){obj->RestoreAllSurfaces();UpdateWindow( hwnd);load_init();};
}
// HTTRSZIN
void RAJZ::hatter(DWORD szin)
{
	DDBLTFX dfx;ZeroMemory(&dfx,sizeof(dfx)); 
	dfx.dwSize=sizeof(dfx);dfx.dwFillColor=szin;
	back->Blt(NULL,NULL,NULL,DDBLT_COLORFILL,&dfx);
	front->Flip(NULL,0);back->Blt(NULL,NULL,NULL,DDBLT_COLORFILL,&dfx);
}
//
void RAJZ::kiirbetu(LPCTSTR betu,int x,int y)
{

	char buffer[64];HDC hdc;					
	back->GetDC(&hdc);sprintf(buffer,betu);	//lekrdezzk a httrfellet cmt	
	SetTextColor(hdc,0x00ff40ff);//RGB(64,64,255) 
	//SetBkColor(hdc,0x000000ff);	//00bbggrr	httrszin
	SetBkMode(hdc,TRANSPARENT);//OPAQUE
	TextOut(hdc,x,y,buffer,strlen(buffer));	//strlen fggvny megllaptja a sztring hosszt
	back->ReleaseDC(hdc);//ha mr nem kell megszntetjk						
}
/**/
void RAJZ::kiirszam(int szam,int x,int y)
{
	char bufer[20];
	itoa(szam,bufer,10);//bemen adat hov tegye az eredmnyt s milyen szmrendszerben	
	kiirbetu(bufer,x,y);
}
//
/**/
void RAJZ::load_init(int melyiket,int hova)
{
     int i=0,hossz;
     LPCTSTR nevek[]={"map\\h8.bmp","map\\atom.bmp",""}; //itt troljuk a neveket,utoljra egy res sztring
     if (melyiket ==-1)
     {	
	   while(1)
	   {
		 hossz= strlen( nevek[i]);//lekrdezzk a sztring hosszt
		 if(hossz==0)break;			//ha nincs vagy res asztring vge                       
		 hova=i;
		 loadbmp( nevek[i],hova);
		 i++;
       }
       return;
   }
   else 
   {
        hossz= strlen( nevek[melyiket]);
        if(hossz==0)return;
        loadbmp( nevek[melyiket],hova);
   }
        
}
//
//
bool RAJZ::loadbmp(LPCTSTR nev,int i)
{
	

	if(kepek[i].kep)								//volt e mr brtltve kp?
	{
		kepek[i].kep->Release();kepek[i].kep=NULL;	//Ha volt mr betltve trljk
	}
	HRESULT hRet;									//info a fggvny lefutsrl
	DDSURFACEDESC2 ddsd;
	DWORD* lPSurface=NULL;
	int lPitch=0;
	FILE *fp;
	DWORD szine=0,size=0;
	unsigned long width,height,lineend;
	short type;/*,lineend*/;
	unsigned char *sor;
	fp=fopen(nev,"rb");			//megnyitjuk olvassra
	if(fp==NULL)
	{
		MessageBox(NULL,"nem j nv vagy elrsi t","",0); return false;
	}
	fread(&type, sizeof(short), 1, fp);//afile nem 0x4d42 vel kezddik,akkor nem bmp
	if (type != 0x4D42)
	{
		fclose(fp);
		return false;
	}
	fread(&size,sizeof(DWORD),1,fp);//fjl mrete
	fseek(fp, 18, SEEK_SET);		//18.byte-on van a szlessg magassg adat
	fread(&width, sizeof(long), 1,fp);
	fread(&height, sizeof(long), 1,fp);
	lineend=(size-54-(width*height*3))/height;//hossz-fejlc * 3 szin a vgr   
	ZeroMemory(&ddsd,sizeof(ddsd));//mivel tudjuk az adatokat ltre lehet hozni a felletet
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_PIXELFORMAT | DDSD_WIDTH | DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY;
	ddsd.dwWidth =width;
	ddsd.dwHeight =height;
	ddsd.ddpfPixelFormat.dwSize = sizeof(ddsd.ddpfPixelFormat);
	ddsd.ddpfPixelFormat.dwFlags = DDPF_RGB;
	ddsd.ddpfPixelFormat.dwRGBBitCount = 32;
	ddsd.ddpfPixelFormat.dwRBitMask = 0x00ff0000;
	ddsd.ddpfPixelFormat.dwGBitMask = 0x0000ff00;
	ddsd.ddpfPixelFormat.dwBBitMask = 0x000000ff;
	ddsd.ddpfPixelFormat.dwRGBAlphaBitMask = 0x00000000;
	hRet = obj->CreateSurface(&ddsd, &kepek[i].kep, NULL);	//ellltjuk a felletet
	if (hRet != DD_OK)										//a video memriban
	{
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
	hRet = obj->CreateSurface(&ddsd, &kepek[i].kep, NULL);	//ha nincs hely,akkor a rendszerben
	}
	if (hRet != DD_OK)
		return false;
	DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue  = szinkulcs;//hozzrendeljk a fellethez at tltsz sznt
	ddck.dwColorSpaceHighValue = szinkulcs;
	kepek[i].kep->SetColorKey( DDCKEY_SRCBLT, &ddck );
	ZeroMemory(&ddsd,sizeof(ddsd));
	ddsd.dwSize=sizeof(ddsd);
	if ((kepek[i].kep->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL)) != DD_OK)//zroljuk az adatfeltltshez
		//a Lock() fggvny egyben visszaadja fellet memriacmt a lpSurface adattagban
	MessageBox(hwnd, "Failed to lock the surface", "Surface Error", MB_OK);
	lPitch = (int)ddsd.lPitch;
	lPSurface = (DWORD*)ddsd.lpSurface; //fellet memrija
	fseek(fp,54,SEEK_SET);				//rllunk az adatok elejre
	for(int k=height-1; k>=0; k--)
	{

		sor=(unsigned char*)calloc(3*width,sizeof(unsigned char));//helyfoglals egy sornyi adatnak
		fread(sor,width*3*sizeof(char),1,fp);//belvasunk szlessg*3 byte-ot
		for(unsigned long i=0; i<width; i++)	//
		{
			szine=(*(sor+i*3+2)<<16)|(*(sor+i*3+1)<<8)|(*(sor+i*3));//tkonvertljuk DWORD-
			lPSurface[i+k*(lPitch>>2)]=szine;
		}
		free(sor);
		if(!feof(fp)) fseek(fp,lineend,SEEK_CUR);               //sorvge tlpse
	}
	fclose(fp);					//file lezrsa
	kepek[i].kep->Unlock(NULL);	//kpfellet felszabadtsa
	kepek[i].oszlop=	width;	//eltesszk a szlessget,s a magassgot htha mg kell.
	kepek[i].sor=	height;
	return true;
}
void RAJZ::rajzol(int fsurf,int fx,int fy,int fsz,int fm,int csurf,int cx,int cy)
{
	HRESULT hr;LPDIRECTDRAWSURFACE7 mut;
	if(csurf==-1) mut=back;
	else mut=kepek[csurf].kep;RECT f,c;
	f.top=fy;f.left=fx;f.right=fx+fsz;f.bottom=fy+fm;
	c.top=cy;c.left=cx;c.right=cx+fsz;c.bottom=cy+fm;
	hr=mut->Blt(&c,kepek[fsurf].kep,&f,DDBLT_KEYSRC | DDBLT_WAIT,0);
}


#endif
