//
/*  INPUT OSZTLY */
//
#ifndef _INPUT_
#define _INPUT_
#ifndef DIRECTINPUT_VERSION
#define DIRECTINPUT_VERSION 0x800
#endif
#include <dinput.h>	//MSVC dinput8.lib    DEVC++ libdinput.a dxguid lib
//
extern HWND hwnd;
extern bool fut;
extern HINSTANCE hinstance;
extern RAJZ rajz;
//extern bool aktiv;


//

//dekralcik
//
LPDIRECTINPUT8  lpDI; //input objektum ezen keresztl hozzuk ltre a tbbit
LPDIDEVICEINSTANCE instance;
LPDIRECTINPUTDEVICE8  joy;
class INPUT
{
public:
	INPUT();
	~INPUT();
	LPDIRECTINPUTDEVICE8  bill;
	LPDIRECTINPUTDEVICE8  mouse;
	
	bool init_key();
	bool init_mouse();
	bool init_joy();
	bool get_key(unsigned char,bool frissit=false);
	DIMOUSESTATE*	get_mouse();//a kitlttt struktrval tr vissza
	LPDIJOYSTATE2   get_joy();		//a kitlttt struktrval tr vissza
	
	


protected:
	
	BYTE key_buf[256];
	DIMOUSESTATE mouse_buf;//egr adatainak puffer
	DIJOYSTATE2 dij2;


	;
};
//
//MEGVALSTSOK:
//
INPUT::INPUT()
{
	bill=NULL;mouse=NULL;joy=NULL;
}
//
INPUT::~INPUT()
{
	if(bill){bill->Release();bill=NULL;}
	if(mouse){mouse->Release();mouse=NULL;}
	if(joy){joy->Release();joy=NULL;}
	lpDI->Release();lpDI=NULL;
};
/**/
bool INPUT::init_key()
{
	BOOL inf;	//inf,hogy sikerlt- e a fggvny
	if( !lpDI)//ha mg ms nem hozta ltre az objektumot
	{
		inf=DirectInput8Create(	hinstance, DIRECTINPUT_VERSION, IID_IDirectInput8A, (VOID**)&lpDI, NULL);
		if (inf !=DI_OK)return false;//ha nem sikerlt
	}
	if(bill){bill->Release();bill=NULL;}
	inf=lpDI->CreateDevice(GUID_SysKeyboard, &bill, NULL);//kerlunk billentyt 
	if(inf !=DI_OK)return false;
	inf=bill->SetDataFormat(&c_dfDIKeyboard);//billentyzet forma az adat
	if(inf !=DI_OK)return false;
	inf=bill->SetCooperativeLevel(hwnd,DISCL_FOREGROUND | DISCL_NONEXCLUSIVE);
	//aktiv=true;
	bill->Acquire();//aktivljuk

	return true;
}
//
bool INPUT::get_key(unsigned char adat,bool frissit)
{	
	if(frissit)//ha kell, frissti a tblt
	{
		if(bill->GetDeviceState(256,&key_buf)==DIERR_INPUTLOST)
		{
			bill->Acquire();
			return false;	//majd kvetkezre lekrdezzk
		}
	}
	if(key_buf[ DIK_ESCAPE] & 0x80)fut=false;//ez a sor biztostja az esc-re a kilpst
	return (key_buf[adat] & 0x80) ? true:false;//lenyomva,vagy mgse

}
bool INPUT::init_mouse()
{
	BOOL inf;	//inf,hogy sikerlt- e a fggvny
	if( !lpDI)//ha mg ms nem hozta ltre az objektumot
	{
		inf=DirectInput8Create(	hinstance, DIRECTINPUT_VERSION, IID_IDirectInput8A, (VOID**)&lpDI, NULL);
		if (inf !=DI_OK)return false;//ha nem sikerlt
	}
	if(mouse){mouse->Release();mouse=NULL;}
	inf=lpDI->CreateDevice(GUID_SysMouse, &mouse, NULL);//kerlunk egeret 
	if(inf !=DI_OK)return false;
	inf=mouse->SetDataFormat(&c_dfDIMouse);//egr forma az adat
	if(inf !=DI_OK)return false;
	inf=bill->SetCooperativeLevel(hwnd,DISCL_FOREGROUND | DISCL_EXCLUSIVE);
	//aktiv=true;
	mouse->Acquire();//aktivljuk

	return true;
}
//
 DIMOUSESTATE* INPUT:: get_mouse()
{
	LPDIMOUSESTATE mut=NULL;
	if(mouse->GetDeviceState(sizeof(mouse_buf),&mouse_buf)==DIERR_INPUTLOST)
	{mouse->Acquire();return mut;}//ha elveszett volna res pointerrel tr vissza
	return &mouse_buf;
}
 //
 //
BOOL CALLBACK enumCallback(const DIDEVICEINSTANCE* instance, VOID* context)
{
    HRESULT hr;

    // Csatolt eszkzk kztt tallt  botkormnyt ltrehozza az objektumot
    hr = lpDI->CreateDevice(instance->guidInstance, &joy, NULL);

    //Azonban ha nem sikerlt,mert nincs,vagy msfajta akkor tovbb keres
    if (FAILED(hr)) { 
        return DIENUM_CONTINUE;
    }
	//instance->dwDevType tipusban trolja a tallt eszkz pontos tipust
	//most az els tallt botkormnyt illesztjk,lelltjuk a felsorolst 
    // 
    return DIENUM_STOP;
}
BOOL CALLBACK enumAxesCallback(const DIDEVICEOBJECTINSTANCE* instance, VOID* context)
{
    HWND hDlg = (HWND)context;

    DIPROPRANGE propRange; 
    propRange.diph.dwSize       = sizeof(DIPROPRANGE); 
    propRange.diph.dwHeaderSize = sizeof(DIPROPHEADER); 
    propRange.diph.dwHow        = DIPH_BYID; 
    propRange.diph.dwObj        = instance->dwType;
    propRange.lMin              = -1000; 
    propRange.lMax              = +1000; 
    if (FAILED(joy->SetProperty(DIPROP_RANGE, &propRange.diph))) {
        return DIENUM_STOP;
    }

    return DIENUM_CONTINUE;
}


 //
 //
 bool INPUT::init_joy()
 {
	DIDEVCAPS capabilities;
	BOOL inf;	//inf,hogy sikerlt- e a fggvny
	if( !lpDI)//ha mg ms nem hozta ltre az objektumot
	{
		inf=DirectInput8Create(	hinstance, DIRECTINPUT_VERSION, IID_IDirectInput8A, (VOID**)&lpDI, NULL);
		if (inf !=DI_OK)return false;//ha nem sikerlt
	}
	//A felsorol fggvny szmbaveszi a teleptett botkormnyokat s az elst azonostja
	inf = lpDI->EnumDevices(DI8DEVCLASS_GAMECTRL, enumCallback,NULL, DIEDFL_ATTACHEDONLY);
    if (inf !=DI_OK)return false;
	if (joy == NULL)return false;//ha nem jtt ltre az j objektum 
	if (FAILED(inf = joy->SetDataFormat(&c_dfDIJoystick2)))return false;
	if (FAILED(inf = joy->SetCooperativeLevel(hwnd, DISCL_EXCLUSIVE |DISCL_FOREGROUND)))
	return false;
	capabilities.dwSize = sizeof(DIDEVCAPS);
	//szmbaveszi a gombokat,tengelyeket stb.
	if (FAILED(inf = joy->GetCapabilities(&capabilities)))return false;
	//belltja a botkormny max kitrshez az rtket.
	if (FAILED(inf = joy->EnumObjects(enumAxesCallback, NULL, DIDFT_AXIS)))return false;
	return true;
}
//
//
LPDIJOYSTATE2 INPUT::get_joy()
{
	BOOL inf;
	DIJOYSTATE2* mut=NULL;
	if (joy == NULL)return mut;
	inf = joy->Poll();//mivel nem tudhat hogy az eszkz frissti e nmagt kiknyszertjk 
    if (inf!=DI_OK)
	{
		inf = joy->Acquire();//valszn aktivlni kell kvetkezre j lesz
        if(inf !=DI_OK)return mut;//res mutatval vissza
	}
    inf = joy->GetDeviceState(sizeof(DIJOYSTATE2), & dij2);
    if(inf !=DI_OK)return mut;
    return & dij2;
}
#endif
