Communication_Settings = nil
local state = {}
local unitids
local queue = {}
local function debug(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg)
end
local override = false --make it true in order to not send data out, but only send to yourself (opposite of regular functionality), for debugging
function Communication_ToggleOverride()
	override = not override
	Communication_AddText(tostring(override))
end

local SAM = SendAddonMessage
local function C_SAM(pre,msg,loc)
	if override then
		if pre == "DTMR" then
			local a1,a2,a3,a4 = arg1,arg2,arg3,arg4
			arg1,arg2,arg3,arg4 = pre,msg,loc,UnitName("player")
			Communication_OnEvent("CHAT_MSG_ADDON")
			arg1,arg2,arg3,arg4 = a1,a2,a3,a4
		end
	else
		SAM(pre,msg,loc)
	end
end
SendAddonMessage = C_SAM

function Communication_OnLoad()
	this:RegisterEvent("CHAT_MSG_ADDON")
	this:RegisterEvent("VARIABLES_LOADED")
	SLASH_DOTCOM1 = "/comm"
	SlashCmdList["DOTCOM"] = Communication_Commands
end

function Communication_AddText(msg) --basic output function
	if DEFAULT_CHAT_FRAME then DEFAULT_CHAT_FRAME:AddMessage(msg) end
end

function Communication_AddMenuText(msg,fromgui) -- will output a msg if the text menu was accessed; not the GUI menu
	if not fromgui then Communication_AddText(msg) end
end

function Communication_OnEvent()
	if event == "VARIABLES_LOADED" then Communication_Startup()
	elseif Communication_Settings and Communication_Settings.enabled then
		if Communication_Settings.receiving and (arg1 == "DTMR") and (override or (not (arg4 == UnitName("player")))) then --flag
			if not state[arg4] then state[arg4] = {} end
			if arg2 == "cooldownheader" then 
				state[arg4].sending = "cooldowns"
				state[arg4].collected = {}
			elseif arg2 == "debuffheader" then 
				state[arg4].sending = "debuffs"
				state[arg4].collected = {}
			elseif (arg2 == "cooldownfooter" or arg2 == "debufffooter") then Communication_SubmitData(arg4)
			else
				if state[arg4].sending then
					if state[arg4].sending == "cooldowns" then Communication_ReceiveCDData(arg2,arg4)
					elseif state[arg4].sending == "debuffs" then Communication_ReceiveDoTData(arg2,arg4)
					end
				end
			end
		end
	end
end

function Communication_Startup()
	if not DoTimer_Global_Settings then DoTimer_Global_Settings = {} end
	if not DoTimer_Global_Settings.global then DoTimer_Global_Settings.global = {} end
	if DoTimer_Global_Settings.global["Communication"] == nil then DoTimer_Global_Settings.global["Communication"] = false end
	local name = UnitName("player")
	local realm = GetRealmName()
	local identifier = name..":"..realm
	if not DoTimer_Global_Settings[identifier] then DoTimer_Global_Settings[identifier] = {} end
	if not DoTimer_Global_Settings[identifier]["Communication"] then DoTimer_Global_Settings[identifier]["Communication"] = {} end
	if not DoTimer_Global_Settings["Communication"] then DoTimer_Global_Settings["Communication"] = {} end
	local settings
	if DoTimer_Global_Settings.global["Communication"] then settings = DoTimer_Global_Settings["Communication"] else settings = DoTimer_Global_Settings[identifier]["Communication"] end
	if settings.enabled == nil then settings.enabled = true end
	if settings.onlyvisible == nil then settings.onlyvisible = false end
	if settings.newtargets == nil then settings.newtargets = true end
	if settings.recdots == nil then settings.recdots = {} end
	if settings.reccds == nil then settings.reccds = {} end
	if settings.sending == nil then settings.sending = true end
	if settings.receiving == nil then settings.receiving = false end
	if settings.chatmsgnormal == nil then settings.chatmsgnormal = "%e's %s(%r) will expire on [%l]%t in %d." end
	if settings.chatmsgnotarget == nil then settings.chatmsgnotarget = "%e's %s(%r) will finish in %d." end
	if settings.chatmsgcooldowns == nil then settings.chatmsgcooldowns = "%e's cooldown for %s will complete in %d." end
	if settings.chatmsgsoulstone == nil then settings.chatmsgsoulstone = "%e's soulstone on %t will expire in %d." end
	if DoTimer_Global_Settings.global["Communication"] then 
		Communication_Settings = DoTimer_Global_Settings["Communication"]
		DoTimer_Global_Settings[identifier]["Communication"] = Communication_Settings
	else 
		Communication_Settings = DoTimer_Global_Settings[identifier]["Communication"] 
		DoTimer_Global_Settings["Communication"] = Communication_Settings
	end
	unitids = DoTimer_ReturnUnitIDs()
	if not Communication_Settings.enabled then CommunicationFrame:SetScript("OnEvent",nil) end
	if DoTimerFrame then
		DoTimer_CreateTimerGroup(
			"shared",false,true,true,true,1,1,{
				begin = {
					r = .25,
					g = .25,
					b = 1.0,
				},
				half = {
					r = .25,
					g = .25,
					b = 1.0,
				},
				final = {
					r = .25,
					g = .25,
					b = 1.0,
				},
			}
		)
		local D_CT = DoTimer_CreateTooltip
		local function Communication_D_CT(frame,i,id)
			D_CT(frame,i,id)
			local casted = DoTimer_ReturnData()
			if casted[i] and casted[i][id] then
				if casted[i][id].type == "shared" then 
					GameTooltip:AppendText(string.format(" |cff4040ff(%s)|r",casted[i][id].sender or "")) 
				end
			end
		end
		DoTimer_CreateTooltip = Communication_D_CT
		local old_DoT_CI = DoTimer_CreateInterface
		local function Communication_DoT_CI(external,frommenu)
			old_DoT_CI(external,frommenu)
			if (not external) and Communication_Settings.enabled and Communication_Settings.sending then Communication_SendDoTData() end
		end
		DoTimer_CreateInterface = Communication_DoT_CI
		local D_TC = DoTimer_ToChat
		local function Communication_D_TC(i,id)
			local casted = DoTimer_ReturnData()
			if casted[i] and casted[i][id] then
				if (not casted[i].external) and (casted[i][id].external) and (casted[i][id].type == "shared") then
					Communication_ToChat("dotimer",i,id)
				end
			end
			D_TC(i,id)
		end
		DoTimer_ToChat = Communication_D_TC
	end
	if CooldownsFrame then
		Cooldowns_CreateTimerGroup(
			"shared",false,true,true,true,1,1,{
				begin = {
					r = .25,
					g = .25,
					b = 1.0,
				},
				half = {
					r = .25,
					g = .25,
					b = 1.0,
				},
				final = {
					r = .25,
					g = .25,
					b = 1.0,
				},
			}
		)
		local C_CT = Cooldowns_CreateTooltip
		local function Communication_C_CT(frame,i)
			C_CT(frame,i)
			local casted = Cooldowns_ReturnData()
			if casted[i] then
				if casted[i].type == "shared" then 
					GameTooltip:AppendText(string.format(" |cff4040ff(%s)|r",casted[i].sender or "")) 
				end
			end
		end
		Cooldowns_CreateTooltip = Communication_C_CT
		local old_CD_CI = Cooldowns_CreateInterface
		local function Communication_CD_CI(external,frommenu)
			old_CD_CI(external,frommenu)
			if (not external) and Communication_Settings.enabled and Communication_Settings.sending then Communication_SendCDData() end
		end
		Cooldowns_CreateInterface = Communication_CD_CI
		local C_TC = Cooldowns_ToChat
		local function Communication_C_TC(i)
			local casted = Cooldowns_ReturnData()
			if casted[i] then
				if (casted[i].external) and (casted[i].type == "shared") then
					Communication_ToChat("cooldown",i)
				end
			end
			C_TC(i)
		end
		Cooldowns_ToChat = Communication_C_TC
	end
end

function Communication_QueueMsg(msg)
	if msg == "cooldownheader" then
		local flag = false
		for index,value in ipairs(queue) do
			if value == "cooldownheader" then flag = true end
			if flag then table.remove(queue,index) end
			if value == "cooldownfooter" then flag = false end
		end
	elseif msg == "debuffheader" then
		local flag = false
		for index,value in ipairs(queue) do
			if value == "debuffheader" then flag = true end
			if flag then table.remove(queue,index) end
			if value == "debufffooter" then flag = false end
		end
	end
	table.insert(queue,msg)
	if table.getn(queue) == 1 then CommunicationSenderFrame:SetScript("OnUpdate",function() Communication_SendQueue() end) end
end

function Communication_SendQueue()
	local msg = queue[1]
	if msg then
		SendAddonMessage("DTMR",msg,"RAID")
		table.remove(queue,1)
		if table.getn(queue) == 0 then CommunicationSenderFrame:SetScript("OnUpdate",nil) end
	end
end

function Communication_intable(query,checkedtable)
	return checkedtable[query]
end

function Communication_SendDoTData()
	if (not override) and GetNumRaidMembers() == 0 and GetNumPartyMembers() == 0 then return end
	Communication_QueueMsg("debuffheader")
	local casted = DoTimer_ReturnData()
	for i = 1,table.getn(casted) do
		Communication_QueueMsg(string.format("<t><%s><%d><%d><%d><%s>",casted[i].target,casted[i].sex,casted[i].level,casted[i].icon,casted[i].type))
		for id = 1,table.getn(casted[i]) do
			local spell = string.lower(casted[i][id].spell)
			local type = casted[i][id].type
			if (type == "debuff" or type == "depreciated" or type == "enslave") then
				Communication_QueueMsg(string.format("<d><%s><%s><%s><%d><%f><%s><%s><%d>",casted[i][id].spell,casted[i][id].rank,casted[i][id].texture,casted[i][id].duration,(GetTime() - casted[i][id].time),casted[i][id].english,casted[i][id].info.type,casted[i][id].info.id))
			end
		end
	end
	Communication_QueueMsg("debufffooter")
end

function Communication_SendCDData()
	if (not override) and GetNumRaidMembers() == 0 and GetNumPartyMembers() == 0 then return end
	Communication_QueueMsg("cooldownheader")
	local casted = Cooldowns_ReturnData()
	for i = 1,table.getn(casted) do
		local spell = string.lower(casted[i].english)
		local type = casted[i].type
		if type == "cooldown" then
			Communication_QueueMsg(string.format("<%s><%s><%s><%d><%f><%s><%s><%d>",casted[i].spell,casted[i].rank,casted[i].texture,casted[i].duration,(GetTime() - casted[i].time),casted[i].english,casted[i].info.type,casted[i].info.id))
		end
	end
	Communication_QueueMsg("cooldownfooter")
end

function Communication_ReceiveDoTData(msg,sender)
	local type,info1,info2,info3,info4,info5,info6,info7,info8 = SpellSystem_ParseString(msg,"<(.-)>")
	if type == "t" then --target data
		local timertable = {
			target = info1,
			sex = info2,
			level = info3,
			icon = info4,
			type = info5,
		}
		table.insert(state[sender].collected,timertable)
	elseif type == "d" and Communication_intable(string.lower(info1),Communication_Settings.recdots) then --debuff data
		local newdebuff = {
			spell = info1,
			rank = info2,
			texture = info3,
			duration = info4,
			time = GetTime() - info5,
			english = info6,
			type = "shared",
			info = {
				type = info7,
				id = info8,
			},
			sender = sender,
			external = 1,
		}
		if info7 == BOOKTYPE_SPELL or info7 == BOOKTYPE_PET then
			local _,book,id = SpellSystem_FindInfo(info1,info2,"spell")
			local name,rank = GetSpellName(id,book)
			if (name == info1 and (rank == info2 or info2 == "")) then
				newdebuff.info.id = id
			else
				newdebuff.info = nil
			end
		end
		table.insert(state[sender].collected[table.getn(state[sender].collected)],newdebuff)
	end
end

function Communication_ReceiveCDData(msg,sender)
	local info1,info2,info3,info4,info5,info6,info7,info8 = SpellSystem_ParseString(msg,"<(.-)>")
	if Communication_intable(string.lower(info1),Communication_Settings.reccds) then
		local newcooldown = {
			spell = info1,
			rank = info2,
			texture = info3,
			duration = info4,
			time = GetTime() - info5,
			english = info6,
			type = "shared",
			info = {
				type = info7,
				id = info8,
			},
			sender = sender,
			external = 1,
		}
		if info7 == BOOKTYPE_SPELL or info7 == BOOKTYPE_PET then
			local _,book,id = SpellSystem_FindInfo(info1,info2,"spell")
			local name,rank = GetSpellName(id,book)
			if (name == info1 and (rank == info2 or info2 == "")) then
				newcooldown.info.id = id
			else
				newcooldown.info = nil
			end
		end
		table.insert(state[sender].collected,newcooldown)
	end
end

function Communication_IsVisible(query)
	for _,unit in ipairs(unitids) do
		if UnitName(unit) == query then
			if UnitIsVisible(unit) then return true else return false end
		end
	end
	return true
end

function Communication_SubmitData(sender)
	if Communication_Settings.onlyvisible and not (Communication_IsVisible(sender)) then return end
	if state[sender].collected then
		local casted
		if state[sender].sending == "debuffs" then
			casted = DoTimer_ReturnData()
			for i = table.getn(casted),1,-1 do
				if not casted[i].external then
					for id = table.getn(casted[i]),1,-1 do
						if casted[i][id].type == "shared" and casted[i][id].sender == sender then table.remove(casted[i],id) end
					end
				end
				if table.getn(casted[i]) == 0 then table.remove(casted,i) end
			end
			for i = 1,table.getn(state[sender].collected) do
				local t = state[sender].collected[i]
				if table.getn(t) > 0 then
					local targetindex = DoTimer_ReturnTargetTable(t.target,t.sex,t.level,t.icon)
					if targetindex then
						for i = 1,table.getn(t) do table.insert(casted[targetindex],t[i]) end
					else
						if Communication_Settings.newtargets then 
							table.insert(casted,t)
						end
					end
				end
			end
		else
			casted = Cooldowns_ReturnData()
			for i = table.getn(casted),1,-1 do
				if casted[i].type == "shared" and casted[i].sender == sender then table.remove(casted,i) end
			end		
			local t = state[sender].collected
			if table.getn(t) > 0 then
				for i = 1,table.getn(t) do table.insert(casted,t[i]) end
			end
		end
		if state[sender].sending == "debuffs" then DoTimer_CreateInterface(1) else Cooldowns_CreateInterface(1) end
	end
	state[sender].sending = nil
	state[sender].collected = nil
end

function Communication_ToChat(which,i,id)
	local subentries,unsubbedmsg
	if which == "dotimer" then
		local casted = DoTimer_ReturnData()
		local displayed = casted[i][id].displayed
		local spell = casted[i][id].spell
		local rank = casted[i][id].rank
		local target = casted[i].target
		local level = casted[i].level
		local sender = casted[i][id].sender
		if (displayed and spell and rank and target and level and sender) then
			displayed = DoTimer_ReturnNewDuration(displayed)
			if target == "No Target" then
				subentries = {
					["%d"] = displayed,
					["%s"] = spell,
					["%r"] = rank,
					["%e"] = sender,
				}
				unsubbedmsg = Communication_Settings.chatmsgnotarget		
			else
				subentries = {
					["%d"] = displayed,
					["%s"] = spell,
					["%r"] = rank,
					["%t"] = target,
					["%l"] = level,
					["%e"] = sender,
				}
				unsubbedmsg = Communication_Settings.chatmsgnormal
			end
		end
	elseif which == "cooldown" then
		local casted = Cooldowns_ReturnData()
		local displayed = casted[i].displayed
		local spell = casted[i].spell
		local rank = casted[i].rank
		local sender = casted[i].sender
		if (displayed and spell and rank and sender) then
			displayed = Cooldowns_ReturnNewDuration(displayed)
			if casted[i].english == "Soulstone" then
				subentries = {
					["%d"] = displayed,
					["%s"] = spell,
					["%t"] = rank,
					["%e"] = sender,
				}
				unsubbedmsg = Communication_Settings.chatmsgsoulstone
			else
				subentries = {
					["%d"] = displayed,
					["%s"] = spell,
					["%e"] = sender,
				}
				unsubbedmsg = Communication_Settings.chatmsgcooldowns
			end
		end
	end
	local chat = "SAY"
	if GetNumRaidMembers() > 0 then chat = "RAID" elseif GetNumPartyMembers() > 0 then chat = "PARTY" end
	local msg = string.gsub(unsubbedmsg,"(%%%a)",function(a) return subentries[a] or "" end)
	msg = string.gsub(msg,"%(%)","")
	SendChatMessage(msg,chat)
end

function Communication_Commands(msg,fromgui)
	if msg == "" then CommunicationMenuFrame:Show()
	elseif string.sub(msg,1,4) == "help" then
		Communication_AddHelpMenu(msg)
	elseif msg == "on" then
		Communication_Settings.enabled = true
		CommunicationFrame:SetScript("OnEvent",function() Communication_OnEvent(event) end)
		Communication_AddMenuText("Communication is now enabled!",fromgui)
	elseif msg == "off" then
		Communication_Settings.enabled = false
		CommunicationFrame:SetScript("OnEvent",nil)
		Communication_AddMenuText("Communication is now disabled.",fromgui)
	elseif msg == "only visible people" then
		Communication_Settings.onlyvisible = true
		Communication_AddMenuText("You will only see communicated timers for players visible to you.",fromgui)
	elseif msg == "all people" then
		Communication_Settings.onlyvisible = false
		Communication_AddMenuText("All communicated timers will be shown.",fromgui)
	elseif msg == "add new targets" then
		Communication_Settings.newtargets = true
		Communication_AddMenuText("New target tables might be created.",fromgui)
	elseif msg == "no new targets" then
		Communication_Settings.newtargets = false
		Communication_AddMenuText("New target tables will not be added.",fromgui)
	elseif msg == "status" then
		Communication_AddText("|cff00ffffCommunication Status:|r")
		Communication_AddText("Addon enabled: |cff00ff00"..tostring(Communication_Settings.enabled).."|r")
		Communication_AddText("Only visible people: |cff00ff00"..tostring(Communication_Settings.onlyvisible).."|r")
		Communication_AddText("Adding new targets: |cff00ff00"..tostring(Communication_Settings.newtargets).."|r")
		Communication_AddText("Sending Data: |cff00ff00"..tostring(Communication_Settings.sending).."|r")
		Communication_AddText("Receiving Data: |cff00ff00"..tostring(Communication_Settings.receiving).."|r")
	elseif msg == "reset" then
		Communication_AddMenuText("All user data is now reset.",fromgui)
		for index,value in pairs(Communication_Settings) do Communication_Settings[index] = nil end
		Communication_Startup()
	elseif msg == "do not send data" then
		Communication_Settings.sending = false
		Communication_AddMenuText("Data will not be sent.",fromgui)
	elseif msg == "do not receive data" then
		Communication_Settings.receiving = false
		Communication_AddMenuText("Data will not be received.",fromgui)
	elseif msg == "send data" then
		Communication_Settings.sending = true
		Communication_AddMenuText("Data will be sent.",fromgui)
	elseif msg == "receive data" then
		Communication_Settings.receiving = true
		Communication_AddMenuText("Data will be received.",fromgui)
	elseif msg == "show shared timers" then
		Communication_AddText("Received DoTs:")
		for index,value in pairs(Communication_Settings.recdots) do Communication_AddText(index) end
		Communication_AddText("Received Cooldowns:")
		for index,value in pairs(Communication_Settings.reccds) do Communication_AddText(index) end
	elseif msg == "global settings" then
		DoTimer_Global_Settings.global["Communication"] = true
		Communication_AddMenuText("Communication's settings will now be shared across all characters.",fromgui)
	elseif msg == "local settings" then
		DoTimer_Global_Settings.global["Communication"] = false
		Communication_AddMenuText("Communication's settings can be now changed per character.",fromgui)
	elseif string.sub(msg,1,8) == "rec dot " then
		local query = string.lower(string.sub(msg,9))
		Communication_Settings.recdots[query] = 1
		Communication_AddMenuText("The DoT for "..query.." will be displayed from others.",fromgui)
	elseif string.sub(msg,1,7) == "rec cd " then
		local query = string.lower(string.sub(msg,8))
		Communication_Settings.reccds[query] = 1
		Communication_AddMenuText("The cooldown for "..query.." will be displayed from others.",fromgui)
	elseif string.sub(msg,1,10) == "unrec dot " then
		local query = string.lower(string.sub(msg,11))
		Communication_Settings.recdots[query] = nil
		Communication_AddMenuText("The DoT for "..query.." will not be displayed from others.",fromgui)
	elseif string.sub(msg,1,9) == "unrec cd " then
		local query = string.lower(string.sub(msg,10))
		Communication_Settings.reccds[query] = nil
		Communication_AddMenuText("The cooldown for "..query.." will not be displayed from others.",fromgui)
	elseif string.sub(msg,1,9) == "chat msg " then
		local type,newmsg = SpellSystem_ParseString(msg,"chat msg (%a+):%s?(.+)")
		if newmsg then
			if type == "dotimer" then
				Communication_Settings.chatmsgnormal = newmsg
				Communication_AddMenuText("The new format string for DoTimer normal timers is now "..newmsg,fromgui)		
			elseif type == "notarget" then
				Communication_Settings.chatmsgnotarget = newmsg
				Communication_AddMenuText("The new format string for DoTimer notarget timers is now "..newmsg,fromgui)
			elseif type == "cooldowns" then
				Communication_Settings.chatmsgcooldowns = newmsg
				Communication_AddMenuText("The new format string for Cooldowns normal timers is now "..newmsg,fromgui)
			elseif type == "soulstone" then
				Communication_Settings.chatmsgsoulstone = newmsg
				Communication_AddMenuText("The new format string for Cooldowns soulstone timers is now "..newmsg,fromgui)
			end
		end
	else
		Communication_AddMenuText("Type |cff00ff00/comm help|r for more options, or |cff00ff00/comm|r to open the menu!",fromgui)
	end
end
