Cooldowns_Settings = nil
local casted = { --governs the currently casted debuffs.  entries are 1-10 targets, which in turn are 1-20 debuffs and the target name
	target = "Cooldowns ", --the space is in case some player named "Cooldowns" exists
	sex = 0,
	level = 0,
	icon = 0,
	type = "player",
	external = true,
}
local sentcooldown = {} --holds data waiting for a successful cast
local cooldowns,othercooldowns 
local timerdata = {}
local flag = true

function Cooldowns_OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN")
	this:RegisterEvent("BAG_UPDATE_COOLDOWN")
	this:RegisterEvent("PET_BAR_UPDATE_COOLDOWN")
	this:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	SpellSystem_RegisterEvent(Cooldowns_OnEvent,"SPELLSYSTEM_SUCCESS")
	SLASH_COOLDOWNS1 = "/cooldowns"
	SLASH_COOLDOWNS2 = "/cd"
	SlashCmdList["COOLDOWNS"] = Cooldowns_Commands
end

function Cooldowns_OnEvent(event)
	if event == "PLAYER_ENTERING_WORLD" then Cooldowns_Startup()
	elseif Cooldowns_Settings and Cooldowns_Settings.status then
		if event == "SPELLSYSTEM_SUCCESS" then Cooldowns_PotentialCooldown()
		else Cooldowns_CheckForCooldowns(event)
		end
	end
end

function Cooldowns_AddText(msg) --basic output function
	if DEFAULT_CHAT_FRAME then DEFAULT_CHAT_FRAME:AddMessage(msg) end
end

function Cooldowns_AddMenuText(msg,fromgui) -- will output a msg if the text menu was accessed; not the GUI menu
	if not fromgui then Cooldowns_AddText(msg) end
end

function Cooldowns_OnUpdate()
	if table.getn(casted) == 0 then CooldownsFrame:SetScript("OnUpdate",nil) end
	local time = GetTime()
	for i = table.getn(casted),1,-1 do
		local type = casted[i].type
		if timerdata[type].hastimer then
			if time >= casted[i].time + casted[i].duration then --yep it's done all right
				Cooldowns_RemoveTimer(i,"finished")
			elseif (not Cooldowns_Settings.dotimer) and (timerdata[type].disptimer) then
				local timeremaining = casted[i].duration - time + casted[i].time
				local remaining = tonumber(string.format(Cooldowns_Settings.tenths and "%.1f" or "%d",timeremaining))
				if Cooldowns_Settings.format == "icons" then
					if (not casted[i].displayed) or (remaining < casted[i].displayed) then
						getglobal("CooldownsTableCooldown"..i.."IconTime"):SetText(Cooldowns_ReturnNewDuration(timeremaining)) --updating the time if they aren't done
						if remaining == 5 then
							if Cooldowns_Settings.playsound then PlaySoundFile("Interface\\Addons\\DoTimer\\Extras\\expalert.wav") end
							if Cooldowns_Settings.expalert then 
								getglobal("CooldownsTableCooldown"..i.."IconButton"):LockHighlight()
								getglobal("CooldownsTableCooldown"..i.."IconTime"):SetTextColor(timerdata[type].colors.final.r,timerdata[type].colors.final.g,timerdata[type].colors.final.b)
							end
						elseif remaining == 3 then
							if Cooldowns_Settings.expalert then getglobal("CooldownsTableCooldown"..i.."IconButton"):UnlockHighlight() end
						elseif (remaining == math.floor(casted[i].duration) / 2) and remaining > 5 then
							getglobal("CooldownsTableCooldown"..i.."IconTime"):SetTextColor(timerdata[type].colors.half.r,timerdata[type].colors.half.g,timerdata[type].colors.half.b)
						end
						casted[i].displayed = tonumber(string.format(Cooldowns_Settings.tenths and "%.1f" or "%d",timeremaining))
					end
				elseif Cooldowns_Settings.format == "bars" then
					getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetValue(timeremaining)		
					if (not casted[i].displayed) or (remaining < casted[i].displayed) then
						getglobal("CooldownsTableCooldown"..i.."BarStatusTime"):SetText(Cooldowns_FormatBarText(i)) --updating the time if they aren't done
						if remaining == 5 then
							if Cooldowns_Settings.playsound then PlaySoundFile("Interface\\Addons\\DoTimer\\Extras\\expalert.wav") end
							if Cooldowns_Settings.expalert then 
								getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetStatusBarColor(timerdata[type].colors.final.r,timerdata[type].colors.final.g,timerdata[type].colors.final.b)
							end
						elseif (remaining > 5) and (remaining == math.floor(casted[i].duration / 2)) then
							getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetStatusBarColor(timerdata[type].colors.half.r,timerdata[type].colors.half.g,timerdata[type].colors.half.b)
						end
						casted[i].displayed = tonumber(string.format(Cooldowns_Settings.tenths and "%.1f" or "%d",timeremaining))
					end
				elseif Cooldowns_Settings.format == "text" then	
					if (not casted[i].displayed) or (remaining < casted[i].displayed) then
						getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetText(Cooldowns_FormatBarText(i)) --updating the time if they aren't done
						if remaining == 5 then
							if Cooldowns_Settings.playsound then PlaySoundFile("Interface\\Addons\\DoTimer\\Extras\\expalert.wav") end
							if Cooldowns_Settings.expalert then
								getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetTextColor(timerdata[type].colors.final.r,timerdata[type].colors.final.g,timerdata[type].colors.final.b)
							end
						elseif (remaining > 5) and (remaining == math.floor(casted[i].duration / 2)) then
							getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetTextColor(timerdata[type].colors.half.r,timerdata[type].colors.half.g,timerdata[type].colors.half.b)
						end
						casted[i].displayed = tonumber(string.format(Cooldowns_Settings.tenths and "%.1f" or "%d",timeremaining))
					end
				end
			end
		end
	end
end

function Cooldowns_FormatBarText(cooldownindex)
	local displayed = casted[cooldownindex].duration - GetTime() + casted[cooldownindex].time
	local spell = casted[cooldownindex].spell
	local rank = casted[cooldownindex].rank
	local subentries = {
		["%d"] = Cooldowns_ReturnNewDuration(displayed),
		["%s"] = spell,
		["%r"] = rank,
	}
	local msg = string.gsub(Cooldowns_Settings.barmsg,"(%%%a)",function(a) return subentries[a] or "" end)
	msg = string.gsub(msg,"%(%)","")
	return msg
end

function Cooldowns_RemoveTimer(cooldownid,reason,suppress)
	--possible reasons: finished, inaccurate, clicked, replaced
	if reason == "finished" and Cooldowns_Settings.ghosts and timerdata[casted[cooldownid].type].isreal then Cooldowns_CreateGhostTimer(cooldownid) end
	if reason == "clicked" and IsShiftKeyDown() then Cooldowns_Commands("block "..casted[cooldownid].spell,1) end
	table.remove(casted,cooldownid)
	if not suppress then Cooldowns_CreateInterface() end
end

function Cooldowns_RemoveAllTimers()
	for i = 1,table.getn(casted) do
		table.remove(casted,1)
	end
	Cooldowns_CreateInterface()
end

function Cooldowns_Startup() --called on first login per session, creates the default settings if needed or else just hides the interface and sets the scale
	if flag then
		if not DoTimer_Global_Settings then DoTimer_Global_Settings = {} end
		if not DoTimer_Global_Settings.global then DoTimer_Global_Settings.global = {} end
		if DoTimer_Global_Settings.global["Cooldowns"] == nil then DoTimer_Global_Settings.global["Cooldowns"] = false end
		local name = UnitName("player")
		local realm = GetRealmName()
		local identifier = name..":"..realm
		if not DoTimer_Global_Settings[identifier] then DoTimer_Global_Settings[identifier] = {} end
		if not DoTimer_Global_Settings[identifier]["Cooldowns"] then DoTimer_Global_Settings[identifier]["Cooldowns"] = {} end
		if not DoTimer_Global_Settings["Cooldowns"] then DoTimer_Global_Settings["Cooldowns"] = {} end
		local settings
		if DoTimer_Global_Settings.global["Cooldowns"] then settings = DoTimer_Global_Settings["Cooldowns"] else settings = DoTimer_Global_Settings[identifier]["Cooldowns"] end
		if settings.status == nil then 
			settings.status = true 
			CooldownsAnchorFrameFirstUse:Show()
			CooldownsAnchorFrameFirstUse:SetText("Welcome to Cooldowns!  Please type \"/cooldowns help new\"\n for first-time information. -->\nSimply drag the drag button to remove this display.")
		end
		if settings.scale == nil then settings.scale = 1 end --setting the default settings
		if settings.names == nil then settings.names = true end
		if settings.maxdebuffs == nil then settings.maxdebuffs = 8 end
		if settings.locked == nil then settings.locked = false end
		if settings.debufflayout == nil then settings.debufflayout = "down" end
		if settings.sortmethod == nil then settings.sortmethod = "remaining" end
		if settings.clickable == nil then settings.clickable = true end
		if settings.expalert == nil then settings.expalert = true end
		if settings.buttonscale == nil then settings.buttonscale = 1 end
		if settings.playsound == nil then settings.playsound = false end
		if settings.format == nil then settings.format = "bars" end
		if settings.barlength == nil then settings.barlength = 150 end
		if settings.dotimer == nil then settings.dotimer = false end
		if settings.blocked == nil then settings.blocked = {} end
		if settings.mincd == nil then settings.mincd = 2 end
		if settings.spacing == nil then settings.spacing = 5 end
		if settings.chatmsgnormal == nil then settings.chatmsgnormal = "My cooldown for %s will complete in %d." end
		if settings.chatmsgsoulstone == nil then settings.chatmsgsoulstone = "My soulstone on %t will expire in %d." end
		if settings.tenths == nil then settings.tenths = false end
		if settings.barmsg == nil then settings.barmsg = "%d - %s" end
		if settings.hidesame == nil then settings.hidesame = true end
		if settings.tooltips == nil then settings.tooltips = true end
		if settings.icons == nil then settings.icons = true end
		if settings.alpha == nil then settings.alpha = 1 end
		if settings.ghostdata == nil then settings.ghostdata = 5 end
		if settings.ghosts == nil then settings.ghosts = true end
		if DoTimer_Global_Settings.global["Cooldowns"] then 
			Cooldowns_Settings = DoTimer_Global_Settings["Cooldowns"]
			DoTimer_Global_Settings[identifier]["Cooldowns"] = Cooldowns_Settings
		else 
			Cooldowns_Settings = DoTimer_Global_Settings[identifier]["Cooldowns"] 
			DoTimer_Global_Settings["Cooldowns"] = Cooldowns_Settings
		end
		CooldownsMainFrame:SetScale(Cooldowns_Settings.scale)
		CooldownsTable:Hide()
		Cooldowns_DefineFormat()
		for i = 1,20 do
			getglobal("CooldownsTableCooldown"..i):Hide()
		end
		local _,class = UnitClass("player")
		othercooldowns = Cooldowns_DefineSpells()
		Cooldowns_DefineInterface(Cooldowns_Settings.debufflayout,1)
		if Cooldowns_Settings.locked then CooldownsAnchorFrame:Hide() else CooldownsAnchorFrame:Show() end
		if Cooldowns_Settings.status == false then 
			CooldownsFrame:Hide() 
			CooldownsMainFrame:Hide()
		end
		CooldownsAnchorFrame:ClearAllPoints()
		if Cooldowns_Settings.offsetX then
			CooldownsAnchorFrame:SetPoint("BOTTOMLEFT","UIParent","BOTTOMLEFT",Cooldowns_Settings.offsetX,Cooldowns_Settings.offsetY)
		else
			CooldownsAnchorFrame:SetPoint("CENTER","UIParent","CENTER",-5,0)
		end
		if DoTimerFrame then
			local D_RT = DoTimer_RemoveTimer
			local function Cooldowns_D_RT(i,id,reason,fromcst)
				local casted = DoTimer_ReturnData()
				if casted[i] and casted[i][id] then
					if casted[i].external and reason == "clicked" and casted[i].target == "Cooldowns " then
						Cooldowns_RemoveTimer(id,"clicked")
					end
				end
				D_RT(i,id,reason,fromcst)
			end
			DoTimer_RemoveTimer = Cooldowns_D_RT
			local D_TC = DoTimer_ToChat
			local function Cooldowns_D_TC(i,id)
				local casted = DoTimer_ReturnData()
				if casted[i] and casted[i][id] then
					if casted[i].external and casted[i].target == "Cooldowns " then
						Cooldowns_ToChat(id)
					end
				end
				D_TC(i,id)
			end
			DoTimer_ToChat = Cooldowns_D_TC
			local D_CT = DoTimer_CreateTooltip
			local function Cooldowns_D_CT(frame,i,id)
				D_CT(frame,i,id)
				local casted = DoTimer_ReturnData()
				if casted[i] and casted[i][id] then
					if casted[i].external and casted[i].target == "Cooldowns " and casted[i][id].english == "Soulstone" then
						GameTooltip:AppendText(string.format(" (%s)",casted[i][id].rank or ""))
					end
				end
			end
			DoTimer_CreateTooltip = Cooldowns_D_CT
		end
		Cooldowns_ResizeInterface()
		flag = false
	end
	Cooldowns_CheckAllCooldowns()
end

function Cooldowns_ReturnNewDuration(time) --modifies the time remaining on the debuff into a format suitable for the screen
	local minutes = math.floor(time / 60)
	local seconds = math.floor(time - (60 * minutes))
	local remaining = time - (60 * minutes) - (seconds)
	local decimal
	if Cooldowns_Settings.tenths then decimal = "."..string.format("%d",remaining * 10) else decimal = "" end
	return string.format("%d:%.2d%s",minutes,seconds,decimal)
end

function Cooldowns_PotentialCooldown()
	if Cooldowns_intable(arg1.texture,othercooldowns) then
		if arg3.type == "spell" then return end
		local spell = SpellSystem_Copy(arg1)
		spell.info = SpellSystem_Copy(arg3)
		spell.type = "cooldown"
		spell.duration = othercooldowns[spell.texture].duration
		spell.time = GetTime()
		spell.english = othercooldowns[spell.texture].name
		spell.rank = ""
		if spell.english == "Soulstone" then spell.rank = arg2.target end
		Cooldowns_CreateCooldown(spell)
	end
end

function Cooldowns_CheckAllCooldowns()
	Cooldowns_CheckForCooldowns("ACTIONBAR_UPDATE_COOLDOWN")
	Cooldowns_CheckForCooldowns("BAG_UPDATE_COOLDOWN")
	Cooldowns_CheckForCooldowns("SPELL_UPDATE_COOLDOWN")
	Cooldowns_CheckForCooldowns("PET_BAR_UPDATE_COOLDOWN")
end

function Cooldowns_CheckForCooldowns(event)
	if event == "ACTIONBAR_UPDATE_COOLDOWN" then
		for i = 1,19 do
			local spellname = GetItemInfo(GetInventoryItemLink("player",i) or "")
			local texture = GetInventoryItemTexture("player",i)
			if spellname and (not othercooldowns[texture]) then
				local start,duration,real = GetInventoryItemCooldown("player",i)
				if start > 0 and duration > Cooldowns_Settings.mincd and real == 1 then
					local entry = {
						spell = spellname,
						rank = "", 
						texture = texture, 
						duration = duration, 
						time = start,
						type = "cooldown",
						english = spellname,
						info = {
							type = "item",
							id = SpellSystem_ParseString(GetInventoryItemLink("player",i),"item:(%d+)"),
						},
					}
					Cooldowns_CreateCooldown(entry)
				elseif start == 0 then
					Cooldowns_RemoveCooldown(spellname,"item")
				end
			end
		end
	elseif event == "BAG_UPDATE_COOLDOWN" then
		for b = 0,4 do
			for s = 1,GetContainerNumSlots(b) do
				local spellname = GetItemInfo(GetContainerItemLink(b,s) or "")	
				local texture = GetContainerItemInfo(b,s)				
				if spellname and (not othercooldowns[texture]) then
					local start,duration,real = GetContainerItemCooldown(b,s)
					if start > 0 and duration > Cooldowns_Settings.mincd and real == 1 then
						local entry = {
							spell = spellname,
							rank = "", 
							texture = texture, 
							duration = duration, 
							time = start,
							type = "cooldown",
							english = spellname,
							info = {
								type = "item",
								id = SpellSystem_ParseString(GetContainerItemLink(b,s),"item:(%d+)")
							},
						}
						Cooldowns_CreateCooldown(entry)
					elseif start == 0 then
						Cooldowns_RemoveCooldown(spellname,"item")
					end
				end
			end
		end
	elseif event == "SPELL_UPDATE_COOLDOWN" then
		local numtabs = GetNumSpellTabs()
		local _,_,offset,num = GetSpellTabInfo(numtabs)
		local numspells = offset + num
		for i = numspells,1,-1 do
			local spellname = GetSpellName(i,BOOKTYPE_SPELL)
			local texture = GetSpellTexture(i,BOOKTYPE_SPELL)
			if spellname and (not othercooldowns[texture]) then
				local start,duration,real = GetSpellCooldown(i,BOOKTYPE_SPELL)
				if start > 0 and duration > Cooldowns_Settings.mincd and real == 1 then
					local entry = {
						spell = spellname,
						rank = "", 
						texture = texture, 
						duration = duration, 
						time = start,
						type = "cooldown",
						english = spellname,
						info = {
							type = BOOKTYPE_SPELL,
							id = i,
						},
					}
					Cooldowns_CreateCooldown(entry)
				elseif start == 0 then
					Cooldowns_RemoveCooldown(spellname,"spell")
				end
			end
		end
	elseif event == "PET_BAR_UPDATE_COOLDOWN" then
		for i = 1,10 do
			local spellname = GetPetActionInfo(i)
			local _,_,texture = GetPetActionInfo(i)
			if spellname and (not othercooldowns[texture]) then
				local start,duration,real = GetPetActionCooldown(i)
				if start > 0 and duration > Cooldowns_Settings.mincd and real == 1 then
					local entry = {
						spell = spellname,
						rank = "", 
						texture = texture, 
						duration = duration, 
						time = start,
						type = "cooldown",
						english = spellname,
						info = {
							type = BOOKTYPE_PET,
							id = SpellSystem_ReturnPetID(spellname),
						},
					}
					Cooldowns_CreateCooldown(entry)
				elseif start == 0 then
					Cooldowns_RemoveCooldown(spellname,"spell")
				end
			end
		end
	end
end

function Cooldowns_RemoveCooldown(spell,type)
	for i = table.getn(casted),1,-1 do
		if casted[i].spell == spell and casted[i].info.type == type and timerdata[casted[i].type].isreal then
			Cooldowns_RemoveTimer(i,"finished")
		end
	end
end

function Cooldowns_intable(query,checkedtable)
	return checkedtable[query]
end

function Cooldowns_CreateCooldown(spelltable)
	if Cooldowns_Settings.blocked[string.lower(spelltable.spell)] then return end
	for i = 1,table.getn(casted) do
		if ((casted[i].spell == spelltable.spell) or Cooldowns_Settings.hidesame) and math.abs(casted[i].duration - spelltable.duration) <= .1 and (math.abs(casted[i].time - spelltable.time) <= .1) and (timerdata[casted[i].type].isreal) then return end
	end
	for i = table.getn(casted),1,-1 do
		if casted[i].spell == spelltable.spell and timerdata[casted[i].type].isreal then
			local reason = "inaccurate"
			if casted[i].type == "ghost" then reason = "replaced" end
			Cooldowns_RemoveTimer(i,reason,1)
		end
	end
	if table.getn(casted) == Cooldowns_Settings.maxdebuffs then return end
	table.insert(casted,spelltable)
	Cooldowns_CreateInterface()
end

function Cooldowns_DefineFormat()
	if Cooldowns_Settings.format == "icons" then
		for i = 1,20 do
			getglobal("CooldownsTableCooldown"..i.."Icon"):Show()
			getglobal("CooldownsTableCooldown"..i.."Bar"):Hide()
			getglobal("CooldownsTableCooldown"..i.."Text"):Hide()
		end
	elseif Cooldowns_Settings.format == "bars" then
		for i = 1,20 do
			getglobal("CooldownsTableCooldown"..i.."Icon"):Hide()
			getglobal("CooldownsTableCooldown"..i.."Bar"):Show()
			getglobal("CooldownsTableCooldown"..i.."Text"):Hide()
			local offset
			if Cooldowns_Settings.icons then
				offset = 16
				getglobal("CooldownsTableCooldown"..i.."BarButtonTexture"):Show()
			else
				offset = 0
				getglobal("CooldownsTableCooldown"..i.."BarButtonTexture"):Hide()
			end
			getglobal("CooldownsTableCooldown"..i.."BarStatus"):ClearAllPoints()
			getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetPoint("TOPLEFT","CooldownsTableCooldown"..i.."Bar","TOPLEFT",offset,0)
			getglobal("CooldownsTableCooldown"..i.."Bar"):SetWidth(Cooldowns_Settings.barlength + offset)
			getglobal("CooldownsTableCooldown"..i.."BarStatusTime"):SetWidth(Cooldowns_Settings.barlength - 6)
			getglobal("CooldownsTableCooldown"..i.."BarButton"):SetWidth(Cooldowns_Settings.barlength + offset)
			getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetWidth(Cooldowns_Settings.barlength)
			getglobal("CooldownsTableCooldown"..i.."BarBackground"):SetWidth(Cooldowns_Settings.barlength)
		end
	elseif Cooldowns_Settings.format == "text" then
		for i = 1,10 do
			for id = 1,20 do
				getglobal("CooldownsTableCooldown"..i.."Icon"):Hide()
				getglobal("CooldownsTableCooldown"..i.."Bar"):Hide()
				getglobal("CooldownsTableCooldown"..i.."Text"):Show()
				getglobal("CooldownsTableCooldown"..i.."Text"):SetWidth(Cooldowns_Settings.barlength)
				getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetWidth(Cooldowns_Settings.barlength)
				getglobal("CooldownsTableCooldown"..i.."TextButton"):SetWidth(Cooldowns_Settings.barlength)
			end
		end
	end
end

function Cooldowns_ResizeInterface() --resizes the frames that hold the debuffs so that they are more tightly compacted on the screen
	local maxwidth,maxheight,otherwidth,otherheight,debuffheight,debuffwidth,timerheight,timerwidth
	if Cooldowns_Settings.format == "icons" then
		local text
		if Cooldowns_Settings.tenths then text = "0:00.0" else text = "0:00" end
		CooldownsTableCooldown1IconTime:SetText(text)
		debuffheight = CooldownsTableCooldown1IconButton:GetHeight() * Cooldowns_Settings.buttonscale
		debuffwidth = CooldownsTableCooldown1IconButton:GetWidth() * Cooldowns_Settings.buttonscale
		timerheight = CooldownsTableCooldown1IconTime:GetHeight()
		timerwidth = CooldownsTableCooldown1IconTime:GetWidth()
	elseif Cooldowns_Settings.format == "bars" then
		debuffheight = CooldownsTableCooldown1BarButton:GetHeight() * Cooldowns_Settings.buttonscale
		debuffwidth = CooldownsTableCooldown1BarButton:GetWidth() * Cooldowns_Settings.buttonscale
	elseif Cooldowns_Settings.format == "text" then
		debuffheight = CooldownsTableCooldown1TextButton:GetHeight() * Cooldowns_Settings.buttonscale
		debuffwidth = CooldownsTableCooldown1TextButton:GetWidth() * Cooldowns_Settings.buttonscale
	end
	local d = Cooldowns_Settings.debufflayout
	if d == "up" or d == "down" then -- wider than they are tall
		if Cooldowns_Settings.format == "icons" then
			maxwidth = debuffwidth + timerwidth + 5
			maxheight = math.max(debuffheight,timerheight)
			otherwidth = debuffwidth + timerwidth + 5
			otherheight = debuffheight
		else
			maxwidth = debuffwidth
			maxheight = debuffheight
			otherwidth = debuffwidth
			otherheight = debuffheight
		end
	else --taller than they are wide
		if Cooldowns_Settings.format == "icons" then
			maxwidth = math.max(debuffwidth,timerwidth)
			maxheight = debuffheight + timerheight + 5
			otherwidth = debuffwidth
			otherheight = debuffheight + timerheight + 5
		else
			maxwidth = debuffwidth
			maxheight = debuffheight
			otherwidth = debuffwidth
			otherheight = debuffheight
		end
	end
	CooldownsTable:SetWidth(maxwidth)
	CooldownsTable:SetHeight(maxheight)
	for i = 1,20 do
		local frame
		getglobal("CooldownsTableCooldown"..i):SetWidth(maxwidth)
		getglobal("CooldownsTableCooldown"..i):SetHeight(maxheight)
		if Cooldowns_Settings.format == "icons" then
			frame = getglobal("CooldownsTableCooldown"..i.."Icon")
		elseif Cooldowns_Settings.format == "bars" then
			frame = getglobal("CooldownsTableCooldown"..i.."Bar")
		elseif Cooldowns_Settings.format == "text" then
			frame = getglobal("CooldownsTableCooldown"..i.."Text")
		end
		frame:SetWidth(otherwidth)
		frame:SetHeight(otherheight)
	end
end 

function Cooldowns_DefineInterface(debuffsetup,startup) --the controller behind the 16 different interface layouts
	local olddebuffsetup = Cooldowns_Settings.debufflayout
	Cooldowns_Settings.debufflayout = debuffsetup
	local ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9
	local num1,num2,num3,num4,num5,num6,num7,num8
	--ref1/2: name string to target frame: the name is anchored by (1) to the target's (2)
	--ref3/4: time string to debuff texture: the timer is anchored by (3) to the texture's (4)
	--ref5/6 the anchor corner/its opposite: the 1st target is anchored by (5) to the drag icon's (6)
	--ref7/8: anchors for the debuffs: the next debuff is anchored by its (8) to the previous's (7) (reversed order than usual)
	--ref9: anchor for the 1st debuff; it is connected by its (9) to the target frame's (9)
	--num1/2: dist. between name string and target: you go left (1) and up (2) to go from target to name
	--num3/4: dist. between time string and texture: you go left (3) and up (4) to go from texture to timer
	--num5/6: dist. between debuffs: you go left (5) and up (6) to go from one debuff to the next
	--num7/8: from main frame to 1st target, for a bit of room: you go left (7) and up (8) to go from main frame to 1st target
	if debuffsetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9 = "LEFT","RIGHT","TOP","BOTTOM","TOPRIGHT","BOTTOMLEFT","LEFT","RIGHT","TOPRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8 = 5,0,0,-5,-Cooldowns_Settings.spacing,0,-5,-5
	elseif debuffsetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9 = "TOP","BOTTOM","LEFT","RIGHT","BOTTOMRIGHT","TOPLEFT","TOP","BOTTOM","BOTTOMRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8 = 0,-5,5,0,0,Cooldowns_Settings.spacing,-5,5
	elseif debuffsetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9 = "RIGHT","LEFT","TOP","BOTTOM","TOPLEFT","BOTTOMRIGHT","RIGHT","LEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8 = -5,0,0,-5,Cooldowns_Settings.spacing,0,5,-5
	elseif debuffsetup == "down" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9 = "BOTTOM","TOP","LEFT","RIGHT","TOPLEFT","BOTTOMRIGHT","BOTTOM","TOP","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8 = 0,5,5,0,0,-Cooldowns_Settings.spacing,5,-5
	else
		Cooldowns_AddText("Failure to change interface design! No changes made.")
		Cooldowns_Settings.debufflayout = olddebuffsetup
	end
	if (not (Cooldowns_Settings.debufflayout == olddebuffsetup)) or (startup) then 
		getglobal("CooldownsTable"):ClearAllPoints()
		getglobal("CooldownsTableName"):ClearAllPoints()
		getglobal("CooldownsTableName"):SetPoint(ref1,"CooldownsTableCooldown1",ref2,num1,num2)
		for i = 1,20 do
			getglobal("CooldownsTableCooldown"..i):ClearAllPoints()
			getglobal("CooldownsTableCooldown"..i.."IconTime"):ClearAllPoints()
			getglobal("CooldownsTableCooldown"..i.."IconTime"):SetPoint(ref3,"CooldownsTableCooldown"..i.."IconButton",ref4,num3,num4)
		end
		getglobal("CooldownsTableCooldown1"):SetPoint(ref9,"CooldownsTable",ref9)
		for i = 2,20 do
			getglobal("CooldownsTableCooldown"..i):SetPoint(ref8,"CooldownsTableCooldown"..(i-1),ref7,num5,num6)
		end
		getglobal("CooldownsTable"):SetPoint(ref5,"CooldownsMainFrame",ref6,num7,num8)
		DoTimer_ResizeInterface() 
	end
end

function Cooldowns_CreateInterface(external,frommenu)
	local time = GetTime()
	if table.getn(casted) == 0 then 
		CooldownsFrame:SetScript("OnUpdate",nil) 
		if Cooldowns_Settings.dotimer then
			local cooldownsindex = DoTimer_ReturnTargetTable("Cooldowns ",0,0,0)
			if cooldownsindex then DoTimer_RemoveTarget(cooldownsindex) end
		end
	end
	if table.getn(casted) == 1 then CooldownsFrame:SetScript("OnUpdate",function() Cooldowns_OnUpdate() end) end
	if table.getn(casted) > 0 then
		Cooldowns_SortTimers()
		if Cooldowns_Settings.dotimer then
			local dotimer_casted = DoTimer_ReturnData()
			local cooldownsindex = DoTimer_ReturnTargetTable("Cooldowns ",0,0,0)
			if not cooldownsindex then table.insert(dotimer_casted,casted) end
			DoTimer_CreateInterface(1)
			CooldownsTable:Hide()
		else	
			CooldownsTable:Show()
			if Cooldowns_Settings.names then --set the target name if you have them on, else hide it
				getglobal("CooldownsTableName"):Show()
				getglobal("CooldownsTableNameText"):SetText("Cooldowns")
				getglobal("CooldownsTableName"):SetHeight(getglobal("CooldownsTableNameText"):GetHeight())
				getglobal("CooldownsTableName"):SetWidth(getglobal("CooldownsTableNameText"):GetWidth())
			else
				getglobal("CooldownsTableName"):Hide()
			end
			for i = 1,math.min(table.getn(casted),Cooldowns_Settings.maxdebuffs) do --for each debuff on the target
				local cooldownframe = getglobal("CooldownsTableCooldown"..i)
				if frommenu or not (cooldownframe.data and cooldownframe.data == casted[i]) then
					cooldownframe.data = casted[i]
					local type = casted[i].type
					if Cooldowns_Settings.format == "icons" then
						getglobal("CooldownsTableCooldown"..i):Show()
						getglobal("CooldownsTableCooldown"..i.."IconButton"):UnlockHighlight()
						getglobal("CooldownsTableCooldown"..i.."IconButtonTexture"):SetTexture(casted[i].texture) --setting the icon
						if timerdata[type].disptimer then
							local remaining = casted[i].duration - time + casted[i].time
							getglobal("CooldownsTableCooldown"..i.."IconTime"):SetText(Cooldowns_ReturnNewDuration(remaining)) --setting the time remaining
							local displayed = casted[i].displayed
							if displayed and (displayed == 5 or displayed == 4) and Cooldowns_Settings.expalert then getglobal("CooldownsTableCooldown"..i.."IconButton"):LockHighlight() end
							local color
							local half = casted[i].duration / 2						
							if remaining <= 5 then
								color = timerdata[type].colors.final
							elseif remaining <= half then
								color = timerdata[type].colors.half
							else
								color = timerdata[type].colors.begin
							end
							getglobal("CooldownsTableCooldown"..i.."IconTime"):SetTextColor(color.r,color.g,color.b) --setting the color of the time remaining
						else
							getglobal("CooldownsTableCooldown"..i.."IconTime"):SetText(casted[i].spell)
							local color = timerdata[type].colors.begin
							getglobal("CooldownsTableCooldown"..i.."IconTime"):SetTextColor(color.r,color.g,color.b)
						end
						getglobal("CooldownsTableCooldown"..i.."Icon"):SetAlpha(timerdata[type].alpha * Cooldowns_Settings.alpha)
						getglobal("CooldownsTableCooldown"..i.."IconButton"):SetScale(Cooldowns_Settings.buttonscale * timerdata[type].scale)
						local clickable = Cooldowns_Settings.clickable and timerdata[type].clickable or false
						getglobal("CooldownsTableCooldown"..i.."IconButton"):EnableMouse(clickable)
					elseif Cooldowns_Settings.format == "bars" then
						getglobal("CooldownsTableCooldown"..i):Show()
						getglobal("CooldownsTableCooldown"..i.."BarButtonTexture"):SetTexture(casted[i].texture) --setting the icon
						if timerdata[type].disptimer then
							local remaining = casted[i].duration - time + casted[i].time
							getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetMinMaxValues(0,casted[i].duration)
							getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetValue(remaining)
							getglobal("CooldownsTableCooldown"..i.."BarStatusTime"):SetText(Cooldowns_FormatBarText(i)) --setting the time remaining
							local color
							local half = casted[i].duration / 2
							if remaining <= 5 then
								color = timerdata[type].colors.final
							elseif remaining <= half then
								color = timerdata[type].colors.half
							else
								color = timerdata[type].colors.begin	
							end
							getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetStatusBarColor(color.r,color.g,color.b) --setting the color of the time remaining
						else
							getglobal("CooldownsTableCooldown"..i.."BarStatusTime"):SetText(casted[i].spell)
							getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetMinMaxValues(0,1)
							getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetValue(1)
							local color = timerdata[type].colors.begin
							getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetStatusBarColor(color.r,color.g,color.b)
						end
						getglobal("CooldownsTableCooldown"..i.."Bar"):SetAlpha(timerdata[type].alpha * Cooldowns_Settings.alpha)
						getglobal("CooldownsTableCooldown"..i.."BarButton"):SetScale(Cooldowns_Settings.buttonscale * timerdata[type].scale)
						getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetScale(Cooldowns_Settings.buttonscale * timerdata[type].scale)
						getglobal("CooldownsTableCooldown"..i.."BarBackground"):SetScale(Cooldowns_Settings.buttonscale * timerdata[type].scale)	
						local clickable = Cooldowns_Settings.clickable and timerdata[type].clickable or false
						getglobal("CooldownsTableCooldown"..i.."BarButton"):EnableMouse(clickable)
					elseif Cooldowns_Settings.format == "text" then
						getglobal("CooldownsTableCooldown"..i):Show()
						getglobal("CooldownsTableCooldown"..i.."TextButton"):UnlockHighlight()
						if timerdata[type].disptimer then
							local remaining = casted[i].duration - time + casted[i].time
							getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetText(Cooldowns_FormatBarText(i)) --setting the time remaining
							local color
							local half = casted[i].duration / 2						
							if remaining <= 5 then
								color = timerdata[type].colors.final
							elseif remaining <= half then
								color = timerdata[type].colors.half
							else
								color = timerdata[type].colors.begin
							end
							getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetTextColor(color.r,color.g,color.b) --setting the color of the time remaining
						else
							getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetText(casted[i].spell)
							local color = timerdata[type].colors.begin
							getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetTextColor(color.r,color.g,color.b)
						end												
						getglobal("CooldownsTableCooldown"..i.."Text"):SetAlpha(timerdata[type].alpha * Cooldowns_Settings.alpha) --setting the alpha of the icon
						getglobal("CooldownsTableCooldown"..i.."TextButton"):SetScale(Cooldowns_Settings.buttonscale * timerdata[type].scale)
						local clickable = Cooldowns_Settings.clickable and timerdata[type].clickable or false
						getglobal("CooldownsTableCooldown"..i.."TextButton"):EnableMouse(clickable)
					end
				end
			end
		end
	else
		CooldownsTable:Hide()
	end
	for i = table.getn(casted) + 1,20 do
		local cooldownframe = getglobal("CooldownsTableCooldown"..i)
		cooldownframe:Hide() --hiding unused targets
		cooldownframe.data = nil
	end
end

function Cooldowns_AddTimers(numcooldowns) --used to view different interface layouts
	Cooldowns_DelTimers()
	CooldownsTable:Show()
	if Cooldowns_Settings.names then --set the target name if you have them on, else hide it
		getglobal("CooldownsTableName"):Show()
		getglobal("CooldownsTableNameText"):SetText("Cooldowns")
		getglobal("CooldownsTableName"):SetHeight(getglobal("CooldownsTableNameText"):GetHeight())
		getglobal("CooldownsTableName"):SetWidth(getglobal("CooldownsTableNameText"):GetWidth())
	else
		getglobal("CooldownsTableName"):Hide()
	end
	for i = 1,(numcooldowns or Cooldowns_Settings.maxdebuffs) do
		if Cooldowns_Settings.format == "icons" then
			getglobal("CooldownsTableCooldown"..i):Show()
			getglobal("CooldownsTableCooldown"..i.."IconButton"):UnlockHighlight()
			getglobal("CooldownsTableCooldown"..i.."IconButtonTexture"):SetTexture(GetSpellTexture(i,BOOKTYPE_SPELL)) --setting the icon
			getglobal("CooldownsTableCooldown"..i.."IconTime"):SetText("0:00") --setting the time remaining
			getglobal("CooldownsTableCooldown"..i.."IconTime"):SetTextColor(.2,1,.2) --setting the color of the time remaining
		elseif Cooldowns_Settings.format == "bars" then
			getglobal("CooldownsTableCooldown"..i):Show()
			getglobal("CooldownsTableCooldown"..i.."BarButtonTexture"):SetTexture(GetSpellTexture(i,BOOKTYPE_SPELL)) --setting the icon
			getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetMinMaxValues(0,1)
			getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetValue(1)
			getglobal("CooldownsTableCooldown"..i.."BarStatusTime"):SetText("0:00 - Fake Spell") --setting the time remaining
			getglobal("CooldownsTableCooldown"..i.."BarStatus"):SetStatusBarColor(.2,1,.2) --setting the color of the time remaining
		elseif Cooldowns_Settings.format == "text" then
			getglobal("CooldownsTableCooldown"..i):Show()
			getglobal("CooldownsTableCooldown"..i.."TextButton"):UnlockHighlight()
			getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetText("0:00 - Fake Spell") --setting the time remaining
			getglobal("CooldownsTableCooldown"..i.."TextButtonTime"):SetTextColor(.2,1,.2) --setting the color of the time remaining
		end
	end
end

function Cooldowns_DelTimers() --used to hide the "fake" timers created by the above function
	getglobal("CooldownsTableName"):Hide()
	for i = 1,20 do
		getglobal("CooldownsTableCooldown"..i):Hide()
	end
end

function Cooldowns_SortTimers() --separated the timers by their type then arranges by time added or time remaining
	local regtimers = {} --the 5 different types that timers can be, and a table to catch all blank timers
	local othertimers = {}
	local ghosttimers = {}
	local total = table.getn(casted)
	for i = total,1,-1 do --sorting into correct table
		local intable
		if casted[i].type == "cooldown" then intable = regtimers
		elseif casted[i].type == "ghost" then intable = ghosttimers 
		else intable = othertimers
		end
		table.insert(intable,casted[i])
		table.remove(casted,i)
	end
	local time = GetTime()
	local tables = {regtimers,ghosttimers,othertimers}
	for index,value in ipairs(tables) do
		if Cooldowns_Settings.sortmethod == "remaining" then --sorting the temp tables by time added or time remaining
			local time = GetTime()
			table.sort(value,function(a,b) return (a.duration - time + a.time) < (b.duration - time + b.time) end)
		else
			table.sort(value,function(a,b) return (a.time) < (b.time) end)
		end
	end
	for i = 1,table.getn(regtimers) do table.insert(casted,regtimers[i]) end
	for i = 1,table.getn(ghosttimers) do table.insert(casted,ghosttimers[i]) end
	for i = 1,table.getn(othertimers) do table.insert(casted,othertimers[i]) end
end

function Cooldowns_CreateGhostTimer(cooldownid)
	local spell = SpellSystem_Copy(casted[cooldownid])
	spell.time = GetTime()
	local ghostdata = Cooldowns_Settings.ghostdata
	if ghostdata == 0 then
		timerdata["ghost"].hastimer = false
	else
		timerdata["ghost"].hastimer = true
		spell.duration = ghostdata
	end
	spell.type = "ghost"
	for i = table.getn(casted),1,-1 do
		if casted[i].type == "ghost" and casted[i].spell == spell.spell then Cooldowns_RemoveTimer(i,"replaced",1) end
	end
	if table.getn(casted) < Cooldowns_Settings.maxdebuffs then table.insert(casted,spell) end
	Cooldowns_CreateInterface()
end

function Cooldowns_CreateTooltip(frame,cooldownindex)
	if not (casted[cooldownindex]) then return end
	GameTooltip:SetOwner(frame,"ANCHOR_RIGHT")
	if casted[cooldownindex].info then
		local type = casted[cooldownindex].info.type
		if type == BOOKTYPE_SPELL then
			GameTooltip:SetSpell(casted[cooldownindex].info.id,BOOKTYPE_SPELL)
		elseif type == "item" then
			GameTooltip:SetHyperlink(SpellSystem_ReturnItemLink(casted[cooldownindex].info.id))
		elseif type == BOOKTYPE_PET then
			GameTooltip:SetSpell(casted[cooldownindex].info.id,BOOKTYPE_PET)
		end
	else
		GameTooltip:AddLine(casted[cooldownindex].spell,1,1,1)
	end
	if casted[cooldownindex].english == "Soulstone" then GameTooltip:AppendText(string.format(" (%s)",casted[cooldownindex].rank)) end
	GameTooltip:Show()
end

function Cooldowns_Commands(msg,fromgui,bypass) --governs the /command
	if msg == "" then CooldownsMenuFrame:Show() return
	elseif msg == "on" then 
		Cooldowns_Settings.status = true
		Cooldowns_AddMenuText("Cooldowns by Asheyla now activated!",fromgui)
		CooldownsFrame:Show()
		CooldownsMainFrame:Show()
	elseif msg == "off" then
		Cooldowns_Settings.status = false
		Cooldowns_AddMenuText("Cooldowns by Asheyla is now deactivated.",fromgui)
		CooldownsFrame:Hide()
		CooldownsMainFrame:Hide()
	elseif msg == "reset" then
		for index,value in pairs(Cooldowns_Settings) do Cooldowns_Settings[index] = nil end
		Cooldowns_Commands("reset position",1)
		flag = true
		Cooldowns_Startup()
		Cooldowns_AddMenuText("All user data is now reset.",fromgui)
	elseif msg == "set format bars" then
		Cooldowns_Settings.format = "bars"
		Cooldowns_DefineFormat()
		Cooldowns_AddMenuText("Timers will now be displayed as bars.",fromgui)
	elseif msg == "set format icons" then
		Cooldowns_Settings.format = "icons"
		Cooldowns_DefineFormat()
		Cooldowns_AddMenuText("Timers will now be displayed as icons.",fromgui)	
	elseif msg == "set format text" then
		Cooldowns_Settings.format = "text"
		Cooldowns_DefineFormat()
		Cooldowns_AddMenuText("Timers will now be displayed as text.",fromgui)
	elseif msg == "reset position" then
		CooldownsAnchorFrame:ClearAllPoints()
		CooldownsAnchorFrame:SetPoint("CENTER","UIParent","CENTER",-5,0)
		Cooldowns_Settings.offsetX = nil
		Cooldowns_AddMenuText("The position of the UI is now reset.",fromgui)		
	elseif msg == "play sounds" then
		Cooldowns_Settings.playsound = true
		Cooldowns_AddMenuText("A sound will be played at 5 seconds.",fromgui)
	elseif msg == "do not play sounds" then
		Cooldowns_Settings.playsound = false
		Cooldowns_AddMenuText("No sounds will be played.",fromgui)
	elseif msg == "header off" then
		Cooldowns_Settings.names = false
		Cooldowns_AddMenuText("The header will not be shown.",fromgui)
		Cooldowns_ResizeInterface()
	elseif msg == "header on" then
		Cooldowns_Settings.names = true
		Cooldowns_AddMenuText("The header will  be shown.",fromgui)
		Cooldowns_ResizeInterface()
	elseif msg == "lock" then
		Cooldowns_Settings.locked = true
		CooldownsAnchorFrame:Hide()
		Cooldowns_AddMenuText("The timers are now locked in place.",fromgui)
	elseif msg == "unlock" then
		Cooldowns_Settings.locked = false
		CooldownsAnchorFrame:Show()
		Cooldowns_AddMenuText("The timers can now be moved by dragging the little button around.",fromgui)
	elseif msg == "sort by remaining" then
		Cooldowns_AddMenuText("Timers will now be ordered by their time remaining.",fromgui)
		Cooldowns_Settings.sortmethod = "remaining"
	elseif msg == "sort by added" then
		Cooldowns_AddMenuText("Timers will now be ordered by when they were cast. ",fromgui)
		Cooldowns_Settings.sortmethod = "added"
	elseif msg == "clickable cooldowns" then
		Cooldowns_Settings.clickable = true
		Cooldowns_AddMenuText("The timers can now be clicked.  Leftclick to add to chat, rightclick to remove, shift+rightclick to remove and block.",fromgui)
	elseif msg == "unclickable cooldowns" then
		Cooldowns_Settings.clickable = false
		Cooldowns_AddMenuText("The timers can no longer be clicked.",fromgui)
	elseif msg == "integrate" then
		Cooldowns_Settings.dotimer = true
		Cooldowns_AddMenuText("The cooldowns will be displayed in DoTimer's tables.",fromgui)
		CooldownsTable:Hide()
	elseif msg == "separate" then
		Cooldowns_Settings.dotimer = false
		Cooldowns_AddMenuText("The cooldowns will be displayed separate from DoTimer's tables.",fromgui)
		local dotimer_casted = DoTimer_ReturnData()
		local targetindex = DoTimer_ReturnTargetTable("Cooldowns ",0,0,0)
		if targetindex then 
			table.remove(dotimer_casted,targetindex)
			DoTimer_CreateInterface(1)
		end
	elseif msg == "no expire alert" then
		Cooldowns_Settings.expalert = false
		Cooldowns_AddMenuText("The timers will not change color or highlight.",fromgui)
	elseif msg == "expire alert" then
		Cooldowns_Settings.expalert = true
		Cooldowns_AddMenuText("The timers will change to red and highlight at 5 seconds.",fromgui)
	elseif msg == "show blocked" then
		Cooldowns_AddText("Blocked timers:")
		for index,value in pairs(Cooldowns_Settings.blocked) do Cooldowns_AddText(index) end
	elseif msg == "show tenths" then
		Cooldowns_AddMenuText("The timers will now display to the nearest .1 second.",fromgui)
		Cooldowns_Settings.tenths = true
	elseif msg == "hide tenths" then
		Cooldowns_AddMenuText("The timers will now display to the nearest 1 second.",fromgui)
		Cooldowns_Settings.tenths = false
	elseif msg == "hide" then
		Cooldowns_DelTimers()
	elseif msg == "show tooltips" then
		Cooldowns_AddMenuText("Tooltips will now be shown when mousing over timers.",fromgui)
		Cooldowns_Settings.tooltips = true
	elseif msg == "hide tooltips" then
		Cooldowns_AddMenuText("Tooltips will not be shown when mousing over timers.",fromgui)
		Cooldowns_Settings.tooltips = false
	elseif msg == "hide identical timers" then
		Cooldowns_AddMenuText("Identical timers will be hidden.",fromgui)
		Cooldowns_Settings.hidesame = true
	elseif msg == "show identical timers" then
		Cooldowns_AddMenuText("Identical timers will be shown.",fromgui)
		Cooldowns_Settings.hidesame = false
	elseif msg == "global settings" then
		DoTimer_Global_Settings.global["Cooldowns"] = true
		Cooldowns_AddMenuText("Cooldowns's settings will now be shared across all characters.",fromgui)
	elseif msg == "local settings" then
		DoTimer_Global_Settings.global["Cooldowns"] = false
		Cooldowns_AddMenuText("Cooldowns's settings can be now changed per character.",fromgui)
	elseif msg == "show icons" then
		Cooldowns_Settings.icons = true
		Cooldowns_AddMenuText("The icons on the bars of the bar format will now be shown.",fromgui)
		Cooldowns_DefineFormat()
	elseif msg == "hide icons" then
		Cooldowns_Settings.icons = false
		Cooldowns_AddMenuText("The icons on the bars of the bar format will now be hidden.",fromgui)
		Cooldowns_DefineFormat()
	elseif msg == "show ghosts" then
		Cooldowns_Settings.ghosts = true
		Cooldowns_AddMenuText("Ghost timers will now be shown.",fromgui)
	elseif msg == "hide ghosts" then
		Cooldowns_Settings.ghosts = false
		Cooldowns_AddMenuText("Ghost timers will not be shown.",fromgui)
	elseif string.sub(msg,1,10) == "set alpha " then
		local alpha = string.sub(msg,11)
		if type(tonumber(alpha)) == "number" then
			scale = tonumber(string.format("%.2f",alpha))
			Cooldowns_Settings.alpha = alpha
			Cooldowns_AddMenuText("New alpha: "..alpha,fromgui)
		end
	elseif string.sub(msg,1,13) == "ghost length " then
		local ghostdata = string.sub(msg,14)
		if type(tonumber(ghostdata)) == "number" then
			ghostdata = tonumber(string.format("%d",ghostdata))
			Cooldowns_Settings.ghostdata = ghostdata
			if ghostdata == 0 then
				Cooldowns_AddMenuText("Ghost timers will now last indefinitely.",fromgui)
			else
				Cooldowns_AddMenuText("Ghost timers will now last "..ghostdata.." seconds.",fromgui)
			end
		end
	elseif string.sub(msg,1,8) == "bar msg " then
		local msg = string.sub(msg,9)
		Cooldowns_Settings.barmsg = msg
		Cooldowns_AddMenuText("The text inside the bars is now "..msg,fromgui)
	elseif string.sub(msg,1,4) == "show" then
		local number = SpellSystem_ParseString(msg,"(%d+)")
		Cooldowns_AddTimers(number)
		bypass = 1
	elseif string.sub(msg,1,11) == "min length " then
		local number = string.sub(msg,12)
		if type(tonumber(number)) == "number" then
			number = tonumber(string.format("%d",number))
			Cooldowns_Settings.mincd = number
			Cooldowns_AddMenuText("New minimum cooldown: "..number,fromgui)
		end
	elseif string.sub(msg,1,6) == "block " then
		local spell = string.lower(string.sub(msg,7))
		Cooldowns_Settings.blocked[spell] = 1
		Cooldowns_AddMenuText(spell.." will not be shown as a timer.",fromgui)
	elseif string.sub(msg,1,8) == "unblock " then
		local spell = string.lower(string.sub(msg,9))
		Cooldowns_Settings.blocked[spell] = nil
		Cooldowns_AddMenuText(spell.." will be shown again as a timer.",fromgui)
	elseif string.sub(msg,1,11) == "set layout " then
		local debufflayout = SpellSystem_ParseString(msg,"(%a+)",-1)
		Cooldowns_AddMenuText("Cooldowns will be added "..(debufflayout or "<cannot parse!>")..".",fromgui)
		Cooldowns_DefineInterface(debufflayout)
	elseif string.sub(msg,1,5) == "scale" then
		local scale = string.sub(msg,7)
		if type(tonumber(scale)) == "number" then
			scale = tonumber(string.format("%.2f",scale))
			CooldownsMainFrame:SetScale(scale)
			Cooldowns_Settings.scale = scale
			Cooldowns_AddMenuText("New scale: "..scale,fromgui)
			Cooldowns_ResizeInterface()
		end
	elseif string.sub(msg,1,11) == "bar length " then
		local number = tonumber(string.sub(msg,12))
		if type(number) == "number" and number >= 50 and number <= 250 then
			Cooldowns_Settings.barlength = number
			Cooldowns_DefineFormat()
			Cooldowns_AddMenuText("Timer bars will now have length "..number,fromgui)
		end
	elseif string.sub(msg,1,12) == "set spacing " then
		local number = tonumber(string.sub(msg,13))
		if type(number) == "number" and number >= 0 and number <= 10 then
			Cooldowns_Settings.spacing = number
			Cooldowns_DefineInterface(Cooldowns_Settings.debufflayout,1)
			Cooldowns_AddMenuText("Debuffs will now be spaced "..number.." apart.",fromgui)
		end
	elseif string.sub(msg,1,14) == "max cooldowns " then
		local number = tonumber(string.sub(msg,15))
		if type(number) == "number" and number > 0 and number < 21 then
			Cooldowns_Settings.maxdebuffs = number
			Cooldowns_AddMenuText("Max number of cooldowns is now "..number,fromgui)
		end
	elseif string.sub(msg,1,13) == "button scale " then
		local scale = string.sub(msg,14)
		if type(tonumber(scale)) == "number" then 
			scale = tonumber(string.format("%.2f",scale))
			Cooldowns_Settings.buttonscale = scale
			Cooldowns_AddMenuText("The new button scale is now "..scale,fromgui)
		end	
	elseif string.sub(msg,1,9) == "chat msg " then
		local type,newmsg = SpellSystem_ParseString(msg,"chat msg (%a+):%s?(.+)")
		if newmsg then
			if type == "normal" then
				Cooldowns_Settings.chatmsgnormal = newmsg
				Cooldowns_AddMenuText("The new format string for normal cooldowns is now "..newmsg,fromgui)	
			elseif type == "soulstone" then
				Cooldowns_Settings.chatmsgnotarget = newmsg
				Cooldowns_AddMenuText("The new format string for soulstone cooldowns is now "..newmsg,fromgui)		
			end
		end
	elseif string.sub(msg,1,4) == "help" then Cooldowns_AddHelpMenu(msg)
	else
		Cooldowns_AddMenuText("Type |cff00ff00/cooldowns help|r for more options, or |cff00ff00/cooldowns|r to open the menu!",fromgui)
	end
	if not (fromgui or bypass) then Cooldowns_CreateInterface(1,1) end
end

function Cooldowns_ToChat(cooldownindex)
	if not casted[cooldownindex].external then
		local displayed = casted[cooldownindex].displayed
		local spell = casted[cooldownindex].spell
		local rank = casted[cooldownindex].rank
		if (displayed and spell and rank) then
			displayed = Cooldowns_ReturnNewDuration(displayed)
			local chat = "SAY"
			if GetNumRaidMembers() > 0 then chat = "RAID" elseif GetNumPartyMembers() > 0 then chat = "PARTY" end
			local subentries,unsubbedmsg
			if casted[cooldownindex].english == "Soulstone" then
				subentries = {
					["%d"] = displayed,
					["%s"] = spell,
					["%t"] = rank,
				}
				unsubbedmsg = Cooldowns_Settings.chatmsgsoulstone
			else
				subentries = {
					["%d"] = displayed,
					["%s"] = spell,
				}
				unsubbedmsg = Cooldowns_Settings.chatmsgnormal
			end
			local msg = string.gsub(unsubbedmsg,"(%%%a)",function(a) return subentries[a] or "" end)
			msg = string.gsub(msg,"%(%)","")
			SendChatMessage(msg,chat)
		end
	end
end

function Cooldowns_ReturnData(which)
	which = which or "casted"
	if which == "casted" then
		return casted
	elseif which == "timerdata" then
		return timerdata
	end
end

function Cooldowns_CreateTimerGroup(name,isreal,hastimer,disptimer,clickable,scale,alpha,colors)
	timerdata[name] = {
		isreal = isreal,
		hastimer = hastimer,
		disptimer = disptimer,
		clickable = clickable,
		scale = scale,
		alpha = alpha,
		colors = colors
	}
end
