function Cooldowns_SetMenuData()
	CooldownsScaleSlider:SetValue(Cooldowns_Settings.scale)
	CooldownsButtonScaleSlider:SetValue(Cooldowns_Settings.buttonscale)
	CooldownsMaxDebuffsSlider:SetValue(Cooldowns_Settings.maxdebuffs)
	CooldownsFormatSlider:SetValue(CooldownsFormatSlider.values[Cooldowns_Settings.format])
	CooldownsDebuffLayoutSlider:SetValue(CooldownsDebuffLayoutSlider.values[Cooldowns_Settings.debufflayout])
	CooldownsDebuffSortSlider:SetValue(CooldownsDebuffSortSlider.values[Cooldowns_Settings.sortmethod])
	CooldownsEnabledCheckButton:SetChecked(Cooldowns_Settings.status)
	CooldownsLockedCheckButton:SetChecked(Cooldowns_Settings.locked)
	CooldownsNamesCheckButton:SetChecked(Cooldowns_Settings.names)
	CooldownsExpAlertCheckButton:SetChecked(Cooldowns_Settings.expalert)
	CooldownsClickableCheckButton:SetChecked(Cooldowns_Settings.clickable)
	CooldownsPlaySoundsCheckButton:SetChecked(Cooldowns_Settings.playsound)
	CooldownsBarLengthSlider:SetValue(Cooldowns_Settings.barlength)
	CooldownsDoTimerCheckButton:SetChecked(Cooldowns_Settings.dotimer)
	CooldownsMinCDSlider:SetValue(Cooldowns_Settings.mincd)
	CooldownsSpacingSlider:SetValue(Cooldowns_Settings.spacing)
	CooldownsTenthsCheckButton:SetChecked(Cooldowns_Settings.tenths)
	CooldownsTooltipsCheckButton:SetChecked(Cooldowns_Settings.tooltips)
	CooldownsHideSameCheckButton:SetChecked(Cooldowns_Settings.hidesame)
	CooldownsGlobalCheckButton:SetChecked(DoTimer_Global_Settings.global["Cooldowns"])
	CooldownsAlphaSlider:SetValue(Cooldowns_Settings.alpha)
	CooldownsIconsCheckButton:SetChecked(Cooldowns_Settings.icons)
	CooldownsGhostsCheckButton:SetChecked(Cooldowns_Settings.ghosts)
	CooldownsGhostDataSlider:SetValue(Cooldowns_Settings.ghostdata)
end

function Cooldowns_ParseMenuData()
	Cooldowns_Commands("scale "..CooldownsScaleSlider:GetValue(),1)
	Cooldowns_Commands("button scale "..CooldownsButtonScaleSlider:GetValue(),1)
	Cooldowns_Commands("max cooldowns "..CooldownsMaxDebuffsSlider:GetValue(),1)
	Cooldowns_Commands("set format "..CooldownsFormatSlider.values[CooldownsFormatSlider:GetValue()],1)
	Cooldowns_Commands("set layout "..CooldownsDebuffLayoutSlider.values[CooldownsDebuffLayoutSlider:GetValue()],1)
	Cooldowns_Commands("sort by "..CooldownsDebuffSortSlider.values[CooldownsDebuffSortSlider:GetValue()],1)
	Cooldowns_Commands("bar length "..CooldownsBarLengthSlider:GetValue(),1)
	Cooldowns_Commands("min length "..CooldownsMinCDSlider:GetValue(),1)
	Cooldowns_Commands("set spacing "..CooldownsSpacingSlider:GetValue(),1)
	Cooldowns_Commands("set alpha "..CooldownsAlphaSlider:GetValue(),1)
	Cooldowns_Commands("ghost length "..CooldownsGhostDataSlider:GetValue(),1)
	if CooldownsEnabledCheckButton:GetChecked() then Cooldowns_Commands("on",1) else Cooldowns_Commands("off",1) end
	if CooldownsLockedCheckButton:GetChecked() then Cooldowns_Commands("lock",1) else Cooldowns_Commands("unlock",1) end
	if CooldownsNamesCheckButton:GetChecked() then Cooldowns_Commands("header on",1) else Cooldowns_Commands("header off",1) end
	if CooldownsExpAlertCheckButton:GetChecked() then Cooldowns_Commands("expire alert",1) else Cooldowns_Commands("no expire alert",1) end
	if CooldownsClickableCheckButton:GetChecked() then Cooldowns_Commands("clickable cooldowns",1) else Cooldowns_Commands("unclickable cooldowns",1) end
	if CooldownsPlaySoundsCheckButton:GetChecked() then Cooldowns_Commands("play sounds",1) else Cooldowns_Commands("do not play sounds",1) end
	if CooldownsDoTimerCheckButton:GetChecked() then Cooldowns_Commands("integrate",1) else Cooldowns_Commands("separate",1) end
	if CooldownsTenthsCheckButton:GetChecked() then Cooldowns_Commands("show tenths",1) else Cooldowns_Commands("hide tenths",1) end
	if CooldownsTooltipsCheckButton:GetChecked() then Cooldowns_Commands("show tooltips",1) else Cooldowns_Commands("hide tooltips",1) end
	if CooldownsHideSameCheckButton:GetChecked() then Cooldowns_Commands("hide identical timers",1) else Cooldowns_Commands("show identical timers",1) end
	if CooldownsGlobalCheckButton:GetChecked() then Cooldowns_Commands("global settings",1) else Cooldowns_Commands("local settings",1) end
	if CooldownsIconsCheckButton:GetChecked() then Cooldowns_Commands("show icons",1) else Cooldowns_Commands("hide icons",1) end
	if CooldownsGhostsCheckButton:GetChecked() then Cooldowns_Commands("show ghosts",1) else Cooldowns_Commands("hide ghosts",1) end
	Cooldowns_CreateInterface(1,1)
end

function Cooldowns_AddHelpMenu(msg) --the help menu displayed ingame
	if msg == "help info" then
		Cooldowns_AddText("|cff00ffffCooldowns Version/Author Info:|r")
		Cooldowns_AddText("|cff00ff00Current version|r: "..SpellSystem_ReturnDateUploaded())
		Cooldowns_AddText("|cff00ff00Date Uploaded|r: "..SpellSystem_ReturnDateUploaded())
		Cooldowns_AddText("|cff00ff00Author|r: Asheyla <Warcraft Gaming Faction>, Shattered Hand (Horde)")
		Cooldowns_AddText("|cff00ff00Email|r: ross456@gmail.com")
		Cooldowns_AddText("|cff00ff00Paypal Donations|r: ross456@gmail.com")
	elseif msg == "help new" then
		Cooldowns_AddText("|cff00ffffCooldowns Beginner's Guide:|r")
		Cooldowns_AddText("|cff00ff00Please Note|r: The information in this subsection will not detail any other commands.  Please explore all help menus for a full understanding of all the features of this addon.")
		Cooldowns_AddText("|cff00ff00First Installation|r: You will notice a small black circle in the middle of your screen.  It is to this box that the timers are anchored.  Move it around by dragging it.")
		Cooldowns_AddText("|cff00ff00Cooldowns|r: When a tracked ability begins a cooldown, timers will automatically appear.  There is no configuration required for this basic step.")
		Cooldowns_AddText("|cff00ff00Ghost Timers|r: These are timers created when a real timer expires.  You can control how long they stay on your screen, or if they appear at all.")
		Cooldowns_AddText("|cff00ff00Troubleshooting|r: If you ever have any errors, please contact me.  It would be best if you include a way to duplicate the problem.  Before doing this, try disabling your other addons and seeing if the problem goes away.  If it does, figure out the conflicting addon and tell me.")
		Cooldowns_AddText("|cff00ff00Features|r: Many features of this addon have been direct requests by other players.  If you ever have any suggestions, feel free to contact me about them.")
	else
		Cooldowns_AddText("|cff00ffffCooldowns Help Menu:|r")
		Cooldowns_AddText("|cff00ff00help new|r: information for first-time users")
		Cooldowns_AddText("|cff00ff00help general|r: basic addon features")
		Cooldowns_AddText("|cff00ff00help info|r: displays some version/author info")
	end
end
