------------------------------------------------------------------------------------------------------------
-- ################### DATA ####################### --
------------------------------------------------------------------------------------------------------------

DoTimer_Settings = nil
DoTimer_DebugChannel = nil --for debugging purposes
local hasoffensive,hasdefensive --random variables i use
local lasttarget = {} --a table holding data for my last target
local casted = {} --governs the currently casted debuffs.  entries are 1-10 targets, which in turn are 1-20 debuffs and the target name
local finalspell = {} --a final table for a spell.  created when the debuff most likely lands on the target, lasts until the icon for that debuff appears
local castpetspell --the table for pet spellcasts
local sentpetspell --table for pet spells, to catch resists/whatever
local finalpetspell --another for pet spells, to await the icon
local finalenslavespell --an enslave spell awaiting an UPDATE_PET to be applied
local timerdata = {} --keeps information about how the different timers should be drawns on the screen
local unitids --used for scanning buffs
local targetids = {"target","focus"} --used for scanning debuffs
local petresistmsg = string.gsub(SPELLRESISTOTHEROTHER,"%%.-s","(.+)") --the chat message sent when a pet spell is resisted
local petevademsg = string.gsub(SPELLEVADEDOTHEROTHER,"%%.-s","(.+)") --the chat message sent when a pet spell is evaded
local petimmunemsg = string.gsub(SPELLIMMUNEOTHEROTHER,"%%.-s","(.+)") --the chat message sent when something is immune to pet's spell
local petreflectmsg = string.gsub(SPELLREFLECTOTHEROTHER,"%%.-s","(.+)") --the chat message sent when your pet's spell is reflected back to your pet
local diesmsg = string.gsub(UNITDIESOTHER,"%%.-s","(.+)") --the chat message sent when something dies
local fadesmsg = string.gsub(AURAREMOVEDOTHER,"%%.-s","(.+)") --the chat message sent when a debuff fades from something
local begincastmsg = string.gsub(SPELLCASTOTHERSTART,"%%.-s","(.+)") --in the pet msg for your pet beginning to cast a spell (seduction)
local slainmsg = string.gsub(SELFKILLOTHER,"%%.-s","(.+)") --when you had the killing blow for a death
local spells,healspells,enslavespells,notargetspells,localedata --spells are offensive duration spells,  healspells are friendly duration spells, and enslavespells are enslaving demon spells, protect spells are ones not filtered by onupdates
local spell_leeway_time = 3
local failmsgs = {
	resistmsg = string.gsub(SPELLRESISTSELFOTHER,"%%.-s","(.+)"),
	evademsg = string.gsub(SPELLEVADEDSELFOTHER,"%%.-s","(.+)"),
	immunemsg = string.gsub(SPELLIMMUNESELFOTHER,"%%.-s","(.+)"),
	reflectmsg = string.gsub(SPELLREFLECTSELFOTHER,"%%.-s","(.+)"),
	dodgemsg = string.gsub(SPELLDODGEDSELFOTHER,"%%.-s","(.+)"),
	parrymsg = string.gsub(SPELLPARRIEDSELFOTHER,"%%.-s","(.+)"),
	missmsg = string.gsub(SPELLMISSSELFOTHER,"%%.-s","(.+)"),
	absorbmsg = string.gsub(SPELLLOGABSORBSELFOTHER,"%%.-s","(.+)"),
}
local protectspells = { --spells that my onupdate functions never remove, since an icon is not created for them (or the icon mismatches the casted spell)
	["Spell Lock"] = 1,
	["Power Word: Shield"] = 1,
	["Counterspell"] = 1,
	["Pummel"] = 1,
	["Shield Bash"] = 1,
	["Kick"] = 1,
	["Judgement"] = 1,
	["Earth Shock"] = 1,
}
local uniquespells = { --spells that can only be applied once globally, but lack of cooldown allows spamming
	["Hunter's Mark"] = 1,
	["Fear"] = 1,
}
local uniquebyrank = { --spells which are unique by rank, not by spell
	["Moonfire"] = 1,
}
local notargetinfo = {
	target = "No Target",
	sex = 0,
	level = 0,
	icon = 0,
	type = "player",
}

------------------------------------------------------------------------------------------------------------
-- ################ LOCALIZATION ################### --
------------------------------------------------------------------------------------------------------------

function DoTimer_ReturnEnglish(spellname) --returns the english name of the spell
	spellname = spellname
	local tables = {BOOKTYPE_SPELL,BOOKTYPE_PET}
	local english,texture
	for index,value in ipairs(tables) do
		local i = 1
		while GetSpellName(i,value) do
			local spell = GetSpellName(i,value)
			if spell == spellname then
				texture = GetSpellTexture(i,value)
				break
			end
			i = i + 1
		end
	end
	if texture and localedata[texture] then return localedata[texture].name end
	return "unknown"
end

function DoTimer_ToLocale(spellname) -- returns the localized name of the english spell
	for index,value in pairs(localedata) do
		if value.name == spellname then
			local i = 1
			while GetSpellName(i,BOOKTYPE_SPELL) do
				local texture = GetSpellTexture(i,BOOKTYPE_SPELL)
				if texture == index then
					local spell = GetSpellName(i,BOOKTYPE_SPELL)
					return spell
				end
				i = i + 1
			end
		end
	end
	return "unknown"
end

------------------------------------------------------------------------------------------------------------
-- ############## BASIC FUNCTIONS ################### --
------------------------------------------------------------------------------------------------------------
	
function DoTimer_OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH")
	this:RegisterEvent("PLAYER_ALIVE")
	this:RegisterEvent("PLAYER_REGEN_ENABLED")
	this:RegisterEvent("CHAT_MSG_SPELL_AURA_GONE_OTHER")
	this:RegisterEvent("CHAT_MSG_SPELL_PET_DAMAGE")
	this:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE")
	this:RegisterEvent("PLAYER_TARGET_CHANGED")
	this:RegisterEvent("PET_BAR_UPDATE_COOLDOWN")
	this:RegisterEvent("UNIT_AURA")
	this:RegisterEvent("UNIT_PET")
	SpellSystem_RegisterEvent(DoTimer_OnEvent,"SPELLSYSTEM_SUCCESS")
	SLASH_DOTIMER1 = "/dotimer" --creating the slash command
	SLASH_DOTIMER2 = "/dot" --and the other one, for those who are lazy
	this.time = 0 --for limiting scanning
	SlashCmdList["DOTIMER"] = DoTimer_Commands
end

function DoTimer_OnEvent(event)
	if event == "PLAYER_ENTERING_WORLD" then DoTimer_Startup() -- when you first log in
	elseif DoTimer_Settings and DoTimer_Settings.status then
		if event == "PLAYER_TARGET_CHANGED" then DoTimer_ChangedTargets() --time to make the last target's timers eligible for depreciation
		elseif event == "PET_BAR_UPDATE_COOLDOWN" then DoTimer_PotentialPetTimer()
		elseif event == "CHAT_MSG_COMBAT_HOSTILE_DEATH" then DoTimer_HostileDeath() --deletion of entries based on death: if target died, remove his entries, else: if it was a player, remove entries, else leave alone.  mob entries will be removed on exit combat
		elseif event == "PLAYER_ALIVE" then DoTimer_PlayerDeath() --deleting entries because player died
		elseif event == "CHAT_MSG_SPELL_PET_DAMAGE" then DoTimer_PotentialSeduction() --for the succubus auto-casting seduce; it does not go through the normal function
		elseif event == "CHAT_MSG_SPELL_SELF_DAMAGE" then DoTimer_FailedSpell() --looking for resists, immunes, etc.
		elseif event == "PLAYER_REGEN_ENABLED" then DoTimer_LeftCombat()--deleting mob tables b/c left combat
		elseif event == "CHAT_MSG_SPELL_AURA_GONE_OTHER" then DoTimer_DebuffFade() --checking for debuff fades
		elseif event == "UNIT_AURA" and arg1 == "pet" then DoTimer_CheckEnslave() --checking if the new pet is enslaved
		elseif event == "UNIT_PET" and arg1 == "player" and not UnitExists("pet") then DoTimer_RemoveBadEnslaves() --no pet, so any enslave timers are inaccurate
		elseif event == "SPELLSYSTEM_SUCCESS" and arg3.type == "spell" then DoTimer_PotentialSpellTimer() --seeing if the spell just cast produces a timer
		end
	end
end

function DoTimer_AddText(msg) --basic output function
	if DEFAULT_CHAT_FRAME then DEFAULT_CHAT_FRAME:AddMessage(msg) end
end

function DoTimer_AddMenuText(msg,fromgui) -- will output a msg if the text menu was accessed; not the GUI menu
	if not fromgui then DoTimer_AddText(msg) end
end

function DoTimer_Debug(msg) --makes a debug msg if i have that turned on
	if DoTimer_DebugChannel then
		if DoTimer_DebugChannel ~= "" and getglobal("ChatFrame"..DoTimer_DebugChannel) then getglobal("ChatFrame"..DoTimer_DebugChannel):AddMessage(msg)
		else DoTimer_AddText(msg)
		end
	end
end

function DoTimer_Startup() --called on first login per session, creates the default settings if needed or else just hides the interface and sets the scale
	if not DoTimer_Global_Settings then DoTimer_Global_Settings = {} end
	if not DoTimer_Global_Settings.global then DoTimer_Global_Settings.global = {} end
	if DoTimer_Global_Settings.global["DoTimer"] == nil then DoTimer_Global_Settings.global["DoTimer"] = false end
	local name = UnitName("player")
	local realm = GetRealmName()
	local identifier = name..":"..realm
	if not DoTimer_Global_Settings[identifier] then DoTimer_Global_Settings[identifier] = {} end
	if not DoTimer_Global_Settings[identifier]["DoTimer"] then DoTimer_Global_Settings[identifier]["DoTimer"] = {} end
	if not DoTimer_Global_Settings["DoTimer"] then DoTimer_Global_Settings["DoTimer"] = {} end
	local settings
	if DoTimer_Global_Settings.global["DoTimer"] then settings = DoTimer_Global_Settings["DoTimer"] else settings = DoTimer_Global_Settings[identifier]["DoTimer"] end
	if settings.status == nil then
		settings.status = true
		DoTimerAnchorFrameFirstUse:Show()
		DoTimerAnchorFrameFirstUse:SetText("Welcome to DoTimer!  Please type \"/dotimer help new\" \n<-- for first-time information.\nSimply drag the drag button to remove this display.")
	end
	if settings.scale == nil then settings.scale = 1 end --setting the default settings
	if settings.buttonscale == nil then settings.buttonscale = 1 end
	if settings.names == nil then settings.names = true end
	if settings.maxtargets == nil then settings.maxtargets = 5 end
	if settings.maxdebuffs == nil then settings.maxdebuffs = 8 end
	if settings.locked == nil then settings.locked = false end
	if settings.targetlayout == nil then settings.targetlayout = "down" end
	if settings.debufflayout == nil then settings.debufflayout = "down" end
	if settings.sortmethod == nil then settings.sortmethod = "remaining" end
	if settings.clickable == nil then settings.clickable = true end
	if settings.probable == nil then settings.probable = true end
	if settings.expalert == nil then settings.expalert = true end
	if settings.levels == nil then settings.levels = true end
	if settings.onlytarget == nil then settings.onlytarget = false end
	if settings.playsound == nil then settings.playsound = false end
	if settings.format == nil then settings.format = "bars" end
	if settings.barlength == nil then settings.barlength = 150 end
	if settings.timerspacing == nil then settings.timerspacing = 5 end
	if settings.targetspacing == nil then settings.targetspacing = 5 end
	if settings.blocked == nil then settings.blocked = {} end
	if settings.tenths == nil then settings.tenths = false end
	if settings.dep == nil then settings.dep = true end
	if settings.sorttarget == nil then settings.sorttarget = false end
	if settings.chatmsgnormal == nil then settings.chatmsgnormal = "My %s(%r) will expire on [%l]%t in %d." end
	if settings.chatmsgnotarget == nil then settings.chatmsgnotarget = "My %s(%r) will finish in %d." end
	if settings.barmsg == nil then settings.barmsg = "%d - %s" end
	if settings.resistlength == nil then settings.resistlength = 1 end
	if settings.tooltips == nil then settings.tooltips = true end
	if settings.icons == nil then settings.icons = true end
	if settings.alpha == nil then settings.alpha = 1 end
	if settings.ghostdata == nil then settings.ghostdata = 5 end
	if settings.ghosts == nil then settings.ghosts = true end
	if settings.raidicons == nil then settings.raidicons = true end
	if DoTimer_Global_Settings.global["DoTimer"] then 
		DoTimer_Settings = DoTimer_Global_Settings["DoTimer"]
		DoTimer_Global_Settings[identifier]["DoTimer"] = DoTimer_Settings
	else 
		DoTimer_Settings = DoTimer_Global_Settings[identifier]["DoTimer"] 
		DoTimer_Global_Settings["DoTimer"] = DoTimer_Settings
	end
	local _,class = UnitClass("player")
	spells,healspells,enslavespells,notargetspells,localedata = DoTimer_DefineSpells(class)
	DoTimer_DefineSpell("No Texture","Blank Spot",0,0)
	DoTimerMainFrame:SetScale(DoTimer_Settings.scale)
	unitids = DoTimer_ReturnUnitIDs()
	DoTimer_DefineFormat()
	if DoTimer_Settings.locked then DoTimerAnchorFrame:Hide() else DoTimerAnchorFrame:Show() end
	if DoTimer_Settings.status == false then 
		DoTimerFrame:Hide()
		DoTimerMainFrame:Hide()
	end
	DoTimerAnchorFrame:ClearAllPoints()
	if DoTimer_Settings.offsetX then
		DoTimerAnchorFrame:SetPoint("BOTTOMLEFT","UIParent","BOTTOMLEFT",DoTimer_Settings.offsetX,DoTimer_Settings.offsetY)
	else
		DoTimerAnchorFrame:SetPoint("CENTER","UIParent","CENTER",5,0)
	end 
	DoTimer_DefineInterface(DoTimer_Settings.targetlayout,DoTimer_Settings.debufflayout,1)
	if class == "ROGUE" then
		DoTimerClassFrame:RegisterEvent("PLAYER_COMBO_POINTS")
		DoTimerClassFrame.points = 0
		DoTimerClassFrame.maxpoints = 0
		DoTimerClassFrame:SetScript("OnEvent",function()
			local points = GetComboPoints()
			if points == 0 then
				DoTimerClassFrame.maxpoints = DoTimerClassFrame.points
			end
			DoTimerClassFrame.points = points
		end)
	elseif class == "PALADIN" then
		DoTimerClassFrame:RegisterEvent("PLAYER_AURAS_CHANGED")
		DoTimerClassFrame:SetScript("OnEvent",function()
			if event == "PLAYER_AURAS_CHANGED" then
				local i = 1
				local _,_,buff = UnitBuff("player",i)
				while buff do
					if localedata[buff] and localedata[buff].group == 7 then
						DoTimerClassFrame.buff = buff
						break
					end
					i = i + 1
					_,_,buff = UnitBuff("player",i)
				end
			elseif event == "SPELLSYSTEM_SUCCESS" then
				if DoTimer_ReturnEnglish(arg1.spell) == "Avenger's Shield" then
					local targetindex = DoTimer_ReturnTargetTable(arg2.target,arg2.sex,arg2.level,arg2.icon)
					if targetindex then
						for i = 1,table.getn(casted[targetindex]) do
							if casted[targetindex][i].english == "Judgement" then
								casted[targetindex][i].time = GetTime()
								casted[targetindex][i].displayed = nil
							end
						end
					end
				end
			end
		end)
		SpellSystem_RegisterEvent(DoTimerClassFrame:GetScript("OnEvent"),"SPELLSYSTEM_SUCCESS")
		local _,_,_,num = GetSpellTabInfo(1)
		for i = 1,num do --First Aid shares the icon of Blessing of Sacrifice.  this little hack makes sure a timer is not created when you open your FA book.
			local name = GetSpellName(i,BOOKTYPE_SPELL)
			if DoTimer_ReturnEnglish(name) == "Blessing of Sacrifice" then
				DoTimer_Settings.blocked[name] = 1
				break
			end
		end
	elseif class == "WARRIOR" then
		DoTimerClassFrame:SetScript("OnEvent",function()
			if arg3.type == "spell" and DoTimer_ReturnEnglish(arg1.spell) == "Devastate" then
				local targetindex = DoTimer_ReturnTargetTable(arg2.target,arg2.sex,arg2.level,arg2.icon)
				if targetindex then
					for i = 1,table.getn(casted[targetindex]) do
						if casted[targetindex][i].english == "Sunder Armor" then
							casted[targetindex][i].time = GetTime()
							casted[targetindex][i].displayed = nil
						end
					end
				end
			end
		end)
		SpellSystem_RegisterEvent(DoTimerClassFrame:GetScript("OnEvent"),"SPELLSYSTEM_SUCCESS")
	elseif class == "DRUID" then
		DoTimerClassFrame.points = 0
		DoTimerClassFrame.maxpoints = 0
		DoTimerClassFrame:RegisterEvent("PLAYER_COMBO_POINTS")
		DoTimerClassFrame:SetScript("OnEvent",function()
			local points = GetComboPoints()
			if points == 0 then
				this.maxpoints = this.points
			end
			this.points = points
		end)
	end
	DoTimerFrame:UnregisterEvent("PLAYER_ENTERING_WORLD")
end

------------------------------------------------------------------------------------------------------------
-- ############ TIMER REMOVAL FUNCTIONS ############## --
------------------------------------------------------------------------------------------------------------

function DoTimer_OnUpdate(elapsed) --updating the timers onscreen, as well as checking for any finished debuffs
	if table.getn(casted) == 0 then DoTimerFrame:SetScript("OnUpdate",nil) end
	local time = GetTime()
	for index = table.getn(casted),1,-1 do --scanning all the debuffs to see if they are done
		for i = table.getn(casted[index]),1,-1 do
			if casted[index] and casted[index][i] then
				local type = casted[index][i].type
				if timerdata[type].hastimer then
					if time >= casted[index][i].time + casted[index][i].duration then --yep it's done all right
						DoTimer_Debug(casted[index][i].spell.." has expired from the mob; full duration")
						DoTimer_RemoveTimer(index,i,"finished")
					elseif timerdata[type].disptimer then
						local timeremaining = casted[index][i].duration - time + casted[index][i].time
						local remaining = tonumber(string.format(DoTimer_Settings.tenths and "%.1f" or "%d",timeremaining)) --modifying the displayed time if it needs changing
						if DoTimer_Settings.format == "icons" then
							if (not casted[index][i].displayed) or (remaining < casted[index][i].displayed) then
								getglobal("DoTimerTarget"..index.."Debuff"..i.."IconTime"):SetText(DoTimer_ReturnNewDuration(timeremaining)) --updating the time if they aren't done
								if remaining == 5 then
									if DoTimer_Settings.playsound then PlaySoundFile("Interface\\Addons\\DoTimer\\Extras\\expalert.wav") end
									if DoTimer_Settings.expalert then
										getglobal("DoTimerTarget"..index.."Debuff"..i.."IconButton"):LockHighlight()
										getglobal("DoTimerTarget"..index.."Debuff"..i.."IconTime"):SetTextColor(timerdata[type].colors.final.r,timerdata[type].colors.final.g,timerdata[type].colors.final.b)
									end
								elseif remaining == 3 then
									if DoTimer_Settings.expalert then getglobal("DoTimerTarget"..index.."Debuff"..i.."IconButton"):UnlockHighlight() end
								elseif (remaining > 5) and (remaining == math.floor(casted[index][i].duration / 2)) then
									getglobal("DoTimerTarget"..index.."Debuff"..i.."IconTime"):SetTextColor(timerdata[type].colors.half.r,timerdata[type].colors.half.g,timerdata[type].colors.half.b)
								end
								casted[index][i].displayed = tonumber(string.format(DoTimer_Settings.tenths and "%.1f" or "%d",timeremaining))
							end
						elseif DoTimer_Settings.format == "bars" then
							getglobal("DoTimerTarget"..index.."Debuff"..i.."BarStatus"):SetValue(timeremaining)
							if (not casted[index][i].displayed) or (remaining < casted[index][i].displayed) then
								getglobal("DoTimerTarget"..index.."Debuff"..i.."BarStatusTime"):SetText(DoTimer_FormatBarText(index,i)) --updating the time if they aren't done
								if remaining == 5 then
									if DoTimer_Settings.playsound then PlaySoundFile("Interface\\Addons\\DoTimer\\Extras\\expalert.wav") end
									if DoTimer_Settings.expalert then
										getglobal("DoTimerTarget"..index.."Debuff"..i.."BarStatus"):SetStatusBarColor(timerdata[type].colors.final.r,timerdata[type].colors.final.g,timerdata[type].colors.final.b)
									end
								elseif (remaining > 5) and (remaining == math.floor(casted[index][i].duration / 2)) then
									getglobal("DoTimerTarget"..index.."Debuff"..i.."BarStatus"):SetStatusBarColor(timerdata[type].colors.half.r,timerdata[type].colors.half.g,timerdata[type].colors.half.b)
								end
								casted[index][i].displayed = tonumber(string.format(DoTimer_Settings.tenths and "%.1f" or "%d",timeremaining))
							end
						elseif DoTimer_Settings.format == "text" then	
							if (not casted[index][i].displayed) or (remaining < casted[index][i].displayed) then
								getglobal("DoTimerTarget"..index.."Debuff"..i.."TextButtonTime"):SetText(DoTimer_FormatBarText(index,i)) --updating the time if they aren't done
								if remaining == 5 then
									if DoTimer_Settings.playsound then PlaySoundFile("Interface\\Addons\\DoTimer\\Extras\\expalert.wav") end
									if DoTimer_Settings.expalert then
										getglobal("DoTimerTarget"..index.."Debuff"..i.."TextButtonTime"):SetTextColor(timerdata[type].colors.final.r,timerdata[type].colors.final.g,timerdata[type].colors.final.b)
									end
								elseif (remaining > 5) and (remaining == math.floor(casted[index][i].duration / 2)) then
									getglobal("DoTimerTarget"..index.."Debuff"..i.."TextButtonTime"):SetTextColor(timerdata[type].colors.half.r,timerdata[type].colors.half.g,timerdata[type].colors.half.b)
								end
								casted[index][i].displayed = tonumber(string.format(DoTimer_Settings.tenths and "%.1f" or "%d",timeremaining))
							end
						end
					end
				end
			end
		end
	end
	DoTimerFrame.time = DoTimerFrame.time + elapsed
	if DoTimerFrame.time >= .5 then
		if DoTimer_TypeRunning("offensive") then DoTimer_ScanDebuffs(time) end --seeing if anything has faded unexpectedly
		if DoTimer_TypeRunning("defensive") then DoTimer_ScanBuffs(time) end
		DoTimerFrame.time = 0
	end
end

function DoTimer_ScanDebuffs(time) --deletes the timers of spells which are no longer on the target
	for index,value in ipairs(targetids) do
		if UnitExists(value) then
			local found = DoTimer_ReturnTargetTable(UnitName(value),UnitSex(value),UnitLevel(value),GetRaidTargetIndex(value) or 0)
			if found then
				for i = table.getn(casted[found]),1,-1 do
					local spellname = casted[found][i].spell
					local english = casted[found][i].english
					if time >= casted[found][i].time + 2 then --protect them in case they haven't appeared just yet and AwaitIcon didn't catch the pause (since it can only catch it for current target)
						local ontarget
						if protectspells[english] or DoTimer_HasDebuff(spellname,value) or (not DoTimer_TimerIsAppreciated(found,i)) then ontarget = 1 end
						if not ontarget then
							local wrongreason -- if a new curse or a refresh, the timer will disappear before the other code adds it.  in this case we want to delete, not depreciate
							for id = table.getn(finalspell),1,-1 do
								if (DoTimer_ReturnTargetTable(finalspell[id].target.target,finalspell[id].target.sex,finalspell[id].target.level,finalspell[id].target.icon) == found) and ((finalspell[id].spell.spell == spellname) or (localedata[casted[found][i].texture].group and localedata[casted[found][i].texture].group == localedata[finalspell[id].spell.texture].group)) then wrongreason = 1 end
							end
							if wrongreason then
								DoTimer_Debug(casted[found][i].spell.." not found on "..UnitName(value)..", but we expected that")
							else --player timers are removed because they cannot be depreciated
								DoTimer_Debug(casted[found][i].spell.." not found on "..UnitName(value).."; depreciating if mob, deleting if not")
								if casted[found].type == "mob" then 
									DoTimer_DepreciateTimer(found,i) 
								else 
									local reason = "finshed"
									if ((casted[found][i].displayed or 2) > 1) then reason = "broke" end
									DoTimer_RemoveTimer(found,i,reason)
								end 
							end
						end
					end
				end
			end
		end
	end
end

function DoTimer_ScanBuffs(time) --checking buffs to see if any friendly spells need to be removed
	for index,value in ipairs(unitids) do
		if UnitExists(value) then
			local found = DoTimer_ReturnTargetTable(UnitName(value),UnitSex(value),UnitLevel(value),GetRaidTargetIndex(value) or 0)
			if found then
				for i = table.getn(casted[found]),1,-1 do
					if GetTime() >= casted[found][i].time + 2 then
						local spellname = casted[found][i].spell
						local english = casted[found][i].english
						local ontarget
						if protectspells[english] or (not (casted[found][i].type == "heal")) or DoTimer_HasBuff(spellname,value) then ontarget = 1 end --we will not delete PWF
						if not ontarget then
							DoTimer_Debug(casted[found][i].spell.." not found on target, removing it")
							local reason = "finshed"
							if ((casted[found][i].displayed or 2) > 1) then reason = "broke" end
							DoTimer_RemoveTimer(found,i,reason)
						end
					end
				end
			end
		end
	end
end

function DoTimer_TypeRunning(qtype)
	if qtype == "offensive" then
		return hasoffensive
	elseif qtype == "defensive" then
		return hasdefensive
	end
end

function DoTimer_DepreciateTimer(found,i) --depreciated the timer if the target is eligible
	--if casted[found].eligible then DoTimer_AddText("The timers for "..casted[found].target.." are eligible for depreciation.") else DoTimer_AddText("The timers for "..casted[found].target.." are not eligible for depreciation.") end
	if ((casted[found][i].displayed or 2) > 1) then
		if DoTimer_Settings.dep and (casted[found].eligible) then
			casted[found][i].type = "depreciated"
			casted[found][i].depstart = GetTime()
			DoTimer_CreateInterface(nil,1)
		else
			DoTimer_RemoveTimer(found,i,"broke")
		end
	else
		DoTimer_RemoveTimer(found,i,"finished")
	end
end

function DoTimer_CheckConflag()
	if DoTimer_ReturnEnglish(arg1.spell) == "Conflagrate" then
		local found = DoTimer_ReturnTargetTable(arg2.target,arg2.sex,arg2.level,arg2.icon)
		if found then
			local removed
			for i = table.getn(casted[found]),1,-1 do --checking that target for immolate
				if DoTimer_ReturnEnglish(casted[found][i].spell) == "Immolate" and DoTimer_TimerIsAppreciated(found,i) then
					DoTimer_Debug(casted[found].target.." had an appreciated immol, removed it")
					DoTimer_RemoveTimer(found,i,"replaced")
					removed = 1
					break
				end
			end
			if not removed then
				local id,cast
				for i = table.getn(casted[found]),1,-1 do
					if DoTimer_ReturnEnglish(casted[found][i].spell) == "Immolate" and (casted[found][i].type == "depreciated") then
						if casted[found][i].depstart >= (cast or 0) then
							cast = casted[found][i].depstart
							id = i
						end
					end
				end
				if id then
					DoTimer_Debug(casted[found].target.." had a depreciated immol, removed it")
					DoTimer_RemoveTimer(found,id,"replaced")
				end
			end
		end
	end
end

function DoTimer_ChangedTargets()
	DoTimerTargetFrame.time = GetTime()
	DoTimerTargetFrame:SetScript("OnUpdate",function()
		if GetTime() >= this.time + .1 then
			local newtarget
			if UnitExists("target") then newtarget = {UnitName("target"),UnitSex("target"),UnitLevel("target"),GetRaidTargetIndex("target") or 0} end
			for i = 1,table.getn(casted) do
				if casted[i].type == "mob" then casted[i].eligible = 1 end --all mob tables are now eligible for depreciated timers
			end
			if lasttarget then
				local found = DoTimer_ReturnTargetTable(lasttarget[1],lasttarget[2],lasttarget[3],lasttarget[4])
				if newtarget and newtarget[1] == lasttarget[1] and newtarget[2] == lasttarget[2] and newtarget[3] == lasttarget[3] and newtarget[4] == lasttarget[4] then
					DoTimer_Debug("new target identical to old target")
					if found then
						DoTimer_Debug("depreciating all appreciated timers for "..casted[found].target)
						for i = table.getn(casted[found]),1,-1 do
							if DoTimer_TimerIsAppreciated(found,i) then DoTimer_DepreciateTimer(found,i) end --if we are switching targets to one that is "identical" to the previous, automatically depreciate since we know they are inaccurate
						end
					end
				end
			end
			if DoTimer_Settings.onlytarget or DoTimer_Settings.sorttarget then
				DoTimer_Debug("redoing interface to reflect target change")
				DoTimer_CreateInterface()
			end
			if UnitExists("target") then lasttarget = newtarget else lasttarget = nil end
			this:SetScript("OnUpdate",nil)
		end
	end)
end

function DoTimer_HostileDeath()
	DoTimer_Debug(event)
	DoTimer_Debug(arg1)
	local died = SpellSystem_ParseString(arg1,diesmsg) --checking if the dead mob had any tables
	if not died then
		died = SpellSystem_ParseString(arg1,slainmsg)
	end
	if died == UnitName("target") and UnitIsDead("target") then --your target died, we will delete its entries
		DoTimer_Debug("current target died")
		local found = DoTimer_ReturnTargetTable(died,UnitSex("target"),UnitLevel("target"),GetRaidTargetIndex("target") or 0)
		if found then --sure enough, it did!
			DoTimer_Debug("and it had timers; removing appreciated or entire table")
			if casted[found].eligible then
				for i = table.getn(casted[found]),1,-1 do
					if DoTimer_TimerIsAppreciated(found,i) then DoTimer_RemoveTimer(found,i,"target") end
				end
			else
				DoTimer_RemoveTarget(found)
			end
			--DoTimer_AddText(died.." died and its entries were removed.")
		end
		for i = table.getn(finalspell),1,-1 do
			if (DoTimer_ReturnTargetTable(finalspell[i].target.target,finalspell[i].target.sex,finalspell[i].target.level,finalspell[i].target.icon) == found) then table.remove(finalspell,i) end --removing pretimers for that target
		end
	else --will ignore if mob, will delete if player
		DoTimer_Debug("mob died, not current target")
		for i = table.getn(casted),1,-1 do
			if  (casted[i].target == died) and (not (casted[i].type == "mob")) then
				DoTimer_Debug("removing its timers anyway though")
				DoTimer_RemoveTarget(i) --dont bother with appreciated stuff; it has a unique name so it should be removed outright
				break
				--DoTimer_AddText(died.." died and its entries were removed.")
			end
		end
		for i = table.getn(finalspell),1,-1 do
			if (finalspell[i].target.target == died and not (finalspell[i].target.type == "mob")) then table.remove(finalspell,i) end --removing pretimers for that target
		end
	end
end

function DoTimer_PlayerDeath()
	DoTimer_Debug(event)
	if UnitIsGhost("player") then
		DoTimer_Debug("still dead 3 seconds later; removing all timers")
		for i = table.getn(casted),1,-1 do
			if not (casted[i].external) then DoTimer_RemoveTarget(i,1) end
		end
		for i = table.getn(finalspell),1,-1 do table.remove(finalspell,i) end
		DoTimer_CreateInterface()
	end
end

function DoTimer_LeftCombat()
	DoTimer_Debug("left combat")
	DoTimerCombatFrame.time = GetTime()
	DoTimerCombatFrame:SetScript("OnUpdate",function() --we delay the combat check .5 seconds, just to make sure we are really out of combat
		if GetTime() >= this.time + .5 then
			if not UnitAffectingCombat("player") then
				DoTimer_Debug("still out of combat .5 seconds later; removing all non-enslave, non-player timers")
				for i = table.getn(casted),1,-1 do
					if not (casted[i].type == "player") then DoTimer_RemoveTarget(i) end
				end
				if DoTimer_Settings.ghostdata == 0 then
					for i = table.getn(casted),1,-1 do
						if not casted[i].external then
							for id = 1,table.getn(casted[i]) do
								if not (casted[i][id].type == "ghost") then break end
								if id == table.getn(casted[i]) then DoTimer_RemoveTarget(i) end
							end
						end
					end
				end
			end
			this:SetScript("OnUpdate",nil)
		end
	end)
end

function DoTimer_DebuffFade()
	local chatspell,chattarget = SpellSystem_ParseString(arg1,fadesmsg)
	--we will delete the timer if 1) the target is our current target, and 2) there are now no occurrences of the debuff on the target
	if DoTimer_intable(chatspell,spells) then --scan target for debuffs; if no more occurrences then we can delete that timer
		DoTimer_Debug(event)
		if arg1 then DoTimer_Debug(arg1) end
		DoTimer_Debug("the spell that faded is a timer spell")
		local units = {"target","pettarget","focus"}
		for index,value in ipairs(units) do
			if UnitExists(value) then
				if chattarget == UnitName(value) and DoT_OwnSpellOnTarget(chatspell,value) and not DoT_SpellOnTarget(chatspell,value) then
					local found = DoTimer_ReturnTargetTable(UnitName(value),UnitSex(value),UnitLevel(value),GetRaidTargetIndex(value) or 0)
					if found then
						for i = table.getn(casted[found]),1,-1 do
							if casted[found][i].spell == chatspell and DoTimer_TimerIsAppreciated(found,i) and (not protectspells[casted[found][i].english]) and ((casted[found][i].duration - GetTime() + casted[found][i].time) <= 1) then
								DoTimer_Debug("no more occurrences of the spell, so removing the timer")
								DoTimer_RemoveTimer(found,i,"broke")
								break
							end
						end
					end
				end
			end
		end
	end
end

function DoTimer_RemoveTimer(targetindex,debuffindex,reason,suppress) --deletes a timer onscreen from existence
	--possible reasons: finished, broke, replaced, target, full, clicked
	if casted[targetindex] and casted[targetindex][debuffindex] then
		if not casted[targetindex].external then
			DoTimer_Debug("the timer for "..casted[targetindex][debuffindex].spell.." has been removed, reason: "..reason)
			if reason == "finished" and DoTimer_Settings.ghosts and (not casted[targetindex].external) and timerdata[casted[targetindex][debuffindex].type].isreal then DoTimer_CreateGhostTimer(targetindex,debuffindex) end
			if reason == "clicked" and IsShiftKeyDown() then DoTimer_Commands("block "..casted[targetindex][debuffindex].spell,1) end
			table.remove(casted[targetindex],debuffindex)
			if not suppress then
				if table.getn(casted[targetindex]) == 0 then
					DoTimer_RemoveTarget(targetindex)
				end
				DoTimer_CreateInterface()
			end
		end
	end
end

function DoTimer_RemoveTarget(targetindex,norefresh)
	DoTimer_Debug("a target table has been removed forcibly")
	table.remove(casted,targetindex)
	if not norefresh then DoTimer_CreateInterface() end
end

function DoTimer_RemoveAllTimers()
	DoTimer_Debug("the interface has been cleared")
	for i = table.getn(casted),1,-1 do
		DoTimer_RemoveTarget(i,1)
	end
	DoTimer_CreateInterface()
end

function DoTimer_UnitMatchesData(targettable)
	local unit = targettable.unit
	if UnitExists(unit) and UnitName(unit) == targettable.target and UnitSex(unit) == targettable.sex and UnitLevel(unit) == targettable.level and (GetRaidTargetIndex(unit) or 0) == targettable.icon then return true end
	return false
end

function DoTimer_PassToFinal(spelltable)
	if DoTimer_UnitMatchesData(spelltable.target) then
		spelltable.unitmatches = true
		spelltable.debuffcount = DoTimer_HasDebuff(spelltable.spell.spell,spelltable.target.unit) or 0
	end
	spelltable.spell.time = GetTime()
	table.insert(finalspell,spelltable)
	if table.getn(finalspell) == 1 then DoTimerAfterFrame:SetScript("OnUpdate",function() DoTimer_AfterCast() end) end
end

function DoTimer_AfterCast()
	local time = GetTime()
	for i = table.getn(finalspell),1,-1 do
		local spelltable = finalspell[i]
		if time >= spelltable.spell.time + DoTimer_Settings.resistlength then
			local unitmatches = DoTimer_UnitMatchesData(spelltable.target)
			if (not unitmatches) or (DoTimer_HasDebuff(spelltable.spell.spell,spelltable.target.unit)) then
				DoTimer_Debug("creating a timer for "..spelltable.spell.spell..", it survived 1 second")
				DoTimer_CreateSpellTimer(spelltable)
				table.remove(finalspell,i)
				if table.getn(finalspell) == 0 then DoTimerAfterFrame:SetScript("OnUpdate",nil) end
			else
				if time >= spelltable.spell.time + spell_leeway_time then
					DoTimer_Debug(spelltable.spell.spell.." took too long as a pretimer, removing it")
					table.remove(finalspell,i)
					if table.getn(finalspell) == 0 then DoTimerAfterFrame:SetScript("OnUpdate",nil) end
				end
			end
		elseif spelltable.unitmatches then
			spelltable.unitmatches = DoTimer_UnitMatchesData(spelltable.target)
			if spelltable.unitmatches then
				if not spelltable.noticed then
					local count = DoTimer_HasDebuff(spelltable.spell.spell,spelltable.target.unit) or 0
					if count > spelltable.debuffcount then
						spelltable.noticed = true
						DoTimer_Debug("noticed "..spelltable.spell.spell.." on "..spelltable.target.target..", saving the time")
						spelltable.timenoticed = GetTime()
					end
					spelltable.debuffcount = count
				end
			end
		end
	end
end

function DoTimer_FailedSpell()
	if table.getn(finalspell) == 0 then return end
	local _,spellname,target 
	for index,value in pairs(failmsgs) do
		_,_,spellname,target = string.find(arg1,value)
		if spellname then break end
	end
	if spellname and target then
		DoTimer_Debug("failed spell: "..spellname.." on "..target)
		for i = table.getn(finalspell),1,-1 do
			if spellname == finalspell[i].spell.spell and target== finalspell[i].target.target then
				DoTimer_Debug("it had predata, removed it!")
				table.remove(finalspell,i)
				break
			end
		end
	end
end

function DoTimer_CheckPetFailure()
	if not sentpetspell then return end
	local spellname,target --looking for all the random things that would cause a failed timer
	spellname,target = SpellSystem_ParseString(arg1,petresistmsg)
	if not (spellname and target) then
		spellname,target = SpellSystem_ParseString(arg1,petevademsg)
	end
	if not (spellname and target) then
		spellname,target = SpellSystem_ParseString(arg1,petimmunemsg)
	end
	if not (spellname and target) then
		spellname,target = SpellSystem_ParseString(arg1,petreflectmsg)
	end
	if spellname and target then
		DoTimer_Debug(event)
		if arg1 then DoTimer_Debug(arg1) end
		if sentpetspell.spell.spell == spellname and sentpetspell.target.target == target then
			DoTimer_Debug(sentpetspell.spell.spell.." was not successfully applied to mob; removing it")
			sentpetspell = nil
			DoTimerPetDelayFrame:SetScript("OnUpdate",nil)
		end
	end
end

-----------------------------------------------------------------------------------------------------------
-- ########### GENERAL TIMER FUNCTIONS ############### --
-----------------------------------------------------------------------------------------------------------

function DoTimer_HasDebuff(spell,unit,english)
	unit = unit or "target"
	spell = string.gsub(spell,"(%p)","%%%1")
	local i = 1
	local count
	local debuff = UnitDebuff(unit,1)
	while debuff do
		if english then debuff = DoTimer_ReturnEnglish(debuff) end
		if string.find(debuff,spell) then count = (count or 0) + 1 end
		i = i + 1
		debuff = UnitDebuff(unit,i)
	end
	return count
end

function DoTimer_HasBuff(spell,unit)
	unit = unit or "target"
	spell = string.gsub(spell,"(%p)","%%%1")
	local i = 1
	local count
	local buff = UnitBuff(unit,1)
	while buff do
		if string.find(buff,spell) then count = (count or 0) + 1 end
		i = i + 1
		buff = UnitBuff(unit,i)
	end
	return count
end

function DoTimer_ReturnTargetTable(target,sex,level,icon) --returns the timer table for the corresponding target/sex/level information
	local found
	for i = 1,table.getn(casted) do
		if casted[i].target == target and casted[i].sex == sex and casted[i].level == level and casted[i].icon == icon then found = i end
	end
	return found
end

function DoTimer_ReturnTexture(spell) --returns the texture path for the icon of the spell
	local tables = {BOOKTYPE_SPELL,BOOKTYPE_PET}
	for index,value in ipairs(tables) do
		local i = 1
		while GetSpellName(i,value) do
			local spellname = GetSpellName(i,value)
			if spell == spellname then
				return GetSpellTexture(i,value)
			end
			i = i + 1
		end
	end
	return GetSpellTexture(1,BOOKTYPE_SPELL)
end

function DoTimer_CreateSpellTimer(spelltable) --creates a timer onscreen from nothingness
	if DoTimer_Settings.blocked[string.lower(spelltable.spell.spell)] then return end
	DoTimer_Debug("processing timer for "..spelltable.spell.spell.." on "..spelltable.target.target)
	--DoTimer_AddText(spell.." has been successfully cast on "..target..".")
	spelltable.spell.time = spelltable.noticed and spelltable.timenoticed or GetTime()
	spelltable.spell.english = DoTimer_ReturnEnglish(spelltable.spell.spell)
	spelltable.spell.texture = DoTimer_ReturnTexture(spelltable.spell.spell)
	if uniquespells[spelltable.spell.english] then --filtering out spells that can be cast once at a time
		for i = table.getn(casted),1,-1 do
			for id = table.getn(casted[i]),1,-1 do
				if casted[i][id].spell == spelltable.spell.spell and timerdata[casted[i][id].type].isreal then 
					DoTimer_Debug("removing timers on other targets since it can only be applied once")
					DoTimer_RemoveTimer(i,id,"replaced",1)
				end
			end
		end
	end
	local found = DoTimer_ReturnTargetTable(spelltable.target.target,spelltable.target.sex,spelltable.target.level,spelltable.target.icon)
	if not found then
		DoTimer_Debug("creating new target table")
		if table.getn(casted) == DoTimer_Settings.maxtargets then --deleting tables if over the  limit
			DoTimer_Debug("reached max targets; deleting one")
			DoTimer_RemoveTarget(2 - (DoTimer_Settings.maxtargets == 1 and 1 or 0),1)
		end
		table.insert(casted,spelltable.target)
		found = table.getn(casted)
	end
	local spelltype = localedata[spelltable.spell.texture] and localedata[spelltable.spell.texture].group
	if timerdata[spelltable.spell.type].isreal then
		for i = table.getn(casted[found]),1,-1 do --testing if any other spells need to be deleted: other curses, or other spells w/ same name (as in, user is refreshing a DoT)
			if --normally id make this one line, but it is very complicated, and subject to error if data does not come in correctly, so i separate it
				(
					(
						casted[found][i].spell == spelltable.spell.spell 
					and 
						(not (casted[found][i].type == "depreciated"))
					and
						(
							(not uniquebyrank[spelltable.spell.english])
						or 
							casted[found][i].rank == spelltable.spell.rank
						or
							casted[found][i].type == "ghost"
						)
					)					
				or 
					(
						spelltype 
					and
						(not (casted[found][i].type == "depreciated"))
					and 
						localedata[casted[found][i].texture] and localedata[casted[found][i].texture].group == spelltype
					)
				) 
			then
				DoTimer_RemoveTimer(found,i,"replaced",1)
				DoTimer_Debug("removing a duplicate timer, or a different curse/whatever, or a ghost timer")
			end
		end
	end
	if table.getn(casted[found]) == DoTimer_Settings.maxdebuffs then --deleting any extra debuffs on target
		DoTimer_Debug("reached max debuffs; deleting one")
		local ofound
		for i = 1,table.getn(casted[found]) do
			if casted[found][i].type == "depreciated" then
				DoTimer_RemoveTimer(found,i,"full",1)
				ofound = 1
				break
			end
		end
		if not ofound then DoTimer_RemoveTimer(found,1,"full",1) end
	end
	table.insert(casted[found],spelltable.spell) --adding the new debuff entry
	for i = 1,table.getn(casted) do
		if table.getn(casted[1]) == 0 then DoTimer_RemoveTarget(i,1) end
	end
	DoTimer_CreateInterface() --draws the interface based on the variable command given, found = table that the debuff is going to
end

function DoTimer_PotentialSpellTimer()
	if DoTimer_intable(arg1.spell,spells) then
		DoTimer_Debug("spell success: "..arg1.spell)
		local spell = SpellSystem_Copy(arg1)
		local target = SpellSystem_Copy(arg2)
		spell.info = SpellSystem_Copy(arg3)
		spell.type = "debuff"
		if spell.texture == "Interface\\Icons\\Spell_Holy_RighteousFury" then
			local newtexture = DoTimerClassFrame.buff
			spell.duration = DoTimer_ReturnDuration(spell.spell,spell.rank)
			spell.texture = newtexture
		else
			spell.duration = DoTimer_ReturnDuration(spell.spell,spell.rank)
		end
		local finalspellentry = {
			spell = spell,
			target = target,
		}
		DoTimer_PassToFinal(finalspellentry)
	elseif DoTimer_intable(arg1.spell,notargetspells) then
		DoTimer_Debug("notarget success: "..arg1.spell)
		local spell = SpellSystem_Copy(arg1)
		spell.info = SpellSystem_Copy(arg3)
		spell.type = "debuff"
		spell.duration = DoTimer_ReturnDuration(spell.spell,spell.rank)
		spell.time = GetTime()
		local finishednotarget = {
			spell = spell,
			target = notargetinfo,
		}
		DoTimer_CreateSpellTimer(finishednotarget)
	elseif DoTimer_intable(arg1.spell,healspells) then
		DoTimer_Debug("heal success: "..arg1.spell)
		local spell = SpellSystem_Copy(arg1)
		local target = SpellSystem_Copy(arg2)
		spell.info = SpellSystem_Copy(arg3)
		spell.type = "heal"
		spell.duration = DoTimer_ReturnDuration(spell.spell,spell.rank)
		spell.time = GetTime()
		local finishedheal = {
			spell = spell,
			target = target
		}
		DoTimer_CreateSpellTimer(finishedheal)
	elseif DoTimer_intable(arg1.spell,enslavespells) then
		DoTimer_Debug("enslave success: "..arg1.spell)
		local spell = SpellSystem_Copy(arg1)
		spell.info = SpellSystem_Copy(arg3)
		spell.type = "enslave"
		spell.duration = DoTimer_ReturnDuration(spell.spell,spell.rank)
		spell.time = GetTime()
		finalenslavespell = spell
	end
	DoTimer_CheckConflag()
end

function DoTimer_TimerIsAppreciated(targetindex,debuffindex)
	return (casted[targetindex][debuffindex].type == "debuff")
end

function DoTimer_intable(query,checkedtable) --checks a spell to see if it needs to be watched (as in, it was in that big spell list at the top)
	return checkedtable[DoTimer_ReturnEnglish(query)] --used to be longer, but code changes made it simpler.  dont feel like replacing it in the code, so it's here to stay
end

function DoTimer_ReturnDuration(spell,rank) --returns the duration of a spell
	DoTimerScanningFrame:SetOwner(UIParent,"ANCHOR_NONE")
	local tables = {BOOKTYPE_SPELL,BOOKTYPE_PET}
	for index,value in ipairs(tables) do
		local i = 1
		while GetSpellName(i,value) do
			local spellname,spellrank = GetSpellName(i,value)
			if spellname == spell and ((spellrank == rank) or (rank == "") or (value == BOOKTYPE_PET)) then
				DoTimerScanningFrame:ClearLines()
				DoTimerScanningFrame:SetSpell(i,value)
				local num = DoTimerScanningFrame:NumLines()
				if num == 0 then return 0 end
				local text = getglobal("DoTimerScanningFrameTextLeft"..num):GetText()
				local allnumbers = {SpellSystem_ParseString(text," (%d[%d%.]*) ")}
				local basenumber = localedata[DoTimer_ReturnTexture(spell)].duration
				if basenumber == 0 then
					local _,class = UnitClass("player")
					if class == "ROGUE" then
						local english = DoTimer_ReturnEnglish(spell)
						if english == "Kidney Shot" then
							return 1 + math.max(DoTimerClassFrame.maxpoints,DoTimerClassFrame.points)
						elseif english == "Rupture" then
							return 6 + (2 * math.max(DoTimerClassFrame.maxpoints,DoTimerClassFrame.points))
						end
					elseif class == "PALADIN" then
						local buff = DoTimerClassFrame.buff
						if buff then
							local name = localedata[buff].name
							if name == "Seal of Command" or name == "Seal of Righteousness" then
								return 0
							else								
								return 20
							end
						else
							return 0
						end
						DoTimerClassFrame.buff = nil
					elseif class == "DRUID" then
						return 1 + math.max(DoTimerClassFrame.maxpoints,DoTimerClassFrame.points)
					end
				end
				local multiplier = localedata[DoTimer_ReturnTexture(spell)].multiplier
				if allnumbers[1] == false then allnumbers[1] = basenumber end
				local truenumber
				for index2,value2 in ipairs(allnumbers) do
					if ((not truenumber) or (math.abs(value2 - basenumber) < math.abs(truenumber - basenumber))) then truenumber = value2 end
				end
				return truenumber * multiplier
			end
			i = i + 1
		end
	end
	return 0
end

------------------------------------------------------------------------------------------------------------
-- ############## PLAYER TIMER FUNCTIONS ############## --
------------------------------------------------------------------------------------------------------------

function DoTimer_ReturnRank(spell) --called if the spell did not have a rank from CastSpellByName, returns highest rank
	local highrank
	local i = 1
	while GetSpellName(i,BOOKTYPE_SPELL) do
		local spellname,spellrank = GetSpellName(i,BOOKTYPE_SPELL)
		if spellname == spell then highrank = spellrank end
		i = i + 1
	end
	if highrank == nil then highrank = "" end
	return highrank
end

------------------------------------------------------------------------------------------------------------
-- ############### PET TIMER FUNCTIONS ############### --
------------------------------------------------------------------------------------------------------------
	
function DoTimer_InitiatePetSpellTimer(spell) --begins the process of making a pet timer onscreen
	local texture,duration,casttime = DoTimer_ReturnPetInfo(spell)
	local unit = UnitExists("pettarget") and "pettarget" or "target"
	if UnitExists(unit) then
		castpetspell = {
			time = GetTime(),
			casttime = casttime,
			unit = unit,
			spell = {
				spell = spell,
				rank = "",
				texture = texture,
				duration = duration,
				type = "debuff",
				info = {
					type = BOOKTYPE_PET,
					id = SpellSystem_ReturnPetID(spell),
				},
			},
			target = {
				target = UnitName(unit),
				sex = UnitSex(unit),
				type = SpellSystem_ReturnTargetType(unit),
				level = UnitLevel(unit),
				icon = GetRaidTargetIndex(unit) or 0,
			},
		}
		DoTimerPetFrame:SetScript("OnUpdate",function() DoTimer_AwaitPetCast() end)
	end
end

function DoTimer_AwaitPetCast()
	--delays the pet timers an amount of time = to casttime, then sends to sentpetspell
	if (GetTime() >= castpetspell.time + castpetspell.casttime) then
		DoTimer_Debug("sending "..castpetspell.spell.spell.." to sentpetspell")
		castpetspell.casttime = .5
		castpetspell.time = GetTime()
		sentpetspell = castpetspell
		castpetspell = nil
		DoTimerPetDelayFrame:SetScript("OnUpdate",function() DoTimer_DelayPetTimer() end)
		DoTimerPetFrame:SetScript("OnUpdate",nil)
	end
end

function DoTimer_DelayPetTimer()
	--delays the pet timers .5 seconds to wait for resists or whatever, then sends to finalpetspell
	if GetTime() >= sentpetspell.time + sentpetspell.casttime then
		--DoTimer_CreateSpellTimer(SpellSystem_SentSpell[i])
		DoTimer_Debug("passing "..sentpetspell.spell.spell.." to finalpetspell")
		sentpetspell.time = GetTime()
		if UnitExists("pettarget") and not (sentpetspell.unit == "pettarget") then
			sentpetspell.unit = "pettarget"
			sentpetspell.target.target = UnitName("pettarget")
			sentpetspell.target.sex = UnitSex("pettarget")
			sentpetspell.target.type = SpellSystem_ReturnTargetType("pettarget")
			sentpetspell.target.level = UnitLevel("pettarget")
			sentpetspell.target.icon = GetRaidTargetIndex("pettarget") or 0
		end
		finalpetspell = sentpetspell
		sentpetspell = nil
		if finalpetspell.target.target then DoTimerPetIconFrame:SetScript("OnUpdate",function() DoTimer_AwaitPetIcon() end) else finalpetspell = nil end
		DoTimerPetDelayFrame:SetScript("OnUpdate",nil)
	end
end

function DoTimer_AwaitPetIcon() --waiting for the icon to appear onits target before creating the timer
	local found
	local unit = finalpetspell.unit
	if not (UnitName(unit) == finalpetspell.target.target and UnitSex(unit) == finalpetspell.target.sex and UnitLevel(unit) == finalpetspell.target.level and (GetRaidTargetIndex(unit) or 0) == finalpetspell.target.icon) then
		found = 1
	elseif DoTimer_intable(finalpetspell.spell.spell,protectspells) then
		found = 1
	else
		if DoTimer_HasDebuff(finalpetspell.spell.spell,unit) then found = 1 end
	end
	if found then
		if UnitExists("pet") then --make sure target data has been set
			DoTimer_Debug("creating a timer for "..finalpetspell.spell.spell)
			DoTimer_CreateSpellTimer(finalpetspell)
		else
			DoTimer_Debug(finalpetspell.spell.spell.." finished, but pet is dead, so cancelling")
		end
		finalpetspell = nil
	end
	if finalpetspell and (GetTime() >= finalpetspell.time + spell_leeway_time) then finalpetspell = nil end
	if not finalpetspell then DoTimerPetIconFrame:SetScript("OnUpdate",nil) end
end

function DoTimer_ReturnPetCastTime(spell)
	local i = 1
	local found
	while GetSpellName(i,BOOKTYPE_PET) do --figuring out which spell it is in spellbook
		local spell,rank = GetSpellName(i,BOOKTYPE_PET)
		if spell == spellname then
			DoTimerScanningFrame:ClearLines() --parsing the cast time
			DoTimerScanningFrame:SetSpell(i,BOOKTYPE_PET)
			local casttime = SpellSystem_ParseString(DoTimerScanningFrameTextLeft3:GetText(),"^(%d[%d%.]*) ")
			return (casttime or 0) --if it couldn't find one, it assumes instant cast
		end
		i = i + 1
	end
	return 0
end

function DoTimer_ReturnPetInfo(spell) ----used to be longer; i used to save the data in tables, but due to the fact that this data sometimes changes and not b/c of talents, im gonna parse it every time
	return DoTimer_ReturnTexture(spell),DoTimer_ReturnDuration(spell),DoTimer_ReturnPetCastTime(spell)
end

function DoTimer_PotentialPetTimer()
	local i = 1
	while GetSpellName(i,BOOKTYPE_PET) do
		local name = GetSpellName(i,BOOKTYPE_PET)
		if DoTimer_ReturnEnglish(name) == "Spell Lock" then
			local start,duration = GetSpellCooldown(i,BOOKTYPE_PET)
			if (duration >= 25) and (math.abs(GetTime() - start) <= .2) then
				DoTimer_Debug(event)
				local unit = UnitExists("pettarget") and "pettarget" or "target"
				if not DoT_OwnSpellOnTarget(name,unit) then
					DoTimer_Debug("Spell Lock was cast; beginning timer")
					DoTimer_InitiatePetSpellTimer(name)
				end
			end
		elseif DoTimer_ReturnEnglish(name) == "Intercept" then
			local start,duration = GetSpellCooldown(i,BOOKTYPE_PET)
			if (duration >= 25) and (math.abs(GetTime() - start) <= .2) then
				DoTimer_Debug(event)
				local unit = UnitExists("pettarget") and "pettarget" or "target"
				if not DoT_OwnSpellOnTarget(name,unit) then
					DoTimer_Debug("Intercept was cast; beginning timer")
					DoTimer_InitiatePetSpellTimer(name)
				end
			end
		elseif DoTimer_ReturnEnglish(name) == "Soothing Kiss" then
			local start,duration = GetSpellCooldown(i,BOOKTYPE_PET)
			if (duration >= 3) and (math.abs(GetTime() - start) <= .2) then
				DoTimer_Debug(event)
				local unit = UnitExists("pettarget") and "pettarget" or "target"
				if not DoT_OwnSpellOnTarget(name,unit) then
					DoTimer_Debug("Soothing Kiss was cast; beginning timer")
					DoTimer_InitiatePetSpellTimer(name)
				end
			end
		end
		i = i + 1
	end
end

function DoTimer_PotentialSeduction()
	local person,spellname = SpellSystem_ParseString(arg1,begincastmsg)
	if spellname then
		DoTimer_Debug(event)
		if arg1 then DoTimer_Debug(arg1) end
		if DoTimer_ReturnEnglish(spellname) == "Seduction" then
			DoTimer_Debug("Seduction was cast; beginning a timer for it")
			DoTimer_InitiatePetSpellTimer(spellname)
		end
	end
	DoTimer_CheckPetFailure()
end

function DoTimer_CheckEnslave()
	DoTimer_Debug(event)
	if arg1 then DoTimer_Debug(arg1) end
	if UnitExists("pet") then
		if DoTimer_HasDebuff("Enslave Demon","pet",1) then
			if finalenslavespell then
				DoTimer_Debug("creating a timer for "..finalenslavespell.spell)
				local target = {
					target = "No Target",
					type = "player",
					level = 0,
					sex = 0,
					icon = 0,
				}
				DoTimer_CreateSpellTimer({spell = finalenslavespell,target = target})
				finalenslavespell = nil
			end
		else
			DoTimer_RemoveBadEnslaves()
		end
	else
		DoTimer_RemoveBadEnslaves()
	end
end

function DoTimer_RemoveBadEnslaves()
	DoTimer_Debug("removing inaccurate enslave timers")
	local targetindex = DoTimer_ReturnTargetTable("No Target",0,0,0)
	if targetindex then
		for i = table.getn(casted[targetindex]),1,-1 do
			if casted[targetindex][i].type == "enslave" then
				DoTimer_Debug("removing enslave timer; inaccurate")
				DoTimer_RemoveTimer(targetindex,i,"broke") --removing all enslave timers whenever pet changes
			end
		end
	end
end

------------------------------------------------------------------------------------------------------------
-- ############### MACRO FUNCTIONS ################# --
------------------------------------------------------------------------------------------------------------

function DoT_OwnSpellOnTarget(spellname,unit) --do you have that spell on your target?	
	DoTimer_Debug("DoT_OwnSpellOnTarget")
	unit = unit or "target"
	if DoT_SpellInAir(spellname,unit) or (DoT_TimerOnTarget(spellname,unit) and DoT_SpellIconOnTarget(spellname,unit)) then return true end
	return false
end

function DoT_SpellInAir(spellname,unit) --if the spell is in any of the holding tables (cast, but not applied as a timer yet)
	DoTimer_Debug("DoT_SpellInAir")
	unit = unit or "target"
	for i = table.getn(finalspell),1,-1 do
		if finalspell[i].spell.spell == spellname and finalspell[i].target.target == UnitName(unit) and finalspell[i].target.sex == UnitSex(unit) and finalspell[i].target.level == UnitLevel(unit) and finalspell[i].target.icon == (GetRaidTargetIndex(unit) or 0) then
			DoTimer_Debug(spellname.." was in a pretable")
			return true
		end
	end
	for index,value in ipairs({castpetspell,sentpetspell,finalpetspell}) do
		if value and value.spell.spell == spellname and value.target.target == UnitName(unit) and value.target.sex == UnitSex(unit) and value.target.level == UnitLevel(unit) and value.target.icon == (GetRaidTargetIndex(unit) or 0) then
			DoTimer_Debug(spellname.." was in a pretable")
			return true
		end
	end
	if finalenslavespell and finalenslavespell.spell == spellname then
		DoTimer_Debug(spellname.." was in a pretable")
		return true
	end
	DoTimer_Debug(spellname.." not in any pretables")
	return false
end

function DoT_SpellIconOnTarget(spellname,unit) --if that spell is actually on the target
	DoTimer_Debug("DoT_SpellIconOnTarget")
	unit = unit or "target"
	if not UnitExists(unit) then return false end
	if DoTimer_HasDebuff(spellname,unit) then
		DoTimer_Debug(spellname.." was on target")
		return true
	end
	if DoTimer_HasBuff(spellname,unit) then
		DoTimer_Debug(spellname.." was on target")
		return true
	end	
	DoTimer_Debug(spellname.." not found on target")
	return false
end

function DoT_TimerOnTarget(spellname,unit) --if we currently have a timer for that spell on that unit
	DoTimer_Debug("DoT_TimerOnTarget")
	unit = unit or "target"
	if not UnitExists(unit) then return false end
	local found = DoTimer_ReturnTargetTable(UnitName(unit),UnitSex(unit),UnitLevel(unit),GetRaidTargetIndex(unit) or 0)
	if not found then --there wasn't one
		--DEFAULT_CHAT_FRAME:AddMessage("No debuffs on "..UnitName("target"))
		DoTimer_Debug(spellname.." had no timer table")
		return false
	end
	for i = 1,table.getn(casted[found]) do --oh there was one! is that debuff in the debuff table for that target?
		if casted[found][i].spell == spellname and (timerdata[casted[found][i].type].isreal and (DoTimer_Settings.probable or not (casted[found][i].type == "depreciated"))) then --only want real debuffs or heal timers (not ghost or depreciated or fake), but includes dep. if probable setting is on
			--DEFAULT_CHAT_FRAME:AddMessage(spellname.." found on "..UnitName("target"))
			DoTimer_Debug(spellname.." had an associated timer in target's table")
			return found,i  --seems as though it was
		end
	end
	--DEFAULT_CHAT_FRAME:AddMessage("There were debuffs on "..UnitName("target")..", but not "..spellname)
	DoTimer_Debug(spellname.." was not one of the timers on the target")
	return false
end

function DoT_ReturnElapsed(spellname,unit) --returns how long ago spell was cast on unit
	DoTimer_Debug("DoT_ReturnElapsed")
	unit = unit or "target"
	local found,i = DoT_TimerOnTarget(spellname,unit)
	if found and i then return GetTime() - casted[found][i].time end --seems as though it was, return how many seconds ago it was cast
	return 0 --there were debuffs, but not that spell
end

function DoT_ReturnRemaining(spellname,unit) --returns how much time a spell has left on unit
	DoTimer_Debug("DoT_ReturnRemaining")
	unit = unit or "target"
	local found,i = DoT_TimerOnTarget(spellname,unit)
	if found and i then return casted[found][i].duration - GetTime() + casted[found][i].time end --seems as though it was, return how many seconds it has left
	return 0  --there were debuffs, but not that spell
end

function DoT_SpellOnTarget(spellname,unit) --is the spell on your target?
	DoTimer_Debug("DoT_SpellOnTarget")
	if not unit then unit = "target" end
	if DoT_SpellInAir(spellname,unit) or DoT_SpellIconOnTarget(spellname,unit) then return true end
	return false
end

------------------------------------------------------------------------------------------------------------
-- ############## INTERFACE FUNCTIONS ################ --
------------------------------------------------------------------------------------------------------------

function DoTimer_CreateInterface(external,redraw) --defines the major portion of writing to the screen; it is called when something drastic has to happen to the interface (i.e., not just updating a timer)
	DoTimer_Debug("redoing interface to add/remove timers")
	DoTimer_SortTimers()
	local time = GetTime()
	if table.getn(casted) == 0 then DoTimerFrame:SetScript("OnUpdate",nil) end 
	if table.getn(casted) == 1 then DoTimerFrame:SetScript("OnUpdate",function() DoTimer_OnUpdate(arg1) end) end --restoring that OnUpdate
	local targetindex = DoTimer_ReturnTargetTable(UnitName("target"),UnitSex("target"),UnitLevel("target"),GetRaidTargetIndex("target") or 0)
	for i = 1,math.min(table.getn(casted),DoTimer_Settings.maxtargets) do --displaying the information onscreen for each target
		if (not DoTimer_Settings.onlytarget) or (i == (targetindex or ((not UnitExists("target")) and i or 0))) then
			getglobal("DoTimerTarget"..i):Show()
			local targettext
			if DoTimer_Settings.levels then
				targettext = ((casted[i].target == "No Target" or casted[i].external) and casted[i].target or "["..casted[i].level.."] "..casted[i].target)
			else
				targettext = casted[i].target
			end
			getglobal("DoTimerTarget"..i.."Name").target = targettext
			if DoTimer_Settings.names then --set the target name if you have them on, else hide it
				getglobal("DoTimerTarget"..i.."Name"):Show()
				local targettext
				if DoTimer_Settings.levels then
					targettext = ((casted[i].target == "No Target" or casted[i].external) and casted[i].target or "["..casted[i].level.."] "..string.gsub(casted[i].target," ","\n"))
				else
					targettext = (casted[i].target == "No Target" and casted[i].target or string.gsub(casted[i].target," ","\n"))
				end
				getglobal("DoTimerTarget"..i.."NameText"):SetText(targettext)
				getglobal("DoTimerTarget"..i.."Name"):SetHeight(getglobal("DoTimerTarget"..i.."NameText"):GetHeight())
				getglobal("DoTimerTarget"..i.."Name"):SetWidth(getglobal("DoTimerTarget"..i.."NameText"):GetWidth())
				if casted[i].icon > 0 and DoTimer_Settings.raidicons then
					getglobal("DoTimerTarget"..i.."NameIcon"):Show()
					SetRaidTargetIconTexture(getglobal("DoTimerTarget"..i.."NameIcon"),casted[i].icon)
				else
					getglobal("DoTimerTarget"..i.."NameIcon"):Hide()
				end
			else
				getglobal("DoTimerTarget"..i.."Name"):Hide()
			end
			for id = 1,math.min(table.getn(casted[i]),DoTimer_Settings.maxdebuffs) do --for each debuff on the target
				local debuffframe = getglobal("DoTimerTarget"..i.."Debuff"..id)
				if redraw or not (debuffframe.data and debuffframe.data == casted[i][id]) then
					debuffframe.data = casted[i][id]
					local type = casted[i][id].type
					if DoTimer_Settings.format == "icons" then
						getglobal("DoTimerTarget"..i.."Debuff"..id):Show()
						getglobal("DoTimerTarget"..i.."Debuff"..id.."IconButton"):UnlockHighlight()
						getglobal("DoTimerTarget"..i.."Debuff"..id.."IconButtonTexture"):SetTexture(casted[i][id].texture) --setting the icon
						if timerdata[type].disptimer then
							local remaining = casted[i][id].duration - time + casted[i][id].time
							getglobal("DoTimerTarget"..i.."Debuff"..id.."IconTime"):SetText(DoTimer_ReturnNewDuration(remaining))
							local displayed = casted[i][id].displayed
							if (displayed == 5 or displayed == 4) and DoTimer_Settings.expalert then getglobal("DoTimerTarget"..i.."Debuff"..id.."IconButton"):LockHighlight() end
							local half = math.floor(casted[i][id].duration / 2)
							local color
							if remaining <= 5 then
								color = timerdata[type].colors.final
							elseif remaining <= half then
								color = timerdata[type].colors.half
							else
								color = timerdata[type].colors.begin
							end
							getglobal("DoTimerTarget"..i.."Debuff"..id.."IconTime"):SetTextColor(color.r,color.g,color.b)
						else
							getglobal("DoTimerTarget"..i.."Debuff"..id.."IconTime"):SetText(casted[i][id].spell)
							local color = timerdata[type].colors.begin
							getglobal("DoTimerTarget"..i.."Debuff"..id.."IconTime"):SetTextColor(color.r,color.g,color.b)
						end											
						getglobal("DoTimerTarget"..i.."Debuff"..id.."Icon"):SetAlpha(timerdata[type].alpha * DoTimer_Settings.alpha) --setting the alpha of the icon
						getglobal("DoTimerTarget"..i.."Debuff"..id.."IconButton"):SetScale(DoTimer_Settings.buttonscale * timerdata[type].scale)
						local clickable = DoTimer_Settings.clickable and timerdata[type].clickable or false
						getglobal("DoTimerTarget"..i.."Debuff"..id.."IconButton"):EnableMouse(clickable)
					elseif DoTimer_Settings.format == "bars" then
						getglobal("DoTimerTarget"..i.."Debuff"..id):Show()
						getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButtonTexture"):SetTexture(casted[i][id].texture) --setting the icon
						if timerdata[type].disptimer then
							local remaining = casted[i][id].duration - time + casted[i][id].time
							getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetMinMaxValues(0,casted[i][id].duration)
							getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetValue(remaining)
							getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatusTime"):SetText(DoTimer_FormatBarText(i,id)) 							
							local half = casted[i][id].duration / 2
							local color
							if remaining <= 5 then
								color = timerdata[type].colors.final
							elseif remaining <= half then
								color = timerdata[type].colors.half
							else
								color = timerdata[type].colors.begin
							end
							getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetStatusBarColor(color.r,color.g,color.b)
						else
							getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatusTime"):SetText(casted[i][id].spell)
							getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetMinMaxValues(0,1)
							getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetValue(1)
							local color = timerdata[type].colors.begin
							getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetStatusBarColor(color.r,color.g,color.b)
						end
						getglobal("DoTimerTarget"..i.."Debuff"..id.."Bar"):SetAlpha(timerdata[type].alpha * DoTimer_Settings.alpha)
						getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButton"):SetScale(DoTimer_Settings.buttonscale * timerdata[type].scale)
						getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetScale(DoTimer_Settings.buttonscale * timerdata[type].scale)
						getglobal("DoTimerTarget"..i.."Debuff"..id.."BarBackground"):SetScale(DoTimer_Settings.buttonscale * timerdata[type].scale)							
						getglobal("DoTimerTarget"..i.."Debuff"..id.."BarBackground"):SetAlpha(.5)
						local clickable = DoTimer_Settings.clickable and timerdata[type].clickable or false
						getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButton"):EnableMouse(clickable)
					elseif DoTimer_Settings.format == "text" then
						getglobal("DoTimerTarget"..i.."Debuff"..id):Show()
						if timerdata[type].disptimer then
							local remaining = casted[i][id].duration - time + casted[i][id].time
							getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButtonTime"):SetText(DoTimer_FormatBarText(i,id))
							local half = math.floor(casted[i][id].duration / 2)
							local color
							if remaining <= 5 then
								color = timerdata[type].colors.final
							elseif remaining <= half then
								color = timerdata[type].colors.half
							else
								color = timerdata[type].colors.begin
							end
							getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButtonTime"):SetTextColor(color.r,color.g,color.b)
						else
							getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButtonTime"):SetText(casted[i][id].spell)
							local color = timerdata[type].colors.begin
							getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButtonTime"):SetTextColor(color.r,color.g,color.b)
						end												
						getglobal("DoTimerTarget"..i.."Debuff"..id.."Text"):SetAlpha(timerdata[type].alpha * DoTimer_Settings.alpha) --setting the alpha of the icon
						getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButton"):SetScale(DoTimer_Settings.buttonscale * timerdata[type].scale)
						local clickable = DoTimer_Settings.clickable and timerdata[type].clickable or false
						getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButton"):EnableMouse(clickable)
					end
				end
			end
		end
	end
	for i = 1,10 do
		if (not casted[i]) or (DoTimer_Settings.onlytarget and not (i == (targetindex or ((not UnitExists("target")) and i or 0)))) then
			getglobal("DoTimerTarget"..i):Hide() --hiding unused targets
			for id = 1,20 do
				getglobal("DoTimerTarget"..i.."Debuff"..id).data = nil
			end
		else
			for id = table.getn(casted[i]) + 1,20 do
				local debuffframe = getglobal("DoTimerTarget"..i.."Debuff"..id)
				debuffframe:Hide() --hiding unused debuffs in used targets
				debuffframe.data = nil
			end
		end
	end
	DoTimer_ResizeInterface()
	hasoffensive,hasdefensive = nil,nil
	for i = 1,table.getn(casted) do
		for id = 1,table.getn(casted[i]) do
			local type = casted[i][id].type
			if type == "debuff" then hasoffensive = 1 
			elseif type == "heal" then hasdefensive = 1
			end
		end
	end
end

function DoTimer_SortTimers() --separated the timers by their type then arranges by time added or time remaining
	for i = table.getn(casted),1,-1 do
		if not casted[i].external then
			local regtimers = {} --the 5 different types that timers can be, and a table to catch all blank timers
			local deptimers = {}
			local faketimers = {}
			local enslavetimers = {}
			local ghosttimers = {}
			local othertimers = {}
			if DoTimer_Settings.septimers then --filtering out all blank timers first
				for id = table.getn(casted[i]),1,-1 do
					if casted[i][id].type == "blank" then table.remove(casted[i],id) end
				end
			end
			local total = table.getn(casted[i])
			for id = total,1,-1 do --sorting into correct table
				local intable,type
				type = casted[i][id].type
				if type == "debuff" or type == "heal" then intable = regtimers
				elseif type == "depreciated" then intable = deptimers
				elseif type == "fake" then intable = faketimers
				elseif type == "enslave" then intable = enslavetimers
				elseif type == "ghost" then intable = ghosttimers
				else intable = othertimers
				end
				table.insert(intable,casted[i][id])
				table.remove(casted[i],id)
			end
			local time = GetTime()
			local tables = {regtimers,deptimers,faketimers,enslavetimers,othertimers,ghosttimers}
			if DoTimer_Settings.sortmethod == "remaining" then --sorting the temp tables by time added or time remaining
				for index,value in ipairs(tables) do
					table.sort(value,function(a,b) return (a.duration - time + a.time) < (b.duration - time + b.time) end)
				end
			else
				for index,value in ipairs(tables) do
					table.sort(value,function(a,b) return (a.time) < (b.time) end)
				end		
			end
			for id = 1,table.getn(enslavetimers) do table.insert(casted[i],enslavetimers[id]) end --inserting them back into the main table in the order i want them displayed onscreen
			for id = 1,table.getn(regtimers) do table.insert(casted[i],regtimers[id]) end
			for id = 1,table.getn(deptimers) do table.insert(casted[i],deptimers[id]) end
			for id = 1,table.getn(faketimers) do table.insert(casted[i],faketimers[id]) end
			if DoTimer_Settings.septimers and (table.getn(casted[i]) > 0) and (total - table.getn(casted[i]) > 0) and (total < DoTimer_Settings.maxdebuffs) then DoTimer_InsertBlankTimer(i) end
			for id = 1,table.getn(ghosttimers) do table.insert(casted[i],ghosttimers[id]) end
			for id = 1,table.getn(othertimers) do table.insert(casted[i],othertimers[id]) end
		end
	end
	if (DoTimer_Settings.onlytarget or DoTimer_Settings.sorttarget) and UnitExists("target") then --moving the table for current target to 1st position if necessary
		local targetindex = DoTimer_ReturnTargetTable(UnitName("target"),UnitSex("target"),UnitLevel("target"),GetRaidTargetIndex("target") or 0)
		if targetindex then
			local castedentry = casted[targetindex]
			table.remove(casted,targetindex)
			table.insert(casted,1,castedentry)
		end
	end
	local notargetindex = DoTimer_ReturnTargetTable("No Target",0,0,0)
	if notargetindex then
		local castedentry = casted[notargetindex]
		table.remove(casted,notargetindex)
		table.insert(casted,castedentry)
	end
	local external = {}
	for i = table.getn(casted),1,-1 do
		if casted[i].external then
			table.insert(external,casted[i])
			table.remove(casted,i)
		end
	end
	for i = 1,table.getn(external) do
		table.insert(casted,external[i])
	end
end

function DoTimer_AddTimers(numtargets,numdebuffs) --used to view different interface layouts
	DoTimer_DelTimers()
	for i = 1,(numtargets or DoTimer_Settings.maxtargets) do
		getglobal("DoTimerTarget"..i):Show()
		if DoTimer_Settings.names then
			local targettext
			if DoTimer_Settings.levels then
				targettext = "[60] Target\nName\nNumber "..i
			else
				targettext = "Target\nName\nNumber "..i
			end
			getglobal("DoTimerTarget"..i.."Name"):Show()
			getglobal("DoTimerTarget"..i.."NameIcon"):Hide()
			getglobal("DoTimerTarget"..i.."NameText"):SetText(targettext)
			getglobal("DoTimerTarget"..i.."Name"):SetHeight(getglobal("DoTimerTarget"..i.."NameText"):GetHeight())
			getglobal("DoTimerTarget"..i.."Name"):SetWidth(getglobal("DoTimerTarget"..i.."NameText"):GetWidth())
			getglobal("DoTimerTarget"..i.."Name").target = "Target Name Number "..i
		end
		for id = 1,(numdebuffs or DoTimer_Settings.maxdebuffs) do
			getglobal("DoTimerTarget"..i.."Debuff"..id):Show()
			if DoTimer_Settings.format == "icons" then
				getglobal("DoTimerTarget"..i.."Debuff"..id.."IconButtonTexture"):SetTexture(GetSpellTexture(id,BOOKTYPE_SPELL))
				getglobal("DoTimerTarget"..i.."Debuff"..id.."IconTime"):SetText("0:00")
				getglobal("DoTimerTarget"..i.."Debuff"..id.."IconTime"):SetTextColor(.2,1,.2)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Icon"):SetAlpha(1)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."IconButton"):SetScale(DoTimer_Settings.buttonscale)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."IconButton"):EnableMouse(DoTimer_Settings.clickable)
			elseif DoTimer_Settings.format == "bars" then
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetMinMaxValues(0,1)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetValue(1)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetStatusBarColor(.2,1,.2)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatusTime"):SetText("0:00 - Fake Spell")
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButtonTexture"):SetTexture(GetSpellTexture(id,BOOKTYPE_SPELL))
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Bar"):SetAlpha(1)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButton"):SetScale(DoTimer_Settings.buttonscale)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetScale(DoTimer_Settings.buttonscale)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarBackground"):SetScale(DoTimer_Settings.buttonscale)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarBackground"):SetAlpha(.5)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButton"):EnableMouse(DoTimer_Settings.clickable)
			elseif DoTimer_Settings.format == "text" then
				getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButtonTime"):SetText("0:00 - Fake Spell")
				getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButtonTime"):SetTextColor(.2,1,.2)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Text"):SetAlpha(1)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButton"):SetScale(DoTimer_Settings.buttonscale)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButton"):EnableMouse(DoTimer_Settings.clickable)
			end
		end
	end
	DoTimer_ResizeInterface()
end

function DoTimer_DelTimers() --used to hide the "fake" timers created by the above function
	for i = 1,10 do
		getglobal("DoTimerTarget"..i):Hide()
		getglobal("DoTimerTarget"..i.."Name"):Hide()
		for id = 1,20 do
			getglobal("DoTimerTarget"..i.."Debuff"..id):Hide()
		end
	end
end

function DoTimer_DefineInterface(targetsetup,debuffsetup,startup) --the controller behind the 16 different interface layouts
	local oldtargetsetup = DoTimer_Settings.targetlayout
	local olddebuffsetup = DoTimer_Settings.debufflayout
	DoTimer_Settings.targetlayout = targetsetup
	DoTimer_Settings.debufflayout = debuffsetup
	local ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10
	local num1,num2,num3,num4,num5,num6,num7,num8,num9,num10
	--ref1/2: name string to target frame: the name is anchored by (1) to the target's (2)
	--ref3/4: time string to debuff texture: the timer is anchored by (3) to the texture's (4)
	--ref5/6 the anchor corner/its opposite: the 1st target is anchored by (5) to the drag icon's (6)
	--ref7: corner for the other targets: the next target is anchored by (5) to the current's (7)
	--ref8/9: anchors for the debuffs: the next debuff is anchored by its (9) to the previous's (8) (reversed order than usual)
	--ref10: anchor for the 1st debuff; it is connected by its (10) to the target frame's (10)
	--num1/2: dist. between name string and target: you go left (1) and up (2) to go from target to name
	--num3/4: dist. between time string and texture: you go left (3) and up (4) to go from texture to timer
	--num5/6: dist. between debuffs: you go left (5) and up (6) to go from one debuff to the next
	--num7/8: dist. between targets: you go left (7) and up (8) to go from one target to the next
	--num9/10: from main frame to 1st target, for a bit of room: you go left (9) and up (10) to go from main frame to 1st target
	if targetsetup == "up" and debuffsetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "LEFT","RIGHT","TOP","BOTTOM","BOTTOMRIGHT","TOPLEFT","TOPRIGHT","LEFT","RIGHT","BOTTOMRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 5,0,0,-5,-DoTimer_Settings.timerspacing,0,0,DoTimer_Settings.targetspacing,-5,5
	elseif targetsetup == "down" and debuffsetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "LEFT","RIGHT","TOP","BOTTOM","TOPRIGHT","BOTTOMLEFT","BOTTOMRIGHT","LEFT","RIGHT","TOPRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 5,0,0,-5,-DoTimer_Settings.timerspacing,0,0,-DoTimer_Settings.targetspacing,-5,-5
	elseif targetsetup == "left" and debuffsetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "TOP","BOTTOM","LEFT","RIGHT","BOTTOMRIGHT","TOPLEFT","BOTTOMLEFT","TOP","BOTTOM","BOTTOMRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,-5,5,0,0,DoTimer_Settings.timerspacing,-DoTimer_Settings.targetspacing,0,-5,5
	elseif targetsetup == "right" and debuffsetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "TOP","BOTTOM","LEFT","RIGHT","BOTTOMLEFT","TOPRIGHT","BOTTOMRIGHT","TOP","BOTTOM","BOTTOMLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,-5,5,0,0,DoTimer_Settings.timerspacing,DoTimer_Settings.targetspacing,0,5,5
	elseif targetsetup == "up" and debuffsetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "RIGHT","LEFT","TOP","BOTTOM","BOTTOMLEFT","TOPRIGHT","TOPLEFT","RIGHT","LEFT","BOTTOMLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = -5,0,0,-5,DoTimer_Settings.timerspacing,0,0,DoTimer_Settings.targetspacing,5,5
	elseif targetsetup == "down" and debuffsetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "RIGHT","LEFT","TOP","BOTTOM","TOPLEFT","BOTTOMRIGHT","BOTTOMLEFT","RIGHT","LEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = -5,0,0,-5,DoTimer_Settings.timerspacing,0,0,-DoTimer_Settings.targetspacing,5,-5
	elseif targetsetup == "left" and debuffsetup == "down" then --default!
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOM","TOP","LEFT","RIGHT","TOPRIGHT","BOTTOMLEFT","TOPLEFT","BOTTOM","TOP","TOPRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,5,0,0,-DoTimer_Settings.timerspacing,-DoTimer_Settings.targetspacing,0,-5,-5
	elseif targetsetup == "right" and debuffsetup == "down" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOM","TOP","LEFT","RIGHT","TOPLEFT","BOTTOMRIGHT","TOPRIGHT","BOTTOM","TOP","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,5,0,0,-DoTimer_Settings.timerspacing,DoTimer_Settings.targetspacing,0,5,-5
	elseif targetsetup == "right" and debuffsetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMLEFT","TOPLEFT","TOP","BOTTOM","TOPLEFT","BOTTOMRIGHT","TOPRIGHT","RIGHT","LEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,0,-5,DoTimer_Settings.timerspacing,0,DoTimer_Settings.targetspacing,0,5,-5
	elseif targetsetup == "down" and debuffsetup == "down" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "TOPRIGHT","TOPLEFT","LEFT","RIGHT","TOPLEFT","BOTTOMRIGHT","BOTTOMLEFT","BOTTOM","TOP","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = -5,0,5,0,0,-DoTimer_Settings.timerspacing,0,-DoTimer_Settings.targetspacing,5,-5
	elseif targetsetup == "left" and debuffsetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMRIGHT","TOPRIGHT","TOP","BOTTOM","TOPRIGHT","BOTTOMLEFT","TOPLEFT","LEFT","RIGHT","TOPRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,0,-5,-DoTimer_Settings.timerspacing,0,-DoTimer_Settings.targetspacing,0,-5,-5
	elseif targetsetup == "up" and debuffsetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMRIGHT","BOTTOMLEFT","LEFT","RIGHT","BOTTOMLEFT","TOPRIGHT","TOPLEFT","TOP","BOTTOM","BOTTOMLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = -5,0,5,0,0,DoTimer_Settings.timerspacing,0,DoTimer_Settings.targetspacing,5,5
	elseif targetsetup == "up" and debuffsetup == "down" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "TOPRIGHT","TOPLEFT","LEFT","RIGHT","BOTTOMLEFT","TOPRIGHT","TOPLEFT","BOTTOM","TOP","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = -5,0,5,0,0,-DoTimer_Settings.timerspacing,0,DoTimer_Settings.targetspacing,5,5
	elseif targetsetup == "down" and debuffsetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMRIGHT","BOTTOMLEFT","LEFT","RIGHT","TOPLEFT","BOTTOMRIGHT","BOTTOMLEFT","TOP","BOTTOM","BOTTOMLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = -5,0,5,0,0,DoTimer_Settings.timerspacing,0,-DoTimer_Settings.targetspacing,5,-5
	elseif targetsetup == "left" and debuffsetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMLEFT","TOPLEFT","TOP","BOTTOM","TOPRIGHT","BOTTOMLEFT","TOPLEFT","RIGHT","LEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,0,-5,DoTimer_Settings.timerspacing,0,-DoTimer_Settings.targetspacing,0,5,-5
	elseif targetsetup == "right" and debuffsetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMRIGHT","TOPRIGHT","TOP","BOTTOM","TOPLEFT","BOTTOMRIGHT","TOPRIGHT","LEFT","RIGHT","TOPRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,0,-5,-DoTimer_Settings.timerspacing,0,DoTimer_Settings.targetspacing,0,-5,-5
	else
		DoTimer_AddText("Failure to change interface design! No changes made.")
		DoTimer_Settings.targetlayout = oldtargetsetup
		DoTimer_Settings.debufflayout = olddebuffsetup
	end
	if (not (DoTimer_Settings.targetlayout == oldtargetsetup)) or (not (DoTimer_Settings.debufflayout == olddebuffsetup)) or (startup) then
		for i = 1,10 do
			getglobal("DoTimerTarget"..i):ClearAllPoints()
			getglobal("DoTimerTarget"..i.."Name"):ClearAllPoints()
			getglobal("DoTimerTarget"..i.."Name"):SetPoint(ref1,"DoTimerTarget"..i,ref2,num1,num2)
			for id = 1,20 do
				getglobal("DoTimerTarget"..i.."Debuff"..id):ClearAllPoints()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."IconTime"):ClearAllPoints()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."IconTime"):SetPoint(ref3,"DoTimerTarget"..i.."Debuff"..id.."IconButton",ref4,num3,num4)
			end
		end
		for i = 1,10 do
			getglobal("DoTimerTarget"..i.."Debuff1"):SetPoint(ref10,"DoTimerTarget"..i,ref10)
			for id = 2,20 do
				getglobal("DoTimerTarget"..i.."Debuff"..id):SetPoint(ref9,"DoTimerTarget"..i.."Debuff"..(id-1),ref8,num5,num6)
			end
		end
		getglobal("DoTimerTarget1"):SetPoint(ref5,"DoTimerMainFrame",ref6,num9,num10)
		for i = 2,10 do
			getglobal("DoTimerTarget"..i):SetPoint(ref5,"DoTimerTarget"..(i-1),ref7,num7,num8)
		end
		DoTimer_ResizeInterface()
	end
end

function DoTimer_ResizeInterface() --resizes the frames that hold the debuffs so that they are more tightly compacted on the screen
	local maxwidth,maxheight,otherwidth,otherheight,debuffheight,debuffwidth,timerheight,timerwidth
	if DoTimer_Settings.format == "icons" then
		debuffheight = DoTimerTarget1Debuff1IconButton:GetHeight() * DoTimer_Settings.buttonscale
		debuffwidth = DoTimerTarget1Debuff1IconButton:GetWidth() * DoTimer_Settings.buttonscale
		timerheight = DoTimerTarget1Debuff1IconTime:GetHeight()
		timerwidth = DoTimerTarget1Debuff1IconTime:GetWidth()
	elseif DoTimer_Settings.format == "bars" then
		debuffheight = DoTimerTarget1Debuff1BarButton:GetHeight() * DoTimer_Settings.buttonscale
		debuffwidth = DoTimerTarget1Debuff1BarButton:GetWidth() * DoTimer_Settings.buttonscale
	elseif DoTimer_Settings.format == "text" then
		debuffheight = DoTimerTarget1Debuff1TextButton:GetHeight() * DoTimer_Settings.buttonscale
		debuffwidth = DoTimerTarget1Debuff1TextButton:GetWidth() * DoTimer_Settings.buttonscale
	end
	local d = DoTimer_Settings.debufflayout
	if d == "up" or d == "down" then -- wider than they are tall
		if DoTimer_Settings.format == "icons" then
			maxwidth = debuffwidth + timerwidth + 5
			maxheight = math.max(debuffheight,timerheight)
			otherwidth = debuffwidth + timerwidth + 5
			otherheight = debuffheight
		else
			maxwidth = debuffwidth
			maxheight = debuffheight
			otherwidth = debuffwidth
			otherheight = debuffheight
		end
	else --taller than they are wide
		if DoTimer_Settings.format == "icons" then
			maxwidth = math.max(debuffwidth,timerwidth)
			maxheight = debuffheight + timerheight + 5
			otherwidth = debuffwidth
			otherheight = debuffheight + timerheight + 5
		else
			maxwidth = debuffwidth
			maxheight = debuffheight
			otherwidth = debuffwidth
			otherheight = debuffheight
		end
	end
	for i = 1,10 do
		local num = DoTimer_GetNumTimers(i)
		local targetwidth = (DoTimer_Settings.names and getglobal("DoTimerTarget"..i.."Name"):GetWidth() or 0)
		local targetheight = (DoTimer_Settings.names and getglobal("DoTimerTarget"..i.."Name"):GetHeight() or 0)
		if d == "up" or d == "down" then
			getglobal("DoTimerTarget"..i):SetWidth(math.max(targetwidth,maxwidth))
			getglobal("DoTimerTarget"..i):SetHeight(math.max(targetheight + 5,((num * (maxheight + DoTimer_Settings.timerspacing)) + 5 - DoTimer_Settings.timerspacing)))
		else
			getglobal("DoTimerTarget"..i):SetWidth(math.max(targetwidth + 5,((num * (maxwidth + DoTimer_Settings.timerspacing)) + 5 - DoTimer_Settings.timerspacing)))
			getglobal("DoTimerTarget"..i):SetHeight(math.max(targetheight,maxheight))		
		end
		for id = 1,20 do
			getglobal("DoTimerTarget"..i.."Debuff"..id):SetWidth(maxwidth)
			getglobal("DoTimerTarget"..i.."Debuff"..id):SetHeight(maxheight)
			local frame
			if DoTimer_Settings.format == "icons" then
				frame = getglobal("DoTimerTarget"..i.."Debuff"..id.."Icon")
			elseif DoTimer_Settings.format == "bars" then
				frame = getglobal("DoTimerTarget"..i.."Debuff"..id.."Bar")
			elseif DoTimer_Settings.format == "text" then
				frame = getglobal("DoTimerTarget"..i.."Debuff"..id.."Text")
			end
			frame:SetWidth(otherwidth)
			frame:SetHeight(otherheight)
		end
	end
end

function DoTimer_GetNumTimers(query)
	for i = 20,1,-1 do
		if getglobal("DoTimerTarget"..query.."Debuff"..i):IsVisible() then return i end
	end
	return 0
end

function DoTimer_SimulateTimer(spell,target) --used to make a fake timer, no real reason for it
	local rank = DoTimer_ReturnRank(spell)
	local sex,level,type
	sex = 0
	level = 60
	type = "player"
	local texture = DoTimer_ReturnTexture(spell)
	local duration = DoTimer_ReturnDuration(spell,rank)
	local spelltable = {spell = {spell = spell, rank = rank, texture = texture, duration = duration, type = "fake"}, target = {target = target, sex = sex, level = level, type = type,icon = 0}}
	DoTimer_CreateSpellTimer(spelltable)
end

function DoTimer_DefineFormat()
	if DoTimer_Settings.format == "icons" then
		for i = 1,10 do
			for id = 1,20 do
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Icon"):Show()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Bar"):Hide()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Text"):Hide()
			end
		end
	elseif DoTimer_Settings.format == "bars" then
		for i = 1,10 do
			for id = 1,20 do
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Icon"):Hide()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Bar"):Show()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Text"):Hide()
				local offset
				if DoTimer_Settings.icons then
					offset = 16
					getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButtonTexture"):Show()
				else
					offset = 0
					getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButtonTexture"):Hide()
				end
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):ClearAllPoints()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetPoint("TOPLEFT","DoTimerTarget"..i.."Debuff"..id.."Bar","TOPLEFT",offset,0)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Bar"):SetWidth(DoTimer_Settings.barlength + offset)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatusTime"):SetWidth(DoTimer_Settings.barlength - 6)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarButton"):SetWidth(DoTimer_Settings.barlength + offset)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarStatus"):SetWidth(DoTimer_Settings.barlength)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."BarBackground"):SetWidth(DoTimer_Settings.barlength)
			end
		end
	elseif DoTimer_Settings.format == "text" then
		for i = 1,10 do
			for id = 1,20 do
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Icon"):Hide()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Bar"):Hide()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Text"):Show()
				getglobal("DoTimerTarget"..i.."Debuff"..id.."Text"):SetWidth(DoTimer_Settings.barlength)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButtonTime"):SetWidth(DoTimer_Settings.barlength)
				getglobal("DoTimerTarget"..i.."Debuff"..id.."TextButton"):SetWidth(DoTimer_Settings.barlength)
			end
		end
	end
	DoTimer_ResizeInterface()
end

function DoTimer_InsertBlankTimer(targetindex)
	local list = {
		spell = "Blank Spot", 
		rank = "", 
		texture = "No Texture", 
		duration = 0, 
		time = 0, 
		type = "blank", 
		english = "Blank Spot",
	}
	table.insert(casted[targetindex],list)
end

function DoTimer_CreateGhostTimer(targetindex,debuffindex)
	local spell = SpellSystem_Copy(casted[targetindex][debuffindex])
	spell.time = GetTime()
	local ghostdata = DoTimer_Settings.ghostdata
	if ghostdata == 0 then
		timerdata["ghost"].hastimer = false
	else
		timerdata["ghost"].hastimer = true
		spell.duration = ghostdata
	end
	spell.type = "ghost"
	for i = table.getn(casted[targetindex]),1,-1 do
		if casted[targetindex][i].type == "ghost" and casted[targetindex][i].spell == spell.spell then DoTimer_RemoveTimer(targetindex,i,"replaced",1) end
	end
	if table.getn(casted[targetindex]) < DoTimer_Settings.maxdebuffs then table.insert(casted[targetindex],spell) end
	DoTimer_CreateInterface()
end

function DoTimer_ReturnNewDuration(time) --modifies the time remaining on the debuff into a format suitable for the screen
	local minutes = math.floor(time / 60)
	local seconds = math.floor(time - (60 * minutes))
	local remaining = time - (60 * minutes) - (seconds)
	local decimal
	if DoTimer_Settings.tenths then decimal = "."..string.format("%d",remaining * 10) else decimal = "" end
	return string.format("%d:%.2d%s",minutes,seconds,decimal)
end

function DoTimer_ReturnData(which)
	which = which or "casted"
	if which == "casted" then
		return casted
	elseif which == "timerdata" then
		return timerdata
	elseif which == "localedata" then
		return localedata
	end
end

function DoTimer_CreateTooltip(frame,targetindex,debuffindex)
	if not (casted[targetindex] and casted[targetindex][debuffindex]) then return end
	GameTooltip:SetOwner(frame,"ANCHOR_RIGHT")
	if casted[targetindex][debuffindex].info then	
		local type = casted[targetindex][debuffindex].info.type
		if type == BOOKTYPE_SPELL then
			GameTooltip:SetSpell(casted[targetindex][debuffindex].info.id,BOOKTYPE_SPELL)
		elseif type == "item" then
			GameTooltip:SetHyperlink(SpellSystem_ReturnItemLink(casted[targetindex][debuffindex].info.id))
		elseif type == BOOKTYPE_PET then
			GameTooltip:SetSpell(casted[targetindex][debuffindex].info.id,BOOKTYPE_PET)								
		end
	else
		GameTooltip:AddLine(casted[targetindex][debuffindex].spell,1,1,1)
		GameTooltip:AddLine(casted[targetindex][debuffindex].rank,1,1,1)
	end
	GameTooltip:Show()
end

------------------------------------------------------------------------------------------------------------
-- ############### OTHER FUNCTIONS ################# --
------------------------------------------------------------------------------------------------------------

function DoTimer_Commands(msg,fromgui) --governs the /command
	local bypass
	if msg == "" then DoTimerMenuFrame:Show()
	elseif msg == "on" then
		DoTimer_Settings.status = true
		DoTimer_AddMenuText("DoTimer by Asheyla now activated!",fromgui)
		DoTimerFrame:Show()
		DoTimerMainFrame:Show()
	elseif msg == "off" then
		DoTimer_Settings.status = false
		DoTimer_AddMenuText("DoTimer by Asheyla is now deactivated.",fromgui)
		DoTimerFrame:Hide()
		DoTimerMainFrame:Hide()
	elseif msg == "debug off" then
		DoTimer_DebugChannel = nil
		DoTimer_AddMenuText("No longer printing debug messages.",fromgui)
	elseif msg == "reset" then
		for index,value in pairs(DoTimer_Settings) do DoTimer_Settings[index] = nil end
		DoTimer_Commands("reset position",1)
		DoTimer_Startup()
		DoTimer_AddMenuText("All user data is now reset.",fromgui)
	elseif msg == "set format bars" then
		DoTimer_Settings.format = "bars"
		DoTimer_DefineFormat()
		DoTimer_AddMenuText("Timers will now be displayed as bars.",fromgui)
	elseif msg == "set format icons" then
		DoTimer_Settings.format = "icons"
		DoTimer_DefineFormat()
		DoTimer_AddMenuText("Timers will now be displayed as icons.",fromgui)
	elseif msg == "set format text" then
		DoTimer_Settings.format = "text"
		DoTimer_DefineFormat()
		DoTimer_AddMenuText("Timers will now be displayed as text.",fromgui)		
	elseif msg == "reset position" then
		DoTimerAnchorFrame:ClearAllPoints()
		DoTimerAnchorFrame:SetPoint("CENTER","UIParent","CENTER",5,0)
		DoTimer_Settings.offsetX = nil
		DoTimer_AddMenuText("The position of the UI is now reset.",fromgui)		
	elseif msg == "play sounds" then
		DoTimer_Settings.playsound = true
		DoTimer_AddMenuText("A sound will be played at 5 seconds.",fromgui)
	elseif msg == "do not play sounds" then
		DoTimer_Settings.playsound = false
		DoTimer_AddMenuText("No sounds will be played.",fromgui)
	elseif msg == "show only target" then
		DoTimer_Settings.onlytarget = true
		DoTimer_AddMenuText("Only timers your current target will be shown.",fromgui)
	elseif msg == "do not show only target" then
		DoTimer_Settings.onlytarget = false
		DoTimer_AddMenuText("All timers will be shown.",fromgui)
	elseif msg == "names off" then
		DoTimer_Settings.names = false
		DoTimer_AddMenuText("Names will not be shown.",fromgui)
		DoTimer_ResizeInterface()
	elseif msg == "names on" then
		DoTimer_Settings.names = true
		DoTimer_AddMenuText("Names will  be shown.",fromgui)
		DoTimer_ResizeInterface()
	elseif msg == "lock" then
		DoTimer_Settings.locked = true
		DoTimerAnchorFrame:Hide()
		DoTimer_AddMenuText("The timers are now locked in place.",fromgui)
	elseif msg == "unlock" then
		DoTimer_Settings.locked = false
		DoTimerAnchorFrame:Show()
		DoTimer_AddMenuText("The timers can now be moved by dragging the little button around.",fromgui)
	elseif msg == "hide" then
		DoTimer_DelTimers()
	elseif msg == "show levels" then
		DoTimer_Settings.levels = true
		DoTimer_AddMenuText("Levels will be shown with the target name.",fromgui)
	elseif msg == "sort target" then
		DoTimer_Settings.sorttarget = true
		DoTimer_AddMenuText("The table for your current target will be sorted to the first position.",fromgui)
	elseif msg == "do not sort target" then
		DoTimer_Settings.sorttarget = false
		DoTimer_AddMenuText("The table for your current target will not be automatically sorted.",fromgui)
	elseif msg == "no levels" then
		DoTimer_Settings.levels = false
		DoTimer_AddMenuText("Levels will not be shown with the target name.",fromgui)
	elseif msg == "sort by remaining" then
		DoTimer_AddMenuText("Timers will now be ordered by their time remaining.",fromgui)
		DoTimer_Settings.sortmethod = "remaining"
	elseif msg == "sort by added" then
		DoTimer_AddMenuText("Timers will now be ordered by when they were cast. ",fromgui)
		DoTimer_Settings.sortmethod = "added"
	elseif msg == "clickable debuffs" then
		DoTimer_Settings.clickable = true
		DoTimer_AddMenuText("The debuffs can now be clicked.  Leftclick to add to chat, rightclick to remove, shift+rightclick to remove and block.",fromgui)
	elseif msg == "unclickable debuffs" then
		DoTimer_Settings.clickable = false
		DoTimer_AddMenuText("The debuffs can no longer be clicked.",fromgui)
	elseif msg == "no expire alert" then
		DoTimer_Settings.expalert = false
		DoTimer_AddMenuText("The timers will not change color or highlight.",fromgui)
	elseif msg == "expire alert" then
		DoTimer_Settings.expalert = true
		DoTimer_AddMenuText("The timers will change to red and highlight at 5 seconds.",fromgui)
	elseif msg == "old timers" then
		DoTimer_Settings.dep = true
		DoTimer_AddMenuText("Timers which may no longer be accurate for your current target will still be shown.",fromgui)
	elseif msg == "no old timers" then
		DoTimer_Settings.dep = false
		DoTimer_AddMenuText("Timers which may no longer be accurate for your current target will be deleted.",fromgui)
	elseif msg == "do not include probable" then
		DoTimer_Settings.probable = false
		DoTimer_AddMenuText("The functions scanning for your own debuffs will ignore depreciated timers.",fromgui)
	elseif msg == "include probable" then
		DoTimer_Settings.probable = true
		DoTimer_AddMenuText("The functions scanning for your own debuffs will include depreciated timers.",fromgui)
	elseif msg == "separate timers" then
		DoTimer_Settings.septimers = true
		DoTimer_AddMenuText("Ghost timers will be separated from regular timers.",fromgui)
	elseif msg == "do not separate timers" then
		DoTimer_Settings.septimers = false
		DoTimer_AddMenuText("Ghost timers will not be separated from regular timers.",fromgui)
	elseif msg == "show blocked" then
		DoTimer_AddText("Blocked timers:")
		for index,value in pairs(DoTimer_Settings.blocked) do DoTimer_AddText(index) end
	elseif msg == "show tenths" then
		DoTimer_AddMenuText("The timers will now display to the nearest .1 second.",fromgui)
		DoTimer_Settings.tenths = true
	elseif msg == "hide tenths" then
		DoTimer_AddMenuText("The timers will now display to the nearest 1 second.",fromgui)
		DoTimer_Settings.tenths = false
	elseif msg == "show tooltips" then
		DoTimer_AddMenuText("Tooltips will now be shown when mousing over timers.",fromgui)
		DoTimer_Settings.tooltips = true
	elseif msg == "hide tooltips" then
		DoTimer_AddMenuText("Tooltips will not be shown when mousing over timers.",fromgui)
		DoTimer_Settings.tooltips = false
	elseif msg == "global settings" then
		DoTimer_Global_Settings.global["DoTimer"] = true
		DoTimer_AddMenuText("DoTimer's settings will now be shared across all characters.",fromgui)
	elseif msg == "local settings" then
		DoTimer_Global_Settings.global["DoTimer"] = false
		DoTimer_AddMenuText("DoTimer's settings can be now changed per character.",fromgui)
	elseif msg == "show icons" then
		DoTimer_Settings.icons = true
		DoTimer_AddMenuText("The icons on the bars of the bar format will now be shown.",fromgui)
		DoTimer_DefineFormat()
	elseif msg == "hide icons" then
		DoTimer_Settings.icons = false
		DoTimer_AddMenuText("The icons on the bars of the bar format will now be hidden.",fromgui)
		DoTimer_DefineFormat()
	elseif msg == "show ghosts" then
		DoTimer_Settings.ghosts = true
		DoTimer_AddMenuText("Ghost timers will now be shown.",fromgui)
	elseif msg == "hide ghosts" then
		DoTimer_Settings.ghosts = false
		DoTimer_AddMenuText("Ghost timers will not be shown.",fromgui)
	elseif msg == "show raid icons" then
		DoTimer_Settings.raidicons = true
		DoTimer_AddMenuText("Raid icons will now be shown on the target names.",fromgui)
	elseif msg == "hide raid icons" then
		DoTimer_Settings.raidicons = false
		DoTimer_AddMenuText("Ghost timers will not be shown on the target names.",fromgui)
	elseif string.sub(msg,1,10) == "set alpha " then
		local alpha = string.sub(msg,11)
		if type(tonumber(alpha)) == "number" then
			scale = tonumber(string.format("%.2f",alpha))
			DoTimer_Settings.alpha = alpha
			DoTimer_AddMenuText("New alpha: "..alpha,fromgui)
		end
	elseif string.sub(msg,1,13) == "ghost length " then
		local ghostdata = string.sub(msg,14)
		if type(tonumber(ghostdata)) == "number" then
			ghostdata = tonumber(string.format("%d",ghostdata))
			DoTimer_Settings.ghostdata = ghostdata
			if ghostdata == 0 then
				DoTimer_AddMenuText("Ghost timers will now last indefinitely.",fromgui)
			else
				DoTimer_AddMenuText("Ghost timers will now last "..ghostdata.." seconds.",fromgui)
			end
		end
	elseif string.sub(msg,1,8) == "bar msg " then
		local msg = string.sub(msg,9)
		DoTimer_Settings.barmsg = msg
		DoTimer_AddMenuText("The text inside the bars is now "..msg,fromgui)
	elseif string.sub(msg,1,6) == "block " then
		local spell = string.lower(string.sub(msg,7))
		DoTimer_Settings.blocked[spell] = 1
		DoTimer_AddMenuText(spell.." will not be shown as a timer.",fromgui)
	elseif string.sub(msg,1,8) == "unblock " then
		local spell = string.lower(string.sub(msg,9))
		DoTimer_Settings.blocked[spell] = nil
		DoTimer_AddMenuText(spell.." will be shown again as a timer.",fromgui)
	elseif string.sub(msg,1,11) == "set layout " then
		local targetlayout,debufflayout = SpellSystem_ParseString(msg,"(%a+)",-2)
		DoTimer_AddMenuText("Target tables will be added "..(targetlayout or "<cannot parse!>").." and debuffs will be added "..(debufflayout or "<cannot parse!>")..".",fromgui)
		DoTimer_DefineInterface(targetlayout,debufflayout)
	elseif string.sub(msg,1,4) == "show" then
		local num1,num2 = SpellSystem_ParseString(msg,"(%d+)",2)
		DoTimer_AddTimers(num1,num2)
		bypass = 1
	elseif string.sub(msg,1,5) == "debug" then
		DoTimer_DebugChannel = SpellSystem_ParseString(msg,"(%d+)")
		if not DoTimer_DebugChannel then DoTimer_DebugChannel = "" end
		DoTimer_AddMenuText("Now printing debug messages.",fromgui)
	elseif string.sub(msg,1,5) == "scale" then
		local scale = string.sub(msg,7)
		if type(tonumber(scale)) == "number" then
			scale = tonumber(string.format("%.2f",scale))
			DoTimerMainFrame:SetScale(scale)
			DoTimer_Settings.scale = scale
			DoTimer_AddMenuText("New scale: "..scale,fromgui)
			DoTimer_ResizeInterface()
		end
	elseif string.sub(msg,1,14) == "resist length " then
		local length = string.sub(msg,15)
		if type(tonumber(length)) == "number" then
			length = tonumber(string.format("%.2f",length))
			DoTimer_Settings.resistlength = length
			DoTimer_AddMenuText("Timers will now be buffered "..length.." seconds.",fromgui)
		end
	elseif string.sub(msg,1,11) == "bar length " then
		local number = tonumber(string.sub(msg,12))
		if type(number) == "number" and number >= 50 and number <= 250 then
			DoTimer_Settings.barlength = number
			DoTimer_DefineFormat()
			DoTimer_AddMenuText("Timer bars will now have length "..number,fromgui)
		end
	elseif string.sub(msg,1,18) == "set timer spacing " then
		local number = tonumber(string.sub(msg,19))
		if type(number) == "number" and number >= 0 and number <= 20 then
			DoTimer_Settings.timerspacing = number
			DoTimer_DefineInterface(DoTimer_Settings.targetlayout,DoTimer_Settings.debufflayout,1)
			DoTimer_AddMenuText("Debuffs will now be spaced "..number.." apart.",fromgui)
		end
	elseif string.sub(msg,1,19) == "set target spacing " then
		local number = tonumber(string.sub(msg,20))
		if type(number) == "number" and number >= 0 and number <= 30 then
			DoTimer_Settings.targetspacing = number
			DoTimer_DefineInterface(DoTimer_Settings.targetlayout,DoTimer_Settings.debufflayout,1)
			DoTimer_AddMenuText("Targets will now be spaced "..number.." apart.",fromgui)
		end
	elseif string.sub(msg,1,11) == "max targets" then
		local number = tonumber(string.sub(msg,12))
		if type(number) == "number" and number > 0 and number < 11 then
			DoTimer_Settings.maxtargets = number
			DoTimer_AddMenuText("Max number of target tables is now "..number,fromgui)
		end
	elseif string.sub(msg,1,4) == "sim " then
		local spell,target = SpellSystem_ParseString(msg,"sim (.+) on (.+)")
		if spell and target and DoTimer_intable(spell,spells) then DoTimer_SimulateTimer(spell,target) end
	elseif string.sub(msg,1,12) == "max debuffs " then
		local number = tonumber(string.sub(msg,13))
		if type(number) == "number" and number > 0 and number < 21 then
			DoTimer_Settings.maxdebuffs = number
			DoTimer_AddMenuText("Max number of debuffs per target table is now "..number,fromgui)
		end
	elseif string.sub(msg,1,13) == "button scale " then
		local scale = string.sub(msg,14)
		if type(tonumber(scale)) == "number" then
			scale = tonumber(string.format("%.2f",scale))
			DoTimer_Settings.buttonscale = scale
			DoTimer_AddMenuText("The new button scale is now "..scale,fromgui)
		end
	elseif string.sub(msg,1,9) == "chat msg " then
		local type,newmsg = SpellSystem_ParseString(msg,"chat msg (%a+):%s?(.+)")
		if newmsg then
			if type == "normal" then
				DoTimer_Settings.chatmsgnormal = newmsg
				DoTimer_AddMenuText("The new format string for normal timers is now "..newmsg,fromgui)		
			elseif type == "notarget" then
				DoTimer_Settings.chatmsgnotarget = newmsg
				DoTimer_AddMenuText("The new format string for notarget timers is now "..newmsg,fromgui)		
			end
		end
	elseif string.sub(msg,1,4) == "help" then DoTimer_AddHelpMenu(msg)
	else
		DoTimer_AddMenuText("Type |cff00ff00/dotimer help|r for some info, or |cff00ff00/dotimer|r to open the menu!",fromgui)
	end
	if not (fromgui or bypass) then DoTimer_CreateInterface(1,1) end
end

function DoTimer_Time(name,length,ontarget,isreal)
	local newentry = {
		spell = {
			spell = name,
			rank = "",
			texture = "Interface\\Icons\\Spell_Lightning_LightningBolt01",
			duration = length,
			type = ((isreal or (not ontarget)) and "debuff" or "fake"),
			time = GetTime(),
		},
		target = 
			((ontarget and UnitExists("target")) and
				{
				target = UnitName("target"),
				sex = UnitSex("target"),
				level = UnitLevel("target"),
				icon = GetRaidTargetIndex("target") or 0,
				type = SpellSystem_ReturnTargetType("target"),	
				}
			or 
				{
				target = "No Target",
				sex = 0,
				level = 0,
				icon = 0,
				type = "player",	
				}),
	}
	DoTimer_DefineSpell("Interface\\Icons\\Spell_Lightning_LightningBolt01",name,length,1)
	if isreal then
		table.insert(finalspell,newentry)
		if table.getn(finalspell) == 1 then DoTimerAfterFrame:SetScript("OnUpdate",function() DoTimer_AfterCast() end) end
	else
		DoTimer_CreateSpellTimer(newentry)
	end
end

function DoTimer_ToChat(targetindex,debuffindex)
	if not (casted[targetindex].external or casted[targetindex][debuffindex].external) and timerdata[casted[targetindex][debuffindex].type].isreal then
		local displayed = casted[targetindex][debuffindex].displayed
		local spell = casted[targetindex][debuffindex].spell
		local rank = casted[targetindex][debuffindex].rank
		local target = casted[targetindex].target
		local level = casted[targetindex].level
		if (displayed and spell and rank and target and level) then
			displayed = DoTimer_ReturnNewDuration(displayed)
			local subentries,unsubbedmsg
			if target == "No Target" then
				subentries = {
					["%d"] = displayed,
					["%s"] = spell,
					["%r"] = rank,
				}
				unsubbedmsg = DoTimer_Settings.chatmsgnotarget		
			else
				subentries = {
					["%d"] = displayed,
					["%s"] = spell,
					["%r"] = rank,
					["%t"] = target,
					["%l"] = level,
				}
				unsubbedmsg = DoTimer_Settings.chatmsgnormal
			end
			local chat = "SAY"
			if GetNumRaidMembers() > 0 then chat = "RAID" elseif GetNumPartyMembers() > 0 then chat = "PARTY" end
			local msg = string.gsub(unsubbedmsg,"(%%%a)",function(a) return subentries[a] or "" end)
			msg = string.gsub(msg,"%(%)","")
			SendChatMessage(msg,chat)
		end
	end
end

function DoTimer_FormatBarText(targetindex,debuffindex)
	local displayed = casted[targetindex][debuffindex].duration - GetTime() + casted[targetindex][debuffindex].time
	local spell = casted[targetindex][debuffindex].spell
	local rank = casted[targetindex][debuffindex].rank
	local target = casted[targetindex].target
	local level = casted[targetindex].level
	local subentries = {
		["%d"] = DoTimer_ReturnNewDuration(displayed),
		["%s"] = spell,
		["%r"] = rank,
		["%t"] = target,
		["%l"] = level,
	}
	local msg = string.gsub(DoTimer_Settings.barmsg,"(%%%a)",function(a) return subentries[a] or "" end)
	msg = string.gsub(msg,"%(%)","")
	return msg
end

function DoTimer_FakeInterface() -- used to make the screenshot, yay!
	casted = {
		[1] = {
			["target"] = "Scary Mob",
			["level"] = 63,
			["sex"] = 0,
			["type"] = "mob",
			[1] = {
				["spell"] = "Curse of Agony",
				["rank"] = "Rank 6",
				["duration"] = 24,
				["time"] = GetTime() - 15,
				["texture"] = "Interface\\Icons\\Spell_Shadow_CurseOfSargeras",
				["type"] = "debuff",
				["english"] = "Curse of Agony",
			},
			[2] = {
				["spell"] = "Corruption",
				["rank"] = "Rank 7",
				["duration"] = 18,
				["time"] = GetTime(),
				["texture"] = "Interface\\Icons\\Spell_Shadow_AbominationExplosion",
				["type"] = "debuff",
				["english"] = "Corruption",
			},
			[3] = {
				["spell"] = "Immolate",
				["rank"] = "Rank 8",
				["duration"] = 15,
				["time"] = GetTime() - 11,
				["texture"] = "Interface\\Icons\\Spell_Fire_Immolation",
				["type"] = "debuff",
				["english"] = "Immolate",
				["dep"] = 1,
			},
		},
		[2] = {
			["target"] = "Scary Player",
			["level"] = 60,
			["sex"] = 0,
			["type"] = "player",
			[1] = {
				["spell"] = "Curse of Shadow",
				["rank"] = "Rank 2",
				["duration"] = 300,
				["time"] = GetTime() - 120,
				["texture"] = "Interface\\Icons\\Spell_Shadow_CurseOfAchimonde",
				["type"] = "debuff",
				["english"] = "Curse of Shadow",
			},
			[2] = {
				["spell"] = "Spell Lock",
				["rank"] = "",
				["duration"] = 8,
				["time"] = GetTime() - 2,
				["texture"] = "Interface\\Icons\\Spell_Shadow_MindRot",
				["type"] = "debuff",
				["english"] = "Spell Lock",
			},
		},
	}
	DoTimer_CreateInterface()
end

function DoTimer_CreateTimerGroup(name,isreal,hastimer,disptimer,clickable,scale,alpha,colors)
	timerdata[name] = {
		isreal = isreal,
		hastimer = hastimer,
		disptimer = disptimer,
		clickable = clickable,
		scale = scale,
		alpha = alpha,
		colors = colors
	}
end

function DoTimer_DefineSpell(texture,name,duration,multiplier,group)
	localedata[texture] = {
		name = name,
		duration = duration,
		multiplier = multiplier,
		group = group,
	}
end
