function DoTimer_SetMenuData()
	DoTimerScaleSlider:SetValue(DoTimer_Settings.scale)
	DoTimerButtonScaleSlider:SetValue(DoTimer_Settings.buttonscale)
	DoTimerMaxTargetsSlider:SetValue(DoTimer_Settings.maxtargets)
	DoTimerMaxDebuffsSlider:SetValue(DoTimer_Settings.maxdebuffs)
	DoTimerFormatSlider:SetValue(DoTimerFormatSlider.values[DoTimer_Settings.format])
	DoTimerTargetLayoutSlider:SetValue(DoTimerTargetLayoutSlider.values[DoTimer_Settings.targetlayout])
	DoTimerDebuffLayoutSlider:SetValue(DoTimerDebuffLayoutSlider.values[DoTimer_Settings.debufflayout])
	DoTimerDebuffSortSlider:SetValue(DoTimerDebuffSortSlider.values[DoTimer_Settings.sortmethod])
	local debugging
	if DoTimer_DebugChannel then
		if DoTimer_DebugChannel == "" then debugging = "on" else debugging = DoTimer_DebugChannel end
	else
		debugging = "off"
	end
	DoTimerDebugEditBox:SetText(debugging)
	DoTimerEnabledCheckButton:SetChecked(DoTimer_Settings.status)
	DoTimerLockedCheckButton:SetChecked(DoTimer_Settings.locked)
	DoTimerNamesCheckButton:SetChecked(DoTimer_Settings.names)
	DoTimerLevelsCheckButton:SetChecked(DoTimer_Settings.levels)
	DoTimerExpAlertCheckButton:SetChecked(DoTimer_Settings.expalert)
	DoTimerClickableCheckButton:SetChecked(DoTimer_Settings.clickable)
	DoTimerDepCheckButton:SetChecked(DoTimer_Settings.dep)
	DoTimerProbableCheckButton:SetChecked(DoTimer_Settings.probable)
	DoTimerSepTimerCheckButton:SetChecked(DoTimer_Settings.septimers)
	DoTimerOnlyTargetCheckButton:SetChecked(DoTimer_Settings.onlytarget)
	DoTimerPlaySoundsCheckButton:SetChecked(DoTimer_Settings.playsound)
	DoTimerTenthsCheckButton:SetChecked(DoTimer_Settings.tenths)
	DoTimerTooltipsCheckButton:SetChecked(DoTimer_Settings.tooltips)
	DoTimerSortTargetCheckButton:SetChecked(DoTimer_Settings.sorttarget)
	DoTimerBarLengthSlider:SetValue(DoTimer_Settings.barlength)
	DoTimerTimerSpacingSlider:SetValue(DoTimer_Settings.timerspacing)
	DoTimerTargetSpacingSlider:SetValue(DoTimer_Settings.targetspacing)
	DoTimerResistLengthSlider:SetValue(DoTimer_Settings.resistlength)
	DoTimerGlobalCheckButton:SetChecked(DoTimer_Global_Settings.global["DoTimer"])
	DoTimerAlphaSlider:SetValue(DoTimer_Settings.alpha)
	DoTimerIconsCheckButton:SetChecked(DoTimer_Settings.icons)
	DoTimerGhostsCheckButton:SetChecked(DoTimer_Settings.ghosts)
	DoTimerGhostDataSlider:SetValue(DoTimer_Settings.ghostdata)
	DoTimerRaidIconCheckButton:SetChecked(DoTimer_Settings.raidicons)
end

function DoTimer_ParseMenuData()
	DoTimer_Commands("scale "..DoTimerScaleSlider:GetValue(),1)
	DoTimer_Commands("button scale "..DoTimerButtonScaleSlider:GetValue(),1)
	DoTimer_Commands("max targets "..DoTimerMaxTargetsSlider:GetValue(),1)
	DoTimer_Commands("max debuffs "..DoTimerMaxDebuffsSlider:GetValue(),1)
	DoTimer_Commands("set format "..DoTimerFormatSlider.values[DoTimerFormatSlider:GetValue()],1)
	DoTimer_Commands("set layout "..DoTimerTargetLayoutSlider.values[DoTimerTargetLayoutSlider:GetValue()].." "..DoTimerDebuffLayoutSlider.values[DoTimerDebuffLayoutSlider:GetValue()],1)
	DoTimer_Commands("sort by "..DoTimerDebuffSortSlider.values[DoTimerDebuffSortSlider:GetValue()],1)
	DoTimer_Commands("debug "..DoTimerDebugEditBox:GetText(),1)
	DoTimer_Commands("bar length "..DoTimerBarLengthSlider:GetValue(),1)
	DoTimer_Commands("set timer spacing "..DoTimerTimerSpacingSlider:GetValue(),1)
	DoTimer_Commands("set target spacing "..DoTimerTargetSpacingSlider:GetValue(),1)
	DoTimer_Commands("resist length "..DoTimerResistLengthSlider:GetValue(),1)
	DoTimer_Commands("set alpha "..DoTimerAlphaSlider:GetValue(),1)
	DoTimer_Commands("ghost length "..DoTimerGhostDataSlider:GetValue(),1)
	if DoTimerEnabledCheckButton:GetChecked() then DoTimer_Commands("on",1) else DoTimer_Commands("off",1) end
	if DoTimerLockedCheckButton:GetChecked() then DoTimer_Commands("lock",1) else DoTimer_Commands("unlock",1) end
	if DoTimerNamesCheckButton:GetChecked() then DoTimer_Commands("names on",1) else DoTimer_Commands("names off",1) end
	if DoTimerLevelsCheckButton:GetChecked() then DoTimer_Commands("show levels",1) else DoTimer_Commands("no levels",1) end
	if DoTimerExpAlertCheckButton:GetChecked() then DoTimer_Commands("expire alert",1) else DoTimer_Commands("no expire alert",1) end
	if DoTimerClickableCheckButton:GetChecked() then DoTimer_Commands("clickable debuffs",1) else DoTimer_Commands("unclickable debuffs",1) end
	if DoTimerDepCheckButton:GetChecked() then DoTimer_Commands("old timers",1) else DoTimer_Commands("no old timers",1) end
	if DoTimerProbableCheckButton:GetChecked() then DoTimer_Commands("include probable",1) else DoTimer_Commands("do not include probable",1) end
	if DoTimerSepTimerCheckButton:GetChecked() then DoTimer_Commands("separate timers",1) else DoTimer_Commands("do not separate timers",1) end
	if DoTimerOnlyTargetCheckButton:GetChecked() then DoTimer_Commands("show only target",1) else DoTimer_Commands("do not show only target",1) end
	if DoTimerPlaySoundsCheckButton:GetChecked() then DoTimer_Commands("play sounds",1) else DoTimer_Commands("do not play sounds",1) end
	if DoTimerTenthsCheckButton:GetChecked() then DoTimer_Commands("show tenths",1) else DoTimer_Commands("hide tenths",1) end
	if DoTimerSortTargetCheckButton:GetChecked() then DoTimer_Commands("sort target",1) else DoTimer_Commands("do not sort target",1) end
	if DoTimerTooltipsCheckButton:GetChecked() then DoTimer_Commands("show tooltips",1) else DoTimer_Commands("hide tooltips",1) end
	if DoTimerGlobalCheckButton:GetChecked() then DoTimer_Commands("global settings",1) else DoTimer_Commands("local settings",1) end
	if DoTimerIconsCheckButton:GetChecked() then DoTimer_Commands("show icons",1) else DoTimer_Commands("hide icons",1) end
	if DoTimerGhostsCheckButton:GetChecked() then DoTimer_Commands("show ghosts",1) else DoTimer_Commands("hide ghosts",1) end
	if DoTimerRaidIconCheckButton:GetChecked() then DoTimer_Commands("show raid icons",1) else DoTimer_Commands("hide raid icons",1) end
	DoTimer_CreateInterface(1,1)
end

function DoTimer_AddHelpMenu(msg) --the help menu displayed ingame
	if msg == "help info" then
		DoTimer_AddText("|cff00ffffDoTimer Version/Author Info:|r")
		DoTimer_AddText("|cff00ff00Current version|r: "..SpellSystem_ReturnVersion())
		DoTimer_AddText("|cff00ff00Date Uploaded|r: "..SpellSystem_ReturnDateUploaded())
		DoTimer_AddText("|cff00ff00Author|r: Asheyla <Warcraft Gaming Faction>, Shattered Hand (Horde)")
		DoTimer_AddText("|cff00ff00Email|r: ross456@gmail.com")
		DoTimer_AddText("|cff00ff00Paypal Donations|r: ross456@gmail.com")
	elseif msg == "help new" then
		DoTimer_AddText("|cff00ffffDoTimer Beginner's Guide:|r")
		DoTimer_AddText("|cff00ff00Please Note|r: The information in this subsection will not detail any other commands.  Please explore all help menus for a full understanding of all the features of this addon.")
		DoTimer_AddText("|cff00ff00First Installation|r: You will notice a small black circle in the middle of your screen.  It is to this box that the timers are anchored.  Move it around by dragging it.  Hide it by locking the interface via \"/dotimer lock\".")
		DoTimer_AddText("|cff00ff00DoTimers|r: When you go out into the world and DoT a mob, timers will automatically appear.  There is no configuration required for this basic step.")
		DoTimer_AddText("|cff00ff00Ghost Timers|r: These are timers created when a real timer expires.  You can control how long they stay on your screen, or if they appear at all.")
		DoTimer_AddText("|cff00ff00Timer Format|r: The command to switch between bars, icons, and text is \"/dotimer set format [bars,icons,text]\".  It is also the 5th slider from the top in the center column in the GUI.")
		DoTimer_AddText("|cff00ff00Troubleshooting|r: If you ever have any errors, please contact me.  It would be best if you include a way to duplicate the problem.  Before doing this, try disabling your other addons and seeing if the problem goes away.  If it does, figure out the conflicting addon and tell me.")
		DoTimer_AddText("|cff00ff00Features|r: Many features of this addon have been direct requests by other players.  If you ever have any suggestions, feel free to contact me about them.")
	elseif msg == "help other cmds" then
		DoTimer_AddText("|cff00ffffDoTimer Other Commands:|r")
		DoTimer_AddText("|cff00ff00sim Spell on Target|r: creates a fake timer for Spell on Target (you must capitalize the spell correctly!)")
		DoTimer_AddText("|cff00ff00/script DoTimer_Time(name,length[,ontarget[,isreal]])|r: creates a timer onscreen with name 'name' and length 'length'.  if ontarget is 1, it will be placed in your target's table, else under 'No Target'.  If isreal, it will check for resists and be removed if dispeled.")
	else
		DoTimer_AddText("|cff00ffffDoTimer Help Menu:|r")
		DoTimer_AddText("|cff00ff00help new|r: information for first-time users")
		DoTimer_AddText("|cff00ff00help general|r: basic addon features")
		DoTimer_AddText("|cff00ff00help info|r: displays some version/author info")
	end
end
