Notifications_Settings = nil
local events = {}
local spellinfo = {}
local currentinfo = {}
local specialevents = {
	["Player Buff Gain"] = "This is sent when you gain a buff. (%s: the buff)",
	["Player Debuff Gain"] = "This is sent when you get a debuff.  It is sent once for the debuff name, and once for its dispel type. (%s: the debuff or type)", 
	["Player Buff Fade"] = "This is sent when a buff fades from you. (%s: the buff)",
	["Player Debuff Fade"] = "This is sent when a debuff fades from you. (%s: the debuff)",
	["Enemy Begin Casting"] = "This is sent when your hostile target begins casting a spell. (%s: the spell, %t: your target)",
	["Enemy Target Buff Gain"] = "This is sent when your hostile target gains a buff.  (%s: the buff, %t: your target)",
	["Enemy Target Buff/Debuff Fade"] = "This is sent when a buff or debuff fades from your hostile target. (%s: the (de)buff, %t: your target)",
}
local regevents = {
	["Spell Begin Casting"] = "This is sent when you begin casting a spell.  (%s: the spell, %t: the spell's target)", 
	["Spell Finish Casting"] = "This is sent when you finish casting a spell.  (%s: the spell, %t: the spell's target)",
	["Item Usage"] = "This is sent when you use an item.  (%s: the item, %t: the item's target, if applicable)",
	["Spell Failed on Mob"] = "This is sent when a spell you cast on a mob is resisted, dodged, evaded, etc.  (%s: the spell, %t: the target)", 
	["Spell Crit Mob"] = "This is sent when you crit a mob with a spell or ability (not white damage).  (%s: the spell, %t: the target, %d: amount damage)",
	["DoT Time Remaining"] = "This option requires DoTimer in order to function.  This is sent every second for each of your DoTimer timers.  (%s: the spell, %t: its target, %d: amount time remaining)", --dotimer
	["DoT Breaking Early"] = "This option requires DoTimer in order to function.  This is sent when a DoT you cast is detected to have broken early from its target. (%s: the spell, %t: its target)", --dotimer
	["DoT Full Duration"] = "This option requires DoTimer in order to function.  This is sent when a DoT you cast expires due to full duration.  (%s: the spell, %t: its target)", --dotimer
	["DoT Applied to Mob"] = "This option requires DoTimer in order to function.  This is sent when a DoT you cast successfully lands on its target.  (%s: the spell, %t: its target)", --dotimer
	["Cooldown Finished"] = "This option requires Cooldowns in order to function.  This is sent when a Cooldown expires.  (%s: the cooldown, %t: Soulstone's target)", --cooldowns
	["Cooldown Time Remaining"] = "This option requires Cooldowns in order to function.  This is sent every second for each of your Cooldowns timers.  (%s: the spell, %d: amount time remaining, %t: Soulstone's target)", --cooldowns
}
local miscevents = {
	["Aggro Gain"] = "This is sent when your current target switches its target to you from something else. (%t: your target)",
	["Aggro Loss"] = "This is sent when your current target switches its target to something else from you.  (%t: your target)",
	["Health"] = "This is sent every time you gain or lose health.  (%d: your current health)",
	["Mana"] = "This is sent every time you gain or lose mana, energy, or rage.  (%d: your current mana/energy/rage)",
}
local orgeventlist = {
	"Spell Begin Casting",
	"Spell Finish Casting",
	"Item Usage",
	"Spell Failed on Mob",
	"Spell Crit Mob",
	"DoT Time Remaining",
	"DoT Breaking Early",
	"DoT Full Duration",
	"DoT Applied to Mob",
	"Cooldown Finished",
	"Cooldown Time Remaining",
	"Player Buff Gain",
	"Player Debuff Gain",
	"Player Buff Fade",
	"Player Debuff Fade",
	"Enemy Begin Casting",
	"Enemy Target Buff Gain",
	"Enemy Target Buff/Debuff Fade",
	"Aggro Gain",
	"Aggro Loss",
	"Health",
	"Mana",
}
local usages = {
	["All"] = 1,
	["Random"] = 1,
}
local matchings = {
	["Partial"] = 1,
	["Exact"] = 1,
}
local failmsgs = {
	resistmsg = string.gsub(SPELLRESISTSELFOTHER,"%%.-s","(.+)"),
	evademsg = string.gsub(SPELLEVADEDSELFOTHER,"%%.-s","(.+)"),
	immunemsg = string.gsub(SPELLIMMUNESELFOTHER,"%%.-s","(.+)"),
	reflectmsg = string.gsub(SPELLREFLECTSELFOTHER,"%%.-s","(.+)"),
	dodgemsg = string.gsub(SPELLDODGEDSELFOTHER,"%%.-s","(.+)"),
	parrymsg = string.gsub(SPELLPARRIEDSELFOTHER,"%%.-s","(.+)"),
	missmsg = string.gsub(SPELLMISSSELFOTHER,"%%.-s","(.+)"),
	absorbmsg = string.gsub(SPELLLOGABSORBSELFOTHER,"%%.-s","(.+)"),
}
local hitmsgs = {
	spellhit = string.gsub(SPELLLOGSCHOOLSELFOTHER,"%%.-[sd]","(.+)"),
	abilityhit = string.gsub(SPELLLOGSELFOTHER,"%%.-[sd]","(.+)"),
}
local critmsgs = {
	spellcrit = string.gsub(SPELLLOGCRITSCHOOLSELFOTHER,"%%.-[sd]","(.+)"),
	abilitycrit = string.gsub(SPELLLOGCRITSELFOTHER,"%%.-[sd]","(.+)"),
}
local enemygainsbuff = string.gsub(AURAADDEDOTHERHELPFUL,"%%.-[sd]","(.+)")
local enemylosesbuff = string.gsub(AURAREMOVEDOTHER,"%%.-[sd]","(.+)")
local playerclass
local prevmana
local prevhealth
local prevstate
local freetable = {}
function Notifications_MakeTable()
	for index,value in pairs(freetable) do freetable[index] = nil end
	return freetable
end
local otherfreetable = {}
function Notifications_MakeOtherTable()
	for index,value in pairs(otherfreetable) do otherfreetable[index] = nil end
	return otherfreetable
end

function Notifications_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED")
	this:RegisterEvent("UNIT_SPELLCAST_SENT")
	this:RegisterEvent("UNIT_SPELLCAST_START")
	this:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE")
	this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS") --hostile gaining a buff
	this:RegisterEvent("CHAT_MSG_SPELL_AURA_GONE_OTHER") --hostile losing a buff
	this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE") --when you gain a debuff
	this:RegisterEvent("COMBAT_TEXT_UPDATE") --player buff/debuff gain/loss
	this:RegisterEvent("UNIT_HEALTH")
	this:RegisterEvent("UNIT_MANA")
	this:RegisterEvent("PLAYER_TARGETS_CHANGED")
	SpellSystem_RegisterEvent(Notifications_OnEvent,"SPELLSYSTEM_SUCCESS")
	SpellSystem_RegisterEvent(Notifications_OnEvent,"SPELLSYSTEM_SUCCESS_NODATA")
	SLASH_NOTIFICATIONS1 = "/notifications" --creating the slash command
	SLASH_NOTIFICATIONS2 = "/not" --and the other one, for those who are lazy
	SlashCmdList["NOTIFICATIONS"] = Notifications_Commands
end

function Notifications_Startup()
	if not DoTimer_Global_Settings then DoTimer_Global_Settings = {} end
	if not DoTimer_Global_Settings.global then DoTimer_Global_Settings.global = {} end
	if DoTimer_Global_Settings.global["Notifications"] == nil then DoTimer_Global_Settings.global["Notifications"] = false end
	local name = UnitName("player")
	local realm = GetRealmName()
	local identifier = name..":"..realm
	if not DoTimer_Global_Settings[identifier] then DoTimer_Global_Settings[identifier] = {} end
	if not DoTimer_Global_Settings[identifier]["Notifications"] then DoTimer_Global_Settings[identifier]["Notifications"] = {} end
	if not DoTimer_Global_Settings["Notifications"] then DoTimer_Global_Settings["Notifications"] = {} end
	local settings
	if DoTimer_Global_Settings.global["Notifications"] then settings = DoTimer_Global_Settings["Notifications"] else settings = DoTimer_Global_Settings[identifier]["Notifications"] end
	if settings.status == nil then settings.status = true end
	if not settings.events then settings.events = {} end
	events = settings.events
	if not events["Spell Begin Casting"] then events["Spell Begin Casting"] = {} end 
	if not events["Spell Finish Casting"]  then events["Spell Finish Casting"] = {} end 
	if not events["Item Usage"] then events["Item Usage"] = {} end
	if not events["Spell Failed on Mob"] then events["Spell Failed on Mob"] = {} end 
	if not events["Spell Crit Mob"] then events["Spell Crit Mob"] = {} end 
	if not events["DoT Time Remaining"] then events["DoT Time Remaining"] = {} end --dotimer
	if not events["DoT Breaking Early"] then events["DoT Breaking Early"] = {} end --dotimer
	if not events["DoT Full Duration"] then events["DoT Full Duration"] = {} end --dotimer
	if not events["DoT Applied to Mob"] then events["DoT Applied to Mob"] = {} end --dotimer
	if not events["Cooldown Finished"] then events["Cooldown Finished"] = {} end --cooldowns
	if not events["Cooldown Time Remaining"] then events["Cooldown Time Remaining"] = {} end --cooldowns
	if not events["Player Buff Gain"] then events["Player Buff Gain"] = {} end 
	if not events["Player Buff Fade"] then events["Player Buff Fade"] = {} end 
	if not events["Player Debuff Fade"] then events["Player Debuff Fade"] = {} end 
	if not events["Player Debuff Gain"] then events["Player Debuff Gain"] = {} end 
	if not events["Enemy Target Buff Gain"] then events["Enemy Target Buff Gain"] = {} end 
	if not events["Enemy Begin Casting"] then events["Enemy Begin Casting"] = {} end
	if not events["Enemy Target Buff/Debuff Fade"] then events["Enemy Target Buff/Debuff Fade"] = {} end
	if not events["Aggro Gain"] then events["Aggro Gain"] = {} end
	if not events["Aggro Loss"] then events["Aggro Loss"] = {} end
	if not events["Health"] then events["Health"] = {} end
	if not events["Mana"] then events["Mana"] = {} end
	for index,value in pairs(events) do if not (specialevents[index] or regevents[index] or miscevents[index]) then events[index] = nil end end
	if DoTimer_Global_Settings.global["Notifications"] then 
		Notifications_Settings = DoTimer_Global_Settings["Notifications"]
		DoTimer_Global_Settings[identifier]["Notifications"] = Notifications_Settings
	else 
		Notifications_Settings = DoTimer_Global_Settings[identifier]["Notifications"] 
		DoTimer_Global_Settings["Notifications"] = Notifications_Settings
	end
	local font = GameFontNormal:GetFont()
	NotificationsAlertFrameText:SetFont(font,50)
	local _,class = UnitClass("player")
	playerclass = class
	NotificationsTargetFrame:SetScript("OnUpdate",function() Notifications_CheckTarget(arg1) end)
	NotificationsTargetFrame.time = .5
	if DoTimerFrame then
		local D_RT = DoTimer_RemoveTimer
		function Notifications_D_RT(i,id,reason,fromcst)
			--if reason is "broke", "DoT Breaking Early"
			--if reason is "finished", "DoT Full Duration"
			if Notifications_Settings.status then
				local casted = DoTimer_ReturnData()
				if casted[i] and casted[i][id] then
					if not casted[i].external then
						local timerdata = DoTimer_ReturnData("timerdata")
						local type = casted[i][id].type
						if timerdata[type].isreal then
							if reason == "broke" then
								Notifications_EventOccurred("DoT Breaking Early",casted[i][id].spell,casted[i].target)				
							elseif reason == "finished" then
								Notifications_EventOccurred("DoT Full Duration",casted[i][id].spell,casted[i].target)
							end
						end
					end
				end
			end
			D_RT(i,id,reason,fromcst)
		end
		DoTimer_RemoveTimer = Notifications_D_RT
		local D_CST = DoTimer_CreateSpellTimer
		function Notifications_D_CST(spelltable)
			--"DoT Applied to Mob"
			if Notifications_Settings.status then
				local type = spelltable.spell.type
				local timerdata = DoTimer_ReturnData("timerdata")
				if timerdata[type].isreal then
					Notifications_EventOccurred("DoT Applied to Mob",spelltable.spell.spell,spelltable.target.target)
				end
			end
			D_CST(spelltable)
		end
		DoTimer_CreateSpellTimer = Notifications_D_CST
		local D_OU = DoTimer_OnUpdate
		function Notifications_D_OU(elapsed)
			if Notifications_EventHasData("DoT Time Remaining") then
				local casted = DoTimer_ReturnData()
				local timerdata = DoTimer_ReturnData("timerdata")
				for index,value in ipairs(casted) do
					for index2,value2 in ipairs(value) do
						value2.prev = value2.displayed
					end
				end
				D_OU(elapsed)
				for index,value in ipairs(casted) do
					if value.external then
						if value.target == "Cooldowns " then
							for index2,value2 in ipairs(value) do
								local displayed = value2.displayed
								if displayed and (not (displayed == value2.prev)) and math.floor(displayed) == displayed then Notifications_EventOccurred("Cooldown Time Remaining",value2.spell,value2.rank,displayed) end
							end
						end
					else
						for index2,value2 in ipairs(value) do
							if timerdata[value2.type].isreal then
								local displayed = value2.displayed
								if displayed and (not (displayed == value2.prev)) and math.floor(displayed) == displayed then Notifications_EventOccurred("DoT Time Remaining",value2.spell,value.target,displayed) end
							end
						end
					end
				end
			else
				D_OU(elapsed)
			end
		end
		DoTimer_OnUpdate = Notifications_D_OU
	end
	if CooldownsFrame then
		local C_RT = Cooldowns_RemoveTimer
		function Notifications_C_RT(i,reason,fromcst)
			--if reason is "finished", "Finished Cooldown"
			if Notifications_Settings.status then
				if reason == "finished" then
					local casted = Cooldowns_ReturnData()
					if casted[i] then
						local timerdata = Cooldowns_ReturnData("timerdata")
						if timerdata[casted[i].type].isreal then Notifications_EventOccurred("Cooldown Finished",casted[i].spell,"") end
					end
				end
			end
			C_RT(i,reason,fromcst)
		end
		Cooldowns_RemoveTimer = Notifications_C_RT
		local C_OU = Cooldowns_OnUpdate
		function Notifications_C_OU(elapsed)
			if Notifications_EventHasData("Cooldown Time Remaining") and (not Cooldowns_Settings.dotimer) then
				local casted = Cooldowns_ReturnData()
				for index,value in ipairs(casted) do
					value.prev = value.displayed
				end
				C_OU(elapsed)
				for index,value in ipairs(casted) do
					if value.type == "cooldown" then
						local displayed = value.displayed
						if displayed and (not (displayed == value.prev)) and math.floor(displayed) == displayed then Notifications_EventOccurred("Cooldown Time Remaining",value.spell,value.rank,displayed) end
					end
				end
			else
				C_OU(elapsed)
			end
		end
		Cooldowns_OnUpdate = Notifications_C_OU
	end
end

function Notifications_Commands()
	NotificationsMenuFrame:Show()
	Notifications_ClearData()
end

function Notifications_ClearData()
	for index in pairs(currentinfo) do currentinfo[index] = nil end
	NotificationsControlButtonText:SetText("<-- Create New / Manage Existing")
	NotificationsUsageSlider:Hide()
	NotificationsDoneButton:Hide()
	NotificationsUsageSlider:SetValue(0)
	NotificationsTimeEditBox:Hide()
	NotificationsTimeEditBox:SetText("")
	NotificationsTriggerEditBox:Hide()
	NotificationsTriggerEditBox:SetText("")
	NotificationsFormatEditBox:Hide()
	NotificationsFormatEditBox:SetText("")
	NotificationsChatEditBox:Hide()
	NotificationsChatEditBox:SetText("")
	NotificationsSoundEditBox:Hide()
	NotificationsSoundEditBox:SetText("")
	NotificationsColorSwatch:Hide()
	NotificationsColorSwatchNormalTexture:SetVertexColor(1,1,1)
	NotificationsMenuFrameInfo:SetText("")
	NotificationsPartialCheckButton:Hide()
	NotificationsAlertLocSlider:Hide()
	NotificationsAlertLocSlider:SetValue(75)
	NotificationsStatEditBox:Hide()
	NotificationsStatEditBox:SetText("")
	NotificationsPartialCheckButton:SetChecked(false)
	NotificationsEnabledCheckButton:SetChecked(Notifications_Settings.status)
end

function Notifications_OnEvent(event)
	if event == "VARIABLES_LOADED" then Notifications_Startup()
	elseif Notifications_Settings and Notifications_Settings.status then
		if string.find(event,"SPELL_SELF_DAMAGE") then
			local _,spell,target
			--if crit, "Spell Crit Mob"
			--if resist/whatever, "Spell Failed on Mob"
			if Notifications_EventHasData("Spell Crit Mob") then
				for index,value in pairs(critmsgs) do
					_,_,spell,target,damage = string.find(arg1,value)
					if spell and target then
						Notifications_EventOccurred("Spell Crit Mob",spell,target,damage)
						return
					end
				end
			end
			if Notifications_EventHasData("Spell Failed on Mob") then
				for index,value in pairs(failmsgs) do
					_,_,spell,target = string.find(arg1,value)
					if spell and target then
						Notifications_EventOccurred("Spell Failed on Mob",spell,target)
						return
					end
				end
			end
		elseif event == "COMBAT_TEXT_UPDATE" then
			local event
			if arg1 == "AURA_START" then
				event = "Player Buff Gain"
			elseif arg1 == "AURA_START_HARMFUL" then
				event = "Player Debuff Gain"
				local type = GetPlayerBuffDispelType(arg2)
				Notifications_EventOccurred(event,type,UnitName("player"))
			elseif arg1 == "AURA_END" then
				event = "Player Buff Fade"
			elseif arg1 == "AURA_END_HARMFUL" then
				event = "Player Debuff Fade"
			else
				return
			end
			Notifications_EventOccurred(event,arg2,UnitName("player"))
		elseif string.find(event,"PERIODIC_HOSTILEPLAYER_BUFFS") then
			--"Enemy Target Buff Gain"
			local _,_,target,spell = string.find(arg1,enemygainsbuff)
			if spell and (target == UnitName("target") and UnitIsEnemy("player","target")) then
				Notifications_EventOccurred("Enemy Target Buff Gain" ,spell,target)
			end
		elseif string.find(event,"AURA_GONE_OTHER") then
			--"Enemy Target Buff Fade"
			local _,_,spell,target = string.find(arg1,enemylosesbuff)
			if spell and (target == UnitName("target") and UnitIsEnemy("player","target")) then
				Notifications_EventOccurred("Enemy Target Buff/Debuff Fade" ,spell,target)
			end
		elseif string.sub(event,1,19) == "SPELLSYSTEM_SUCCESS" then
			--"Spell Cast/Item Use"
			local event
			if arg3.type == "spell" then event = "Spell Finish Casting" elseif arg3.type == "item" then event = "Item Usage" else return end
			Notifications_EventOccurred(event,arg1.spell,arg2.target)
		elseif event == "UNIT_SPELLCAST_START" and arg1 == "target" then
			if UnitIsEnemy("player","target") then
				local spell = UnitCastingInfo("target")
				Notifications_EventOccurred("Enemy Begin Casting",spell,UnitName("target"))
			end
		elseif event == "UNIT_HEALTH" and arg1 == "player" then
			local health = UnitHealth("player")
			prevhealth = prevhealth or UnitHealthMax("player")
			if Notifications_EventHasData("Health") then
				local evententry = Notifications_MakeTable()
				local eventtable = events["Health"]["all"]
				local flag
				for index,value in ipairs(eventtable) do
					local stat = value["Stat Amount"]
					local dir = value["Stat Direction"]
					if health < prevhealth then
						if dir == "-" and (stat <= prevhealth and stat >= health) then 
							table.insert(evententry,value) 
							flag = 1
						end
					elseif health > prevhealth then
						if dir == "+" and (stat <= health and stat >= prevhealth) then 
							table.insert(evententry,value) 
							flag = 1
						end
					else return
					end
				end
				if flag then Notifications_SendEvents(evententry,"Health","","",health) end
			end
			prevhealth = health
		elseif event == "UNIT_MANA" and arg1 == "player" then
			local mana = UnitMana("player")
			prevmana = prevmana or UnitManaMax("player")
			if Notifications_EventHasData("Mana") then
				local evententry = Notifications_MakeTable()
				local eventtable = events["Mana"]["all"]
				for index,value in ipairs(eventtable) do
					local stat = value["Stat Amount"]
					local dir = value["Stat Direction"]
					local flag
					if mana < prevmana then
						if dir == "-" and (stat <= prevmana and stat >= mana) then 
							table.insert(evententry,value) 
							flag = 1
						end
					elseif mana > prevmana then
						if dir == "+" and (stat <= mana and stat >= prevmana) then 
							table.insert(evententry,value) 
							flag = 1
						end
					else return
					end
				end
				if flag then Notifications_SendEvents(evententry,"Mana","","",mana) end
			end
			prevmana = mana
		elseif event == "PLAYER_TARGETS_CHANGED" then
			if UnitExists("targettarget") then
				prevstate = UnitIsUnit("player","targettarget")
			else
				prevstate = nil
			end
		else
			if not (arg1 == "player") then return end
			if string.find(event,"SENT") then
				spellinfo.spell = arg2
				spellinfo.target = arg4
				spellinfo.flag = true
				if spellinfo.target == "" then spellinfo.target = UnitName("player") end
				if playerclass == "WARLOCK" and UnitExists("target") then
					local texture = SpellSystem_FindInfo(arg2,arg3,"spell")
					if texture == "Interface\\Icons\\Spell_Shadow_Twilight" then
						spellinfo.target = UnitName("target")
					end
				end
			elseif string.find(event,"START") and spellinfo.flag then
				--"Spell Begin Casting"
				Notifications_EventOccurred("Spell Begin Casting",spellinfo.spell,spellinfo.target)
				spellinfo.flag = false
			end
		end
	end
end

function Notifications_NewEvent(event,spell,usage,matching,type,info1,info2,info3,info4,info5,info6,info7,info8,info9)
	if spell == "" then return end
	if events[event] then
		local evententry = {
			Type = type,
		}
		if type == "SCT" or type == "Echo" then
			if info1 == "" then 
				DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: invalid message)")
				return 
			end
			evententry["Message"] = info1
			evententry["Color"] = info2
		elseif type == "Alert" then
			if info1 == "" then 
				DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: invalid message)")
				return 
			end
			evententry["Message"] = info1
			evententry["Color"] = info2
			evententry["Offset"] = info5
		elseif type == "Sound" then
			if info3 == "" then 
				DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: no sound file specified)")
				return
			end
			evententry["Sound"] = info3
		elseif type == "Chat" then
			if info1 == "" then
				DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: invalid message)")
				return
			end
			if info4 == "" then 
				DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: no chat specified)")
				return 
			end
			evententry["Message"] = info1
			evententry["Chat"] = info4
		else
			DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: invalid notification type)")
			return
		end
		evententry["Usage"] = usage
		if string.find(event,"Time Remaining") then 
			if not info6 then 
				DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: invalid time)")
				return 
			end
			evententry["Time"] = info6 
		end
		if event == "Health" or event == "Mana" then
			if not info8 then 
				DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: invalid stat amount)")
				return 
			end
			if not (info9 == "+" or info9 == "-") then 
				DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event failed to be created. (Reason: invalid stat direction)")
				return 
			end
			evententry["Stat Amount"] = info8
			evententry["Stat Direction"] = info9
		end
		if not events[event][spell] then events[event][spell] = {} end
		if usage == "Random" then
			events[event][spell].Percent = info7
		end
		if (not string.find(event,"Time Remaining")) and (not (spell == "all")) then
			events[event][spell].Matching = matching
		end
		table.insert(events[event][spell],evententry)
		DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: New event created successfully!")
	end
end

function Notifications_EventHasData(event)
	for index,value in pairs(events[event]) do return true end
	return false
end

function Notifications_EventOccurred(event,spell,target,damage)
	local evententry
	local eventtable = events[event]
	for index,value in pairs(eventtable) do
		if not (index == "all") and ((not value.Matching) or value.Matching == "Exact") then
			if string.lower(index) == string.lower(spell) then
				evententry = value
			end
		end
	end
	if not evententry then
		for index,value in pairs(eventtable) do
			if not (index == "all") and value.Matching == "Partial" then
				if string.find(string.lower(spell),string.lower(index)) then 
					evententry = value
					break
				end
			end
		end
	end
	if not evententry then evententry = eventtable["all"] end
	if evententry then Notifications_SendEvents(evententry,event,spell,target,damage) end
end

function Notifications_SendEvents(evententry,event,spell,target,damage)
	if evententry then
		local randomentries = Notifications_MakeOtherTable()
		for index,value in ipairs(evententry) do
			if (not string.find(event,"Time Remaining")) or (value["Time"] == damage) then
				if value["Usage"] == "All" then
					Notifications_SendEvent(value,spell,target,damage)
				else
					table.insert(randomentries,value)
				end
			end
		end
		local numrandom = table.getn(randomentries)
		if numrandom > 0 then
			local percent = evententry["Percent"]
			if not percent then evententry["Percent"] = 100 end
			percent = percent / 100
			if math.random() > percent then return end
			local index = math.random(1,numrandom)
			Notifications_SendEvent(randomentries[index],spell,target,damage)
		end
	end
end

function Notifications_SendEvent(event,spell,target,damage)
	if event.Type == "SCT" then
		local msg = string.gsub(event["Message"],"(%%%a)",function(a) if a == "%s" then return spell elseif a == "%t" then return target elseif a == "%d" then return damage else return a end end)
		if SCT then 
			SCT:DisplayText(msg,event["Color"],nil,nil,1) 
		elseif MikSBT then
			local color = event["Color"]
			MikSBT.DisplayMessage(msg,nil,nil,(color.r * 255),(color.g * 255),(color.b * 255))
		elseif IsAddOnLoaded("Blizzard_CombatText") then
			local color = event["Color"]
			CombatText_AddMessage(msg,COMBAT_TEXT_SCROLL_FUNCTION,color.r,color.g,color.b)
		end
	elseif event.Type == "Sound" then
		PlaySoundFile("Interface\\AddOns\\DoTimer\\Extras\\"..event["Sound"])
	elseif event.Type == "Alert" then
		local msg = string.gsub(event["Message"],"(%%%a)",function(a) if a == "%s" then return spell elseif a == "%t" then return target elseif a == "%d" then return damage else return a end end)
		local frame = NotificationsAlertFrame
		local frametext = NotificationsAlertFrameText
		frame:Show()
		frame:SetPoint("CENTER","UIParent","CENTER",0,event["Offset"])
		frametext:SetText(msg)
		frametext:SetTextColor(event["Color"].r,event["Color"].g,event["Color"].b)
	elseif event.Type == "Echo" then
		local msg = string.gsub(event["Message"],"(%%%a)",function(a) if a == "%s" then return spell elseif a == "%t" then return target elseif a == "%d" then return damage else return a end end)
		if DEFAULT_CHAT_FRAME then DEFAULT_CHAT_FRAME:AddMessage(msg,event["Color"].r,event["Color"].g,event["Color"].b) end
	elseif event.Type == "Chat" then
		local chat = event["Chat"]
		chat = string.lower(chat)
		local msg = string.gsub(event["Message"],"(%%%a)",function(a) if a == "%s" then return spell elseif a == "%t" then return target elseif a == "%d" then return damage else return a end end)
		if type(tonumber(chat)) == "number" then
			chat = tonumber(chat)
			local id,name = GetChannelName(chat)
			if id > 0 then
				SendChatMessage(msg,"CHANNEL",nil,id)
				return
			else
				chat = "auto"
			end
		end
		if chat == "auto" then
			if GetNumRaidMembers() > 0 then chat = "raid" elseif GetNumPartyMembers() > 0 then chat = "party" else return end
		end
		if chat == "whisper" then
			if target then SendChatMessage(msg,chat,nil,target) end
		else
			SendChatMessage(msg,chat)
		end
	end
end

function Notifications_CheckTarget(elapsed)
	NotificationsTargetFrame.time = NotificationsTargetFrame.time - elapsed
	if NotificationsTargetFrame.time <= 0 then
		NotificationsTargetFrame.time = .5
		if UnitExists("targettarget") then
			if prevstate then
				if prevstate == "aggro" then 
					if not UnitIsUnit("player","targettarget") then --aggro loss
						Notifications_EventOccurred("Aggro Loss","",UnitName("target"))
					end
				elseif prevstate == "no aggro" then
					if UnitIsUnit("player","targettarget") then --aggro gain
						Notifications_EventOccurred("Aggro Gain","",UnitName("target"))
					end
				end
			end
			prevstate = UnitIsUnit("player","targettarget") and "aggro" or "no aggro"
		else
			prevstate = nil
		end
	end
end

function Notifications_DropDownManage()
	local info
	if SPELLSYSTEM_MENU_LEVEL == 5 then
		local types = Notifications_MakeTable()
		if SPELLSYSTEM_MENU_VALUE[1] == "Type" then
			table.insert(types,"SCT")
			table.insert(types,"Echo")
		elseif SPELLSYSTEM_MENU_VALUE[1] == "Usage" then
			table.insert(types,"All")
			table.insert(types,"Random")
		elseif SPELLSYSTEM_MENU_VALUE[1] == "Stat Direction" then
			table.insert(types,"+")
			table.insert(types,"-")
		end
		for index,value in ipairs(types) do
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = value
			local checked
			if SPELLSYSTEM_MENU_VALUE[2] == value then checked = 1 end
			info.checked = checked
			info.arg1 = SPELLSYSTEM_MENU_VALUE[3]
			info.arg2 = SPELLSYSTEM_MENU_VALUE[1]
			info.func = function(arg1,arg2)
				arg1[arg2] = value
				SpellSystem_CloseDropDownMenus()
			end
			SpellSystem_UIDropDownMenu_AddButton(info,5)	
		end
	elseif SPELLSYSTEM_MENU_LEVEL == 4 then
		if SPELLSYSTEM_MENU_VALUE[1] then
			if type(SPELLSYSTEM_MENU_VALUE[2]) == "table" then
				local value = SPELLSYSTEM_MENU_VALUE[1]
				local currenttable = SPELLSYSTEM_MENU_VALUE[2]
				local newmatchings = {"Partial","Exact"}
				for index2,value2 in ipairs(newmatchings) do
					info = SpellSystem_UIDropDownMenu_CreateInfo()
					info.text = value2
					local checked
					if value == value2 then checked = 1 end
					info.checked = checked
					info.func = function()
						currenttable.Matching = value2
						SpellSystem_CloseDropDownMenus()
					end
					SpellSystem_UIDropDownMenu_AddButton(info,4)
				end
			else
				Notifications_SetInfo("event",SPELLSYSTEM_MENU_VALUE[1])
				Notifications_SetInfo("spell",SPELLSYSTEM_MENU_VALUE[2])
				Notifications_SetInfo("matching",SPELLSYSTEM_MENU_VALUE[3])
				Notifications_AddTypes(4)
			end
		else
			for index,value in pairs(SPELLSYSTEM_MENU_VALUE) do
				info = SpellSystem_UIDropDownMenu_CreateInfo()
				info.text = index
				info.isTitle = 1
				info.notCheckable = 1
				SpellSystem_UIDropDownMenu_AddButton(info,4)
				info = SpellSystem_UIDropDownMenu_CreateInfo()
				if index == "Type" then
					info = SpellSystem_UIDropDownMenu_CreateInfo()
					if (value == "Echo" or value == "SCT") then
						info.hasArrow = 1
						info.textR = .2
						info.textG = 1
						info.textB = 1
					else
						info.notClickable = 1
					end
					info.value = {index,value,SPELLSYSTEM_MENU_VALUE}
					info.notCheckable = 1
					info.text = value
				elseif index == "Color" then
					info.text = "Change me:"
					info.r = value.r
					info.g = value.g
					info.b = value.b
					info.value = value
					info.hasColorSwatch = 1
					info.notCheckable = 1
					info.func = function() SpellSystem_UIDropDownMenuButton_OpenColorPicker() end
					info.swatchFunc = function()
						local color = SPELLSYSTEM_MENU_VALUE
						color.r,color.g,color.b = ColorPickerFrame:GetColorRGB()
					end
					info.cancelFunc = function(prevValues)  
						local color = SPELLSYSTEM_MENU_VALUE
						color.r,color.g,color.b = prevValues.r,prevValues.g,prevValues.b
					end
				elseif index == "Usage" then
					info.text = value
					info.value = {index,value,SPELLSYSTEM_MENU_VALUE}
					info.notCheckable = 1
					info.hasArrow = 1
					info.textR = .2
					info.textG = 1
					info.textB = .2
				elseif index == "Stat Direction" then
					info.text = value
					info.value = {index,value,SPELLSYSTEM_MENU_VALUE}
					info.notCheckable = 1
					info.hasArrow = 1
					info.textR = 1
					info.textG = 1
					info.textB = .2
				else
					info.text = value
					info.notClickable = 1
					info.notCheckable = 1
				end
				SpellSystem_UIDropDownMenu_AddButton(info,4)
			end
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = ""
			info.disabled = 1
			SpellSystem_UIDropDownMenu_AddButton(info,4)
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = "Remove This Entry"
			info.arg1 = SPELLSYSTEM_MENU_VALUE
			info.notCheckable = 1
			info.textR = 1
			info.textG = .3
			info.textB = .3
			info.func = function(arg1)
				for index,value in pairs(events) do
					for index2,value2 in pairs(value) do
						for index3,value3 in ipairs(value2) do
							if value3 == arg1 then
								table.remove(value2,index3)
								if table.getn(value2) == 0 then
									value[index2] = nil
								end
								SpellSystem_CloseDropDownMenus()
								return
							end
						end
					end
				end
			end
			SpellSystem_UIDropDownMenu_AddButton(info,4)
		end
	elseif SPELLSYSTEM_MENU_LEVEL == 3 then
		for index,value in ipairs(SPELLSYSTEM_MENU_VALUE) do
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = "Entry "..index
			info.value = value
			info.hasArrow = 1
			info.notCheckable = 1
			SpellSystem_UIDropDownMenu_AddButton(info,3)
		end	
		if SPELLSYSTEM_MENU_VALUE.Matching then
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = "Matching"
			info.isTitle = 1
			info.notCheckable = 1
			SpellSystem_UIDropDownMenu_AddButton(info,3)
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = SPELLSYSTEM_MENU_VALUE.Matching
			info.value = {SPELLSYSTEM_MENU_VALUE.Matching,SPELLSYSTEM_MENU_VALUE}
			info.notCheckable = 1
			info.hasArrow = 1
			info.textR = .2
			info.textG = 1
			info.textB = .2
			SpellSystem_UIDropDownMenu_AddButton(info,3)
		end
		if SPELLSYSTEM_MENU_VALUE.Percent then
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = "Percent"
			info.isTitle = 1
			info.notCheckable = 1
			SpellSystem_UIDropDownMenu_AddButton(info,3)
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = SPELLSYSTEM_MENU_VALUE.Percent
			info.notCheckable = 1
			info.notClickable = 1
			SpellSystem_UIDropDownMenu_AddButton(info,3)
		end
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = ""
		info.disabled = 1
		SpellSystem_UIDropDownMenu_AddButton(info,3)
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = "Add New Entry"
		local event,spell
		for index,value in pairs(events) do
			for index2,value2 in pairs(value) do
				if value2 == SPELLSYSTEM_MENU_VALUE then
					event = index
					spell = index2
				end
			end
		end
		info.value = {event,spell,SPELLSYSTEM_MENU_VALUE["Matching"]}
		info.notCheckable = 1
		info.textR = .2
		info.textG = 1
		info.textB = 1
		info.hasArrow = 1
		SpellSystem_UIDropDownMenu_AddButton(info,3)
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = "Remove These Entries"
		info.arg1 = SPELLSYSTEM_MENU_VALUE
		info.notCheckable = 1
		info.textR = 1
		info.textG = .3
		info.textB = .3
		info.func = function(arg1)
			for index,value in pairs(events) do
				for index2,value2 in pairs(value) do
					if value2 == arg1 then
						value[index2] = nil
						SpellSystem_CloseDropDownMenus()
						return
					end
				end
			end
		end
		SpellSystem_UIDropDownMenu_AddButton(info,3)
	elseif SPELLSYSTEM_MENU_LEVEL == 2 then
		for index,value in pairs(SPELLSYSTEM_MENU_VALUE) do
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = index
			info.value = value
			info.hasArrow = 1
			info.notCheckable = 1
			SpellSystem_UIDropDownMenu_AddButton(info,2)
			info = SpellSystem_UIDropDownMenu_CreateInfo()
		end
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = ""
		info.disabled = 1
		SpellSystem_UIDropDownMenu_AddButton(info,2)
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = "Remove All Entries"
		info.arg1 = SPELLSYSTEM_MENU_VALUE
		info.notCheckable = 1
		info.textR = 1
		info.textG = .3
		info.textB = .3
		info.func = function(arg1)
			for index,value in pairs(events) do
				if value == arg1 then
					events[index] = {}
					SpellSystem_CloseDropDownMenus()
					return
				end
			end
		end
		SpellSystem_UIDropDownMenu_AddButton(info,2)
	elseif SPELLSYSTEM_MENU_LEVEL == 1 then
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = "List of Events:"
		info.isTitle = 1
		info.notCheckable = 1
		SpellSystem_UIDropDownMenu_AddButton(info)
		for k,v in ipairs(orgeventlist) do
			local index = v
			local value = events[index]
			local hasentries
			if value then
				for i,v in pairs(value) do hasentries = 1 break end
				if hasentries then
					info = SpellSystem_UIDropDownMenu_CreateInfo()
					info.text = index
					info.value = value
					info.hasArrow = 1
					info.notCheckable = 1
					SpellSystem_UIDropDownMenu_AddButton(info)
				end
			end
		end
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = ""
		info.disabled = 1
		SpellSystem_UIDropDownMenu_AddButton(info)
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = "Delete All Entries"
		info.notCheckable = 1
		info.textR = 1
		info.textG = .3
		info.textB = .3
		info.func = function()
			Notifications_Settings.events = nil
			Notifications_Startup()
			SpellSystem_CloseDropDownMenus()
		end
		SpellSystem_UIDropDownMenu_AddButton(info)
	end
end

function Notifications_DropDownCreate()
	local info
	if SPELLSYSTEM_MENU_LEVEL == 5 then
		Notifications_SetInfo("spell",SPELLSYSTEM_MENU_VALUE)
		Notifications_AddTypes(5)
	elseif SPELLSYSTEM_MENU_LEVEL == 4 then
		local entries = Notifications_MakeTable()
		if string.sub(SPELLSYSTEM_MENU_VALUE,1,5) == "spell" then
			local tab = string.sub(SPELLSYSTEM_MENU_VALUE,6)
			for i = 1,GetNumSpellTabs() do
				local name,_,offset,numspells = GetSpellTabInfo(i)
				if name == tab then
					for id = offset + 1,offset + numspells do
						local spell = GetSpellName(id,BOOKTYPE_SPELL)
						entries[spell] = 1
					end
					break
				end
			end
		elseif string.sub(SPELLSYSTEM_MENU_VALUE,1,4) == "item" then
			local itemloc = string.sub(SPELLSYSTEM_MENU_VALUE,5)
			if itemloc == "Inventory" then
				for i = 1,19 do
					local name = GetItemInfo(GetInventoryItemLink("player",i) or "")
					if name then
						entries[name] = 1
					end
				end
			else
				local _,bagid
				if itemloc == "Backpack" then
					bagid = 0
				else
					_,_,bagid = string.find(itemloc,"(%d)")
				end
				for i = 1,GetContainerNumSlots(bagid) do
					local name = GetItemInfo(GetContainerItemLink(bagid,i) or "")
					if name then
						entries[name] = 1
					end	
				end
			end
		end
		entries = Notifications_Sort(entries)
		for index,value in pairs(entries) do
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.hasArrow = 1
			info.value = value
			info.notCheckable = 1
			info.text = value	
			SpellSystem_UIDropDownMenu_AddButton(info,4)
		end
	elseif SPELLSYSTEM_MENU_LEVEL == 3 then
		if SPELLSYSTEM_MENU_VALUE == "all" then
			Notifications_SetInfo("spell","all")
			Notifications_AddTypes(3)
		elseif SPELLSYSTEM_MENU_VALUE == "other" then
			Notifications_SetInfo("spell","other")
			Notifications_AddTypes(3)
		else
			local nextentries
			if SPELLSYSTEM_MENU_VALUE == "spell" then
				nextentries = Notifications_MakeTable()
				for i = 1,GetNumSpellTabs() do
					local name = GetSpellTabInfo(i)
					table.insert(nextentries,name)
				end
			elseif SPELLSYSTEM_MENU_VALUE == "item" then
				nextentries = {"Inventory","Backpack","Bag 1","Bag 2","Bag 3","Bag 4"}
			end
			for index,value in ipairs(nextentries) do
				info = SpellSystem_UIDropDownMenu_CreateInfo()
				info.text = value
				info.value = SPELLSYSTEM_MENU_VALUE..value
				info.hasArrow = 1
				info.notCheckable = 1
				SpellSystem_UIDropDownMenu_AddButton(info,3)
			end
		end
	elseif SPELLSYSTEM_MENU_LEVEL == 2 then
		Notifications_SetInfo("event",SPELLSYSTEM_MENU_VALUE)
		if specialevents[SPELLSYSTEM_MENU_VALUE] or miscevents[SPELLSYSTEM_MENU_VALUE] then
			Notifications_AddTypes(2)
		else
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = "Choose a Trigger:"
			info.isTitle = 1
			info.notCheckable = 1
			SpellSystem_UIDropDownMenu_AddButton(info,2)
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = "all"
			info.value = "all"
			info.hasArrow = 1
			info.notCheckable = 1
			SpellSystem_UIDropDownMenu_AddButton(info,2)
			if not (string.sub(SPELLSYSTEM_MENU_VALUE,1,4) == "Item") then
				info = SpellSystem_UIDropDownMenu_CreateInfo()
				info.text = "Spell"
				info.value = "spell"
				info.hasArrow = 1
				info.notCheckable = 1
				SpellSystem_UIDropDownMenu_AddButton(info,2)
			end
			if not ((string.sub(SPELLSYSTEM_MENU_VALUE,1,3) == "DoT") or (string.sub(SPELLSYSTEM_MENU_VALUE,1,5) == "Spell")) then
				info = SpellSystem_UIDropDownMenu_CreateInfo()
				info.text = "Item"
				info.value = "item"
				info.hasArrow = 1
				info.notCheckable = 1
				SpellSystem_UIDropDownMenu_AddButton(info,2)
			end
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			if not string.find(SPELLSYSTEM_MENU_VALUE,"Time Remaining") then
				info.text = "Other..."
				info.value = "other"
				info.tooltipTitle = "Note"
				info.tooltipText = "Pick this option if you cannot find the trigger you want, or if you want to set a partial match."
				info.hasArrow = 1
				info.notCheckable = 1
				SpellSystem_UIDropDownMenu_AddButton(info,2)
			end
		end
	elseif SPELLSYSTEM_MENU_LEVEL == 1 then
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = "Choose an Event:"
		info.isTitle = 1
		info.notCheckable = 1
		SpellSystem_UIDropDownMenu_AddButton(info)
		for k,v in ipairs(orgeventlist) do
			local index = v
			local value = events[index]
			info = SpellSystem_UIDropDownMenu_CreateInfo()
			info.text = index
			info.value = index
			info.hasArrow = 1
			info.notCheckable = 1
			info.tooltipTitle = "Info"
			info.tooltipText = regevents[index] or specialevents[index] or miscevents[index]
			SpellSystem_UIDropDownMenu_AddButton(info)
		end
	end
end

local sorttable = {}
function Notifications_Sort(pretable)
	for index,value in pairs(sorttable) do sorttable[index] = nil end
	for index,value in pairs(pretable) do table.insert(sorttable,index) end
	table.sort(sorttable)
	return sorttable
end

function Notifications_AddTypes(level)
	local info
	info = SpellSystem_UIDropDownMenu_CreateInfo()
	info.text = "Choose a Type:"
	info.isTitle = 1
	info.notCheckable = 1
	SpellSystem_UIDropDownMenu_AddButton(info,level)
	local types = {
		["SCT"] = "Send a message through Scrolling Combat Text, or Mik's Scrolling Battle Text, or Blizzard Floating Combat Text (make sure you have it enabled in Interface Options!) if SCT and MikSBT are not installed.",
		["Echo"] = "Create a message in your chat box only you can see.",
		["Sound"] = "Play a sound file.",
		["Alert"] = "Create a large message in the middle of the screen.",
		["Chat"] = "Send a message to others.",
	}
	for index,value in pairs(types) do
		info = SpellSystem_UIDropDownMenu_CreateInfo()
		info.text = index
		info.value = index
		info.notCheckable = 1
		info.arg1 = index
		info.tooltipTitle = index
		info.tooltipText = value
		info.func = function(arg1) Notifications_SetInfo("Type",arg1) SpellSystem_CloseDropDownMenus() end
		SpellSystem_UIDropDownMenu_AddButton(info,level)
	end
end

function Notifications_SetInfo(type,info)
	currentinfo[type] = info
	if type == "Type" then
		local msg = string.format("Current Config: \nEvent: |cff00ff00%s|r \nType: |cff00ff00%s|r",currentinfo.event,currentinfo.Type)
		if currentinfo.spell and (not (currentinfo.spell == "other")) then
			NotificationsTriggerEditBox:SetText(currentinfo.spell)
		end
		if string.find(currentinfo.event,"Time Remaining") then
			NotificationsTimeEditBox:Show()
		else
			NotificationsTriggerEditBox:Show()
		end
		if miscevents[currentinfo.event] then
			NotificationsTriggerEditBox:SetText("all")
			NotificationsTriggerEditBox:Hide()
			currentinfo.spell = "all"
			if not string.find(currentinfo.event,"Aggro") then
				NotificationsStatEditBox:Show()
			end
		end
		if (not currentinfo.spell) or (currentinfo.spell == "other") then NotificationsPartialCheckButton:Show() else NotificationsPartialCheckButton:Hide() end
		NotificationsMenuFrameInfo:SetText(msg)
		NotificationsUsageSlider:Show()
		NotificationsDoneButton:Show()
		if currentinfo.matching == "Partial" then NotificationsPartialCheckButton:SetChecked(true) end
		if info == "SCT" or info == "Echo" then
			NotificationsFormatEditBox:Show()
			NotificationsColorSwatch:Show()
		elseif info == "Alert" then
			NotificationsAlertLocSlider:Show()
			NotificationsFormatEditBox:Show()
			NotificationsColorSwatch:Show()
		elseif info == "Sound" then
			NotificationsSoundEditBox:Show()
		elseif info == "Chat" then
			NotificationsFormatEditBox:Show()
			NotificationsChatEditBox:Show()
		end
	end
end

function Notifications_ParseMenu()
	if currentinfo.Type then
		local event = currentinfo.event
		local spell = NotificationsTriggerEditBox:GetText()
		local type = currentinfo.Type
		local usage
		local value = NotificationsUsageSlider:GetValue()
		if value == 0 then usage = "All" else usage = "Random" end
		local formatmsg = NotificationsFormatEditBox:GetText()
		local r,g,b = NotificationsColorSwatchNormalTexture:GetVertexColor()
		local color = {r = r, g = g, b = b}
		local chat = NotificationsChatEditBox:GetText()
		local sound = NotificationsSoundEditBox:GetText()
		local matching = NotificationsPartialCheckButton:GetChecked() and "Partial" or "Exact"
		local offset = NotificationsAlertLocSlider:GetValue()
		local time = tonumber(NotificationsTimeEditBox:GetText())
		local stat = NotificationsStatEditBox:GetText()
		local statamount = tonumber(string.sub(stat,2))
		local statdir = string.sub(stat,1,1)
		Notifications_NewEvent(event,spell,usage,matching,type,formatmsg,color,sound,chat,offset,time,value,statamount,statdir)
		Notifications_ClearData()
	end
end
