local castingspell = {
	spell = {},
	target = {},
	type = {},
}
local nodataspell
local potentialtarget = {}
local queuetarget = {}
local playertarget = {
	target = UnitName("player"),
	sex = UnitSex("player"),
	level = UnitLevel("player"),
	type = "player",
	icon = GetRaidTargetIndex("player") or 0,
	unit = "player",
}
local listeners = {
	["SPELLSYSTEM_SUCCESS"] = {},
	["SPELLSYSTEM_SUCCESS_NODATA"] = {},
}
local debugging = false
function SpellSystem_Debug(text)
	if debugging then DEFAULT_CHAT_FRAME:AddMessage(text) end
end
local parseddata
local inqueue
local spelltype
local correctdata
local loaded
local playerclass

function SpellSystem_ReturnVersion()
	return "2.2.2"
end

function SpellSystem_ReturnDateUploaded()
	return "January 15, 2007"
end

function SpellSystem_ToggleDebugs()
	debugging = not debugging
end

function SpellSystem_Startup()
	DEFAULT_CHAT_FRAME:AddMessage("The following addons by |cff00ffffAsheyla|r have been loaded:")
	if DoTimerFrame then DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffDoTimer|r: |cff00ff00/dotimer|r or |cff00ff00/dot|r") end
	if CooldownsFrame then DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffCooldowns|r: |cff00ff00/cooldowns|r or |cff00ff00/cd|r") end
	if CommunicationFrame then DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffCommunication|r: |cff00ff00/comm|r") end
	if NotificationsFrame then DEFAULT_CHAT_FRAME:AddMessage("|cff00ffffNotifications|r: |cff00ff00/notifications|r or |cff00ff00/not|r") end
	notargetdata = {
		spell = {
			spell = "",
			rank = "",
			texture = GetSpellTexture(1,BOOKTYPE_SPELL),
		},
		type = {
			id = 1,
			type = BOOKTYPE_SPELL,
		},
		target = {
			target = UnitName("player"),
			sex = UnitSex("player"),
			level = UnitLevel("player"),
			icon = 0,
		},
	}
	local _,class = UnitClass("player")
	playerclass = class
	loaded = 1
	this:UnregisterEvent("PLAYER_ENTERING_WORLD")
end

function SpellSystem_OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("UNIT_SPELLCAST_SENT")
	this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	local oldfunc = WorldFrame:GetScript("OnMouseDown")
	if not oldfunc then oldfunc = function() end end
	WorldFrame:SetScript("OnMouseDown",function(self,button) oldfunc(self,button); SpellSystem_OnWorldClick(self,button); end)
end

function SpellSystem_OnEvent(event)
	if event == "PLAYER_ENTERING_WORLD" then SpellSystem_Startup() end
	if not (arg1 == "player") then return end
	SpellSystem_Debug(event)
	if event == "UNIT_SPELLCAST_SENT" then
		correctdata = true
		castingspell.spell.spell = arg2
		castingspell.spell.rank = arg3
		castingspell.target.target = arg4
		SpellSystem_Debug("spellsystem: "..arg2.."("..arg3..") has begun to be cast on "..arg4)
		parseddata = nil
		local unit
		local target = arg4
		if (UnitName("player") == target) then unit = "player" elseif UnitName("target") == target then unit = "target" end
		if unit then SpellSystem_CreateTargetInfo(unit) end
		if inqueue then
			if queuetarget.target == target then
				potentialtarget = queuetarget 
				parseddata = 1
			end
			inqueue = nil
		end
		if playerclass == "WARLOCK" and UnitExists("target") then
			local texture = SpellSystem_FindInfo(arg2,arg3,"spell")
			if texture == "Interface\\Icons\\Spell_Shadow_Twilight" then
				castingspell.target.target = UnitName("target")
				SpellSystem_CreateTargetInfo("target")
			end
		end
	elseif event == "UNIT_SPELLCAST_SUCCEEDED" then
		SpellSystem_Success()
	end
end

function SpellSystem_Success()
	if correctdata and spelltype then
		if castingspell.target.target == "" then
			castingspell.target = playertarget
			parseddata = 1
		else
			castingspell.target = potentialtarget
		end
		if parseddata then
			castingspell.spell.texture,castingspell.type.type,castingspell.type.id = SpellSystem_FindInfo(arg2,arg3,spelltype)
			SpellSystem_Debug("spellsystem: "..castingspell.spell.spell.." has been successfully cast on "..castingspell.target.target)
			SpellSystem_Debug("spellsystem: "..castingspell.type.type..":"..(castingspell.type.type == "spell" and "true" or "false"))
			SpellSystem_SendEvent("SPELLSYSTEM_SUCCESS")
		end
	else
		if loaded then
			SpellSystem_Debug("sending an event with no real data for "..arg2)
			local temp = castingspell
			castingspell = notargetdata
			castingspell.spell.spell,castingspell.spell.rank = arg2,arg3
			SpellSystem_SendEvent("SPELLSYSTEM_SUCCESS_NODATA")
			castingspell = temp
		end
	end
	correctdata = false
end

function SpellSystem_SendEvent(newevent)
	if table.getn(listeners[newevent]) > 0 then
		local savedevent = event
		local savedarg1 = arg1
		local savedarg2 = arg2
		local savedarg3 = arg3
		local temp = castingspell.spell.spell
		castingspell.spell.spell = (castingspell.type.type == "item" and castingspell.spell.item or castingspell.spell.spell)
		event = newevent
		arg1 = castingspell.spell
		arg2 = castingspell.target
		arg3 = castingspell.type
		for index,value in ipairs(listeners[event]) do 
			if type(value) == "function" then value(event) end
		end
		event = savedevent
		arg1 = savedarg1
		arg2 = savedarg2
		arg3 = savedarg3
		castingspell.spell.spell = temp
	end
end

function SpellSystem_RegisterEvent(eventfunc,eventname)
	if listeners[eventname] then
		table.insert(listeners[eventname],eventfunc)
	end
end

function SpellSystem_UnregisterEvent(eventfunc,eventname)
	if listeners[eventname] then
		for index,value in pairs(listeners[eventname]) do
			if value == eventfunc then
				table.remove(listeners[eventname],index)
			end
		end
	end
end

function SpellSystem_CreateTargetInfo(unit)
	if UnitExists(unit) then
		parseddata = 1
		SpellSystem_Debug("spellsystem: initiating data for spellcast")
		potentialtarget.target = UnitName(unit)
		potentialtarget.sex = UnitSex(unit)
		potentialtarget.level = UnitLevel(unit)
		potentialtarget.type = SpellSystem_ReturnTargetType(unit)
		potentialtarget.icon = GetRaidTargetIndex(unit) or 0
		potentialtarget.unit = unit
	end
end

function SpellSystem_QueueTargetInfo(unit)
	if UnitExists(unit) then
		inqueue = 1
		SpellSystem_Debug("spellsystem: queuing data for spellcast")
		queuetarget.target = UnitName(unit)
		queuetarget.sex = UnitSex(unit)
		queuetarget.level = UnitLevel(unit)
		queuetarget.type = SpellSystem_ReturnTargetType(unit)
		queuetarget.icon = GetRaidTargetIndex(unit) or 0
		queuetarget.unit = unit
	end
end

function SpellSystem_ReturnTargetType(unit)
	if (UnitIsPlayer(unit) or UnitPlayerControlled(unit)) then return "player" end
	local type = UnitClassification(unit)
	if type == "worldboss" or type == "rare" or type == "rareelite" then return "specialmob" end
	return "mob"
end

function SpellSystem_ReturnRank(spell) 
	local highrank = ""
	local i = 1
	while GetSpellName(i,BOOKTYPE_SPELL) do
		local spellname,spellrank = GetSpellName(i,BOOKTYPE_SPELL)
		if spellname == spell then highrank = spellrank end
		i = i + 1
	end
	return highrank
end

function SpellSystem_FindInfo(query,queryrank,type)
	if type then
		if type == "spell" then
			local i = 1
			local name,rank = GetSpellName(i,BOOKTYPE_SPELL)
			while name do
				if name == query and (queryrank == "" or queryrank == rank) then 
					local texture = GetSpellTexture(i,BOOKTYPE_SPELL)
					return texture,BOOKTYPE_SPELL,i
				end
				i = i + 1
				name,rank = GetSpellName(i,BOOKTYPE_SPELL)
			end
			i = 1
			name,rank = GetSpellName(i,BOOKTYPE_PET)
			while name do
				if name == query and (queryrank == "" or queryrank == rank) then 
					local texture = GetSpellTexture(i,BOOKTYPE_PET)
					return texture,BOOKTYPE_PET,i
				end
				i = i + 1
				name,rank = GetSpellName(i,BOOKTYPE_PET)
			end
		elseif type == "item" then
			for b = 0,4 do
				for s = 1,GetContainerNumSlots(b) do
					local name = GetItemInfo(GetContainerItemLink(b,s) or "") or ""
					if name == query then
						local texture = GetContainerItemInfo(b,s)
						local itemid = SpellSystem_ParseString(GetContainerItemLink(b,s),"item:(%d+)")
						return texture,"item",itemid
					end
					name = GetItemSpell(GetContainerItemLink(b,s) or "") or ""
					if name == query then
						local texture = GetContainerItemInfo(b,s)
						local itemid = SpellSystem_ParseString(GetContainerItemLink(b,s),"item:(%d+)")
						return texture,"item",itemid
					end
				end
			end
			for i = 1,19 do
				local name = GetItemInfo(GetInventoryItemLink("player",i) or "") or ""
				if name == query then
					local texture = GetInventoryItemTexture("player",i)
					local itemid = SpellSystem_ParseString(GetInventoryItemLink("player",i),"item:(%d+)")
					return texture,"item",itemid
				end
				name = GetItemSpell(GetInventoryItemLink("player",i) or "") or ""
				if name == query then
					local texture = GetInventoryItemTexture("player",i)
					local itemid = SpellSystem_ParseString(GetInventoryItemLink("player",i),"item:(%d+)")
					return texture,"item",itemid
				end
			end
		elseif string.sub(type,1,6) == "action" then
			local action = string.sub(type,7)
			local texture = GetActionTexture(action)
			local stype,id = GetActionInfo(action)
			if stype == "item" then castingspell.spell.item = GetItemInfo(id) end
			return texture,stype,id
		end
	end
	local texture = GetSpellTexture(1,BOOKTYPE_SPELL)
	return texture,BOOKTYPE_SPELL,1
end

function SpellSystem_ReturnPetID(query)
	local i = 1
	local name = GetSpellName(i,BOOKTYPE_PET)
	while name do
		if name == query then 
			return i
		end
		i = i + 1
		name = GetSpellName(i,BOOKTYPE_PET)
	end
	return 1
end

function SpellSystem_ReturnItemLink(itemid)
	local _,itemlink = GetItemInfo(itemid)
	return itemlink
end

function SpellSystem_SpellFromPlayer(spell)
	local i = 1
	local name = GetSpellName(i,BOOKTYPE_SPELL)
	while name do
		if name == spell then return true end
		i = i + 1
		name = GetSpellName(i,BOOKTYPE_SPELL)
	end
	return false
end

function SpellSystem_Capitalize(type,query,queryrank)
	if type == "spell" then
		local i = 1
		local name,rank = GetSpellName(i,BOOKTYPE_SPELL)
		while name do
			if string.lower(name) == string.lower(query) then
				return name
			end
			i = i + 1
			name,rank = GetSpellName(i,BOOKTYPE_SPELL)
		end
	elseif type == "rank" then
		local i = 1
		local name,rank = GetSpellName(i,BOOKTYPE_SPELL)
		while name do
			if string.lower(name) == string.lower(query) and string.lower(rank) == string.lower(queryrank) then
				return name,rank
			end
			i = i + 1
			name,rank = GetSpellName(i,BOOKTYPE_SPELL)
		end
	elseif type == "item" then
		for b = 0,4 do
			for s = 1,GetContainerNumSlots(b) do
				local name = GetItemInfo(GetContainerItemLink(b,s) or "") or ""
				if string.lower(name) == string.lower(query) then
					return name
				end
			end
		end
		for i = 1,19 do
			local name = GetItemInfo(GetInventoryItemLink("player",i) or "") or ""
			if string.lower(name) == string.lower(query) then
				return name
			end
		end
	end
	return query,queryrank
end

local function CSBN(spell,unit)
	spelltype = "spell"
	if unit then
		local spellname,spellrank
		spellrank = SpellSystem_ParseString(spell,"%((.-)%)",-1)
		if spellrank then
			spellname = string.gsub(spell,"(.-)%("..spellrank.."%).*","%1")
		else
			spellname = string.gsub(spell,"([%s;]*)$","")
			spellrank = ""
		end
		spellname = SpellSystem_Capitalize("spell",spellname)
		if spellrank == "" then 
			spellrank = SpellSystem_ReturnRank(spellname)
		else
			spellrank = SpellSystem_Capitalize("rank",spellname,spellrank)
		end
		if not SpellSystem_SpellFromPlayer(spellname) then return end
		SpellSystem_Debug("csbn:"..spell..":"..spellname..":"..spellrank..":"..unit..":"..(UnitName(unit) or "noexists"))
		if castingspell.spell.spell == spellname and castingspell.spell.rank == spellrank and (castingspell.target.target == UnitName(unit)) then
			SpellSystem_CreateTargetInfo(unit)
		end
	else
		local target = castingspell.target.target
		if target then
			if (UnitName("player") == target) then unit = "player" elseif UnitName("target") == target then unit = "target" else return end
			SpellSystem_CreateTargetInfo(unit)
		end
	end
end
hooksecurefunc("CastSpellByName",CSBN)

local function CS(id,book,unit)
	spelltype = "spell"
	if unit then
		local spellname,spellrank = GetSpellName(id,book)
		if book == BOOKTYPE_PET then return end
		if castingspell.spell.spell == spellname and castingspell.spell.rank == spellrank and (castingspell.target.target == UnitName(unit)) then
			SpellSystem_CreateTargetInfo(unit)
		end
	else
		local target = castingspell.target.target
		if target then
			if (UnitName("player") == target) then unit = "player" elseif UnitName("target") == target then unit = "target" else return end
			SpellSystem_CreateTargetInfo(unit)
		end
	end
end
hooksecurefunc("CastSpell",CS)

local function CSF(index)
	spelltype = "spell"
end
hooksecurefunc("CastShapeshiftForm",CSF)

local function UII(id,unit)
	spelltype = "item"
	local link = GetInventoryItemLink("player",id)
	if not link then return end
	castingspell.spell.item = GetItemInfo(link)
	if unit then
		local name,rank = GetItemSpell(link)
		if castingspell.spell.spell == name and castingspell.spell.rank == rank and (castingspell.target.target == UnitName(unit)) then
			SpellSystem_CreateTargetInfo(unit)
		end
	else
		local target = castingspell.target.target
		if target then
			if (UnitName("player") == target) then unit = "player" elseif UnitName("target") == target then unit = "target" else return end
			SpellSystem_CreateTargetInfo(unit)
		end
	end
end
hooksecurefunc("UseInventoryItem",UII)

local function UCI(b,s,unit)
	spelltype = "item"
	local link = GetContainerItemLink(b,s)
	if not link then return end
	castingspell.spell.item = GetItemInfo(link)
	if unit then
		local name,rank = GetItemSpell(link)
		if castingspell.spell.spell == name and castingspell.spell.rank == rank and (castingspell.target.target == UnitName(unit)) then
			SpellSystem_CreateTargetInfo(unit)
		end	
	else
		local target = castingspell.target.target
		if target then
			if (UnitName("player") == target) then unit = "player" elseif UnitName("target") == target then unit = "target" else return end
			SpellSystem_CreateTargetInfo(unit)
		end
	end
end
hooksecurefunc("UseContainerItem",UCI)

local function UIBN(item,unit)
	spelltype = "item"
	item = SpellSystem_Capitalize("item",item)
	castingspell.spell.item = item
	if unit then
		local name,rank = GetItemSpell(item)
		if castingspell.spell.spell == name and castingspell.spell.rank == rank and (castingspell.target.target == UnitName(unit)) then
			SpellSystem_CreateTargetInfo(unit)
		end	
	else
		local target = castingspell.target.target
		if target then
			if (UnitName("player") == target) then unit = "player" elseif UnitName("target") == target then unit = "target" else return end
			SpellSystem_CreateTargetInfo(unit)
		end
	end
end
hooksecurefunc("UseItemByName",UIBN)

local function UA(action,unit,button)
	local type = GetActionInfo(action)
	if not (type == "macro") then spelltype = "action"..action end
end
hooksecurefunc("UseAction",UA)

local function STU(unit)
	if (not SpellIsTargeting()) then
		SpellSystem_CreateTargetInfo(unit)
	end
end
hooksecurefunc("SpellTargetUnit",STU)

local function TU(unit)
	if (not SpellIsTargeting()) and SpellSystem_ValidUnit(unit) then
		SpellSystem_CreateTargetInfo(unit)
	end
end
hooksecurefunc("TargetUnit",TU)

function SpellSystem_OnWorldClick(self,button)
	if UnitExists("mouseover") and button == "LeftButton" and SpellIsTargeting() and SpellCanTargetUnit("mouseover") then
		SpellSystem_QueueTargetInfo("mouseover")
	end
end

function SpellSystem_ValidUnit(query)
	query = string.lower(query)
	query = string.gsub(query,"target","")
	query = string.gsub(query,"pet","")
	if query == "" or query == "player" or query == "mouseover" or query == "npc" or query == "focus" or string.find(query,"^raid%d+$") or string.find(query,"^party%d+$") then return true end
	return false
end	

function SpellSystem_ParseString(text,...) 
	local entries = {}
	local start = 1
	local savetext = text
	for i = 1,select("#",...),2 do
    	local search = select(i,...)
		local newsearch,starter,ender = search,"",""
		if string.sub(search,1,1) == "^" then
			newsearch = string.sub(newsearch,2)
			starter = "^"
		end
		if string.sub(search,string.len(search)) == "$" then
			newsearch = string.sub(newsearch,1,string.len(newsearch)-1)
			ender = "$"
		end
        local numfound = 0
		if not string.find(search,"%(") then
		    if string.find(text,search) then
				numfound = 1
				table.insert(entries,true)
			end
		else
			while string.find(text,search) do				
				numfound = numfound + 1
				local found = {string.find(text,string.format("%s(%s)%s",starter,newsearch,ender))}
				local oldtext = text
				text = string.gsub(text,string.gsub(found[3],"(%p)","%%%1"),"",1)
				for id = 4,table.getn(found) do table.insert(entries,found[id]) end
				if text == oldtext then
					
					break
				end
			end
			if select(i + 1,...) and numfound > 0 then
				local nextarg = select(i + 1,...)
			    local numcaps = (table.getn(entries) - start + 1) / numfound
			    local numstart
				if nextarg < 0 then numstart = start elseif nextarg > 0 then numstart = start + (numcaps * nextarg) end
     			for id = 1,((numfound - math.abs(nextarg)) * numcaps) do table.remove(entries,numstart) end
			end
		end
		if numfound == 0 then table.insert(entries,false) end
		start = table.getn(entries) + 1
		text = savetext
	end
	for index,value in ipairs(entries) do
		if type(tonumber(value)) == "number" then entries[index] = tonumber(value) end
	end
	return unpack(entries)
end

function SpellSystem_Copy(oldtable)
	local newtable = {}
	for index,value in pairs(oldtable) do
		if type(value) == "table" then
			newtable[index] = SpellSystem_Copy(value)
		else
			newtable[index] = value
		end
	end
	return newtable
end

function SpellSystem_TestEvents()
	local f = CreateFrame("Frame")
	f:SetScript("OnEvent",function()
		SpellSystem_Debug(event..":"..arg1.spell..":"..arg2.target)
	end)
	SpellSystem_RegisterEvent(f:GetScript("OnEvent"),"SPELLSYSTEM_SUCCESS")
	SpellSystem_RegisterEvent(f:GetScript("OnEvent"),"SPELLSYSTEM_FAIL")
end
