;************************************************************************************************
;*	KONYHAI IDZT ELEKTRONIKA PIC16F628-AL
;*		
;************************************************************************************************
;*	2005.02.17. -		(PIC16F628)
;************************************************************************************************
;*	VERZISZM	:	0.0
;************************************************************************************************
;*	UTOLS FRISSITS : 2005.06.22.
;************************************************************************************************
;*	RGI LBKIOSZTS :	RB0	NYOMGOMB
;*			RB1	7-SZEGMENS KIJ.
;*			RB2	7-SZEGMENS KIJ.
;*			RB3	7-SZEGMENS KIJ.
;*			RB4	7-SZEGMENS KIJ.
;*			RB5	7-SZEGMENS KIJ.
;*			RB6	7-SZEGMENS KIJ.
;*			RB7	7-SZEGMENS KIJ.
;*			RA0	1. KIJ. ENGEDLYEZS
;*			RA1	2. KIJ. ENGEDLYEZS
;*			RA2	ANALG BEMENET1
;*			RA3	ANALG BEMENET2
;*			RA4	HANGJELZS KIMENET
;*			RA5	TELEP ELLENRZS ENGEDLYEZS
;*			RA6	7-SZEGMENS KIJ.
;*			RA7	3. KIJ. ENGEDLYEZS
;************************************************************************************************
;*	J LBKIOSZTS :	RB0	NYOMGOMB
;*			RB1	7-SZEGMENS KIJ.
;*			RB2	7-SZEGMENS KIJ.
;*			RB3	7-SZEGMENS KIJ.
;*			RB4	7-SZEGMENS KIJ.
;*			RB5	7-SZEGMENS KIJ.
;*			RB6	7-SZEGMENS KIJ.
;*			RB7	7-SZEGMENS KIJ.
;*			RA0	1. KIJ. ENGEDLYEZS
;*			RA1	ANALG BEMENET1		*
;*			RA2	ANALG BEMENET2		*
;*			RA3	2. KIJ. ENGEDLYEZS	*
;*			RA4	TELEP ELLENRZS ENGEDLYEZS	*
;*			RA5	HANGJELZS KIMENET		*
;*			RA6	7-SZEGMENS KIJ.
;*			RA7	3. KIJ. ENGEDLYEZS
;************************************************************************************************
;*	MKDS LERSA :	VGRE RENDESEN MKDIK
;*			
;************************************************************************************************
;*	
;*	
;*	
;*	
;*	
;************************************************************************************************

	PROCESSOR	16F628

;************************************************************************************************
;*	TESZTELSI SEGDLET
;************************************************************************************************
TESZT		SET	.0			;HA 1, AKKOR A PROGRAMOT TESZTELJK
SLEEP_OK	SET	.0			;HA 1, AKKOR SLEEP ZEMMDDAL HASZNLJUK A PIC-ET



;************************************************************************************************
;*	FELHASZNLT LLANDK
;************************************************************************************************
	IF	(TESZT==.0)
IDO_ALAP_0.01_GYARI	EQU	.20		;ENNYI MEGSZAKTST SZMLLUNK A 0.01 SEC-HOZ
IDO_ALAP_SEC_GYARI	EQU	.100		;ENNYI SZAZADSECET SZMLLUNK A SEC-HOZ
GOMB_PRELL_GYARI	EQU	.3		;ENNYI SZAZADSEC IDEIG PRELLMENTESTJUK A GOMBOT
KIJ_GYARI		EQU	.3		;ENNYI MEGSZAKTS UTN LPNK A KVETKEZ SZEGMENSRE
GOMB_DUPLA_GYARI	EQU	.20		;HA ENNYI IDN BELL KTSZER NYOMUNK, AKKOR DUPLNAK SZMT
GOMB_HOSSZU_GYARI	EQU	.150		;HA ENNYI IDEIG NYOMVA TARTJUK, AKKOR HOSSZAN LENYOMVA VAN
IDOZIT_KESL_GYARI	EQU	.200		;AZ ID BELLTSA UTN ENNYISZER 0.01SEC IDVEL KEZDI EL A VISSZASZMLLST
IDO_LEP_10SEC		EQU	.3		;EGY GOMBNYOMSRA ENNYISZER 10 MSODPERCET NVELNK
HOSSZU_ISM_GYARI	EQU	.20		;ENNYISZER 0.01SEC IDKZNKNT NVELJK AZ IDZTST HOSSZ GOMBNYOMSKOR
HANG_IDOTARTAM_GYARI	EQU	.10		;ENNYI SEC IDEIG TART A HANGJELZS
HANG_BE_GYARI		EQU	.1		;ENNYISZER 0.001SEC IDEIG VAN BEKAPCSOLVA A HANGSZR(HANGJELZS FREKVENCIJT BEFOLYSOLJA)
HANG_KI_GYARI		EQU	.1		;ENNYISZER 0.001SEC IDEIG VAN KIKAPCSOLVA A HANGSZR(HANGJELZS FREKVENCIJT BEFOLYSOLJA)
HANG_SZOL_GYARI		EQU	.80		;ENNYISZER 0.01SEC IDEIG SZL A HANG FOLYAMATOSAN
HANG_SZUNET_GYARI	EQU	.50		;ENNYISZER 0.01SEC IDEIG VAN SZNET A CSIPOGSOK KZTT
KIJELZO_EL_GYARI	EQU	.5		;ENNYI SEC IDEIG L A KIJELZ GOMBNYOMS UTN
SLEEP_GYARI		EQU	.5		;ENNYI SEC IDVEL A HANGJELZS BEFEJEZSE UTN KIKAPCSOL A PROCI
	ENDIF

	IF	(TESZT==.1)
IDO_ALAP_0.01_GYARI	EQU	.2		;ENNYI MEGSZAKTST SZMLLUNK A 0.01 SEC-HOZ
IDO_ALAP_SEC_GYARI	EQU	.4		;ENNYI TIZEDSECET SZMLLUNK A SEC-HOZ
GOMB_PRELL_GYARI	EQU	.2		;ENNYI MEGSZAKTS IDEIG PRELLMENTESTJUK A GOMBOT
KIJ_GYARI		EQU	.3		;ENNYI MEGSZAKTS UTN LPNK A KVETKEZ SZEGMENSRE
GOMB_DUPLA_GYARI	EQU	.10		;HA ENNYI IDN BELL KTSZER NYOMUNK, AKKOR DUPLNAK SZMT
GOMB_HOSSZU_GYARI	EQU	.2		;HA ENNYI IDEIG NYOMVA TARTJUK, AKKOR HOSSZAN LENYOMVA VAN
IDOZIT_KESL_GYARI	EQU	.2		;AZ ID BELLTSA UTN ENNYI IDVEL KEZDI EL A VISSZASZMLLST
IDO_LEP_10SEC		EQU	.3		;EGY GOMBNYOMSRA ENNYISZER 10 MSODPERCET NVELNK
HOSSZU_ISM_GYARI	EQU	.2		;ENNYI IDKZNKNT NVEJK AZ IDZTST HOSSZ GOMBNYOMSKOR
HANG_IDOTARTAM_GYARI	EQU	.2		;ENNYI SEC IDEIG TART A HANGJELZS
HANG_BE_GYARI		EQU	.2		;ENNYI MEGSZAKTS IDEIG VAN BEKAPCSOLVA A HANGSZR
HANG_KI_GYARI		EQU	.2		;ENNYI	MEGSZAKTS IDEIG VAN KIKAPCSOLVA A HANGSZR
HANG_SZOL_GYARI		EQU	.2		;ENNYISZER 0.01SEC IDEIG SZL A HANG FOLYAMATOSAN
HANG_SZUNET_GYARI	EQU	.2		;ENNYI 0.01SEC IDEIG VAN SZNET A CSIPOGSOK KZTT
KIJELZO_EL_GYARI	EQU	.2		;ENNYI SEC IDEIG L A KIJELZ GOMBNYOMS UTN
SLEEP_GYARI		EQU	.2		;ENNYI SEC IDVEL A HANGJELZS BEFEJEZSE UTN KIKAPCSOL A PROCI
	ENDIF


;************************************************************************************************
;*	EEPROMHOZ TAROZ LLANDK
;************************************************************************************************


;************************************************************************************************
;STATE BITJEI
;************************************************************************************************
NAGYOBB		EQU		.0			;KTBYTE-OS SSZEHASONLTS EREDMNYE
SEC0.01_BIT	EQU		.1			;0.01 SEC LETELTT JELZ BIT
DUPLA		EQU		.2			;EZ A BIT JELZI, HA DUPLA KATTINTS TRTNT
HOSSZU		EQU		.3			;EZ A BIT JELZI, HA HOSSZAN VAN LENYOMVA A GOMB
FELFUTOEL	EQU		.4			;JELZI A FELFUTLET
LEFUTOEL	EQU		.5			;JELZI A LEFUTLET
SEC		EQU		.6			;JELZI EGY SEC ELTELTT
TIZ_PONT	EQU		.7			;JELZI, HA A TIZEDESPONTOT HTRBB KELL VINNI

;************************************************************************************************
;STATE_2 BITJEI
;************************************************************************************************
HANG		EQU		.0			;JELZI, HA INDULHAT A HANGJELZS
HANG_MEHET	EQU		.1			;JELZI, HA VOLT IDZTS (CSAK AKKOR INDULHAT A HANGJELZS)
KIJELZO_EL	EQU		.2			;JELZI, HA A KIJELZSNEK MENNIE KELL
SLEEP_SZAML_BIT	EQU		.3			;JELZI, HA KEZDDHET A SLEEP VISSZASZMLLS
SLEEP_OK_BIT	EQU		.4			;JELZI, HA SLEEP-BE KELL LLNI A PROCINAK
;************************************************************************************************
;*	CIMEK A 0. BANKBAN
;************************************************************************************************
 CBLOCK 0X20

	STATE				;LLAPOTJELZ BITEK
	STATE_2				;LLAPOTJELZ BITEK

	RTCC_SEC			;REAL-TIME CLOCK MSODPERC SZMLLJA


	IDO_ALAP_0.01_SZAML		;EZT HASZNLJUK AZ 0.01 SEC IDALAP ELLLTSRA
	IDO_ALAP_SEC_SZAML		;EZT HASZNLJUK AZ 1 SEC IDALAP ELLLTSRA

	GOMB_PRELL_SZAML		;A GOMB PRELLMENTESTSHEZ HASZNLJUK
	GOMB_HOSSZU_SZAML		;EZZEL FIGYELJK, HOGY A GOMB SOKIG LE VAN NYOMVA
	GOMB_LATCH			;A BEMENET KEZELSHEZ SZKSGES VLTOZK
	GOMB_ATMENETI
	GOMB_ELOZO_ALLAPOT

	GOMB_DUPLA_SZAML		;ITT FIGYELJK, HOGY MENNYI ID TELIK EL KT GOMBNYOMS KZTT

	IDOZIT_KESL_SZAML

	KIJ_MUTATO			;EZ JELZI, HOGY HNYADIK KIJELZT KELL KIGYJTANI
	KIJ_SZAML			;EZZEL IDZTJK A KIJELZK MULTIPLEXELST
	KIJ_1				;EZEK KERLNEK A KIJELZRE
	KIJ_2
	KIJ_3
	KIJ_ATMENETI			;TMENETI TROL


	IDO_SEC_1			;EZ A MRT ID SECUNDUM RSZE
	IDO_SEC_2
	IDO_MIN_1			;EZ A MRT ID PERC RSZE
	IDO_MIN_2			;BCD KDBAN KELL RTELMEZNI

	HOSSZU_ISM_SZAML		;ITT MRJK A HOSSZ GOMBNYOMS IDEJT


	HANG_IDOTARTAM_SZAML		;ENNYI SEC IDEIG TART A HANGJELZS
	HANG_BE_SZAML			;ENNYISZER 0.001SEC IDEIG VAN BEKAPCSOLVA A HANGSZR
	HANG_KI_SZAML			;ENNYISZER 0.001SEC IDEIG VAN KIKAPCSOLVA A HANGSZR
	HANG_SZOL_SZAML			;ENNYISZER 0.01SEC IDEIG SZL A HANG
	HANG_SZUNET_SZAML		;ENNYISZER 0.01SEC IDEIG VAN SZNET A CSIPOGSOK KZTT

	KIJELZO_EL_SZAML		;EZ A KIJELZS IDTARTAMA GOMBNYOMS UTN
	SLEEP_SZAML			;EZZEL IDZTJK A SLEEP-BE LLST

	D1

	UTOLSO

 ENDC

 CBLOCK 0X79
	TEMP_W				;MEGSZAKITSKOR W RTKE !!! EZ MIND A NGY BANKBAN MEGJELENIK !!
	TEMP_STATUS			;MEGSZAKITSKOR STATUS RTKE
	TEMP_PCLATH			;MEGSZAKITSKOR PCLATH RTKE
 ENDC








	ERRORLEVEL	-302,-307,-306
	NOEXPAND				;A MAKRKAT NEM CSINLJA VGIG, TUGORJA

	LIST    P=16F628
	INCLUDE	<P16F628.INC>
	INCLUDE <MACRO.ASM>
	NOEXPAND
	__CONFIG   _CP_ALL & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _BODEN_ON & _LVP_OFF & _DATA_CP_OFF


	ORG	0X2100
	DE	"KONYHAI IDOZITO 2005.05.03. 18:52"










RESETVEKTOR
	org	0x0000		;A KEZDCIM, ITT INDUL A PROGRAM BEKAPCSOLSKOR
	GOTO	INIT		;TUGORJUK A MEGSZAKITSI RUTINT


MEGSZAKITSVEKTOR
	ORG	0X0004		;MEGSZAKITSI VEKTORCIM

INTERRUPT
PUSH
	MOVWF	TEMP_W			;MEGSZAKITS, ELMENTJK W,STATUS S PCLATH RTKT !!!
	SWAPF	STATUS,W		;A STATUS TARTALMT MEGCSERLJK S TIRJUK W-BE
	BCF	STATUS,RP0		;KIJELLJK A 0-S BANKOT
	BCF	STATUS,RP1		;
	MOVWF	TEMP_STATUS		;A STATUS EREDETI RTKT ELMENTJK A 0-S BANKBA
	MOVF	PCLATH,W		;A PCLATH-OT IS ELMENTJK
	MOVWF	TEMP_PCLATH		;	

INTERRUPT_SELECT
	BANKSEL_0
	BTFSS	INTCON,T0IE
	GOTO	INT_SEL_RB0

	BTFSC	INTCON,T0IF
	GOTO	T0_MEGSZ

INT_SEL_RB0
	BANKSEL_0
	BTFSS	INTCON,INTE
	GOTO	POP

	BTFSC	INTCON,T0IF
	GOTO	RB0_MEGSZ



POP
	BANKSEL_0
	MOVF	TEMP_PCLATH,W		;VISSZATLTJK PCLATH-OT
	MOVWF	PCLATH
	SWAPF	TEMP_STATUS,W		;A STATUS ELZ RTKT VISSZATLTJK
	MOVWF	STATUS
	SWAPF	TEMP_W,F		;A W EREDETI TARTALMNAK VISSZATLTSE, AZRT SWAP-EL
	SWAPF	TEMP_W,W		;CSINLJUK, MERT A MOVWF LLITJA A Z-T !!!
	RETFIE





RB0_MEGSZ
	BCF	INTCON,INTF
	BCF	INTCON,RBIE
	BCF	STATE_2,SLEEP_OK_BIT
	MOVLW	SLEEP_GYARI
	MOVWF	SLEEP_SZAML
	GOTO	POP








T0_MEGSZ
	BCF	INTCON,T0IF
	MOVLW	.6
	ADDWF	TMR0,F			;HOZZADUNK 6-OT, HOGY 250-ET SZMLLJON A SZMLL, GY LESZ PONTOS AZ RA


T0_KIJ_MULTIPLEX
	DECFSZ	KIJ_SZAML,F			;HA SZKSGES, A KVETKEZ SZEGMENSRE MUTATUNK
	GOTO	T0_MEGSZ_IDO_ALAP

	MOVLW	KIJ_GYARI
	MOVWF	KIJ_SZAML

	INCF	KIJ_MUTATO,F
	MOVFW	KIJ_MUTATO			;VLTUNK, HA KELL
	XORLW	.3
	SKPNZ
	CLRF	KIJ_MUTATO

	MOVLW	B'00110010'			;A KIMENETI ADATOT NULLZZUK
	ANDWF	PORTA,F				;
	CLRF	PORTB

	MOVLW	HIGH(T0_MULTIP_UGRO)	;EZ IS KELL A HELYES MKDSHEZ
	MOVWF	PCLATH				;

T0_MULTIP_UGRO
	MOVFW	KIJ_MUTATO			;
	ADDWF	PCL,F				;

	GOTO	T0_MULTIP_0			;0. SZEGMENS KIVLASZTVA
	GOTO	T0_MULTIP_1			;1. SZEGMENS KIVLASZTVA
	GOTO	T0_MULTIP_2			;2. SZEGMENS KIVLASZTVA

T0_MULTIP_0
	BSF	PORTA,0				;ELS 7-SZEGMENS KIJELZ MODUL ENGEDLYEZSE

	MOVLW	.0
	BTFSS	STATE,TIZ_PONT
	IORLW	B'00100000'
	BTFSS	STATE_2,KIJELZO_EL		;HA A KIJELZO NEM L, CSAK EGY TIZEDESPONTOT JELZNK KI
	GOTO	T0_MULTIP_ADATKI

	MOVFW	KIJ_1
	MOVWF	KIJ_ATMENETI
	CALL	KIJ_TABLAZAT_KEZELES
	BTFSS	STATE,TIZ_PONT
	IORLW	B'00100000'
	GOTO	T0_MULTIP_ADATKI
T0_MULTIP_1
	BSF	PORTA,3				;MSODIK 7-SZEGMENS KIJELZ MODUL ENGEDLYEZSE

	MOVLW	.0
	BTFSC	STATE,TIZ_PONT
	IORLW	B'00100000'
	BTFSS	STATE_2,KIJELZO_EL		;HA A KIJELZO NEM L, CSAK EGY TIZEDESPONTOT JELZNK KI
	GOTO	T0_MULTIP_ADATKI

	MOVFW	KIJ_2
	MOVWF	KIJ_ATMENETI
	CALL	KIJ_TABLAZAT_KEZELES
	BTFSC	STATE,TIZ_PONT
	IORLW	B'00100000'
	GOTO	T0_MULTIP_ADATKI
T0_MULTIP_2
	MOVLW	.0
	BTFSS	STATE_2,KIJELZO_EL		;HA A KIJELZO NEM L, CSAK EGY TIZEDESPONTOT JELZNK KI
	GOTO	T0_MULTIP_ADATKI


	BSF	PORTA,7
	MOVFW	KIJ_3
	MOVWF	KIJ_ATMENETI
	CALL	KIJ_TABLAZAT_KEZELES
T0_MULTIP_ADATKI
	MOVWF	PORTB
	MOVWF	D1
	ANDLW	B'00000001'
	SKPZ
	BSF	PORTA,6				;






T0_MEGSZ_IDO_ALAP
	DECF	IDO_ALAP_0.01_SZAML,F		;
	SKPZ
	GOTO	T0_MEGSZ_HANG

	MOVLW	IDO_ALAP_0.01_GYARI
	MOVWF	IDO_ALAP_0.01_SZAML


		;*****************************
		;*	EZ A HANGJELZS ELLLTSHOZ KELL	0.01SEC IDKZNKNT FUT LE!
	BTFSS	STATE_2,HANG
	GOTO	T0_MEGSZ_IDO_ALAP_0.01_SEC


	TSTF	HANG_SZOL_SZAML
	SKPZ
	DECF	HANG_SZOL_SZAML,F		;CSKKENTJK A JELZS IDTARTAMT
	TSTF	HANG_SZOL_SZAML
	BNZ	T0_MEGSZ_IDO_ALAP_0.01_SEC			;HA MG SZLNIA KELL A JELZSNEK, AKKOR UGRS

	TSTF	HANG_SZUNET_SZAML
	SKPZ
	DECF	HANG_SZUNET_SZAML,F		;CSKKENTJK A SZNET IDTARTAM SZMLLT
		;*****************************


T0_MEGSZ_IDO_ALAP_0.01_SEC
	BSF	STATE,SEC0.01_BIT		;JELEZZK, LETELT 0.01 SEC

	DECFSZ	IDO_ALAP_SEC_SZAML,F		;
	GOTO	T0_MEGSZ_HANG

	MOVLW	IDO_ALAP_SEC_GYARI
	MOVWF	IDO_ALAP_SEC_SZAML



T0_MEGSZ_IDO_ALAP_SEC
	TSTF	IDOZIT_KESL_SZAML		;HA MG NEM INDULT MEG AZ IDZTS, AKKOR NEM SZMOLJUK A MSODPERCEKET
	SKPZ
	GOTO	T0_MEGSZ_HANG_RESET

	BSF	STATE,SEC

	BTFSS	STATE_2,KIJELZO_EL		;KIJELZ L SZMLL CSKKENTSE
	GOTO	T0_MEGSZ_SEC_SLEEP

	TSTF	KIJELZO_EL_SZAML
	SKPZ
	DECF	KIJELZO_EL_SZAML,F
	TSTF	KIJELZO_EL_SZAML
	SKPZ
	GOTO	T0_MEGSZ_SEC_SLEEP

	BCF	STATE_2,KIJELZO_EL		;HA LEJRT A BELLTOTT ID, KIKAPCSOLJUK A KIJELZT


T0_MEGSZ_SEC_SLEEP
	BTFSS	STATE_2,SLEEP_SZAML_BIT
	GOTO	T0_MEGSZ_SEC_HANG

	TSTF	SLEEP_SZAML
	SKPZ
	DECF	SLEEP_SZAML,F
	TSTF	SLEEP_SZAML
	SKPNZ
	BSF	STATE_2,SLEEP_OK_BIT		;JELEZZK, HOGY SLEEP-BE KELL LLNI	



T0_MEGSZ_SEC_HANG
		;*****************************
		;*	EZ A HANGJELZS ELLLTSHOZ KELL
	BTFSS	STATE_2,HANG
	GOTO	T0_MEGSZ_HANG

	TSTF	HANG_IDOTARTAM_SZAML
	SKPZ
	DECF	HANG_IDOTARTAM_SZAML,F		;CSKKENTJK A HANGJELZS IDTARTAM SZMLLT
		;*****************************

	GOTO	T0_MEGSZ_HANG

T0_MEGSZ_HANG_RESET
	MOVLW	IDO_ALAP_SEC_GYARI
	MOVWF	IDO_ALAP_SEC_SZAML



		;*****************************
		;*	EZ A HANGJELZS ELLLTSHOZ KELL
T0_MEGSZ_HANG
	BTFSS	STATE_2,HANG			;HA NINCS HANGJELZS, VGE
	GOTO	T0_MEGSZ_VEGE

	TSTF	HANG_IDOTARTAM_SZAML		;HA LEJRT A HANGJELZS IDTARTAMA, AKKOR MINDENT NULLZUNK
	BNZ	T0_MEGSZ_HANG_OK

		;LEJRT A HANGJELZS
	BCF	STATE_2,HANG
	BCF	STATE_2,HANG_MEHET
	BCF	PORTA,2
;	BSF	PORTA,2
	CLRF	HANG_BE_SZAML
	CLRF	HANG_KI_SZAML
	CLRF	HANG_SZUNET_SZAML
	GOTO	T0_MEGSZ_VEGE




T0_MEGSZ_HANG_OK
	TSTF	HANG_SZOL_SZAML
	BNZ	T0_MEGSZ_HANG_VIZSG			;HA NEM SZLHAT A HANG, VGE

	TSTF	HANG_SZUNET_SZAML
	BZ	T0_MEGSZ_HANG_UJRA_FULL
	GOTO	T0_MEGSZ_VEGE

T0_MEGSZ_HANG_VIZSG
	TSTF	HANG_BE_SZAML
	BZ	T0_MEGSZ_HANG_KI

	DECF	HANG_BE_SZAML,F
	BSF	PORTA,2
;	BCF	PORTA,2
	B	T0_MEGSZ_VEGE


T0_MEGSZ_HANG_KI
	TSTF	HANG_KI_SZAML
	BZ	T0_MEGSZ_HANG_UJRA

	DECF	HANG_KI_SZAML,F
	BCF	PORTA,2
;	BSF	PORTA,2
	B	T0_MEGSZ_VEGE

T0_MEGSZ_HANG_UJRA_FULL
	MOVLW	HANG_SZUNET_GYARI
	MOVWF	HANG_SZUNET_SZAML
	MOVLW	HANG_SZOL_GYARI
	MOVWF	HANG_SZOL_SZAML
T0_MEGSZ_HANG_UJRA
	MOVLW	HANG_BE_GYARI
	MOVWF	HANG_BE_SZAML
	MOVLW	HANG_KI_GYARI
	MOVWF	HANG_KI_SZAML

		;*****************************


T0_MEGSZ_VEGE
	GOTO	POP









KIJ_TABLAZAT_KEZELES
	MOVLW	HIGH(KIJ_TABLAZAT)	;EZ IS KELL A HELYES MKDSHEZ
	MOVWF	PCLATH				;

KIJ_TABLAZAT
	MOVFW	KIJ_ATMENETI			;
	ADDWF	PCL,F				;

	RETLW	B'10011111'			;'0'
	RETLW	B'00000011'			;'1'
	RETLW	B'11011001'			;'2'
	RETLW	B'11010011'			;'3'
	RETLW	B'01000111'			;'4'
	RETLW	B'11010110'			;'5'
	RETLW	B'11011110'			;'6'
	RETLW	B'00010111'			;'7'
	RETLW	B'11011111'			;'8'
	RETLW	B'11010111'			;'9'
	RETLW	B'01000000'			;'10'
	RETLW	B'00000000'			;'11'
	RETLW	B'00000000'			;'12'
	RETLW	B'00000000'			;'13'
	RETLW	B'00000000'			;'14'
	RETLW	B'00000000'			;'15'

	IF	HIGH(KIJ_TABLAZAT)!=HIGH($)		;HA TCSSZNA A 256 BYTE-OS HATRON, AKKOR HIBAJELZS !
	ERROR	"UGROTBLA-HIBA !"
	ENDIF







;************************************************************************************************
;*	ITT INICIALIZLJUK A VEZRLT
;************************************************************************************************
INIT
	BANKSEL_0

	MOVLW	B'00000111'		;NINCS HASZNLVA KOMPARTOR
	MOVWF	CMCON			;


	BANKSEL_1
	BSF	PCON,OSCF		;4 MHz-ES OSZCILLTOR
	MOVLW	B'00000000'		;
	MOVWF	TRISA


	MOVLW	B'00000001'		;RB0 BEMENET, A TBBI KIMENET
	MOVWF	TRISB


	MOVLW	B'11010000'		;RB ELL-OK KI,T0: Fosc/4, ELOSZT: T0-HOZ,2-SZERES, RB0 FELFUTLRE MEGSZAKTS
	MOVWF	OPTION_REG

	MOVLW	B'01100000'		;GIE TILTVA, TMR1 S TMR0 ENGEDLYEZVE
	MOVWF	INTCON
	MOVLW	B'00000000'		;TMR1 INT. ENGEDVE, TBBI TILTVA
	MOVWF	PIE1
	BANKSEL_0
	CLRF	PIR1			;TRLNK MINDEN PERIF. MEGSZ. FLAGET (TMR1-ET IS)
	MOVLW	B'00010000'
	MOVWF	PORTA
        MOVLW	.0			;
	MOVWF	PORTB


;******************************************************************
;*	A FELHASZNLT RAMTERLET INICIALIZLSA
;******************************************************************
MEMORIA_TORLES_0			;A 0. BANKOT TRLJK
	BANKSEL_0			;
	MOVLW	0X21			;21-TL NULLZUNK
	MOVWF	FSR			;INDIREKTEN CIMEZZK
	MOVLW	0X5D			;AZ UTOLS 
	MOVWF	0x20			;
MEMORIA_TORLES_0_ISM
	CLRF	INDF			;
	INCF	FSR,F			;
	DECFSZ	0x20,F		;
	GOTO	MEMORIA_TORLES_0_ISM
	CLRF	0X20





ADAT_ELOKESZIT
	MOVLW	IDO_ALAP_0.01_GYARI
	MOVWF	IDO_ALAP_0.01_SZAML

	MOVLW	GOMB_HOSSZU_GYARI
	MOVWF	GOMB_HOSSZU_SZAML

	MOVLW	KIJ_GYARI
	MOVWF	KIJ_SZAML


	MOVLW	IDO_ALAP_SEC_GYARI
	MOVWF	IDO_ALAP_SEC_SZAML

	MOVLW	.0			;NULLZZUK A REALTIME-CLOCK-OT
	MOVWF	RTCC_SEC


	MOVLW	.0
	MOVWF	KIJ_1
	MOVLW	.0
	MOVWF	KIJ_2
	MOVLW	.0
	MOVWF	KIJ_3


	IF	(TESZT==.1)
	BSF	STATE_2,HANG_MEHET
	MOVLW	.2
	MOVWF	IDO_SEC_1
	ENDIF



;**********************************************************************************************
;**********************************************************************************************
;*	FPROGRAM
;**********************************************************************************************
;**********************************************************************************************


FOPROG_ELEJE
	BSF	INTCON,PEIE
	BANKSEL_1
	BSF	PIE1,TMR1IE
	BANKSEL_0

	BSF	INTCON,GIE		;ENGEDLYEZZK A MEGSZAKTSOKAT


	IF	(TESZT==1)
	BSF	STATE_2,HANG_MEHET
	BSF	STATE_2,HANG
	CALL	IDOZIT_NULLA
	MOVLW	.1
	MOVWF	IDO_SEC_1
	ENDIF




FOPROGRAM
	BTFSC	STATE,SEC0.01_BIT		;SZZADMSODPERCENKNT VIZSGLJUK A NYOMGOMBOT
	CALL	GOMB_KEZ

	CALL	GOMB_VEGREHAJT
	CALL	KIJELZO_ADATOK
	CALL	IDOZITES



SLEEP_ELOKESZITES
	BTFSS	STATE_2,SLEEP_OK_BIT
	GOTO	FOPROGRAM

	BCF	INTCON,GIE			;LETILTJUK A MEGSZAKTSOKAT
	BANKSEL_1
	BCF	OPTION_REG,INTEDG			;NEGATV LRE GENERLDIK MEGSZAKTS
	BANKSEL_0

	BSF	INTCON,INTE			;ENGEDLYEZZK RB0 MEGSZAKTSOKAT
	MOVLW	B'00000000'
	MOVWF	PORTA
	MOVLW	B'00000000'
	MOVWF	PORTB
	BCF	INTCON,INTF			;TRLJK AZ ESETLEGES MEGSZAKTST
	BSF	INTCON,GIE			;ENGEDLYEZZK A MEGSZAKTSOKAT

	NOP
	NOP
	SLEEP
	NOP
	NOP
	NOP

	GOTO	FOPROGRAM




;**************************************************
;*	ITT SZMOLJUK AZ IDT, VISSZAFEL
;**************************************************
IDOZITES
	TSTF	IDOZIT_KESL_SZAML		;HA ELG HOSSZ IDEIG NEM NYOMTK MEG A GOMBOT, ELINDULHAT AZ IDZTS
	SKPZ
	RETURN
	BTFSS	STATE,SEC
	RETURN

	BCF	STATE,SEC
	MOVFW	IDO_SEC_1
	IORWF	IDO_SEC_2,W
	IORWF	IDO_MIN_1,W
	IORWF	IDO_MIN_2,W
	BZ	IDOZIT_NULLA			;AZ IDZTS LEJRT

	BSF	STATE_2,HANG_MEHET			;HA AZ IDZT LEJR, ELINDULHAT A HANGJELZS
	TSTF	IDO_SEC_1
	BZ	IDOZIT_SEC_2			;A MSODPERC MUTAT NULLA
	DECF	IDO_SEC_1,F
	RETURN
IDOZIT_SEC_2
	MOVLW	.9
	MOVWF	IDO_SEC_1
	TSTF	IDO_SEC_2
	BZ	IDOZIT_MIN_1
	DECF	IDO_SEC_2,F			;CSKKENTJK A TZMSODPERCET
	RETURN
IDOZIT_MIN_1
	MOVLW	.5
	MOVWF	IDO_SEC_2
	TSTF	IDO_MIN_1
	BZ	IDOZIT_MIN_2
	DECF	IDO_MIN_1,F			;CSKKENTJK A PERCET
	RETURN
IDOZIT_MIN_2
	MOVLW	.9
	MOVWF	IDO_MIN_1
	TSTF	IDO_MIN_2
	SKPNZ
	RETURN
	DECF	IDO_MIN_2,F			;CSKKENTJK A TZPERCET
	RETURN



IDOZIT_NULLA
	BTFSS	STATE_2,HANG_MEHET		;HA BELLTOTT RTKTL JUTOTTUNK EL A NULLIG, AKKOR HANGJELZS MEHET
	GOTO	IDOZ_NULL_VEGE
	BTFSC	STATE_2,HANG			;HA MR BE VAN BILLENTVE A BIT, VGE
	RETURN

	BSF	STATE_2,HANG
	MOVLW	HANG_IDOTARTAM_GYARI
	MOVWF	HANG_IDOTARTAM_SZAML
	MOVLW	HANG_SZUNET_GYARI
	MOVWF	HANG_SZUNET_SZAML
	MOVLW	HANG_SZOL_GYARI
	MOVWF	HANG_SZOL_SZAML
	MOVLW	HANG_BE_GYARI
	MOVWF	HANG_BE_SZAML
	MOVLW	HANG_KI_GYARI
	MOVWF	HANG_KI_SZAML
	RETURN

IDOZ_NULL_VEGE
	BCF	PORTA,2
;	BSF	PORTA,2
	TSTF	HANG_IDOTARTAM_SZAML
	SKPZ
	GOTO	IDOZ_RET

	BTFSC	STATE_2,SLEEP_SZAML_BIT
	GOTO	IDOZ_RET

	BSF	STATE_2,SLEEP_SZAML_BIT
	MOVLW	SLEEP_GYARI
	MOVWF	SLEEP_SZAML

IDOZ_RET
	RETURN



;**************************************************
;*	ITT RAKJA KI A MEGFELEL ADATOKAT A PUFFERBE
;**************************************************
KIJELZO_ADATOK
	TSTF	IDO_MIN_2			;HA A TZPERC RTK NEM 0, AKKOR CSSZIK A KIJELZS
	BNZ	KIJ_ADAT_2

	BCF	STATE,TIZ_PONT
	MOVFW	IDO_SEC_1
	MOVWF	KIJ_3
	MOVFW	IDO_SEC_2
	MOVWF	KIJ_2
	MOVFW	IDO_MIN_1
	MOVWF	KIJ_1
	RETURN

KIJ_ADAT_2		;TIZEDES CSSZIK
	BSF	STATE,TIZ_PONT
	MOVFW	IDO_SEC_2
	MOVWF	KIJ_3
	MOVFW	IDO_MIN_1
	MOVWF	KIJ_2
	MOVFW	IDO_MIN_2
	MOVWF	KIJ_1
	RETURN














;**************************************************
;*	ITT HAJTJUK VGRE A GOMBNYOMSHOZ TARTOZ FELADATOKAT
;**************************************************
GOMB_VEGREHAJT
	IF	(TESZT==.1)
;	BSF	STATE,FELFUTOEL
;	BSF	STATE_2,HANG
;	MOVLW	HANG_IDOTARTAM_GYARI
;	MOVWF	HANG_IDOTARTAM_SZAML
;	MOVLW	HANG_BE_GYARI
;	MOVWF	HANG_BE_SZAML
;	MOVLW	HANG_KI_GYARI
;	MOVWF	HANG_KI_SZAML
	ENDIF

	BTFSS	STATE,FELFUTOEL
	GOTO	GOMB_VEGRE_DUPLA

	BTFSC	STATE_2,HANG			;HA HANGJELZS VAN FOLYAMATBAN, AZT KIKAPCSOLJUK
	GOTO	GV_DUPLA_TOROL

	BTFSC	STATE_2,KIJELZO_EL
	B	GV_NOVEL
	MOVLW	KIJELZO_EL_GYARI
	MOVWF	KIJELZO_EL_SZAML
	BSF	STATE_2,KIJELZO_EL
	BCF	STATE,FELFUTOEL
	CLRF	IDOZIT_KESL_SZAML		;A SZMLLST FOLYTATNI KELL TOVBB
	GOTO	GOMB_VEGRE_DUPLA

GV_NOVEL
	MOVLW	IDOZIT_KESL_GYARI		;AZ IDZTS NEM KEZDDHET EL
	MOVWF	IDOZIT_KESL_SZAML

	BCF	STATE_2,SLEEP_SZAML_BIT
	CLRF	SLEEP_SZAML

	CALL	GV_IDOZIT_NOVEL

	
GOMB_VEGRE_DUPLA				;DUPLA GOMBNYOMSSAL NULLZZUK A SZMLLST
	BTFSS	STATE,DUPLA
	GOTO	GOMB_VEGRE_HOSSZU

GV_DUPLA_TOROL
	BCF	STATE,FELFUTOEL
	BCF	STATE,HOSSZU
	BCF	STATE,DUPLA
	BCF	INTCON,GIE
	MOVLW	SLEEP_GYARI
	MOVWF	SLEEP_SZAML
	BSF	STATE_2,SLEEP_SZAML_BIT
	BCF	STATE_2,HANG
	BCF	STATE_2,HANG_MEHET
	BCF	STATE_2,KIJELZO_EL
	BCF	PORTA,2
;	BSF	PORTA,2
	CLRF	HANG_BE_SZAML
	CLRF	HANG_KI_SZAML
	CLRF	HANG_SZUNET_SZAML
	CLRF	HANG_IDOTARTAM_SZAML
	CLRF	IDO_MIN_2
	CLRF	IDO_MIN_1
	CLRF	IDO_SEC_2
	CLRF	IDO_SEC_1
	BSF	INTCON,GIE



GOMB_VEGRE_HOSSZU
	BTFSS	STATE,HOSSZU
	GOTO	GOMB_VEGRE_VEGE

	MOVLW	IDOZIT_KESL_GYARI
	MOVWF	IDOZIT_KESL_SZAML

	TSTF	HOSSZU_ISM_SZAML		;HA A SZMLL NULLA, AKKOR NVELJK AZ IDZT RTKT
	BNZ	GOMB_VEGRE_VEGE

	CALL	GV_IDOZIT_NOVEL

	MOVLW	HOSSZU_ISM_GYARI
	MOVWF	HOSSZU_ISM_SZAML

GOMB_VEGRE_VEGE
	RETURN







GV_IDOZIT_NOVEL
	MOVLW	KIJELZO_EL_GYARI
	MOVWF	KIJELZO_EL_SZAML
	BSF	STATE_2,KIJELZO_EL		;JELEZZK, HOGY A KIJELZT BE KELL KAPCSOLNI

;**********************************************************************************************
;*
;*	A MEGADOTT RTKKEL NVELJK AZ IDZT RTKT
;*
;**********************************************************************************************
	CLRF	IDO_SEC_1			;A MSODPERCET NULLZZUK
	MOVLW	.3
	SUBWF	IDO_SEC_2,W
	BNC	GV_ID_OK_RESET

	MOVLW	.3
	MOVWF	IDO_SEC_2
	GOTO	GV_ID_OK


GV_ID_OK_RESET
	CLRF	IDO_SEC_2
GV_ID_OK
	MOVLW	.9
	SUBWF	IDO_MIN_2,W			;90 MIN FL NEM MEGYNK!
	SKPNC
	RETURN

	BCF	STATE,FELFUTOEL
	MOVLW	IDO_LEP_10SEC
	ADDWF	IDO_SEC_2,F

	MOVLW	.6
	SUBWF	IDO_SEC_2,W
	SKPC
	RETURN
	
GV_KORR_MIN_1
	MOVWF	IDO_SEC_2
	INCF	IDO_MIN_1,F

	MOVLW	.10
	SUBWF	IDO_MIN_1,W
	SKPC
	RETURN

GV_KORR_MIN_2
	MOVWF	IDO_MIN_1
	INCF	IDO_MIN_2,F

	RETURN












	
GOMB_KEZ
;**********************************************************************************************
;*
;*	MEGVIZSGLJUK A BEMENETET
;*
;**********************************************************************************************
	BCF	STATE,SEC0.01_BIT

	TSTF	HOSSZU_ISM_SZAML		;A HOSSZ GOMBNYOMS IDZTST CSKKENTJK, HA KELL
	SKPZ
	DECF	HOSSZU_ISM_SZAML,F


	TSTF	GOMB_DUPLA_SZAML
	SKPZ
	DECF	GOMB_DUPLA_SZAML,F

	TSTF	IDOZIT_KESL_SZAML
	SKPZ
	DECF	IDOZIT_KESL_SZAML,F

	MOVFW	PORTB				;BEOLVASSUK A PORTOT
	MOVWF	GOMB_LATCH			;A BEOLVASOTT RTKET ELMENTJK A TOVBBI FELDOLGOZSHOZ
	XORWF	GOMB_ATMENETI,W			;MEGVIZSGLJUK, HOGY TRTNT-E VLTOZS RB0-N
	ANDLW	B'00000001'			;
	SKPNZ					;HA AZ EREDMNY 0, AKKOR NINCS VLTOZS
	GOTO	NYUGALOM

	MOVLW	GOMB_HOSSZU_GYARI
	MOVWF	GOMB_HOSSZU_SZAML
	BCF	STATE,HOSSZU			;TRLJK A HOSSZ GOMBNYOMST JELZ BITET
	MOVFW	GOMB_LATCH			;VLTOZS TRNT
	MOVWF	GOMB_ATMENETI			;A MOSTANI LLAPOTOT AZ TMENETI TROLBA MENTJK
	MOVLW	GOMB_PRELL_GYARI
	MOVWF	GOMB_PRELL_SZAML

;	MOVLW	IDOZIT_KESL_GYARI		;AZ IDZTS NEM KEZDDHET EL
;	MOVWF	IDOZIT_KESL_SZAML
	CLRF	HOSSZU_ISM_SZAML
	RETURN




;**********************************************************************************************
;*
;*	PRELLMENTESTS MEGTRTNT, BELLT A BEMENET LLAPOTA
;*
;**********************************************************************************************
NYUGALOM
	TSTF	GOMB_PRELL_SZAML			;HA A PRELL SZMLL LEJRT, AKKOR RVNYESTJK AZ LLAPOTOT
	SKPZ
	DECF	GOMB_PRELL_SZAML,F
	TSTF	GOMB_PRELL_SZAML
	BNZ	GOMB_KEZ_VEGE			;NEM JRT LE A PRELLMENTESTS, VGE

	MOVFW	GOMB_ATMENETI
	XORWF	GOMB_ELOZO_ALLAPOT,W		;A PRELLMENTESTS UTN MEGNZZK, HOGY MILYEN VLTOZS TRTNT
	ANDLW	B'00000001'			;HA AZ EREDMNY NEM 0, AKKOR VLTOZS TRTNT
	BZ	GOMB_KEZ_HOSSZU_E		;NINCS VLTOZS, FIGYLEJK A HOSSZ GOMBNYOMST


NYUGALOM_VALTOZAS	;LLAPOTVLTS TRTNT
	MOVFW	GOMB_LATCH
	MOVWF	GOMB_ELOZO_ALLAPOT		;A JELENLEGI, RVNYES ADATOT ELMENTJK
	BTFSC	GOMB_LATCH,0
	GOTO	NYUGALOM_LEFUTOEL		;MIVEL A JELENLEGI LLAPOT ALACSONY, LEFUTLET FOGTUNK


NYUGALOM_FELFUTOEL		;MIVEL A JELENLEGI LLAPOT MAGAS, FELFUTLET FOGTUNK
	BSF	STATE,FELFUTOEL
	BCF	STATE,LEFUTOEL
	BCF	STATE,HOSSZU

	BCF	STATE,DUPLA			;BEBILLENTJK A "DUPLA" JELZBITET, MAJD HA SZKSGES, TRLJK
	TSTF	GOMB_DUPLA_SZAML
	SKPZ
	DECF	GOMB_DUPLA_SZAML,F		;HA MG NEM 0, AKKOR CSKKENTJK A SZMLLT
	TSTF	GOMB_DUPLA_SZAML		;HA A SZMLL MR LEJRT, AKKOR TRLJK A "DUPLA" JELZBITET
	SKPNZ					
	GOTO	NYUGALOM_FELFUTO_KOZOS

	BSF	STATE,DUPLA
	BCF	STATE,FELFUTOEL
	CLRF	GOMB_DUPLA_SZAML
	RETURN					;HA MR VOLT DUPLAKATTINTS, AKKOR A SZMLLT NULLZZUK!
NYUGALOM_FELFUTO_KOZOS
	MOVLW	GOMB_DUPLA_GYARI
	MOVWF	GOMB_DUPLA_SZAML		;INNEN FIGYELJUK ISMT A DUPLA GOMBNYOMST!
	RETURN


NYUGALOM_LEFUTOEL		;MIVEL A JELENLEGI LLAPOT ALACSONY, LEFUTLET FOGTUNK
	CLRF	GOMB_HOSSZU_SZAML		;TRLJK A HOSSZ GOMBNYOMS SZMLLJT
	BCF	STATE,HOSSZU
	RETURN



GOMB_KEZ_HOSSZU_E
	BTFSC	PORTB,0				;HA NINCS LENYOVA A GOMB, AKKOR VGE
	GOTO	GOMB_KEZ_HOSSZU_VEGE_TOROL

	BTFSC	STATE,HOSSZU		;HA EGYSZER MR HOSSZAN NYOMTK A GOMBOT, AKKOR MR NEM FIGYELJK
	GOTO	GOMB_KEZ_HOSSZU_VEGE

	TSTF	GOMB_HOSSZU_SZAML
	SKPZ
	DECF	GOMB_HOSSZU_SZAML,F		;HA NEM 0, AKKOR CSKKENTJK A SZMLLT
	BSF	STATE,HOSSZU			;BEBILLENTJK A "HOSSZU" JELZBITET, MAJD HA SZKSGES, TRLJK
	TSTF	GOMB_HOSSZU_SZAML		;HA A SZMLL MR LEJRT, AKKOR TRLJK A "DUPLA" JELZBITET
	SKPZ					
	BCF	STATE,HOSSZU
	RETURN

GOMB_KEZ_HOSSZU_VEGE_TOROL
	BCF	STATE,HOSSZU			;TRLJK A "HOSSZU" JELZBITET, MAJD HA SZKSGES, BELLTJUK
GOMB_KEZ_HOSSZU_VEGE

	RETURN

GOMB_KEZ_VEGE
	RETURN



	END
