;***************************************************************************************************
;***************************************************************************************************
;*	SAJT KSZTS DSO			PIC16F873
;*
;*	20MHz
;***************************************************************************************************
;*	2004.06.28-2004.
;***************************************************************************************************
;*	LLAPOT: 
;***************************************************************************************************
;*	UTOLS MDOSTS:	2004.07.05.		21:41
;*				2004.11.03.		18:10
;***************************************************************************************************
;*MKDS LERSA:  A PIC "BYTE_CSOMAG_GYARI" SZM BYTE-OS CSOMAGOKAT FOGAD AZ USART-ON. HA
;*	MEGRKEZETT EGY CSOMAG, MEGNZI, HOGY A CHECK_SUM J-E. HA J, AKKOR KIRTKELI A VETT
;*	CSOMAGOT. A MEMRIBA RS GY NZ KI, HOGY MKDIK.
;*	JELENLEG A CSOMAGONKNTI TKLDSNL TARTASZ
;***************************************************************************************************
;*	74175 : AZ RAJEL FELFUT LRE RDIK BE AZ ADAT
;***************************************************************************************************

#DEFINE	AZONOSITO	"PIC DSO 2004.11.03. 18:00 25uSEC MINTAVETELEZES"
#DEFINE NOTWE		PORTA,1			;WRITE ENABLE
#DEFINE NOTOE		PORTA,2			;READ ENABLE
#DEFINE LATCH1_CLOCK	PORTA,3			;A RAJZ ALAPJN LATCH1-HEZ A CMVEZETK 10-13 CME TARTOZIK
#DEFINE LATCH2_CLOCK	PORTA,5			;A RAJZ ALAPJN LATCH2-HZ A CMVEZETK 6-9 CME TARTOZIK
#DEFINE CIM14BIT	PORTA,4			;A 14. CMBIT

TESZT	SET	.0
		;HA 1, AKKOR TESZTELJK A PROGRAMOT
TESZT_NO_USART	SET	.0		;HA 1, AKKOR AZ USART-OT KIHAGYJA
MEMORIA_TESZT	SET	.0		;HA 1, AKKOR A MEMRIBA RST NEM 0-RL AKARJUK KEZDENI

BAUD_RATE	SET	.2	;0. : 19200  BAUD
				;1. : 57600  BAUD
				;2. : 115200 BAUD


;************************************************************************************************
;*	FELHASZNLT LLANDK
;************************************************************************************************
CSOMAG_SZAMLALO_GYARI	EQU	.100	;ENNYI BYTE VAN EGY KIADOTT CSOMAGBAN A PC FEL 2X ENNYI BYTE VAN EGY CSOMAGBAN
					;(MIVEL 2BYTE-OS RTKEKKEL DOLGOZUNK)
BYTE_CSOMAG_GYARI	EQU	.11		;ENNYI BYTE JN EGY CSOMAGBAN
KOMM_SZAMLALO_GYARI_1	EQU	.200		;EZ KT BYTE VTELE KZTTI VRAKOZSHOZ KELL
KOMM_SZAMLALO_GYARI_2	EQU	.200
NYUGTA_PC_FELE_GYARI	EQU	0XAA		;EGY ADATCSOMAG MEGFELEL VTELEKOR EZT KLDJK VISSZA A PC-NEK
NYUGTA_PC_FELOL_GYARI	EQU	0X55		;HA A PC VETT EGY CSOMAGOT, EZT KLDI VISSZA
CSOMAG_ISMETLES_GYARI	EQU	.3		;HA A PC NEM KLD NYUGTT, MAX. ENNYISZER PRBLJUK JRA ELKLDENI A CSOMAGOT JRA

ADAS_VAR_1_GYARI	EQU	.10		;A PIC USART LEFAGYSA ELLEN VD SZMLLK
ADAS_VAR_2_GYARI	EQU	.10
ADAS_VAR_3_GYARI	EQU	.10

VETEL_VAR_1_GYARI	EQU	.100		;VTELKOR ENNYI IDT VRUNK
VETEL_VAR_2_GYARI	EQU	.100
VETEL_VAR_3_GYARI	EQU	.20

AD_KESLELTETES		EQU	.5		;.6: ~0,25uSEC A MINTAVTELI RTA

MERESEK_SZAMA_1_GYARI	EQU	0X0A
MERESEK_SZAMA_2_GYARI	EQU	0X00









	IF (BAUD_RATE==.2)
BAUD_RATE_OSZTO		EQU	.10
	ENDIF


	IF (BAUD_RATE==.1)
BAUD_RATE_OSZTO		EQU	.20
	ENDIF


	IF (BAUD_RATE==.0)
BAUD_RATE_OSZTO		EQU	.64
	ENDIF


	IF (MEMORIA_TESZT==.1)
MEMORIA_KEZDOCIM_1	EQU	0X00
MEMORIA_KEZDOCIM_2	EQU	0X7D
	ENDIF





;************************************************************************************************
;*	STATE BITJEI
;************************************************************************************************
ATVITEL_HIBA_FLAG	EQU	.0		;
SZINT_TRIG_FELETT	EQU	.1		;JELZI, HA A MRT SZINT A TRIGGER SZINT FELETT VOLT(ELZ LLAPOT)
SZINT_TRIG_FELETT_2	EQU	.2		;JELZI, HA A MRT SZINT A TRIGGER SZINT FELETT VAN(JELEN LLAPOT)


;----------------------------------------------------------
;	CIMEK AZ ADATMEMRIBAN !!!
;	A BANK 0-BAN
;----------------------------------------------------------
 CBLOCK	0X20
	TEMP_W				;MEGSZAKITSKOR W RTKE !!! EZ MIND A NGY BANKBAN MEGJELENIK !!
	TEMP_STATUS			;MEGSZAKITSKOR STATUS RTKE
	TEMP_PCLATH			;MEGSZAKITSKOR PCLATH RTKE
	;TEMP_FSR			;
	;TEMP_INDF			;

	STATE				;LLAPOTJELZ BIT

	AD_MERT_1_1			;IDE KERLT VOLNA A MRT RTK, DE 15 RTKET AZRT NEM MENTEK EL!
	AD_MERT_1_2
	AD_CSATORNA			;AZ PPEN MRT CSATORNRA MUTAT

	KESLELTETES_SZAML_1		;KSLELTETSHEZ HASZNLJUK
	KESLELTETES_SZAML_2
	KESLELTETES_SZAML_3

	KOMM_VAR_1
	KOMM_VAR_2
	KOMM_VAR_3

	AD_RESULT_LOW			;AZ TALAKTS EREDMNYT IDE MENTJK
	AD_RESULT_HIGH

	MERES_SZAMLALO_1		;ENNYI MRST CSINLUNK
	MERES_SZAMLALO_2

	;ARITMETIKAI VLTOZK
	D1
	D2
	D3
	D4
	D5
	D6
	D7
	D8
	D9
	D10
	D11
	D12
	D13
	D14
	D15
	D16
	D17
	D18
	D19
	D20


	KOMMUNIKACIO_SZAMLALO_1		;EZT HASZNLJUK A KOMMUNIKCIS IDK ELLENRZSRE
	KOMMUNIKACIO_SZAMLALO_2

	BEJOVO_BYTEOK_SZAMLALO		;ITT SZMOLJUK A BEJV BYTE-OKAT
	
	BEJOVO_BYTE_1
	BEJOVO_BYTE_2
	BEJOVO_BYTE_3
	BEJOVO_BYTE_4
	BEJOVO_BYTE_5
	BEJOVO_BYTE_6
	BEJOVO_BYTE_7
	BEJOVO_BYTE_8
	BEJOVO_BYTE_9
	BEJOVO_BYTE_10
	BEJOVO_BYTE_11

	MEMORIA_MUTATO_1		;EZEKKEL CMEZZK A 24257-ET
	MEMORIA_MUTATO_2

	CSOMAG_SZAMLALO			;AZ ADATOKAT ILYEN HOSSZ CSOMAGOKBAN KLDJK T
	SEND_CHECK_SUM			;AZ ADNI SZNT CSOMAG CHECK_SUM-JA
	CSOMAG_ISMETLES			;EGY CSOMAG SIKERTELEN TADSNL MAX. ENNYISZER ADJUK LE AZT JRA

	MINTA_SZAMLALO
	MINTA_SZAMLALO_ERTEK		;EZT KELL MINDIG VISSZATLTENI A SZMLLBA
	TRIGGER_MOD			;EZ MUTATJA, HOGY MILYEN TRIGGER MDBAN VAGYUNK
					;0: SINGLE/EXTERNAL	1: CONTINUOUS/EXTERNAL
					;2: TRIGGERED/SINGLE	3: TRIGGERED/CONTINUOUS
	MERT_AD_HIGH_ELOZO		;AZ AD FELS NYOLC BITJT FIGYELJK CSAK A TRIGGERELSNL, EZ AZ ELZ MINTT TROLJA
 ENDC







	ERRORLEVEL	-302,-307,-306
	NOEXPAND				;A MAKRKAT NEM CSINLJA VGIG, TUGORJA

	LIST    P=16F873
	INCLUDE	<P16F873.INC>
	INCLUDE <MACRO.ASM>
	__CONFIG	_CP_OFF&_DEBUG_OFF&_WRT_ENABLE_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_PWRTE_ON&_HS_OSC


	ORG	0X2100
	IF	(TESZT==0)
	DE	AZONOSITO,TESZT,BAUD_RATE_OSZTO
	ENDIF

	IF	(TESZT==1)
	DE	AZONOSITO," TESZT! ",BAUD_RATE_OSZTO
	ENDIF







RESETVEKTOR
	org	0x0000		;A KEZDCIM, ITT INDUL A PROGRAM BEKAPCSOLSKOR
	GOTO	INIT		;TUGORJUK A MEGSZAKITSI RUTINT





MEGSZAKITSVEKTOR
	ORG	0X0004		;MEGSZAKITSI VEKTORCIM

INTERRUPT
PUSH
	MOVWF	TEMP_W			;MEGSZAKITS, ELMENTJK W,STATUS S PCLATH RTKT !!!
	SWAPF	STATUS,W		;A STATUS TARTALMT MEGCSERLJK S TIRJUK W-BE
	BCF	STATUS,RP0		;KIJELLJK A 0-S BANKOT
	BCF	STATUS,RP1		;
	MOVWF	TEMP_STATUS		;A STATUS EREDETI RTKT ELMENTJK A 0-S BANKBA
	MOVF	PCLATH,W		;A PCLATH-OT IS ELMENTJK
	MOVWF	TEMP_PCLATH		;	

INTERRUPT_SELECT
	BTFSS	INTCON,INTE		;HIBA VAN MEGSZAKTS, HA NINCS ENGEDLYEZVE
	GOTO	POP
	BTFSC	INTCON,INTF		;
	GOTO	INT0_MEGSZ		;

POP
	MOVF	TEMP_PCLATH,W		;VISSZATLTJK PCLATH-OT
	MOVWF	PCLATH
	SWAPF	TEMP_STATUS,W		;A STATUS ELZ RTKT VISSZATLTJK
	MOVWF	STATUS
	SWAPF	TEMP_W,F		;A W EREDETI TARTALMNAK VISSZATLTSE, AZRT SWAP-EL
	SWAPF	TEMP_W,W		;CSINLJUK, MERT A MOVWF LLITJA A Z-T !!!
	RETFIE




INT0_MEGSZ

	GOTO	POP







;*********************************************************************************
;*	INICIALIZLS
;*********************************************************************************
INIT
	BANKSEL_1
;******************************************************************
;*	A B PORT INICIALIZLSA
;******************************************************************
	MOVLW	B'11111111'		;AZ RB0 KIMENET S BEMENET IS LEHET
	MOVWF	TRISB
	MOVLW	B'10000000'		;A FELHZ ELLENLLSOKAT KIKAPCSOLJUK, ELOSZT TMR0-HOZ, 1:2
	MOVWF	OPTION_REG
;******************************************************************
;*	A C PORT INICIALIZLSA
;******************************************************************
	MOVLW	B'10000000'		; A PORTC CMEKET AD, KIMENET( 7. 6. : RX/TX )
	MOVWF	TRISC

	MOVLW	B'00000110'		;ASZINKRON MD, 8-BITES TVITEL, TRANSMIT TILTVA, TRMT : 1, 9. BIT : 0
	MOVWF	TXSTA			;BRGH = 1, ALAPRAJEL : Tosc/(16(X+1))

	MOVLW	BAUD_RATE_OSZTO		;BAUD_RATE_OSZTO = 10   =>   20'000'000 / 16 ( 11 ) ) = 113'636 2% ELTRS 115,2KBAUD-TL
	MOVWF	SPBRG
	BANKSEL_0
	MOVLW	b'10010000'		;ENGEDLYEZZK A SOROS PORTOT S A FOLYAMATOS VTELT
	MOVWF	RCSTA

        movf RCREG,W 
        movf RCREG,W 
        movf RCREG,W            ; flush receive buffer 
	CLRF	RCREG
;******************************************************************
;*	A/D TALAKIT INICIALIZLSA
;******************************************************************
	BANKSEL_1
	MOVLW	B'10001110'	;A0 ANALG, A TBBI DIGITLIS, ADRESH ALS KT BITJE LESZ RTKES
	MOVWF	ADCON1		;

	BANKSEL_0
	MOVLW	B'10000001'	;RA0, IDALAP : 1/32 Fosc, 0. CSATORNA, MODUL BEKAPCSOL
	MOVWF	ADCON0		;

;******************************************************************
;*	AZ A PORT INICIALIZLSA
;******************************************************************
	BANKSEL_1
 	MOVLW	B'00000001'	;
	MOVWF	TRISA		;
	BANKSEL_0
	BSF	NOTWE		;LETILTJUK A RAM-OT
	BSF	NOTOE
	BCF	CIM14BIT
	BCF	LATCH1_CLOCK
	BCF	LATCH1_CLOCK

;******************************************************************
;*	A FELHASZNLT RAMTERLET INICIALIZLSA
;******************************************************************
MEMORIA_TORLESE
	BANKSEL	TEMP_W			;
	MOVLW	0X21			;20-TL NULLZUNK
	MOVWF	FSR			;INDIREKTEN CIMEZZK
	MOVLW	0X5D			;
	MOVWF	TEMP_W			;
MEMORIA_TORLESE_UJRA
	CLRF	INDF			;
	INCF	FSR,F			;
	DECFSZ	TEMP_W,F		;
	GOTO	MEMORIA_TORLESE_UJRA

;************************************************************************************************
;*	SAJT VLTOZK INICIALIZLSA
;************************************************************************************************
	BSF	NOTOE
	BSF	NOTWE				;LETILTJUK A RAM KIMENETEKET
	CLRF	PORTC

	BCF	LATCH1_CLOCK			;TRLJK A CM LATCH-EKET
	NOP
	BSF	LATCH1_CLOCK
	NOP
	BCF	LATCH1_CLOCK
	BCF	LATCH2_CLOCK
	NOP
	BSF	LATCH2_CLOCK
	NOP
	BCF	LATCH2_CLOCK			;A LATCH-EKET LOW-BAN HAGYJUK







FOPROG_USART_INIT
	CALL	SOROS_INIT
FOPROG_USART_RESET
	BCF	STATE,ATVITEL_HIBA_FLAG
	CALL	SOROS_RESET			;RESETELJK, MAJD JRAINDTJUK AZ USART-OT


	MOVLW	BYTE_CSOMAG_GYARI
	MOVWF	BEJOVO_BYTEOK_SZAMLALO		;ELOLRL KEZDJK SZMOLNI AZ ADATOKAT
	MOVLW	BEJOVO_BYTE_1			;INDIREKTEN MENTJK AZ ADATOKAT, AZ ELS ELEMRE MUTATUNK
	MOVWF	FSR


FOPROGRAM

	IF (TESZT_NO_USART==.1)
	MOVLW	B'00100001'
	MOVWF	BEJOVO_BYTE_1
	MOVLW	0X0A
	MOVWF	BEJOVO_BYTE_2
	MOVLW	B'00000001'
	MOVWF	BEJOVO_BYTE_5


	GOTO	VETEL_OK
	ENDIF



;**********************************************************************************************
;*	FPROGRAM 
;**********************************************************************************************
	MOVFW	BEJOVO_BYTEOK_SZAMLALO
	SUBLW	BYTE_CSOMAG_GYARI
	BZ	FOPROGRAM_KOMM

	DECFSZ16_MAC	KOMMUNIKACIO_SZAMLALO_1,KOMMUNIKACIO_SZAMLALO_2
	GOTO	FOPROGRAM_KOMM
	GOTO	FOPROG_USART_RESET			;KIFUTOTTUNK AZ IDBL, RESETELJK A KOMMUNIKCIT


FOPROGRAM_KOMM
	MOVFW	RCSTA				;MEGNZZK, HOGY TRTNT-E HIBA
	ANDLW	B'00000110'			;HA 'FERR' VAGY 'OERR' HIBA VAN, AKKOR JRAINDTJUK AZ USART-OT
	SKPZ
USART_ERROR
	GOTO	FOPROG_USART_RESET


USART_NO_ERROR
	BANKSEL	PIR1

;	IF (TESZT==1)
;	BSF	PIR1,RCIF
;	ENDIF

	BTFSS	PIR1,RCIF			;CSAK AKKOR NZZK MEG A SOROS PORTOT, HA VOLT VTEL!
	GOTO	FOPROGRAM

        movf	RCREG,W            		; save received data in W 
	MOVWF	INDF				;ELMENTJK A VETT BYTE-OT
	INCF	FSR,F				;A KVETKEZ ELEMRE MUTATUNK

	FILL16_MAC	KOMM_SZAMLALO_GYARI_1,KOMM_SZAMLALO_GYARI_2,KOMMUNIKACIO_SZAMLALO_1,KOMMUNIKACIO_SZAMLALO_2

	DECFSZ	BEJOVO_BYTEOK_SZAMLALO,F
	GOTO	FOPROGRAM			;NEM VOLT VTEL, VRAKOZUNK


	CHECK_SUM_MAC	BEJOVO_BYTE_1,(BYTE_CSOMAG_GYARI-1),D1	;KISZMOLJUK AZ 1 BYTE-OS CHECK_SUM-OT

	BNZ	FOPROG_USART_RESET			;A CHECK_SUM HIBS!

	MOVLW	NYUGTA_PC_FELE_GYARI
	CALL	SEND_BYTE

VETEL_OK
;	IF (TESZT==1)
;	MOVLW	B'00100000'				;SINGLE, TRIGGER ZEMMD
;	MOVWF	BEJOVO_BYTE_1
;	MOVLW	0X80					;TRIGGER FELS NYOLC BITJE
;	MOVWF	BEJOVO_BYTE_2
;	MOVLW	0X05					;HNY MINTT TROLUNK
;	MOVWF	BEJOVO_BYTE_3
;	MOVLW	0X00					;FELFUT VAGY LEFUTLET FIGYELJNK-E (0:LEFUT, 1:FELFUT)
;	MOVWF	BEJOVO_BYTE_5
;	ENDIF


	CALL	MERESIMOD_MEGHATAROZ			;BELLTJUK A TRIGGER MD-OT S A MRSI FREKVENCIT


	MOVLW	HIGH(FOMENU_TABLAZAT+1)	;EZ IS KELL A HELYES MKDSHEZ
	MOVWF	PCLATH				;
	MOVFW	TRIGGER_MOD				;MEGNZZK, HOGY MELYIK TRIGGER-MDBAN VAGYUNK

FOMENU_TABLAZAT
	ADDWF	PCL,F				;UGRTBLA
	GOTO	FOPROGRAM_MERES_MENTES			;0. TRIGGER : A PC FELL JV JELRE AUTOMATIKUSAN INDUL IS A MRS
	GOTO	FOPROGRAM_MERES_MENTES			;1. TRIGGER : A PC AUTOMATIKUSAN ADOGATJA A TRIGGER JELEKET
	GOTO	FOPROG_AD_MERES				;2. TRIGGER : FIGYELJK AZ AD RTKT, AKKOR INDUL A MRS, HA A TRIGGER FELETT VAGYUNK
	GOTO	FOPROG_AD_MERES				;3. TRIGGER : ELTRS CSAK A MINTAVTELEK UTN VAN, ITT JRA KELL KEZDENI FIGYELNI A TRIGGERT

	IF	HIGH(FOMENU_TABLAZAT)!=HIGH($)		;HA TCSSZNA A 256 BYTE-OS HATRON, AKKOR HIBAJELZS !
	ERROR	"UGROTBLA-HIBA !"
	ENDIF


FOPROG_AD_MERES						;ELSZR CSINLUNK EGY MRST, EZUTN MINDIG AZ ELZHZ VISZONYTUNK
	BSF	ADCON0,GO_DONE			;INDTJUK AZ TALAKTST
	CALL	AD_RUTIN				;A MRT RTKEKET MEGKAPJUK AD_RESULT_HIGH S AD_RESULT_LOW - BAN

	IF	(TESZT_NO_USART==1)
	MOVLW	0X27
	MOVWF	AD_RESULT_LOW
	ENDIF

	CLRC
	RRF	AD_RESULT_HIGH,F			;JOBRA FORGATJUK KTSZER, GY MEGKAPJUK A FELS NYOLC BITET
	RRF	AD_RESULT_LOW,F				;A TRIGGERSZINT- SSZEHASONLTSHOZ
	CLRC
	RRF	AD_RESULT_HIGH,F
	RRF	AD_RESULT_LOW,F				;AD_RESULT_LOW-BAN AZ FELS NYOLC BIT!
;	MOVWF	MERT_AD_HIGH_ELOZO
	MOVFW	BEJOVO_BYTE_2				;MEGNZZK, HOGY A TRIGGER HOGYAN VISZONYUL A MRT SZINTHEZ
	BCF	STATE,SZINT_TRIG_FELETT
	SUBWF	AD_RESULT_LOW,W				;F-W (MRT_SZINT - TRIGGER SZINT)
	SKPNC
	BSF	STATE,SZINT_TRIG_FELETT			;JELEZZK, HOGY A SZINT A TRIGGER FELETT VAN

FOPROG_AD_MERES_ISM
	CALL	AD_RUTIN				;A MRT RTKEKET MEGKAPJUK AD_RESULT_HIGH S AD_RESULT_LOW - BAN
	CLRC
	RRF	AD_RESULT_HIGH,F			;JOBRA FORGATJUK KTSZER, GY MEGKAPJUK A FELS NYOLC BITET
	RRF	AD_RESULT_LOW,F				;A TRIGGERSZINT- SSZEHASONLTSHOZ
	CLRC
	RRF	AD_RESULT_HIGH,F
	RRF	AD_RESULT_LOW,F				;AD_RESULT_LOW-BAN A FELS NYOLC BIT!

	MOVFW	AD_RESULT_LOW
	W_KISEBBEGYENLO_F_MAC	BEJOVO_BYTE_2,FOPROG_TRIG_MAGAS,W

FOPROG_TRIG_ALACSONY				;A MRT JEL MAGASABB, MINT A TRIGGER SZINT
	BSF	STATE,SZINT_TRIG_FELETT_2
	BTFSS	BEJOVO_BYTE_5,0				;HA '1', AKKOR FELFUTLET KELL FIGYELNI
	GOTO	TRIG_VIZSGALAT_VEGE			;MIVEL A MRT SZINT MAGASABB, BIZTOSAN NINCS LEFUTL
	BTFSS	STATE,SZINT_TRIG_FELETT			;HA ELTTE A TRIGGER ALATT VOLT A SZINT, AKKOR MEGVAN A FELUTL!
	GOTO	FOPROGRAM_MERES_MENTES
	GOTO	TRIG_VIZSGALAT_VEGE


FOPROG_TRIG_MAGAS					;A MRT JEL ALACSONYABB, MINT A TRIGGER SZINT 
	BCF	STATE,SZINT_TRIG_FELETT_2
	BTFSC	BEJOVO_BYTE_5,0				;HA '0', AKKOR LEFUTLET KELL FIGYELNI
	GOTO	TRIG_VIZSGALAT_VEGE			;MIVEL A MRT SZINT ALACSONYABB, BIZTOSAN NINCS FELFUTL
	BTFSC	STATE,SZINT_TRIG_FELETT			;HA ELTTE A TRIGGER FELETT VOLT A SZINT, AKKOR MEGVAN A LEFUTL!
	GOTO	FOPROGRAM_MERES_MENTES
	GOTO	TRIG_VIZSGALAT_VEGE
;ITTARTASZ


TRIG_VIZSGALAT_VEGE
	BCF	STATE,SZINT_TRIG_FELETT
	BTFSC	STATE,SZINT_TRIG_FELETT_2
	BSF	STATE,SZINT_TRIG_FELETT
	GOTO	FOPROG_AD_MERES_ISM



FOPROGRAM_MERES_MENTES
	CALL	MERES_MENTES				;MRNK S KLDNK (AMENNYIT KELL)
	CALL	MEMORIATARTALOM_ATKULDESE

	BTFSS	STATE,ATVITEL_HIBA_FLAG
	GOTO	FOPROGRAM
	GOTO	FOPROG_USART_RESET














;************************************************************************************************************
;*	ITT A VETT BYTE-OK ALAPJN BELLTJUK A MEGFELEL MRSI MDOT
;************************************************************************************************************


MERESIMOD_MEGHATAROZ
	MOVLW	HIGH(IDOZITES_TABLAZAT+1)	;EZ IS KELL A HELYES MKDSHEZ
	MOVWF	PCLATH				;

	MOVFW	BEJOVO_BYTE_1			;BELLTJUK A MINTAVTELI IDT
	ANDLW	B'00001111'			;AZ ALS NGY BITEN VAN A MRSI ID	
	SUBLW	.7				;W-7
	SKPNC
	GOTO	MERESIMOD_TOVABB
	MOVFW	BEJOVO_BYTE_1
	ANDLW	B'11110000'
	IORLW	B'00000111'
	MOVWF	BEJOVO_BYTE_1	
MERESIMOD_TOVABB
	MOVFW	BEJOVO_BYTE_1
	ANDLW	B'00001111'			;AZ ALS NGY BITEN VAN A MRSI ID	
	CALL	IDOZITES_TABLAZAT
	MOVWF	MINTA_SZAMLALO_ERTEK		;EZT KELL MAJD MINDIG VISSZATLTENI A SZAMLALO-BA
	MOVWF	MINTA_SZAMLALO


	SWAPF	BEJOVO_BYTE_1,W
	ANDLW	B'00001111'			;A FELS NGY BITEN VAN A TRIGGER MD
	SUBLW	.3				;W-3
	SKPNC
	GOTO	TRIGGERMOD_TOVABB
	MOVFW	BEJOVO_BYTE_1
	ANDLW	B'00001111'
	IORLW	B'00000000'			;HA NEM MEGFELEL A TRIGGER-MD, AKKOR AZ 0-S MDOT LLTJUK BE
	MOVWF	BEJOVO_BYTE_1	
TRIGGERMOD_TOVABB
	SWAPF	BEJOVO_BYTE_1,W
	ANDLW	B'00001111'			;
	MOVWF	TRIGGER_MOD			;EZ MUTATJA A TRIGGER MDOT
	RETURN



IDOZITES_TABLAZAT
	ADDWF	PCL,F				;UGRTBLA
	RETLW	.1				;40kSPS
	RETLW	.2				;20kSPS
	RETLW	.4				;10kSPS
	RETLW	.8				;5kSPS
	RETLW	.20				;2kSPS
	RETLW	.40				;1kSPS
	RETLW	.80				;500sPS
	RETLW	.200				;200sPS
	RETLW	.200
	RETLW	.200


	IF	HIGH(IDOZITES_TABLAZAT)!=HIGH($)		;HA TCSSZNA A 256 BYTE-OS HATRON, AKKOR HIBAJELZS !
	ERROR	"UGROTBLA-HIBA !"
	ENDIF








;***************************************************************************************************
;*
;*		ITT TRTNIK MEG A KRT SZM MINTA RGZTSE
;*
;***************************************************************************************************
MERES_MENTES


MERES_KEZDETE
	BSF	ADCON0,GO_DONE			;INDTJUK AZ TALAKTST!

	BSF	NOTOE
	BSF	NOTWE				;LETILTJUK A RAM KIMENETEKET
	CLRF	MEMORIA_MUTATO_1		;0-TL KEZDJK FELTLTENI A MEMRIT
	CLRF	MEMORIA_MUTATO_2
	CLRF	PORTC
	BCF	LATCH1_CLOCK			;TRLJK A CM LATCH-EKET
	NOP
	BSF	LATCH1_CLOCK
	NOP
	BCF	LATCH1_CLOCK

	BCF	LATCH2_CLOCK
	NOP
	NOP
	BSF	LATCH2_CLOCK
	NOP
	BCF	LATCH2_CLOCK

	BANKSEL_1
	CLRF	TRISB				;PORTB KIMENET
	BANKSEL_0
	CLRF	PORTB

	CLRF	MEMORIA_MUTATO_1
	CLRF	MEMORIA_MUTATO_2

	IF (MEMORIA_TESZT==.1)
	MOVLW	MEMORIA_KEZDOCIM_1
	MOVWF	MEMORIA_MUTATO_1
	MOVLW	MEMORIA_KEZDOCIM_2
	MOVWF	MEMORIA_MUTATO_2
	ENDIF


;	IF (TESZT==.1)
;	MOVLW	MERESEK_SZAMA_1_GYARI
;	MOVWF	BEJOVO_BYTE_3
;	MOVLW	MERESEK_SZAMA_2_GYARI
;	MOVWF	BEJOVO_BYTE_4
;	ENDIF

	MOV16_MAC BEJOVO_BYTE_3,BEJOVO_BYTE_4,MERES_SZAMLALO_1,MERES_SZAMLALO_2	;A 3-4. VETT BYTE MONDJA MEG, HNY MINTT KELL VENNI


MERES_ISMETLES
	CALL	AD_RUTIN			;MEGNZZK AZ ANALGOT


MEMORIA_IRASA
	NOP						;EZ A SZINKRONOZSHOZ KELL!!! NE TRLD KI!!!
	DECFSZ	MINTA_SZAMLALO,F			;NEM BIZTOS, HOGY EL KELL MENTENI AZ ADATOT! (A MINTAVTELI FREKVENCITL FGG)
	GOTO	MERES_ISMETLES

MEMORIA_IRASA_IRAS
	MOVFW	MINTA_SZAMLALO_ERTEK			;
	MOVWF	MINTA_SZAMLALO				;JRA FELTLTJK AZ ELOSZTT

	CALL	RAM_CIM_BEALLITAS

	MOVFW	AD_RESULT_LOW

	MOVWF	PORTB				;KIRJUK A MEMRIBA
	BCF	NOTWE				;BERJUK AZ ADATOT
	NOP
	BSF	NOTWE				;ISMT LETILTJUK A RAM-BA RST
	ADD16_MAC	MEMORIA_MUTATO_1,MEMORIA_MUTATO_2,.1	;LPTETJK A MEMRIA MUTATT


	BSF	PORTC,0				;ELVILEG IDE ENNYI IS ELG A KVETKEZ CMRE MUTATSHOZ


	MOVFW	AD_RESULT_HIGH

	MOVWF	PORTB				;KIRJUK A MEMRIBA
	BCF	NOTWE				;BERJUK AZ ADATOT
	NOP
	BSF	NOTWE				;ISMT LETILTJUK A RAM-BA RST
	ADD16_MAC	MEMORIA_MUTATO_1,MEMORIA_MUTATO_2,.1	;LPTETJK A MEMRIA MUTATT

	DECFSZ16_MAC	MERES_SZAMLALO_1,MERES_SZAMLALO_2		;CSAK ANNYI MRST CSINLUNK,AMENNYI SZKSGES
	GOTO	MERES_ISMETLES

	RETURN
















;***************************************************************************************************
;*
;*		ITT TRTNIK MEG A KRT SZM MINTA KIOLVASSA S TKLDSE AZ USART-RA
;*
;***************************************************************************************************
MEMORIATARTALOM_ATKULDESE
	BSF	NOTOE
	BSF	NOTWE				;LETILTJUK A RAM KIMENETEKET
	CLRF	MEMORIA_MUTATO_1		;0-TL KEZDJK KIOLVASNI A MEMRIT
	CLRF	MEMORIA_MUTATO_2
	CLRF	PORTC
	BCF	LATCH1_CLOCK			;TRLJK A CM LATCH-EKET
	NOP
	BSF	LATCH1_CLOCK
	NOP
	BCF	LATCH1_CLOCK

	BCF	LATCH2_CLOCK
	NOP
	BSF	LATCH2_CLOCK
	NOP
	BCF	LATCH2_CLOCK


	IF (MEMORIA_TESZT==.1)
	MOVLW	MEMORIA_KEZDOCIM_1
	MOVWF	MEMORIA_MUTATO_1
	MOVLW	MEMORIA_KEZDOCIM_2
	MOVWF	MEMORIA_MUTATO_2
	ENDIF


	MOV16_MAC BEJOVO_BYTE_3,BEJOVO_BYTE_4,MERES_SZAMLALO_1,MERES_SZAMLALO_2	;A 3-4. VETT BYTE MONDJA MEG, HNY MINTT KELL VENNI

	BANKSEL_1
	MOVLW	B'11111111'
	MOVWF	TRISB				;PORTB BEMENET
	BANKSEL_0

	BCF	NOTOE				;OLVASSRA LLTJUK A RAM-OT


SEND_CSOMAG_START
	MOVLW	CSOMAG_ISMETLES_GYARI
	MOVWF	CSOMAG_ISMETLES
SEND_CSOMAG_HIBAS_UJRAKULD
	MOVLW	CSOMAG_SZAMLALO_GYARI
	MOVWF	CSOMAG_SZAMLALO
	CLRF	SEND_CHECK_SUM			;ITT GYJTJK EGY CSOMAG CHECK-SUM-JT
SEND_CSOMAG_ISM
	CALL	MEMORIA_OLVASASA		;KIKULDUNK 2 BYTE-OT
	SUB16_MAC	MERES_SZAMLALO_1,MERES_SZAMLALO_2,.1		;SZMOLJUK VISSZAFEL A MRSEKET

	DECFSZ	CSOMAG_SZAMLALO,F		;SZMOLJUK A KIKLDTT DUPLABYTE-OKAT
	GOTO	SEND_CSOMAG_ISM
	MOVFW	SEND_CHECK_SUM			;KIKLDJK A CHECK_SUM-OT IS
	CALL	SEND_BYTE

	CALL	RECEIVE_BYTE

	XORLW	NYUGTA_PC_FELOL_GYARI		;MEGNZZK, HOGY JTT-E NYUGTA
	BNZ	SEND_CSOMAG_HIBA		;HA NEM JTT NYUGTA, LEKEZELJK A HIBT

		;A NYUGTA MEGJTT, KLDJK A KVETKEZ CSOMAGOT
	TEST16_MAC	MERES_SZAMLALO_1,MERES_SZAMLALO_2	;HA A MRS SZMLL 0, AKKOR VGE
	SKPNZ
	RETURN					;BEFEJEZTK AZ TVITELT
	GOTO	SEND_CSOMAG_START		;KLDJK A KVETKEZ CSOMAGOT


SEND_CSOMAG_HIBA
	DECFSZ	CSOMAG_ISMETLES,F		;HA MG LEHET, MEGPRBLJUK JRA LEADNI A CSOMAGOT
	GOTO	SEND_CSOMAG_UJRAKULD
	BSF	STATE,ATVITEL_HIBA_FLAG		;JELEZZK A FPROGRAMHUROKNAK, HOGY MEGSZAKADT AZ TVITEL
	RETURN					;IDE AKKOR JUTUNK, HA AZ JRAPRBLKOZSOKKAL SEM SIKERL NYUGTT FOGADNUNK
SEND_CSOMAG_UJRAKULD
	ADD16_MAC	MERES_SZAMLALO_1,MERES_SZAMLALO_2,CSOMAG_SZAMLALO_GYARI	;A MRS SZMT S A CMEKET VISSZALLTJUK EGY CSOMAGNYIVAL
	SUB16_MAC	MEMORIA_MUTATO_1,MEMORIA_MUTATO_2,CSOMAG_SZAMLALO_GYARI	;A MEMRIBAN 2-SZER ANNYIT KELL VISSZALLTANI
	SUB16_MAC	MEMORIA_MUTATO_1,MEMORIA_MUTATO_2,CSOMAG_SZAMLALO_GYARI
	GOTO	SEND_CSOMAG_HIBAS_UJRAKULD






;*********************************************************************************************************
;*
;*	KIOLVASUNK A MEMRIBL 2 BYTE-OT S ELKLDJK AZ USART-RA
;*
;*	BEMENET:	MEMORIA_MUTATO_1
;*			MEMORIA_MUTATO_2
;*********************************************************************************************************
MEMORIA_OLVASASA
	CALL	RAM_CIM_BEALLITAS

	MOVFW	PORTB				;BEOLVASSUK AZ ADATOT
	ADDWF	SEND_CHECK_SUM,F		;HOZZADJUK A CHECK_SUM-HOZ
	CALL	SEND_BYTE			;S EL IS KLDJK


	ADD16_MAC	MEMORIA_MUTATO_1,MEMORIA_MUTATO_2,.1	;LPTETJK A MEMRIA MUTATT
	CALL	RAM_CIM_BEALLITAS

	MOVFW	PORTB				;BEOLVASSUK AZ ADATOT
	ADDWF	SEND_CHECK_SUM,F		;HOZZADJUK A CHECK_SUM-HOZ
	CALL	SEND_BYTE			;S EL IS KLDJK

	ADD16_MAC	MEMORIA_MUTATO_1,MEMORIA_MUTATO_2,.1	;LPTETJK A MEMRIA MUTATT

	RETURN


MEMORIA_OLVASASA_BEFEJEZES
	BSF	NOTOE
	BSF	NOTWE				;LETILTJUK A RAM KIMENETEKET
	CLRF	MEMORIA_MUTATO_1		;0-TL KEZDJK KIOLVASNI A MEMRIT
	CLRF	MEMORIA_MUTATO_2
	CLRF	PORTC
	BCF	LATCH1_CLOCK			;TRLJK A CM LATCH-EKET
	NOP
	BSF	LATCH1_CLOCK
	NOP
	BCF	LATCH1_CLOCK

	BCF	LATCH2_CLOCK
	NOP
	BSF	LATCH2_CLOCK
	NOP
	BCF	LATCH2_CLOCK


	IF (MEMORIA_TESZT==.1)
	MOVLW	MEMORIA_KEZDOCIM_1
	MOVWF	MEMORIA_MUTATO_1
	MOVLW	MEMORIA_KEZDOCIM_2
	MOVWF	MEMORIA_MUTATO_2
	ENDIF



;	IF (TESZT_NO_USART==.1)
;	MOVLW	B'01011010'
;	MOVWF	MEMORIA_MUTATO_2
;	MOVLW	B'11011111'
;	MOVWF	MEMORIA_MUTATO_1
;	ENDIF

	MOV16_MAC BEJOVO_BYTE_3,BEJOVO_BYTE_4,MERES_SZAMLALO_1,MERES_SZAMLALO_2	;A 3-4. VETT BYTE MONDJA MEG, HNY MINTT KELL VENNI

	BANKSEL_1
	MOVLW	B'00000000'
	MOVWF	TRISB				;PORTB BEMENET
	BANKSEL_0



	RETURN
















;**********************************************************************************************
;*	ITT LLTJUK BE AZ AKTULIS MEMRIA CMET, D1-ET S D2-T IS FELHASZNLJA!
;**********************************************************************************************
RAM_CIM_BEALLITAS
	BCF	CIM14BIT
	BTFSC	MEMORIA_MUTATO_2,6		;A FELS CM 14. BITJE TARTOZIK RA4-HEZ
	BSF	CIM14BIT

	BCF	LATCH1_CLOCK			;NULLBA HZZUK AZ RAJELET => FELFUTLRE TRTNIK MEG A BERS
	MOVFW	MEMORIA_MUTATO_2
	ANDLW	B'00111100'			;10-13. BITCMEK BELLTSA
	MOVWF	D1				;D1: '00XXXX00'
	CLRC
	RRF	D1,F
	RRF	D1,W
	MOVWF	PORTC				;D1:'0000XXXX' NHNY UTASTSSAL KSBB TRTNI MEG A BERS

	BCF	LATCH2_CLOCK			;NULLBA HZZUK AZ RAJELET => FELFUTLRE TRTNIK MEG A BERS
	MOVFW	MEMORIA_MUTATO_2
	ANDLW	B'00000011'			;
	MOVWF	D1				;D1:'000000XX' EZEK A CM 9-10. BITJEI
	CLRC
	RLF	D1,F
	RLF	D1,F				;D1:'0000XX00'
	
	BSF	LATCH1_CLOCK			;MAGASBA LLTJUK AZ RAJELET => MEG TRTNIK A LATCH1 BERSA
	BCF	LATCH1_CLOCK			;ALACSONYBA HZZUK AZ RAJELEKET, GY MEGRZI A TARTALMT A LATCH


	MOVFW	MEMORIA_MUTATO_1
	ANDLW	B'11000000'
	MOVWF	D2				;D2:'XX000000'
	SWAPF	D2,F				;D2:'0000XX00'
	CLRC
	RRF	D2,F
	RRF	D2,F				;D2:'000000XX'
	MOVFW	D1
	IORWF	D2,W
	MOVWF	PORTC				;D2:'0000XXXX'

	MOVFW	MEMORIA_MUTATO_1
	ANDLW	B'00111111'			;A LEGALS BYTE-OKAT IS KIADJUK, DIREKTBE

	BSF	LATCH2_CLOCK			;MAGASBA LLTJUK AZ RAJELET => MEG TRTNIK A LATCH2 BERSA

	MOVWF	PORTC

	BCF	LATCH2_CLOCK			;ALACSONYBA HZZUK AZ RAJELEKET, GY MEGRZI A TARTALMT A LATCH

	RETURN



























RECEIVE_BYTE					;BYTE_VTELE, IDZTSSEL
	MOVLW	VETEL_VAR_1_GYARI
	MOVWF	KOMM_VAR_1
	MOVLW	VETEL_VAR_2_GYARI
	MOVWF	KOMM_VAR_2
	MOVLW	VETEL_VAR_3_GYARI
	MOVWF	KOMM_VAR_3			;EZZEL A HROM SZMLLVAL VRJUK A VTELT

VETEL_VAR
	BANKSEL_0
	DECF	KOMM_VAR_1,F	;CSKKENTJK A SZMLL RTKT
	BNZ	VETEL_VAR_UJRA	;HA A SZMLL RTKE NEM 0, AKKOR TOVBBLPNK

	DECF	KOMM_VAR_2,F
	BNZ	VETEL_VAR_UJRA

	DECF	KOMM_VAR_3,F
	TSTF	KOMM_VAR_3		;HA A 3. BYTE IS 0, AKKOR LEJRT A SZMLL, KIUGRUNK A HUROKBL
	SKPNZ
	GOTO	VETEL_HIBA		;HA ADOTT IDN BELL NEM VGZNK AZ ADSSAL, AKKOR HIBA VAN
	

VETEL_VAR_UJRA
;	IF	(TESZT==1)
;	BANKSEL_0
;	BSF	PIR1,RCIF
;	ENDIF

;	BANKSEL	PIR1				;FIGYELJK, HOGY JN-E VISSZA NYUGTA
	BTFSS	PIR1,RCIF			;CSAK AKKOR NZZK MEG A SOROS PORTOT, HA VOLT VTEL!
	GOTO	VETEL_VAR

        movf	RCREG,W            		; save received data in W 

VETEL_VAR_VEGE
;       BANKSEL_0		; RAM PAGE 0 
        RETURN			;W-BEN A VETT BYTE
	

VETEL_HIBA
;	BANKSEL_0
	MOVLW	.0
	RETURN				;0 AZ RES VTELT JELZI







;*******************************************************************************************************
;*	D1 IS FEL VAN HASZNLVA!!!
;*******************************************************************************************************
SEND_BYTE
	BANKSEL_0
	MOVWF TXREG             ; send data in W 

	MOVLW	ADAS_VAR_1_GYARI
	MOVWF	KOMM_VAR_1
	MOVLW	ADAS_VAR_2_GYARI
	MOVWF	KOMM_VAR_2
	MOVLW	ADAS_VAR_3_GYARI
	MOVWF	KOMM_VAR_3	;EZZEL A HROM SZMLLVAL VRJUK AZ ADS VGT

ADAS_VAR
	BANKSEL_0
	DECF	KOMM_VAR_1,F	;CSKKENTJK A SZMLL RTKT
	BNZ	ADAS_VAR_UJRA	;HA A SZMLL RTKE NEM 0, AKKOR TOVBBLPNK

	DECF	KOMM_VAR_2,F
	BNZ	ADAS_VAR_UJRA

	DECF	KOMM_VAR_3,F
	TSTF	KOMM_VAR_3		;HA A 3. BYTE IS 0, AKKOR LEJRT A SZMLL, KIUGRUNK A HUROKBL
	SKPNZ
	GOTO	ADAS_HIBA		;HA ADOTT IDN BELL NEM VGZNK AZ ADSSAL, AKKOR HIBA VAN
	

ADAS_VAR_UJRA
;	IF	(TESZT==1)
;	BANKSEL_1
;	BSF	TXSTA,TRMT
;	BANKSEL_0
;	ENDIF

	BANKSEL_1
	BTFSS TXSTA,TRMT	; (1) transmission is complete if hi 
	GOTO	ADAS_VAR

ADAS_VAR_VEGE
        BANKSEL_0		; RAM PAGE 0 
        RETURN			;VGE AZ ADSNAK




ADAS_HIBA
	CALL	SOROS_RESET		;RESETELJK A SOROS PORTOT
	GOTO	0X00			;JRAINDTJUK A PROCESSZORT!






SOROS_RESET
	BANKSEL	TXSTA
	BCF	TXSTA,TXEN

	BANKSEL	RCREG
	MOVLW	0X00
	MOVWF	TXREG
        movf RCREG,W 
        movf RCREG,W 
        movf RCREG,W            ; flush receive buffer 


	BANKSEL	RCSTA
	BCF	RCSTA,CREN


	BANKSEL	TXSTA
	BSF	TXSTA,TXEN

	BANKSEL	RCSTA
	BSF	RCSTA,CREN



	RETURN








SOROS_INIT
	MOVLW	B'00000110'		;ASZINKRON MD, 8-BITES TVITEL, TRANSMIT TILTVA, TRMT : 1, 9. BIT : 0
	BANKSEL	TXSTA
	MOVWF	TXSTA
 	MOVLW	BAUD_RATE_OSZTO		;AZ TVITEL SEBESSGT A KRT BAUD-RA LLTJUK
	MOVWF	SPBRG
	BANKSEL	RCSTA
	MOVLW	b'10010000'		;ENGEDLYEZZK A SOROS PORTOT
	MOVWF	RCSTA


        movf RCREG,W 
        movf RCREG,W 
        movf RCREG,W            ; flush receive buffer 
	RETURN










;************************************************************************************************
;*	AD TALAKTS
;************************************************************************************************
AD_RUTIN


AD_FOLYIK_E					;MEGNZZK, HOGY BEFEJEZDTT-E AZ ELZ TALAKTS
	BTFSC	ADCON0,GO_DONE			;POLLINGOLVA FIGYELJK AZ TALAKTS VGT
	GOTO	AD_FOLYIK_E			;

;	IF	(TESZT==1)
;	MOVLW	.1
;	MOVWF	ADRESH
;	BANKSEL_1
;	MOVLW	0XAA
;	MOVWF	ADRESL
;	BANKSEL_0
;	ENDIF
;************************************************************************************************
;*	AZ TALAKTSNAK VGE
;************************************************************************************************
AD_MERVE
	BANKSEL_1
	MOVFW	ADRESL				;A MRS EREDMNYT ELMENTJK
	BANKSEL_0
	MOVWF	AD_RESULT_LOW

	MOVFW	ADRESH				;A FELS BYTE-OT IS KIOLVASSUK
	MOVWF	AD_RESULT_HIGH


	IF	(TESZT==1)
	MOVLW	.5
	ELSE
	MOVLW	AD_KESLELTETES			;KIVRJUK A BELLSI IDT (ACQUISITION TIME)
	ENDIF
	MOVWF	KESLELTETES_SZAML_1
	NOP
	NOP



AD_VAR
	DECFSZ	KESLELTETES_SZAML_1,F			;
	GOTO	AD_VAR
AD_INDUL				;ITT A KVETKEZ MRST INDTJUK!
	BSF	ADCON0,GO_DONE			;INDTJUK AZ TALAKTST


	RETURN












	END
