/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitPlayer
extends LocalPlayer {
    private final WorldGuardPlugin plugin;
    private final Player player;
    private final String name;
    private final boolean silenced;

    public BukkitPlayer(WorldGuardPlugin plugin, Player player) {
        this(plugin, player, false);
    }

    BukkitPlayer(WorldGuardPlugin plugin, Player player, boolean silenced) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        Preconditions.checkNotNull((Object)player);
        this.plugin = plugin;
        this.player = player;
        this.name = player.getName();
        this.silenced = silenced;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public boolean hasGroup(String group) {
        return this.plugin.inGroup(this.player, group);
    }

    @Override
    public Vector getPosition() {
        Location loc = this.player.getLocation();
        return new Vector(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public void kick(String msg) {
        if (!this.silenced) {
            this.player.kickPlayer(msg);
        }
    }

    @Override
    public void ban(String msg) {
        if (!this.silenced) {
            this.player.setBanned(true);
            this.player.kickPlayer(msg);
        }
    }

    @Override
    public String[] getGroups() {
        return this.plugin.getGroups(this.player);
    }

    @Override
    public void printRaw(String msg) {
        if (!this.silenced) {
            this.player.sendMessage(msg);
        }
    }

    @Override
    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.player, perm);
    }

    public Player getPlayer() {
        return this.player;
    }
}

