/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.QueryCache;
import com.sk89q.worldguard.bukkit.RegionQuery;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.managers.RegionContainerImpl;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.managers.migration.Migration;
import com.sk89q.worldguard.protection.managers.migration.MigrationException;
import com.sk89q.worldguard.protection.managers.migration.UUIDMigration;
import com.sk89q.worldguard.protection.managers.storage.RegionDriver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class RegionContainer {
    private static final Logger log = Logger.getLogger(RegionContainer.class.getCanonicalName());
    private static final int CACHE_INVALIDATION_INTERVAL = 2;
    private final Object lock = new Object();
    private final WorldGuardPlugin plugin;
    private final QueryCache cache = new QueryCache();
    private RegionContainerImpl container;

    RegionContainer(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    void initialize() {
        ConfigurationManager config = this.plugin.getGlobalStateManager();
        this.container = new RegionContainerImpl(config.selectedRegionStoreDriver);
        this.autoMigrate();
        this.loadWorlds();
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onWorldLoad(WorldLoadEvent event) {
                RegionContainer.this.load(event.getWorld());
            }

            @EventHandler
            public void onWorldUnload(WorldUnloadEvent event) {
                RegionContainer.this.unload(event.getWorld());
            }

            @EventHandler
            public void onChunkLoad(ChunkLoadEvent event) {
                RegionManager manager = RegionContainer.this.get(event.getWorld());
                if (manager != null) {
                    Chunk chunk = event.getChunk();
                    manager.loadChunk(new Vector2D(chunk.getX(), chunk.getZ()));
                }
            }

            @EventHandler
            public void onChunkUnload(ChunkUnloadEvent event) {
                RegionManager manager = RegionContainer.this.get(event.getWorld());
                if (manager != null) {
                    Chunk chunk = event.getChunk();
                    manager.unloadChunk(new Vector2D(chunk.getX(), chunk.getZ()));
                }
            }
        }, (Plugin)this.plugin);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                RegionContainer.this.cache.invalidateAll();
            }
        }, 2L, 2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unload() {
        Object object = this.lock;
        synchronized (object) {
            this.container.unloadAll();
        }
    }

    public RegionDriver getDriver() {
        return this.container.getDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWorlds() {
        Object object = this.lock;
        synchronized (object) {
            for (World world : Bukkit.getServer().getWorlds()) {
                this.load(world);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            this.unload();
            this.loadWorlds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RegionManager load(World world) {
        RegionManager manager;
        Preconditions.checkNotNull((Object)world);
        WorldConfiguration config = this.plugin.getGlobalStateManager().get(world);
        if (!config.useRegions) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            manager = this.container.load(world.getName());
            if (manager != null) {
                ArrayList<Vector2D> positions = new ArrayList<Vector2D>();
                for (Chunk chunk : world.getLoadedChunks()) {
                    positions.add(new Vector2D(chunk.getX(), chunk.getZ()));
                }
                manager.loadChunks(positions);
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unload(World world) {
        Preconditions.checkNotNull((Object)world);
        Object object = this.lock;
        synchronized (object) {
            this.container.unload(world.getName());
        }
    }

    @Nullable
    public RegionManager get(World world) {
        return this.container.get(world.getName());
    }

    public List<RegionManager> getLoaded() {
        return Collections.unmodifiableList(this.container.getLoaded());
    }

    public Set<RegionManager> getSaveFailures() {
        return this.container.getSaveFailures();
    }

    public RegionQuery createQuery() {
        return new RegionQuery(this.plugin, this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(Migration migration) throws MigrationException {
        Preconditions.checkNotNull((Object)migration);
        Object object = this.lock;
        synchronized (object) {
            try {
                log.info("Unloading and saving region data that is currently loaded...");
                this.unload();
                migration.migrate();
            }
            finally {
                log.info("Loading region data for loaded worlds...");
                this.loadWorlds();
            }
        }
    }

    private void autoMigrate() {
        ConfigurationManager config = this.plugin.getGlobalStateManager();
        if (config.migrateRegionsToUuid) {
            RegionDriver driver = this.getDriver();
            UUIDMigration migrator = new UUIDMigration(driver, this.plugin.getProfileService());
            migrator.setKeepUnresolvedNames(config.keepUnresolvedNames);
            try {
                this.migrate(migrator);
                log.info("Regions saved after UUID migration! This won't happen again unless you change the relevant configuration option in WorldGuard's config.");
                config.disableUuidMigration();
            }
            catch (MigrationException e) {
                log.log(Level.WARNING, "Failed to execute the migration", e);
            }
        }
    }
}

