/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.event.block;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sk89q.worldguard.bukkit.cause.Cause;
import com.sk89q.worldguard.bukkit.event.BulkEvent;
import com.sk89q.worldguard.bukkit.event.DelegateEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

abstract class AbstractBlockEvent
extends DelegateEvent
implements BulkEvent {
    private final World world;
    private final List<Block> blocks;
    private final Material effectiveMaterial;

    protected AbstractBlockEvent(@Nullable Event originalEvent, Cause cause, World world, List<Block> blocks, Material effectiveMaterial) {
        super(originalEvent, cause);
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull(blocks);
        Preconditions.checkNotNull((Object)effectiveMaterial);
        this.world = world;
        this.blocks = blocks;
        this.effectiveMaterial = effectiveMaterial;
    }

    protected AbstractBlockEvent(@Nullable Event originalEvent, Cause cause, Block block) {
        this(originalEvent, cause, block.getWorld(), AbstractBlockEvent.createList((Block)Preconditions.checkNotNull((Object)block)), block.getType());
    }

    protected AbstractBlockEvent(@Nullable Event originalEvent, Cause cause, Location target, Material effectiveMaterial) {
        this(originalEvent, cause, target.getWorld(), AbstractBlockEvent.createList(target.getBlock()), effectiveMaterial);
    }

    private static List<Block> createList(Block block) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(block);
        return blocks;
    }

    public World getWorld() {
        return this.world;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public boolean filter(Predicate<Location> predicate, boolean cancelEventOnFalse) {
        boolean hasRemoval = false;
        Iterator<Block> it = this.blocks.iterator();
        while (it.hasNext()) {
            if (predicate.apply((Object)it.next().getLocation())) continue;
            hasRemoval = true;
            if (cancelEventOnFalse) {
                this.getBlocks().clear();
                this.setCancelled(true);
                break;
            }
            it.remove();
        }
        return hasRemoval;
    }

    public boolean filter(Predicate<Location> predicate) {
        return this.filter(predicate, false);
    }

    public Material getEffectiveMaterial() {
        return this.effectiveMaterial;
    }

    @Override
    public Event.Result getResult() {
        if (this.blocks.isEmpty()) {
            return Event.Result.DENY;
        }
        return super.getResult();
    }

    @Override
    public Event.Result getExplicitResult() {
        return super.getResult();
    }
}

