/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.inventory.UseItemEvent;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;

public class BlockedPotionsListener
extends AbstractListener {
    public BlockedPotionsListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onItemInteract(UseItemEvent event) {
        ConfigurationManager cfg = this.getPlugin().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getWorld());
        ItemStack item = event.getItemStack();
        if (item.getType() != Material.POTION || BukkitUtil.isWaterPotion(item)) {
            return;
        }
        if (!wcfg.blockPotions.isEmpty()) {
            PotionEffect blockedEffect = null;
            Potion potion = Potion.fromDamage((int)BukkitUtil.getPotionEffectBits(item));
            for (PotionEffect effect : potion.getEffects()) {
                if (!wcfg.blockPotions.contains(effect.getType())) continue;
                blockedEffect = effect;
                break;
            }
            if (blockedEffect != null) {
                Player player = event.getCause().getFirstPlayer();
                if (player != null) {
                    if (this.getPlugin().hasPermission((CommandSender)player, "worldguard.override.potions")) {
                        if (potion.isSplash() && wcfg.blockPotionsAlways) {
                            player.sendMessage(ChatColor.RED + "Sorry, potions with " + blockedEffect.getType().getName() + " can't be thrown, " + "even if you have a permission to bypass it, " + "due to limitations (and because overly-reliable potion blocking is on).");
                            event.setCancelled(true);
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "Sorry, potions with " + blockedEffect.getType().getName() + " are presently disabled.");
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }
}

