/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.protection;

import com.google.common.base.Preconditions;
import com.sk89q.worldguard.bukkit.RegionQuery;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Location;

public class DelayedRegionOverlapAssociation
implements RegionAssociable {
    private final RegionQuery query;
    private final Location location;
    @Nullable
    private Set<ProtectedRegion> source;

    public DelayedRegionOverlapAssociation(RegionQuery query, Location location) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)location);
        this.query = query;
        this.location = location;
    }

    @Override
    public Association getAssociation(List<ProtectedRegion> regions) {
        if (this.source == null) {
            ApplicableRegionSet result = this.query.getApplicableRegions(this.location);
            this.source = result.getRegions();
        }
        for (ProtectedRegion region : regions) {
            if ((!region.getId().equals("__global__") || !this.source.isEmpty()) && !this.source.contains(region)) continue;
            return Association.OWNER;
        }
        return Association.NON_MEMBER;
    }
}

