/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.util.report;

import com.sk89q.worldguard.util.report.DataReport;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.generator.ChunkGenerator;

public class WorldReport
extends DataReport {
    public WorldReport() {
        super("Worlds");
        List worlds = Bukkit.getServer().getWorlds();
        this.append("World Count", worlds.size());
        for (World world : worlds) {
            DataReport report = new DataReport("World: " + world.getName());
            report.append("UUID", world.getUID());
            report.append("World Type", world.getWorldType());
            report.append("Environment", world.getEnvironment());
            ChunkGenerator generator = world.getGenerator();
            report.append("Chunk Generator", generator != null ? generator.getClass().getName() : "<Default>");
            DataReport spawning = new DataReport("Spawning");
            spawning.append("Animals?", world.getAllowAnimals());
            spawning.append("Monsters?", world.getAllowMonsters());
            spawning.append("Ambient Spawn Limit", world.getAmbientSpawnLimit());
            spawning.append("Animal Spawn Limit", world.getAnimalSpawnLimit());
            spawning.append("Monster Spawn Limit", world.getMonsterSpawnLimit());
            spawning.append("Water Creature Spawn Limit", world.getWaterAnimalSpawnLimit());
            report.append(spawning.getTitle(), spawning);
            DataReport config = new DataReport("Configuration");
            config.append("Difficulty", world.getDifficulty());
            config.append("Max Height", world.getMaxHeight());
            config.append("Sea Level", world.getSeaLevel());
            report.append(config.getTitle(), config);
            DataReport state = new DataReport("State");
            state.append("Spawn Location", world.getSpawnLocation());
            state.append("Full Time", world.getFullTime());
            state.append("Weather Duration", world.getWeatherDuration());
            state.append("Thunder Duration", world.getThunderDuration());
            report.append(state.getTitle(), state);
            DataReport protection = new DataReport("Protection");
            protection.append("PVP?", world.getPVP());
            protection.append("Game Rules", world.getGameRules());
            report.append(protection.getTitle(), protection);
            this.append(report.getTitle(), report);
        }
    }
}

