/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.flags;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.flags.RegionGroupFlag;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;

public abstract class Flag<T> {
    private final String name;
    private final RegionGroupFlag regionGroup;

    public Flag(String name, @Nullable RegionGroup defaultGroup) {
        this.name = name;
        this.regionGroup = defaultGroup != null ? new RegionGroupFlag(name + "-group", defaultGroup) : null;
    }

    public Flag(String name) {
        this(name, RegionGroup.ALL);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public T getDefault() {
        return null;
    }

    @Nullable
    public T chooseValue(Collection<T> values) {
        if (!values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    public boolean hasConflictStrategy() {
        return false;
    }

    public boolean implicitlySetWithMembership() {
        return false;
    }

    public boolean usesMembershipAsDefault() {
        return false;
    }

    public boolean requiresSubject() {
        return false;
    }

    public RegionGroupFlag getRegionGroupFlag() {
        return this.regionGroup;
    }

    public abstract T parseInput(WorldGuardPlugin var1, CommandSender var2, String var3) throws InvalidFlagFormat;

    public abstract T unmarshal(@Nullable Object var1);

    public abstract Object marshal(T var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "name='" + this.name + '\'' + '}';
    }
}

