/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.managers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.RegionResultSet;
import com.sk89q.worldguard.protection.managers.RegionDifference;
import com.sk89q.worldguard.protection.managers.RemovalStrategy;
import com.sk89q.worldguard.protection.managers.index.ConcurrentRegionIndex;
import com.sk89q.worldguard.protection.managers.storage.DifferenceSaveException;
import com.sk89q.worldguard.protection.managers.storage.RegionDatabase;
import com.sk89q.worldguard.protection.managers.storage.StorageException;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.util.RegionCollectionConsumer;
import com.sk89q.worldguard.util.Normal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.bukkit.Location;

public final class RegionManager {
    private final RegionDatabase store;
    private final Supplier<? extends ConcurrentRegionIndex> indexFactory;
    private ConcurrentRegionIndex index;

    public RegionManager(RegionDatabase store, Supplier<? extends ConcurrentRegionIndex> indexFactory) {
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull(indexFactory);
        this.store = store;
        this.indexFactory = indexFactory;
        this.index = (ConcurrentRegionIndex)indexFactory.get();
    }

    public String getName() {
        return this.store.getName();
    }

    public void load() throws StorageException {
        Set<ProtectedRegion> regions = this.store.loadAll();
        for (ProtectedRegion region : regions) {
            region.setDirty(false);
        }
        this.setRegions(regions);
    }

    public void save() throws StorageException {
        this.index.setDirty(false);
        this.store.saveAll(new HashSet<ProtectedRegion>(this.getValuesCopy()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveChanges() throws StorageException {
        RegionDifference diff = this.index.getAndClearDifference();
        boolean successful = false;
        try {
            if (diff.containsChanges()) {
                try {
                    this.store.saveChanges(diff);
                }
                catch (DifferenceSaveException e) {
                    this.save();
                }
                successful = true;
                boolean bl = true;
                return bl;
            }
            successful = true;
            boolean bl = false;
            return bl;
        }
        finally {
            if (!successful) {
                this.index.setDirty(diff);
            }
        }
    }

    public void loadChunk(Vector2D position) {
        this.index.bias(position);
    }

    public void loadChunks(Collection<Vector2D> positions) {
        this.index.biasAll(positions);
    }

    public void unloadChunk(Vector2D position) {
        this.index.forget(position);
    }

    public Map<String, ProtectedRegion> getRegions() {
        HashMap<String, ProtectedRegion> map = new HashMap<String, ProtectedRegion>();
        for (ProtectedRegion region : this.index.values()) {
            map.put(Normal.normalize(region.getId()), region);
        }
        return Collections.unmodifiableMap(map);
    }

    public void setRegions(Map<String, ProtectedRegion> regions) {
        Preconditions.checkNotNull(regions);
        this.setRegions(regions.values());
    }

    public void setRegions(Collection<ProtectedRegion> regions) {
        Preconditions.checkNotNull(regions);
        ConcurrentRegionIndex newIndex = (ConcurrentRegionIndex)this.indexFactory.get();
        newIndex.addAll(regions);
        newIndex.getAndClearDifference();
        this.index = newIndex;
    }

    public void addRegion(ProtectedRegion region) {
        Preconditions.checkNotNull((Object)region);
        this.index.add(region);
    }

    public boolean hasRegion(String id) {
        return this.index.contains(id);
    }

    @Nullable
    public ProtectedRegion getRegion(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.index.get(id);
    }

    @Nullable
    public ProtectedRegion matchRegion(String pattern) {
        Preconditions.checkNotNull((Object)pattern);
        if (pattern.startsWith("#")) {
            int index;
            try {
                index = Integer.parseInt(pattern.substring(1)) - 1;
            }
            catch (NumberFormatException e) {
                return null;
            }
            for (ProtectedRegion region : this.index.values()) {
                if (index == 0) {
                    return region;
                }
                --index;
            }
            return null;
        }
        return this.getRegion(pattern);
    }

    @Nullable
    public Set<ProtectedRegion> removeRegion(String id) {
        return this.removeRegion(id, RemovalStrategy.REMOVE_CHILDREN);
    }

    @Nullable
    public Set<ProtectedRegion> removeRegion(String id, RemovalStrategy strategy) {
        return this.index.remove(id, strategy);
    }

    public ApplicableRegionSet getApplicableRegions(Vector position) {
        Preconditions.checkNotNull((Object)position);
        HashSet regions = Sets.newHashSet();
        this.index.applyContaining(position, new RegionCollectionConsumer(regions, true));
        return new RegionResultSet(regions, this.index.get("__global__"));
    }

    public ApplicableRegionSet getApplicableRegions(ProtectedRegion region) {
        Preconditions.checkNotNull((Object)region);
        HashSet regions = Sets.newHashSet();
        this.index.applyIntersecting(region, new RegionCollectionConsumer(regions, true));
        return new RegionResultSet(regions, this.index.get("__global__"));
    }

    public List<String> getApplicableRegionsIDs(Vector position) {
        Preconditions.checkNotNull((Object)position);
        final ArrayList<String> names = new ArrayList<String>();
        this.index.applyContaining(position, new Predicate<ProtectedRegion>(){

            public boolean apply(ProtectedRegion region) {
                return names.add(region.getId());
            }
        });
        return names;
    }

    public boolean overlapsUnownedRegion(ProtectedRegion region, final LocalPlayer player) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)player);
        ConcurrentRegionIndex index = this.index;
        final AtomicBoolean overlapsUnowned = new AtomicBoolean();
        index.applyIntersecting(region, new Predicate<ProtectedRegion>(){

            public boolean apply(ProtectedRegion test) {
                if (!test.getOwners().contains(player)) {
                    overlapsUnowned.set(true);
                    return false;
                }
                return true;
            }
        });
        return overlapsUnowned.get();
    }

    public int size() {
        return this.index.size();
    }

    public int getRegionCountOfPlayer(final LocalPlayer player) {
        Preconditions.checkNotNull((Object)player);
        final AtomicInteger count = new AtomicInteger();
        this.index.apply(new Predicate<ProtectedRegion>(){

            public boolean apply(ProtectedRegion test) {
                if (test.getOwners().contains(player)) {
                    count.incrementAndGet();
                }
                return true;
            }
        });
        return count.get();
    }

    private List<ProtectedRegion> getValuesCopy() {
        return new ArrayList<ProtectedRegion>(this.index.values());
    }

    public ApplicableRegionSet getApplicableRegions(Location loc) {
        return this.getApplicableRegions(BukkitUtil.toVector((Location)loc).floor());
    }
}

